/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.views.actions;

import com.blixx.boom.engine.AgentCard;
import com.blixx.boom.engine.BMUI;
import com.blixx.boom.engine.Repository;
import com.blixx.boom.engine.ServerClient;
import com.blixx.boom.gui.views.NodeListView;
import com.blixx.shared.IODataStream;
import com.blixx.shared.sc.CMDS;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.Action;

public class SetFirewallAction
extends Action {
    private String m_action = null;
    private List<AgentCard> m_agentCards = new ArrayList<AgentCard>();

    public SetFirewallAction(List<AgentCard> agentCards, String action) {
        super(action == null ? NodeListView.SET_FIREWALLED_OFF : action);
        this.setId("SetFirewall");
        this.m_action = action == null ? NodeListView.SET_FIREWALLED_OFF : action;
        for (AgentCard ac : agentCards) {
            if (!this.isPermitted(ac)) continue;
            this.m_agentCards.add(ac);
        }
        if (this.m_agentCards.size() == 0) {
            this.setEnabled(false);
            return;
        }
        if (this.m_action.equals(NodeListView.SET_FIREWALLED_ON)) {
            this.setImageDescriptor(BMUI.IMAGE_DESCR_FIREWALL_ON);
        } else {
            this.setImageDescriptor(BMUI.IMAGE_DESCR_FIREWALL_OFF);
        }
        if (this.m_agentCards.size() == 1 && this.m_action == null) {
            AgentCard ac;
            ac = this.m_agentCards.get(0);
            this.m_action = ac.isFirewalled() ? NodeListView.SET_FIREWALLED_OFF : NodeListView.SET_FIREWALLED_ON;
            this.setText(this.m_action);
        } else if (this.m_agentCards.size() >= 1 && this.m_action != null) {
            this.setText(this.m_action);
        } else {
            this.m_action = NodeListView.SET_FIREWALLED_OFF;
            this.setText(NodeListView.SET_FIREWALLED_OFF);
            this.setEnabled(false);
        }
    }

    private boolean isPermitted(AgentCard ac) {
        return ac != null && !ac.isExternal() && ac.isApproved() && Repository.getInstance().isPermittedAgentModify(ac.getAgentID());
    }

    public void run() {
        int i = 0;
        while (i < this.m_agentCards.size()) {
            AgentCard ac = this.m_agentCards.get(i);
            this.changeMode(ac);
            ++i;
        }
        IODataStream[] arr = this.m_agentCards.toArray(new IODataStream[0]);
        ServerClient sc = new ServerClient("ProcessAGENT", CMDS.ACTION_UPDATE_OBJECT, arr);
        Repository.getJobManager().schedule(sc);
    }

    public void changeMode(AgentCard ac) {
        if (this.m_action.equals(NodeListView.SET_FIREWALLED_ON) && !ac.isFirewalled()) {
            if (ac.getMode() == 1) {
                ac.setMode(8);
            } else {
                ac.setMode(7);
            }
            ac.m_forceRefresh = 1;
        } else if (this.m_action.equals(NodeListView.SET_FIREWALLED_OFF) && ac.isFirewalled()) {
            ac.setMode(0);
            ac.m_forceRefresh = 1;
        } else {
            return;
        }
    }
}

