/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.views.actions;

import com.blixx.boom.engine.AgentCard;
import com.blixx.boom.engine.BMUI;
import com.blixx.boom.engine.Repository;
import com.blixx.boom.gui.Activator;
import com.blixx.boom.gui.views.AgentCardView;
import com.blixx.boom.gui.views.AgentTab;
import com.blixx.boom.gui.views.AssignmentsSummaryView;
import com.blixx.boom.gui.views.MessagesView;
import com.blixx.boom.gui.views.NodeListView;
import com.blixx.ctrl.sc.in.ScGetAssigned;
import com.blixx.log.RTLogger;
import com.blixx.shared.utils.GroupTreeObject;
import com.blixx.shared.utils.GroupTreeObjectLast;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.ui.IWorkbenchPart;

public class ShowAssignedPoliciesAction
extends Action {
    private List<AgentCard> m_elements = new ArrayList<AgentCard>();
    private static int MAX = 10;

    public ShowAssignedPoliciesAction(TreeViewer treeViewer) {
        super("ShowAssigned...");
        this.setText("Open Agent");
        this.setId("showAssigned");
        if (treeViewer == null || Repository.getInstance().getRights(1002) < 2) {
            this.setEnabled(false);
            return;
        }
        String treeType = (String)treeViewer.getData(AssignmentsSummaryView.VIEWER_TYPE);
        StructuredSelection sel = (StructuredSelection)treeViewer.getSelection();
        for (Object selected : sel) {
            GroupTreeObject gto;
            AgentCard ac;
            if (treeType.equals(AssignmentsSummaryView.ASSIGN_TREE_VIEWER) && selected instanceof GroupTreeObjectLast) {
                GroupTreeObjectLast gtol = (GroupTreeObjectLast)selected;
                ac = null;
                if (gtol.getLinkedPath() != null && gtol.getLinkedPath().length() > 0) {
                    String realAgentID = gtol.getLinkedPath();
                    ac = Repository.getInstance().getAgentCard(realAgentID);
                } else {
                    ac = (AgentCard)gtol.getTreeObject().getObject();
                }
                if (ac == null) continue;
                this.m_elements.add(ac);
                RTLogger.print(5, "Requested ID:" + ac.getAgentID());
                continue;
            }
            if (treeType.equals(AssignmentsSummaryView.AGENT_TREE_VIEWER) && selected instanceof GroupTreeObject) {
                gto = (GroupTreeObject)selected;
                if (!(gto.getTreeObject() instanceof AgentCard) || (ac = (AgentCard)((GroupTreeObject)selected).getTreeObject()) == null) continue;
                this.m_elements.add(ac);
                RTLogger.print(5, "Requested ID:" + ac.getAgentID());
                continue;
            }
            if (!treeType.equals(NodeListView.NODE_LIST) || !(selected instanceof GroupTreeObject) || !((gto = (GroupTreeObject)selected).getTreeObject() instanceof AgentCard) || (ac = (AgentCard)((GroupTreeObject)selected).getTreeObject()) == null) continue;
            this.m_elements.add(ac);
            RTLogger.print(5, "Requested ID:" + ac.getAgentID());
        }
        if (this.m_elements.size() > 1) {
            this.setText("Open Agents");
        }
        if (this.m_elements.size() == 0 || this.m_elements.size() > MAX) {
            this.setEnabled(false);
        }
    }

    public ShowAssignedPoliciesAction(List<AgentCard> agentCards) {
        super("ShowAssigned...");
        this.setText("Open Agent");
        this.setId("showAssigned");
        if (agentCards == null || agentCards.size() == 0 || Repository.getInstance().getRights(1002) < 2) {
            this.setEnabled(false);
            return;
        }
        this.m_elements.addAll(agentCards);
        if (this.m_elements.size() > 1) {
            this.setText("Open Agents");
        }
        if (this.m_elements.size() > MAX) {
            this.setEnabled(false);
        }
    }

    public ShowAssignedPoliciesAction(AgentCard ac) {
        super("ShowAssigned...");
        this.setText("Open Agent");
        this.setId("showAssigned");
        this.setImageDescriptor(BMUI.IMAGE_PC_DETAILS_DESCRIPTOR);
        if (ac == null || Repository.getInstance().getRights(1002) < 2) {
            this.setEnabled(false);
            return;
        }
        this.m_elements.add(ac);
    }

    public void run() {
        int i = 0;
        while (i < this.m_elements.size()) {
            this.openAgentCard(this.m_elements.get(i));
            ++i;
        }
    }

    public void openAgentCard(AgentCard agentCard) {
        if (agentCard.isApproved() && !agentCard.isExternal()) {
            RTLogger.print(5, "Requested ID:" + agentCard.getAgentID());
            ScGetAssigned sc = new ScGetAssigned(Repository.getInstance(), agentCard.getAgentID());
            sc.addCmdPostProcess(Repository.getInstance());
            sc.start();
        }
        Activator.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage().activate((IWorkbenchPart)AgentCardView.getInstance());
        CTabFolder folder = AgentCardView.getInstance().getFolder();
        RTLogger.print(5, "creating a new Assignment tab.");
        try {
            if (folder == null) {
                RTLogger.print(5, "NodeViewFolder empty for NV=" + (Object)((Object)MessagesView.getInstance()));
            } else {
                CTabItem[] opened = folder.getItems();
                int i = 0;
                while (i < opened.length) {
                    AgentCard ac;
                    CTabItem tab = opened[i];
                    Object data = tab.getData();
                    if (tab instanceof AgentTab && data != null && data instanceof AgentCard && (ac = (AgentCard)data).getAgentID().equals(agentCard.getAgentID())) {
                        ((AgentTab)tab).createMainArea();
                        ((AgentTab)tab).getControl().setVisible(true);
                        folder.setSelection(tab);
                        return;
                    }
                    ++i;
                }
                AgentTab at = new AgentTab(folder, 64, folder.getItemCount(), agentCard);
                folder.setSelection((CTabItem)at);
                at.addDisposeListener(new DisposeListener(){

                    public void widgetDisposed(DisposeEvent e) {
                        CTabItem tab = (CTabItem)e.getSource();
                        if (((AgentTab)tab).isDirty()) {
                            ((AgentTab)tab).saveAgentDetails();
                        } else {
                            ((AgentTab)tab).setDirty(false);
                        }
                    }
                });
            }
        }
        catch (Throwable e) {
            RTLogger.print(5, "SAP2317", e);
        }
    }
}

