/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.views.actions;

import com.blixx.boom.engine.BMUI;
import com.blixx.boom.engine.Repository;
import com.blixx.boom.gui.dialogs.ProgressDialog;
import com.blixx.boom.gui.dialogs.ShowSimpleDialog;
import com.blixx.boom.gui.views.AgentTab;
import com.blixx.boom.gui.views.MessagesView;
import com.blixx.shared.utils.GroupTreeObjectLast;
import com.blixx.shared.utils.GroupTreeObjectUnsubmitted;
import java.util.HashMap;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Display;

public class ShowMessagesForSource
extends Action {
    private HashMap<String, String> m_elements = new HashMap();
    private static int MAX = 1000;
    private String m_browserType = "IndicationBrowser";
    private String m_agentID = null;

    public ShowMessagesForSource(String name, String type, String agentID) {
        super("ShowMessagesForSource");
        this.setText("Show Indications");
        this.setId("ShowMessagesForSource");
        this.setImageDescriptor(BMUI.IMAGE_DESC_INDICATIONS);
        if (name == null || name.isEmpty() || type == null || type.isEmpty() || Repository.getInstance().getRights(1000) <= 1) {
            this.setEnabled(false);
            return;
        }
        this.m_agentID = agentID;
        this.m_elements.put(name, type);
        if (this.m_elements.size() == 0 || this.m_elements.size() > MAX) {
            this.setEnabled(false);
            return;
        }
    }

    public ShowMessagesForSource(GroupTreeObjectLast policy) {
        super("ShowMessagesForSource");
        this.setText("Show Indications");
        this.setId("ShowMessagesForSource");
        this.setImageDescriptor(BMUI.IMAGE_DESC_INDICATIONS);
        if (policy == null || policy instanceof GroupTreeObjectUnsubmitted || Repository.getInstance().getRights(1000) <= 1) {
            this.setEnabled(false);
            return;
        }
        String name = policy.getName();
        String type = policy.getTreeObject().getType();
        this.m_elements.put(name, type);
        if (this.m_elements.size() == 0 || this.m_elements.size() > MAX) {
            this.setEnabled(false);
            return;
        }
    }

    public ShowMessagesForSource(TreeViewer treeViewer) {
        super("ShowMessagesForSource");
        this.setText("Show Indications");
        this.setId("ShowMessagesForSource");
        this.setImageDescriptor(BMUI.IMAGE_DESC_INDICATIONS);
        if (treeViewer == null || Repository.getInstance().getRights(1000) <= 1) {
            this.setEnabled(false);
            return;
        }
        IStructuredSelection ssel = (IStructuredSelection)treeViewer.getSelection();
        for (Object o : ssel) {
            if (o instanceof GroupTreeObjectUnsubmitted || !(o instanceof GroupTreeObjectLast)) continue;
            GroupTreeObjectLast policy = (GroupTreeObjectLast)o;
            String name = policy.getName();
            String type = policy.getTreeObject().getType();
            this.m_elements.put(name, type);
        }
        if (this.m_elements.size() == 0) {
            this.setEnabled(false);
            return;
        }
    }

    public ShowMessagesForSource(TableViewer tableViewer) {
        super("ShowMessagesForSource");
        this.setText("Show Indications");
        this.setId("ShowMessagesForSource");
        this.setImageDescriptor(BMUI.IMAGE_DESC_INDICATIONS);
        if (tableViewer == null || Repository.getInstance().getRights(1000) <= 1) {
            this.setEnabled(false);
            return;
        }
        IStructuredSelection ssel = (IStructuredSelection)tableViewer.getSelection();
        for (String[] item : ssel) {
            String type = item[0];
            String name = item[1];
            this.m_elements.put(name, type);
        }
        if (this.m_elements.size() == 0) {
            this.setEnabled(false);
            return;
        }
    }

    public void run() {
        boolean showIndications = false;
        if (this.m_elements.size() > MAX) {
            ShowSimpleDialog dialog = new ShowSimpleDialog(Display.getCurrent().getActiveShell(), "  Show Indications", "Do you want to show Indications for " + this.m_elements.size() + " Policies?", "Show Indications", "Cancel");
            int res = dialog.open();
            if (res == 0) {
                showIndications = true;
            }
        } else if (this.m_elements.size() > 0) {
            showIndications = true;
        }
        if (showIndications) {
            ProgressDialog pd = new ProgressDialog("  Show Indications", "", 0, this.m_elements.size());
            pd.setBlockOnOpen(false);
            pd.open();
            int pdNumber = 0;
            try {
                int count = 0;
                for (String name : this.m_elements.keySet()) {
                    String type = this.m_elements.get(name);
                    String combined = name;
                    if (type.equals(BMUI.type_mon)) {
                        combined = "Monitor:" + name + ":";
                    } else {
                        if (!type.equals(BMUI.type_msg)) continue;
                        combined = "Message:" + name + ":";
                    }
                    pd.setProgress("   Show Indications for " + name, ++pdNumber);
                    boolean activateTab = false;
                    if (++count == this.m_elements.size()) {
                        activateTab = true;
                    }
                    if (this.m_agentID != null) {
                        AgentTab.showMessagesForSource(name, combined, this.m_agentID);
                        continue;
                    }
                    MessagesView.showMessagesForSource(name, combined, activateTab);
                }
            }
            catch (Throwable throwable) {
                try {
                    pd.close();
                }
                catch (Throwable throwable2) {}
                throw throwable;
            }
            try {
                pd.close();
            }
            catch (Throwable throwable) {}
        }
    }
}

