/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.views.actions;

import com.blixx.boom.engine.Repository;
import com.blixx.boom.gui.dialogs.RelatedPolicyInfoDialog;
import com.blixx.boom.gui.policies.PolicyManager;
import com.blixx.shared.utils.GroupTreeObjectLast;
import com.blixx.shared.utils.GroupTreeObjectUnsubmitted;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class ShowRelatedPolicyInfosAction
extends Action {
    private Shell m_shell = null;
    private StructuredSelection m_ssel = null;

    public ShowRelatedPolicyInfosAction(String pName, String pType, Shell shell) {
        super("ShowRelatedInfos");
        this.setId("ShowRelatedInfos");
        this.m_shell = shell;
        if (Repository.getInstance().getRights(1008) <= 1 && Repository.getInstance().getRights(1002) <= 1) {
            this.setEnabled(false);
            return;
        }
        GroupTreeObjectLast gtol = PolicyManager.getInstance().getPolicyTree().findElement(pName, pType);
        if (gtol == null) {
            this.setEnabled(false);
            return;
        }
        this.m_ssel = new StructuredSelection((Object)gtol);
        if (this.m_ssel == null || this.m_ssel.isEmpty() || pName == null || pName.equals("") || pType == null || pType.equals("")) {
            this.setEnabled(false);
            return;
        }
    }

    public ShowRelatedPolicyInfosAction(StructuredSelection ssel, Shell shell) {
        super("ShowRelatedInfos");
        this.setId("ShowRelatedInfos");
        this.m_ssel = ssel;
        this.m_shell = shell;
        if (Repository.getInstance().getRights(1008) <= 1 && Repository.getInstance().getRights(1002) <= 1) {
            this.setEnabled(false);
            return;
        }
        if (this.m_ssel == null || this.m_ssel.isEmpty()) {
            this.setEnabled(false);
        }
    }

    public ShowRelatedPolicyInfosAction(Object viewer, Shell shell) {
        super("ShowRelatedInfos");
        this.setId("ShowRelatedInfos");
        this.m_shell = shell;
        this.setText("Related Information");
        if (Repository.getInstance().getRights(1008) <= 1 && Repository.getInstance().getRights(1002) <= 1 || viewer == null) {
            this.setEnabled(false);
            return;
        }
        if (viewer instanceof TableViewer) {
            TableViewer tableViewer = (TableViewer)viewer;
            this.m_ssel = (StructuredSelection)tableViewer.getSelection();
        } else if (viewer instanceof TreeViewer) {
            TreeViewer treeViewer = (TreeViewer)viewer;
            this.m_ssel = (StructuredSelection)treeViewer.getSelection();
            if (this.m_ssel.getFirstElement() instanceof GroupTreeObjectUnsubmitted) {
                this.setEnabled(false);
                return;
            }
        }
        if (this.m_ssel == null || this.m_ssel.isEmpty()) {
            this.setEnabled(false);
        }
    }

    public void run() {
        if (this.m_ssel == null || this.m_ssel.isEmpty()) {
            return;
        }
        if (this.m_shell == null) {
            this.m_shell = Display.getCurrent().getActiveShell();
        }
        RelatedPolicyInfoDialog dialog = new RelatedPolicyInfoDialog(this.m_shell, this.m_ssel);
        dialog.setBlockOnOpen(false);
        dialog.open();
    }
}

