/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.views.actions;

import com.blixx.boom.engine.Repository;
import com.blixx.boom.gui.Activator;
import com.blixx.log.RTLogger;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IWorkbenchPage;

public class ShowViewAction
extends Action {
    public int m_itemID;
    public int m_minRightValue;
    public String m_viewID;
    public String m_secondaryViewID;

    public ShowViewAction(int itemID, int minRightValue, String viewID, String title, ImageDescriptor imageDescriptor) {
        this.setText(title);
        this.setId("Show " + title);
        if (imageDescriptor != null) {
            this.setImageDescriptor(imageDescriptor);
        }
        this.m_itemID = itemID;
        this.m_minRightValue = minRightValue;
        this.m_viewID = viewID;
        this.setEnabled(this.m_itemID == -1 || Repository.getInstance().getRights(this.m_itemID) > this.m_minRightValue);
    }

    public ShowViewAction(int itemID, int minRightValue, String viewID, String secondaryID, String title, ImageDescriptor imageDescriptor) {
        this(itemID, minRightValue, viewID, title, imageDescriptor);
        this.m_secondaryViewID = secondaryID;
    }

    public void run() {
        if (!this.isEnabled()) {
            return;
        }
        IWorkbenchPage activePage = Activator.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage();
        try {
            if (this.m_secondaryViewID != null) {
                activePage.showView(this.m_viewID, this.m_secondaryViewID, 1);
            } else {
                activePage.showView(this.m_viewID);
            }
        }
        catch (Throwable e) {
            RTLogger.print(3, "ShowViewAction: " + e.getMessage());
        }
    }

    public boolean isEnabled() {
        this.setEnabled(this.m_itemID == -1 || Repository.getInstance().getRights(this.m_itemID) > this.m_minRightValue);
        return this.m_itemID == -1 || Repository.getInstance().getRights(this.m_itemID) > this.m_minRightValue;
    }
}

