/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.views.actions;

import com.blixx.boom.engine.AgentCard;
import com.blixx.boom.engine.BMUI;
import com.blixx.boom.engine.Repository;
import com.blixx.boom.gui.dialogs.ShowMessageBox;
import com.blixx.ctrl.sc.SCException;
import com.blixx.ctrl.sc.ServerClientBatch;
import com.blixx.ctrl.sc.in.ScEnableAgentOutagePolicy;
import com.blixx.ctrl.sc.in.ScEnableServerPolicy;
import com.blixx.ctrl.sc.in.ScSaveAgentOutagePolicies;
import com.blixx.ctrl.sc.in.ScSaveServerPolicies;
import com.blixx.shared.ext.AgentOutagePolicy;
import com.blixx.shared.ext.ForwardFilter;
import com.blixx.shared.ext.OutagePolicy;
import com.blixx.shared.ext.ServerPolicyTemplate;
import com.blixx.shared.ext.TimeInterval;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.UUID;
import org.eclipse.jface.action.Action;

public class StartAdHocMaintenanceAction
extends Action {
    private List<String> m_agentIDs = new LinkedList<String>();
    private int m_action = 1;

    public StartAdHocMaintenanceAction(AgentCard agentCard, int action) {
        this.m_action = action;
        this.setImageDescriptor(BMUI.IMAGE_DESCR_ADHOC_MAINTENANCE);
        this.setText("Start AdHoc Maintenance (" + OutagePolicy.getActionLabel(action) + ")");
        if (Repository.getInstance().isPermittedAgentModify(agentCard.getID()) && !agentCard.isDisabled()) {
            this.m_agentIDs.add(agentCard.getID());
        } else {
            this.setEnabled(false);
        }
    }

    public StartAdHocMaintenanceAction(List<AgentCard> agentCards, int action) {
        for (AgentCard ac : agentCards) {
            if (!Repository.getInstance().isPermittedAgentModify(ac.getID()) || ac.isDisabled()) continue;
            this.m_agentIDs.add(ac.getID());
        }
        this.m_action = action;
        this.setImageDescriptor(BMUI.IMAGE_DESCR_ADHOC_MAINTENANCE);
        this.setText("Start AdHoc Maintenance (" + OutagePolicy.getActionLabel(action) + ")");
        if (this.m_agentIDs.isEmpty()) {
            this.setEnabled(false);
        }
    }

    public void run() {
        this.startAgentOutage();
    }

    @Deprecated
    private void startAgentOutage() {
        block15: {
            LinkedList<ServerPolicyTemplate> tosave = new LinkedList<ServerPolicyTemplate>();
            LinkedList<String> tosaveIDs = new LinkedList<String>();
            for (String id : this.m_agentIDs) {
                try {
                    AgentOutagePolicy sp = new AgentOutagePolicy();
                    sp.setID(UUID.randomUUID().toString());
                    Properties p = new Properties();
                    p.setProperty("FILTER_NUMBER", "1");
                    String label = "All Severities";
                    p.setProperty("NAME", label);
                    p.setProperty("DESCRIPTION", "");
                    p.setProperty("ATTRIBUTE", "SEVERITY");
                    p.setProperty("PATTERN", "<*>");
                    sp.addFilter(ForwardFilter.getInstance(p));
                    sp.setAction(this.m_action);
                    sp.setPostAction(0);
                    sp.m_agentID = id;
                    TimeInterval ti = new TimeInterval(System.currentTimeMillis(), Long.MAX_VALUE);
                    sp.setTimeInterval(ti);
                    tosave.add(sp);
                    tosaveIDs.add(sp.getID());
                }
                catch (Throwable throwable) {}
            }
            ServerClientBatch scb = new ServerClientBatch(Repository.getInstance());
            try {
                try {
                    ScSaveAgentOutagePolicies scp1 = new ScSaveAgentOutagePolicies(Repository.getInstance(), tosave);
                    scb.runBatch(scp1);
                    Thread.sleep(500L);
                    ScEnableAgentOutagePolicy scp2 = new ScEnableAgentOutagePolicy(Repository.getInstance(), tosaveIDs, true, Repository.getInstance().getUser());
                    scb.runBatch(scp2);
                    String result = scp1.getResultObject();
                    if (!scp1.isSuccess() && result != null) {
                        new ShowMessageBox("AdHoc Maintenance", result.toString(), 1);
                    }
                }
                catch (Throwable e) {
                    new ShowMessageBox("Error", e.getMessage(), 1);
                    try {
                        scb.close();
                    }
                    catch (Exception exception) {}
                    break block15;
                }
            }
            catch (Throwable throwable) {
                try {
                    scb.close();
                }
                catch (Exception exception) {}
                throw throwable;
            }
            try {
                scb.close();
            }
            catch (Exception exception) {}
        }
    }

    public void startOutagePolicy() {
        LinkedList<ServerPolicyTemplate> tosave = new LinkedList<ServerPolicyTemplate>();
        LinkedList<String> tosaveIDs = new LinkedList<String>();
        for (String id : this.m_agentIDs) {
            try {
                OutagePolicy sp = new OutagePolicy(UUID.randomUUID().toString(), "Maintenance for AgentID: " + id);
                Properties p = new Properties();
                p.setProperty("FILTER_NUMBER", "1");
                String label = "AgentID=" + id;
                AgentCard agentCard = null;
                try {
                    agentCard = Repository.getInstance().getAgentCard(id);
                    label = "Agent: " + agentCard.getLabel();
                }
                catch (Throwable throwable) {}
                p.setProperty("NAME", label);
                p.setProperty("DESCRIPTION", "");
                if (agentCard != null && agentCard.isExternal()) {
                    String[] hosts;
                    String[] ips;
                    p.setProperty("ATTRIBUTE", "HOST");
                    LinkedList<String> list = new LinkedList<String>();
                    String[] stringArray = ips = agentCard.getAgentIP().split("\\|");
                    int n = ips.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String ip = stringArray[n2];
                        if (ip != null && ip.length() > 0 && !list.contains(ip)) {
                            list.add(ip);
                        }
                        ++n2;
                    }
                    String[] stringArray2 = hosts = agentCard.getAgentHost().split("\\|");
                    int n3 = hosts.length;
                    n = 0;
                    while (n < n3) {
                        String host = stringArray2[n];
                        if (host != null && host.length() > 0 && !list.contains(host)) {
                            list.add(host);
                        }
                        ++n;
                    }
                    StringBuilder sb = new StringBuilder();
                    sb.append('[');
                    Iterator it = list.iterator();
                    while (it.hasNext()) {
                        String hostOrIP = (String)it.next();
                        sb.append(hostOrIP);
                        if (!it.hasNext()) continue;
                        sb.append('|');
                    }
                    sb.append(']');
                    p.setProperty("PATTERN", sb.toString());
                } else {
                    p.setProperty("ATTRIBUTE", "AGENTID");
                    p.setProperty("PATTERN", id);
                }
                sp.addFilter(ForwardFilter.getInstance(p));
                sp.setAction(this.m_action);
                sp.setDescription("");
                sp.setPostAction(0);
                TimeInterval ti = new TimeInterval(System.currentTimeMillis(), Long.MAX_VALUE);
                sp.setTimeInterval(ti);
                tosave.add(sp);
                tosaveIDs.add(sp.getID());
            }
            catch (Throwable throwable) {}
        }
        ServerClientBatch scb = new ServerClientBatch(Repository.getInstance());
        try {
            ScSaveServerPolicies scp1 = new ScSaveServerPolicies(Repository.getInstance(), tosave);
            scb.runBatch(scp1);
            ScEnableServerPolicy scp2 = new ScEnableServerPolicy(Repository.getInstance(), tosaveIDs, true, Repository.getInstance().getUser());
            scb.runBatch(scp2);
        }
        catch (SCException e) {
            new ShowMessageBox("Error", e.getMessage(), 1);
        }
    }
}

