/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.views.actions;

import com.blixx.boom.engine.AgentCard;
import com.blixx.boom.engine.Repository;
import com.blixx.boom.gui.dialogs.ShowMessageDialog;
import com.blixx.ctrl.sc.in.ScRemoteActionServer;
import com.blixx.shared.BM;
import com.blixx.shared.utils.GroupTreeObject;
import com.blixx.shared.utils.GroupTreeObjectLast;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class SyncAgentsAction
extends Action {
    Set<AgentCard> m_selectedAgents = new HashSet<AgentCard>();

    public SyncAgentsAction(StructuredSelection sel) {
        this.setText("Trigger Agent Synchronization");
        for (Object obj : sel) {
            if (obj instanceof AgentCard) {
                AgentCard ac = (AgentCard)obj;
                if (!this.isPermitted(ac)) continue;
                this.m_selectedAgents.add(ac);
                continue;
            }
            if (obj instanceof GroupTreeObjectLast) {
                AgentCard agentCard;
                GroupTreeObjectLast gtol = (GroupTreeObjectLast)obj;
                if (!"agt".equals(gtol.getType()) || !(gtol.getTreeObject() instanceof AgentCard) || !this.isPermitted(agentCard = (AgentCard)gtol.getTreeObject())) continue;
                this.m_selectedAgents.add(agentCard);
                continue;
            }
            if (!(obj instanceof GroupTreeObject)) continue;
            GroupTreeObject gto = (GroupTreeObject)obj;
            for (GroupTreeObject gtol : gto.findElementsByType("agt")) {
                AgentCard ac;
                if (!(gtol.getTreeObject() instanceof AgentCard) || !this.isPermitted(ac = (AgentCard)gtol.getTreeObject())) continue;
                this.m_selectedAgents.add(ac);
            }
        }
        if (this.m_selectedAgents.size() == 0) {
            this.setEnabled(false);
        }
    }

    private boolean isPermitted(AgentCard ac) {
        return ac != null && !ac.isExternal() && ac.isApproved() && Repository.getInstance().isPermittedAgentModify(ac.getAgentID());
    }

    public void run() {
        String title = "   Synchronize Agent";
        String header = "Do you want to synchronize the following Agent:";
        String footer = "1 Agent to upgrade!";
        String noElementText = "No Agents to upgrade";
        if (this.m_selectedAgents.size() > 1) {
            title = "   Synchronize Agents";
            header = "Do you want to synchronize the following Agents:";
            footer = String.valueOf(this.m_selectedAgents.size()) + " Agents to upgrade!";
        }
        ShowMessageDialog md = new ShowMessageDialog(new Shell(Display.getCurrent().getActiveShell()), title, header, footer, true, "Trigger Sync", new ArrayList<AgentCard>(this.m_selectedAgents), noElementText, ShowMessageDialog.TYPE_LIST_WITH_IMAGES);
        md.setBlockOnOpen(true);
        md.open();
        if (md.getReturnCode() == 0) {
            StringBuilder sb = new StringBuilder();
            for (AgentCard ac : this.m_selectedAgents) {
                sb.append(' ').append(ac.getAgentID());
            }
            ScRemoteActionServer sc = new ScRemoteActionServer(Repository.getInstance(), BM.DUMMY_UUID, "@@SYNC_AGTS" + sb.toString(), 100);
            Repository.getJobManager().schedule(sc);
        }
    }
}

