/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.views.actions;

import com.blixx.boom.engine.AgentCard;
import com.blixx.boom.engine.Repository;
import com.blixx.boom.engine.ServerClient;
import com.blixx.boom.gui.dialogs.ShowSimpleDialog;
import com.blixx.log.RTLogger;
import com.blixx.shared.Assignment;
import com.blixx.shared.utils.GroupTreeObject;
import com.blixx.shared.utils.GroupTreeObjectLast;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Display;

public class TriggerDeploymentAction
extends Action {
    private List<String> m_selectedAgents = null;
    private List<GroupTreeObject> m_parentList = null;
    private List<GroupTreeObject> m_selectedGTOs = null;

    public TriggerDeploymentAction(TreeViewer viewer) {
        super("TriggerDeploymentAction");
        this.setId("TriggerDeploymentAction");
        this.setText("Trigger Deployments");
        if (Repository.getInstance().getRights(1002) < 3 || Repository.getInstance().getRights(1007) < 3 || viewer == null) {
            this.setEnabled(false);
        } else {
            this.m_selectedAgents = new ArrayList<String>();
            this.m_parentList = new ArrayList<GroupTreeObject>();
            this.m_selectedGTOs = new ArrayList<GroupTreeObject>();
            StructuredSelection sel = (StructuredSelection)viewer.getSelection();
            for (Object o : sel) {
                if (o instanceof GroupTreeObjectLast) {
                    GroupTreeObjectLast gtoLast = (GroupTreeObjectLast)o;
                    AgentCard ac = (AgentCard)gtoLast.getTreeObject().getObject();
                    this.m_selectedAgents.add(ac.getAgentID());
                    if (this.m_parentList.contains(gtoLast.getParent())) continue;
                    this.m_parentList.add(gtoLast.getParent());
                    continue;
                }
                if (!(o instanceof GroupTreeObject)) continue;
                this.m_selectedGTOs.add((GroupTreeObject)o);
            }
            int i = 0;
            while (i < this.m_selectedGTOs.size()) {
                GroupTreeObject gto = this.m_selectedGTOs.get(i);
                if (!this.m_parentList.contains(gto)) {
                    List<GroupTreeObject> list = gto.getElements();
                    int ii = 0;
                    while (ii < list.size()) {
                        GroupTreeObject gto2 = list.get(ii);
                        if (gto2 instanceof GroupTreeObjectLast) {
                            GroupTreeObjectLast gtol = (GroupTreeObjectLast)gto2;
                            AgentCard ac = (AgentCard)gtol.getTreeObject().getObject();
                            this.m_selectedAgents.add(ac.getAgentID());
                        }
                        ++ii;
                    }
                }
                ++i;
            }
        }
    }

    public TriggerDeploymentAction(List<AgentCard> agents) {
        super("TriggerDeploymentAction");
        this.setId("TriggerDeploymentAction");
        if (agents == null || agents.size() == 0) {
            this.setEnabled(false);
        } else {
            this.m_selectedAgents = new ArrayList<String>();
            int i = 0;
            while (i < agents.size()) {
                AgentCard ac = agents.get(i);
                if (!this.m_selectedAgents.contains(ac.getAgentID())) {
                    this.m_selectedAgents.add(ac.getAgentID());
                }
                ++i;
            }
        }
    }

    public TriggerDeploymentAction(Object[] assignments) {
        super("TriggerDeploymentAction");
        this.setId("TriggerDeploymentAction");
        this.setText("Trigger All Deployments");
        if (assignments == null || assignments.length == 0) {
            this.setEnabled(false);
        } else {
            this.m_selectedAgents = new ArrayList<String>();
            int i = 0;
            while (i < assignments.length) {
                Assignment asn = (Assignment)assignments[i];
                if (!this.m_selectedAgents.contains(asn.getAgentID())) {
                    this.m_selectedAgents.add(asn.getAgentID());
                }
                ++i;
            }
        }
    }

    public void run() {
        ShowSimpleDialog dialog;
        int res;
        if (!this.isEnabled() || this.m_selectedAgents == null || this.m_selectedAgents.size() == 0) {
            return;
        }
        boolean doDeploy = true;
        if (this.m_selectedAgents.size() >= 10 && (res = (dialog = new ShowSimpleDialog(Display.getCurrent().getActiveShell(), "Deployment", "Do you want to Trigger Deployments for " + this.m_selectedAgents.size() + " Agents?", "YES", "NO")).open()) != 0) {
            doDeploy = false;
        }
        if (doDeploy) {
            RTLogger.print(5, "trigger deployments for " + this.m_selectedAgents);
            ServerClient sc = ServerClient.triggerDelayedDeployments(this.m_selectedAgents.toArray(new String[0]));
            Repository.getJobManager().schedule(sc);
        }
    }
}

