/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.views.actions;

import com.blixx.boom.engine.AgentCard;
import com.blixx.boom.engine.Repository;
import com.blixx.ctrl.sc.in.ScAgentInventoryTrigger;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.jface.action.Action;

public class TriggerInventoryAction
extends Action {
    List<AgentCard> list = new LinkedList<AgentCard>();

    public TriggerInventoryAction(List<AgentCard> agentCardList) {
        super("TriggerInventoryAction");
        this.setId("TriggerInventoryAction");
        this.setText("Trigger Inventory");
        for (AgentCard agentCard : agentCardList) {
            if (!this.isPermitted(agentCard)) continue;
            this.list.add(agentCard);
        }
        if (this.list.size() == 0) {
            this.setEnabled(false);
        }
    }

    public TriggerInventoryAction(AgentCard aCard) {
        super("TriggerInventoryAction");
        this.setId("TriggerInventoryAction");
        this.setText("Trigger Inventory");
        if (!this.isPermitted(aCard)) {
            this.setEnabled(false);
            return;
        }
        this.list.add(aCard);
    }

    private boolean isPermitted(AgentCard ac) {
        return ac != null && !ac.isExternal() && ac.isApproved() && Repository.getInstance().isPermittedAgentModify(ac.getAgentID());
    }

    public void run() {
        if (!this.isEnabled()) {
            return;
        }
        StringBuilder IDs = new StringBuilder();
        for (AgentCard ac : this.list) {
            IDs.append(ac.getAgentID());
            IDs.append(',');
        }
        IDs.deleteCharAt(IDs.length() - 1);
        ScAgentInventoryTrigger sc = new ScAgentInventoryTrigger(Repository.getInstance(), IDs.toString());
        Repository.getJobManager().schedule(sc);
    }
}

