/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.views.actions;

import com.blixx.boom.engine.AgentCard;
import com.blixx.boom.engine.JobManager;
import com.blixx.boom.engine.Repository;
import com.blixx.boom.gui.dialogs.ShowMessageDialog;
import com.blixx.ctrl.sc.in.ScUndeployAll;
import com.blixx.shared.utils.GroupTreeObject;
import com.blixx.shared.utils.GroupTreeObjectLast;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class UndeployFromAll
extends Action {
    private List<String> agentNames = new ArrayList<String>();
    private List<AgentCard> agentCards = new ArrayList<AgentCard>();
    private StructuredSelection ssel = null;
    private Collection<String> agentIds = null;

    public UndeployFromAll(StructuredSelection ssel) {
        this.setText("Undeploy All");
        if (ssel == null || ssel.isEmpty()) {
            this.setEnabled(false);
            return;
        }
        this.ssel = ssel;
    }

    public UndeployFromAll(String agentid) {
        this.setText("Undeploy All");
        if (agentid == null || agentid.equals("") || !Repository.getInstance().isPermittedAgentModify(agentid)) {
            this.setEnabled(false);
            return;
        }
        this.agentNames.add(agentid);
        AgentCard ac = Repository.getInstance().getAgentCard(agentid);
        if (ac != null) {
            this.agentCards.add(ac);
        }
    }

    public UndeployFromAll(Collection<String> agentIDs) {
        this.setText("Undeploy All");
        if (agentIDs == null || agentIDs.isEmpty()) {
            this.setEnabled(false);
            return;
        }
        this.agentIds = agentIDs;
    }

    public void run() {
        if (this.ssel != null) {
            this.collectAgentIds(this.ssel);
            if (this.agentNames.isEmpty()) {
                MessageDialog.openInformation((Shell)new Shell(Display.getCurrent().getActiveShell()), (String)"Undeploy All", (String)"No Agents are selected or you have not enough rights to performe this action!");
                return;
            }
            this.undeployAll();
        } else if (!this.agentNames.isEmpty()) {
            this.undeployAll();
        } else if (this.agentIds != null) {
            this.collectAgentIds(this.agentIds);
            if (this.agentNames.isEmpty()) {
                MessageDialog.openInformation((Shell)new Shell(Display.getCurrent().getActiveShell()), (String)"Undeploy All", (String)"No Agents are selected or you have not enough rights to performe this action!");
                return;
            }
            this.undeployAll();
        }
    }

    private void undeployAll() {
        boolean doUndeploy = this.openUndeployAllDialog();
        if (doUndeploy) {
            ScUndeployAll sc = new ScUndeployAll(Repository.getInstance(), this.agentNames);
            JobManager.getInstance().schedule(sc);
        }
    }

    public void collectAgentIds(StructuredSelection ssel) {
        for (Object o : ssel) {
            if (o instanceof GroupTreeObjectLast) {
                GroupTreeObjectLast gtol = (GroupTreeObjectLast)o;
                AgentCard ac = (AgentCard)gtol.getTreeObject().getObject();
                if (!Repository.getInstance().isPermittedAgentModify(ac.getID()) || this.agentNames.contains(ac.getID())) continue;
                this.agentNames.add(ac.getID());
                this.agentCards.add(ac);
                continue;
            }
            if (!(o instanceof GroupTreeObject)) continue;
            GroupTreeObject nodeGTO = (GroupTreeObject)o;
            List<GroupTreeObjectLast> allGtols = nodeGTO.getAllGTOLs();
            for (GroupTreeObject groupTreeObject : allGtols) {
                if (groupTreeObject == null || !(groupTreeObject instanceof GroupTreeObjectLast)) continue;
                GroupTreeObjectLast gtol = (GroupTreeObjectLast)groupTreeObject;
                AgentCard ac = (AgentCard)gtol.getTreeObject().getObject();
                if (!Repository.getInstance().isPermittedAgentModify(ac.getID()) || this.agentNames.contains(ac.getID())) continue;
                this.agentNames.add(ac.getID());
                this.agentCards.add(ac);
            }
        }
    }

    public void collectAgentIds(Collection<String> agentIds) {
        for (String agentId : agentIds) {
            if (!Repository.getInstance().isPermittedAgentModify(agentId) || this.agentNames.contains(agentId)) continue;
            this.agentNames.add(agentId);
            AgentCard ac = Repository.getInstance().getAgentCard(agentId);
            if (ac == null) continue;
            this.agentCards.add(ac);
        }
    }

    public boolean openUndeployAllDialog() {
        String title = " Undeploy All";
        String header = "Do you want to undeploy all elements from the following agents: ";
        String footer = String.valueOf(this.agentNames.size()) + " agents are selected!";
        String noElementsText = "No agents are selected!";
        ShowMessageDialog md = new ShowMessageDialog(new Shell(Display.getCurrent().getActiveShell()), title, header, footer, true, "Undeploy All", this.agentCards, noElementsText, ShowMessageDialog.TYPE_LIST_WITH_IMAGES);
        md.setBlockOnOpen(true);
        md.open();
        return md.getReturnCode() == 0;
    }
}

