/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.views.actions;

import com.blixx.boom.engine.Repository;
import com.blixx.boom.gui.Activator;
import com.blixx.boom.gui.views.ServerFilterUsersTab;
import com.blixx.boom.gui.views.ServerFilterView;
import com.blixx.shared.ext.ForwardFilter;
import com.blixx.shared.ext.ForwardPolicy;
import java.util.ArrayList;
import org.eclipse.jface.action.Action;
import org.eclipse.ui.ISharedImages;

public class UnlinkAttributeFilterAction
extends Action {
    private Object m_object = null;
    private ArrayList<ForwardFilter> m_list = null;

    public UnlinkAttributeFilterAction(Object obj, String[] selection, String type) {
        super("removeAttributeFilter");
        this.setId("removeattributefilter");
        this.setText("Remove Filter");
        ISharedImages sharedImages = Activator.getDefault().getWorkbench().getActiveWorkbenchWindow().getWorkbench().getSharedImages();
        this.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_DELETE"));
        this.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_DELETE_DISABLED"));
        this.m_object = obj;
        if (this.m_object == null || type == null) {
            this.setEnabled(false);
            return;
        }
        if (type.equals("NOTIFICATION")) {
            if (Repository.getInstance().getRights(1009) < 3) {
                this.setEnabled(false);
                return;
            }
        } else if (type.equals("USERS") && Repository.getInstance().getRights(1004) < 3) {
            this.setEnabled(false);
            return;
        }
        this.m_list = new ArrayList();
        int i = 0;
        while (i < selection.length) {
            String fFilterName = selection[i];
            this.m_list.add(ServerFilterView.getAttrFilter(fFilterName));
            ++i;
        }
        if (this.m_list.size() > 1) {
            this.setText("Remove Filters");
        } else if (this.m_list.size() == 0) {
            this.setEnabled(false);
        }
    }

    public void run() {
        if (!this.isEnabled()) {
            return;
        }
        if (this.m_object instanceof ServerFilterView) {
            ForwardPolicy currentPol = ServerFilterView.getInstance().getCurrentPolicy();
            currentPol.removeFilters(this.m_list);
            ServerFilterView.getInstance().updateAttrFilterList(currentPol);
            ServerFilterView.getInstance().setDirty(true);
            ServerFilterView.getInstance().m_unlink_attrFilter_btn.setEnabled(false);
        } else if (this.m_object instanceof ServerFilterUsersTab) {
            ForwardPolicy currentPol = ServerFilterUsersTab.getInstance().getCurrentPolicy();
            currentPol.removeFilters(this.m_list);
            ServerFilterUsersTab.getInstance().updateAttrFilterList(currentPol);
            ServerFilterUsersTab.getInstance().setDirty(true);
            ServerFilterUsersTab.getInstance().m_unlink_attrFilter_btn.setEnabled(false);
        }
    }
}

