/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.views.actions;

import com.blixx.boom.engine.BMUI;
import com.blixx.boom.engine.EventFilter;
import com.blixx.boom.engine.Repository;
import com.blixx.shared.SEvent;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.action.Action;

public class UnloadClosedIndications
extends Action {
    List<EventFilter> m_filters = null;

    public UnloadClosedIndications(List<EventFilter> filters) {
        this.m_filters = filters;
        this.setId(((Object)((Object)this)).getClass().getName());
        this.setText("Unload indications (Use active filters)");
        this.setImageDescriptor(BMUI.IMAGE_DESC_INDICATIONS);
    }

    public void run() {
        ArrayList<EventFilter> encFilters = new ArrayList<EventFilter>(0);
        if (this.m_filters != null && this.m_filters.size() > 0) {
            encFilters.ensureCapacity(this.m_filters.size());
            for (EventFilter ef : this.m_filters) {
                if (!ef.m_isActive) continue;
                encFilters.add(ef);
            }
        }
        UnloadClosedIndications.removeFiltered(encFilters);
        Repository.getEventStorageSubmit().fillTable();
    }

    public static void removeFiltered(ArrayList<EventFilter> encFilters) {
        if (encFilters.size() > 0) {
            LinkedList<String> selectedID = new LinkedList<String>();
            Map<String, SEvent> map = Repository.getEventProvider().getClosedMap();
            for (Map.Entry<String, SEvent> en : map.entrySet()) {
                boolean matches = true;
                for (EventFilter ef : encFilters) {
                    if (ef.select(null, null, en.getValue())) continue;
                    matches = false;
                    break;
                }
                if (!matches) continue;
                selectedID.add(en.getKey());
            }
            for (String id : selectedID) {
                Repository.getEventStorageSubmit().removeClosedID(id);
            }
        } else {
            Repository.getEventStorageSubmit().removeAcknowledged();
        }
    }
}

