/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.views.actions;

import com.blixx.boom.engine.JobManager;
import com.blixx.boom.engine.Repository;
import com.blixx.boom.engine.ServerClient;
import com.blixx.boom.engine.ServerClientBatch;
import com.blixx.ctrl.sc.in.ScPolicyTreeUpdate;
import com.blixx.ctrl.sc.in.ScPolicyTreeUpdate_Add;
import com.blixx.ctrl.sc.in.ScPolicyTreeUpdate_Delete;
import com.blixx.ctrl.sc.in.ScPolicyTreeUpdate_DeleteRecursive;
import com.blixx.ctrl.sc.in.ScPolicyTreeUpdate_Move;
import com.blixx.ctrl.sc.in.ScPolicyTreeUpdate_Rename;
import com.blixx.log.RTLogger;
import com.blixx.shared.sc.CMDS;
import java.util.List;

public class UpdateServer {
    public static String ACTION_DELACTION = "del_action";
    public String m_resultString = "Unknown error.";

    public synchronized boolean syncWithServer(String treePath, String newElement, String action, String type) {
        boolean isOK = true;
        RTLogger.print(5, "Updating server policyTree: Action=" + action + " PATH=" + treePath + " {" + newElement + "}");
        ScPolicyTreeUpdate sc = null;
        if (action.equals(CMDS.ACTION_DEL)) {
            sc = newElement.equals("nonrecursive") ? new ScPolicyTreeUpdate_Delete(Repository.getInstance(), treePath, type) : new ScPolicyTreeUpdate_DeleteRecursive(Repository.getInstance(), treePath, type);
        } else if (action.equals(CMDS.ACTION_ADD)) {
            sc = new ScPolicyTreeUpdate_Add(Repository.getInstance(), treePath, newElement, type);
        } else if (action.equals(CMDS.ACTION_RNM)) {
            sc = new ScPolicyTreeUpdate_Rename(Repository.getInstance(), treePath, newElement, type);
        }
        JobManager.getInstance().schedule(sc);
        return isOK;
    }

    public synchronized boolean syncWithServer(ServerClientBatch scBatch, String treePath, String newElement, String action, String type) {
        boolean isOK = true;
        RTLogger.print(5, "Updating server policyTree: Action=" + action + " PATH=" + treePath + " {" + newElement + "}");
        ScPolicyTreeUpdate sc = null;
        if (action.equals(CMDS.ACTION_DEL_and_UNDEPLOY) || action.equals(CMDS.ACTION_DEL)) {
            sc = newElement.equals("nonrecursive") ? new ScPolicyTreeUpdate_Delete(Repository.getInstance(), treePath, type) : new ScPolicyTreeUpdate_DeleteRecursive(Repository.getInstance(), treePath, type);
        } else if (action.equals(CMDS.ACTION_MOVE)) {
            sc = new ScPolicyTreeUpdate_Move(Repository.getInstance(), treePath, newElement, type);
        } else if (action.equals(CMDS.ACTION_ADD)) {
            sc = new ScPolicyTreeUpdate_Add(Repository.getInstance(), treePath, newElement, type);
        }
        JobManager.getInstance().schedule(sc);
        return isOK;
    }

    public synchronized boolean syncAsnWithServer(String treePath, String newElement, String action, String type) {
        boolean isOK = false;
        RTLogger.print(5, "Updating server assignmentTree: Action=" + action + " PATH=" + treePath + " {" + newElement + "}");
        ServerClient sc = ServerClient.updateAssignmentTree(treePath, newElement, action, type);
        sc.runInUIThread(null);
        this.m_resultString = (String)sc.getResultObject();
        isOK = sc.isSuccess();
        return isOK;
    }

    public synchronized boolean syncAsnWithServer(ServerClientBatch scBatch, String treePath, String newElement, String action, String type) {
        boolean isOK = false;
        RTLogger.print(5, "Updating server assignmentTree: Action=" + action + " PATH=" + treePath + " {" + newElement + "}");
        scBatch.setCommand("ASSIGNMENTTREEUPDATE2", null, new String[]{treePath, newElement, action, type});
        this.m_resultString = (String)scBatch.runBatch();
        isOK = scBatch.isSuccess();
        return isOK;
    }

    @Deprecated
    public synchronized boolean syncAsnWithServer(List<String> arr) {
        boolean isOK = false;
        RTLogger.print(5, "Updating server assignmentTree BatcH arr=" + arr);
        ServerClient sc = ServerClient.updateAssignmentTree(arr.toArray(new String[0]));
        sc.runInUIThread(null);
        this.m_resultString = (String)sc.getResultObject();
        isOK = ((String)sc.getResultObject()).indexOf(70) == -1;
        return isOK;
    }

    public synchronized boolean syncWithActionServer(String action, String[] params) {
        boolean isOK = false;
        ServerClient sc = null;
        RTLogger.print(5, "Updating server actionTree: Action=" + action);
        if (action.equals(CMDS.ACTION_ADD)) {
            sc = ServerClient.addGrp(params[0]);
        } else if (action.equals(CMDS.ACTION_RNM)) {
            sc = ServerClient.renameActionGrp(params[0], params[1]);
        } else if (action.equals(CMDS.ACTION_DEL)) {
            sc = ServerClient.deleteActionGrp(params[0]);
        } else if (action.equals(ACTION_DELACTION)) {
            sc = ServerClient.deleteAction(params[0]);
        }
        if (sc != null) {
            sc.runInUIThread(null);
            this.m_resultString = (String)sc.getResultObject();
            isOK = sc.isSuccess();
        }
        return isOK;
    }

    public synchronized boolean syncWithActionServer(ServerClientBatch scBatch, String action, String[] params) {
        boolean isOK = true;
        RTLogger.print(5, "Updating server actionTree: Action=" + action);
        if (action.equals(CMDS.ACTION_ADD)) {
            scBatch.setCommand("UPDATEACTIONTREE", "ADD_GRP", new String[]{params[0]});
        } else if (action.equals(CMDS.ACTION_RNM)) {
            scBatch.setCommand("UPDATEACTIONTREE", "RENAME_GRP", new String[]{params[0], params[1]});
        } else if (action.equals(CMDS.ACTION_DEL)) {
            scBatch.setCommand("UPDATEACTIONTREE", "DELETE_GRP", new String[]{params[0]});
        } else if (action.equals(ACTION_DELACTION)) {
            scBatch.setCommand("UPDATEACTIONTREE", "DELETE", new String[]{params[0]});
        }
        this.m_resultString = (String)scBatch.runBatch();
        isOK = scBatch.isSuccess();
        return isOK;
    }
}

