/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.views.actions;

import com.blixx.boom.engine.BMUI;
import com.blixx.boom.engine.Repository;
import com.blixx.boom.engine.ServerClient;
import com.blixx.boom.gui.dialogs.ShowMessageBox;
import com.blixx.log.RTLogger;
import org.eclipse.jface.action.Action;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;

public class UploadFileAction
extends Action {
    private String m_pathToPakage = null;

    public UploadFileAction(String pathToPackage) {
        super("Upload File");
        this.m_pathToPakage = "srv/packages" + pathToPackage + "/";
        this.setText("Upload File");
        try {
            this.setId("com.blixx.boom.gui.uploadJAR");
            this.setActionDefinitionId("com.blixx.boom.gui.uploadJAR");
            this.setImageDescriptor(BMUI.IMAGE_DESCR_UPLOAD_FILE);
        }
        catch (RuntimeException runtimeException) {}
        if (Repository.getInstance().getRights(1006) < 3) {
            this.setEnabled(false);
        }
    }

    public void run() {
        try {
            FileDialog fd = new FileDialog(Display.getCurrent().getActiveShell(), 4096);
            fd.setText("Select File to upload");
            String file = fd.open();
            RTLogger.print(5, "File to upload: " + file);
            if (file != null) {
                String pathOnTheServer = String.valueOf(this.m_pathToPakage) + fd.getFileName();
                ServerClient sc = new ServerClient("PUT_FILE", pathOnTheServer, new String[]{file});
                sc.run();
                if (sc.isSuccess()) {
                    new ShowMessageBox("Uploading File", "File uploaded: " + this.m_pathToPakage + fd.getFileName(), 2);
                } else {
                    new ShowMessageBox("Uploading File", " Failed to upload file: " + this.m_pathToPakage + fd.getFileName(), 1);
                }
            }
        }
        catch (RuntimeException e) {
            e.printStackTrace();
        }
    }
}

