/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.views.actions;

import com.blixx.boom.engine.BMUI;
import com.blixx.boom.engine.EventFilter;
import com.blixx.boom.engine.EventFilterAgentAndHost;
import com.blixx.boom.engine.ServiceDashBoard;
import com.blixx.boom.gui.dialogs.EventFilterDialog2;
import com.blixx.boom.gui.settings.UISettings;
import com.blixx.boom.gui.views.MessageBrowserTab;
import com.blixx.boom.gui.views.sim.SimTab;
import com.blixx.shared.utils.HashMapArray;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.CTabItem;

public class ViewFilterAction
extends Action {
    public static HashMapArray<TableViewer, EventFilter> m_filters = new HashMapArray();
    private TableViewer m_lv = null;
    private MessageBrowserTab m_window = null;
    private String m_name = null;
    private String m_title = null;
    private CTabItem m_tab = null;
    private EventFilter m_ef = null;

    public static Iterator<EventFilter> getActiveFiltersIterator(TableViewer tv) {
        return m_filters.iterator(tv);
    }

    public static void addFilter(Object tab, TableViewer tv, EventFilter ef) {
        if (ef == null || tv == null) {
            return;
        }
        m_filters.putV(tv, ef);
        ViewerFilter[] filters = m_filters.getArray(tv).toArray(new EventFilter[0]);
        tv.setFilters(filters);
        tv.setSelection((ISelection)StructuredSelection.EMPTY);
        tv.refresh();
        if (tab != null && tab instanceof MessageBrowserTab) {
            ((MessageBrowserTab)((Object)tab)).createSummary();
        }
    }

    public static void removeFilter(Object tab, TableViewer tv, String[] selection) {
        int i = 0;
        while (i < selection.length) {
            String filterName = selection[i];
            Iterator<EventFilter> it = ViewFilterAction.getActiveFiltersIterator(tv);
            while (it.hasNext()) {
                if (!it.next().toString().equals(filterName)) continue;
                it.remove();
            }
            ++i;
        }
        ViewerFilter[] filters = m_filters.getArray(tv).toArray(new EventFilter[0]);
        tv.setFilters(filters);
        tv.setSelection((ISelection)StructuredSelection.EMPTY);
        tv.refresh();
        if (tab != null && tab instanceof MessageBrowserTab) {
            ((MessageBrowserTab)((Object)tab)).createSummary();
        }
    }

    public static void removeFiltersForTable(Object tab, TableViewer tv) {
        m_filters.remove(tv);
    }

    public static void resetFilters(Object tab, TableViewer tv, HashMapArray<TableViewer, EventFilter> filters) {
        ArrayList eFilters = (ArrayList)filters.get(tv);
        m_filters.remove(tv);
        m_filters.put(tv, eFilters);
        if (tab != null && tab instanceof MessageBrowserTab) {
            ((MessageBrowserTab)((Object)tab)).createSummary();
        }
    }

    public static boolean hasFilter(TableViewer tv, EventFilter ef) {
        List<EventFilter> array = m_filters.getArray(tv);
        if (array == null || array.size() == 0) {
            return false;
        }
        return array.contains((Object)ef);
    }

    public static EventFilter getFilterByName(TableViewer tv, String name) {
        EventFilter filter = null;
        Iterator<EventFilter> it = ViewFilterAction.getActiveFiltersIterator(tv);
        while (it.hasNext()) {
            EventFilter ef = it.next();
            if (!ef.toString().equals(name)) continue;
            filter = ef;
            break;
        }
        return filter;
    }

    public static void addSorter(TableViewer tv, ViewerSorter sorter) {
        tv.setSorter(sorter);
    }

    public static boolean hasActiveFilter(TableViewer tv) {
        Iterator<EventFilter> it = m_filters.iterator(tv);
        while (it.hasNext()) {
            EventFilter ef = it.next();
            if (!ef.m_isActive) continue;
            return true;
        }
        return false;
    }

    public ViewFilterAction(CTabItem tab, MessageBrowserTab window, TableViewer lv, EventFilter ef, String label, boolean isChecked, String title) {
        super("VFilter");
        this.m_window = window;
        this.m_lv = lv;
        this.m_name = label;
        this.m_ef = ef;
        this.m_tab = tab;
        if (this.m_ef == null) {
            this.setText("Filters ...");
            this.setId("VF_new");
            this.m_title = "  Filter Dialog:  " + title;
            if (this.m_tab != null && this.m_tab.getData() != null && this.m_tab.getData() instanceof ServiceDashBoard) {
                this.setEnabled(false);
            }
        } else {
            this.setId("VF_" + this.m_name);
            if (ef != null && ef instanceof EventFilterAgentAndHost) {
                this.setImageDescriptor(BMUI.IMAGE_DESCR_FILTERED);
                this.setText(title);
            } else if (ef != null && ef instanceof ServiceDashBoard) {
                this.setImageDescriptor(BMUI.IMAGE_DESCR_SDASH);
                this.setText(title);
            } else {
                this.setImageDescriptor(BMUI.IMAGE_DESCR_FILTERED);
                this.setText(this.m_name);
            }
            this.setChecked(isChecked);
            if (this.m_ef.m_isLocked) {
                this.setEnabled(false);
            }
        }
        if (!UISettings.getInstance().IB_canModifyFilters() || ef instanceof ServiceDashBoard || this.m_tab == null || this.m_window == null) {
            this.setEnabled(false);
        }
    }

    public void run() {
        if (!this.isEnabled()) {
            return;
        }
        boolean setFilters = false;
        if (this.m_ef == null) {
            this.showDialog2();
        } else {
            this.m_ef.m_isActive = !this.m_ef.m_isActive;
            setFilters = true;
        }
        if (m_filters.size() > 0 && m_filters.getArray(this.m_lv) != null) {
            List<EventFilter> viewFiltersExpected = m_filters.getArray(this.m_lv);
            if (setFilters || viewFiltersExpected.size() != this.m_lv.getFilters().length) {
                setFilters = true;
            } else {
                ViewerFilter[] viewerFilterArray = this.m_lv.getFilters();
                int n = viewerFilterArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ViewerFilter vr = viewerFilterArray[n2];
                    if (vr instanceof EventFilter) {
                        EventFilter efInView = (EventFilter)vr;
                        int foundInExpected = viewFiltersExpected.indexOf((Object)efInView);
                        if (foundInExpected == -1) {
                            setFilters = true;
                            break;
                        }
                        EventFilter expected = viewFiltersExpected.get(foundInExpected);
                        if (expected.m_isActive != efInView.m_isActive || expected.m_isLocked != efInView.m_isLocked || !expected.getLabel().equals(efInView.getLabel())) {
                            setFilters = true;
                            break;
                        }
                    } else {
                        setFilters = true;
                        break;
                    }
                    ++n2;
                }
            }
            if (setFilters) {
                ViewerFilter[] filters = viewFiltersExpected.toArray(new EventFilter[0]);
                this.m_lv.setFilters(filters);
            }
        }
        this.m_lv.setSelection((ISelection)StructuredSelection.EMPTY);
        boolean state = this.m_window.isTableLockedManually();
        if (state) {
            this.m_window.setTableLocked(false, true);
        }
        this.m_lv.refresh();
        if (state) {
            this.m_window.setTableLocked(true, true);
        }
        if (this.m_tab != null) {
            if (this.m_tab instanceof MessageBrowserTab) {
                ((MessageBrowserTab)this.m_tab).createSummary();
            } else if (this.m_tab instanceof SimTab) {
                ((SimTab)this.m_tab).checkTitle();
            }
        }
        UISettings.getInstance().storeAndReload();
    }

    public void showDialog2() {
        EventFilterDialog2 efd = new EventFilterDialog2(this.m_lv, this.m_title, this.m_tab, this.m_window.getEventsSummary());
        efd.open();
    }

    public TableViewer getTableViewer() {
        return this.m_lv;
    }

    public String getText() {
        String text2 = super.getText();
        if (text2.length() > 50) {
            text2 = String.valueOf(text2.substring(0, 50)) + "...";
        }
        return text2;
    }

    public static List<EventFilter> getFilters(TableViewer tv) {
        return m_filters.getArray(tv);
    }
}

