/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.views.configuration;

import com.blixx.boom.engine.BMUI;
import com.blixx.boom.engine.Repository;
import com.blixx.boom.engine.UIJob;
import com.blixx.boom.gui.views.configuration.EditorSiteVirtual;
import com.blixx.boom.gui.views.configuration.EditorTab;
import com.blixx.boom.gui.views.configuration.IndiBrowserConfigTab;
import com.blixx.boom.gui.views.configuration.LdapTab;
import com.blixx.boom.gui.views.configuration.SnmpV3Tab;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabFolder2Listener;
import org.eclipse.swt.custom.CTabFolderEvent;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.ISaveablePart;
import org.eclipse.ui.part.ViewPart;

public class ConfigurationView
extends ViewPart
implements CTabFolder2Listener,
SelectionListener,
ISaveablePart {
    public static final int VIEW_ID = 2004;
    public static final String ID = "com.blixx.boom.gui.views.configurationview";
    private static ConfigurationView m_instance = null;
    protected Composite m_parent = null;
    private static CTabFolder m_folder = null;
    private EditorTab m_etcHostTab = null;
    private int m_tabIndex = -1;
    protected IEditorSite m_site = null;

    public ConfigurationView() {
        m_instance = this;
    }

    public static ConfigurationView getInstance() {
        return m_instance;
    }

    public CTabFolder getFolder() {
        return m_folder;
    }

    public void createPartControl(Composite parent) {
        if (Repository.getInstance().getRights(2004) < 2) {
            parent.setLayout((Layout)new GridLayout(2, false));
            Label l = new Label(parent, 0);
            l.setText(" Insufficient rights.");
            l.setForeground(BMUI.color_critical);
            Button close = new Button(parent, 8);
            close.setText("Close");
            close.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    ConfigurationView.this.getSite().getPage().hideView(ConfigurationView.this.getSite().getPage().findView(ConfigurationView.ID));
                }
            });
            UIJob uiJob = new UIJob("Close Viewcom.blixx.boom.gui.views.configurationview"){

                @Override
                public IStatus runInUIThread(IProgressMonitor monitor) {
                    ConfigurationView.this.getSite().getPage().hideView(ConfigurationView.this.getSite().getPage().findView(ConfigurationView.ID));
                    return Status.OK_STATUS;
                }
            };
            Repository.getUIJobManager().schedule(uiJob);
            return;
        }
        this.setTitleImage(BMUI.IMAGE_SETTINGS);
        ConfigurationView.m_instance.m_parent = parent;
        this.m_site = new EditorSiteVirtual(this);
        ConfigurationView.createFolder();
        this.createETCHostsTab();
        this.createIgnorePerfTab();
        this.createMsgBrowserConfigTab();
        this.createLDAPConfigTab();
        this.createSNMPV3Tab();
        m_folder.setSelection(2);
    }

    public static void createFolder() {
        m_folder = new CTabFolder(ConfigurationView.m_instance.m_parent, 2816);
        m_folder.setSimple(false);
        m_folder.setMinimizeVisible(false);
        m_folder.setMaximizeVisible(false);
        m_folder.setBorderVisible(false);
        m_folder.setBackground(BMUI.color_unknown);
        m_folder.addCTabFolder2Listener((CTabFolder2Listener)m_instance);
        m_folder.addSelectionListener((SelectionListener)m_instance);
    }

    public void createETCHostsTab() {
        for (String slaveHostname : Repository.getInstance().getSlaves()) {
            new EditorTab(m_folder, slaveHostname, this.m_site, ++this.m_tabIndex);
        }
        this.m_etcHostTab = new EditorTab(m_folder, null, this.m_site, ++this.m_tabIndex);
    }

    public void createIgnorePerfTab() {
    }

    public void createMsgBrowserConfigTab() {
        new IndiBrowserConfigTab(m_folder, ++this.m_tabIndex);
    }

    public void createLDAPConfigTab() {
        new LdapTab(m_folder, ++this.m_tabIndex);
    }

    public void createSNMPV3Tab() {
        new SnmpV3Tab(m_folder, 0);
    }

    public void createPropsTab() {
    }

    public void setFocus() {
    }

    public void close(CTabFolderEvent event) {
    }

    public void minimize(CTabFolderEvent event) {
        m_folder.setMinimized(true);
        ConfigurationView.m_instance.m_parent.layout(true);
    }

    public void maximize(CTabFolderEvent event) {
        m_folder.setMaximized(true);
        m_folder.setLayoutData((Object)new GridData(4, 4, true, true));
        ConfigurationView.m_instance.m_parent.layout(true);
    }

    public void restore(CTabFolderEvent event) {
        m_folder.setMinimized(false);
        m_folder.setMaximized(false);
        m_folder.setLayoutData((Object)new GridData(4, 4, true, false));
        ConfigurationView.m_instance.m_parent.layout(true);
    }

    public void showList(CTabFolderEvent event) {
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        try {
            if (e.item instanceof EditorTab) {
                ((EditorTab)e.item).getSimpleEditor().updateActions(true);
            } else {
                ((EditorTab)e.item).getSimpleEditor().updateActions(false);
            }
        }
        catch (Throwable throwable) {}
    }

    public void doSave(IProgressMonitor monitor) {
        if (this.getFolder().getSelection() instanceof EditorTab) {
            EditorTab et = (EditorTab)this.getFolder().getSelection();
            et.save(true);
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    public void doSaveAs() {
    }

    public boolean isDirty() {
        try {
            CTabItem ci = m_folder.getSelection();
            if (ci instanceof EditorTab) {
                return ((EditorTab)ci).getSimpleEditor().isDirty();
            }
        }
        catch (Throwable throwable) {}
        return false;
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public boolean isSaveOnCloseNeeded() {
        return false;
    }

    protected void firePartPropertyChanged(String key, String oldValue, String newValue) {
        super.firePartPropertyChanged(key, oldValue, newValue);
    }

    protected void firePropertyChange(int propertyId) {
        super.firePropertyChange(propertyId);
    }

    public void dispose() {
        super.dispose();
    }
}

