/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.views.configuration;

import com.blixx.boom.editors.IEditorMenuListener;
import com.blixx.boom.editors.PathEditorInput;
import com.blixx.boom.editors.SimpleDocumentProvider;
import com.blixx.boom.editors.SimpleDocumentProviderReadOnly;
import com.blixx.boom.editors.SimpleEditor;
import com.blixx.boom.engine.ActionClient;
import com.blixx.boom.engine.BMUI;
import com.blixx.boom.engine.Repository;
import com.blixx.boom.engine.ServerClient;
import com.blixx.boom.engine.ServerClientBatch;
import com.blixx.boom.gui.Activator;
import com.blixx.boom.gui.utils.GUIDisplayElements;
import com.blixx.log.RTLogger;
import com.blixx.shared.utils.FileUtils;
import java.io.File;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.texteditor.ITextEditorActionConstants;

public class EditorTab
extends CTabItem
implements IPropertyListener,
IEditorMenuListener,
SelectionListener {
    private CTabFolder m_folder = null;
    protected SimpleEditor m_se = null;
    private Composite m_compEditor = null;
    private Button m_save_btn = null;
    private Button m_undo_btn = null;
    private Button m_reload_btn = null;
    private GUIDisplayElements m_gui = null;
    private String TAB_NAME = "srv/etc/hosts";
    private static String SAVE = "SAVE";
    private static String UNDO = "UNDO";
    private static String RELOAD = "RELOAD";
    private String m_serverPath = "srv/etc/hosts";
    private String m_fileName = "hosts";
    private String m_localDir = Repository.getUserTmpDirectory();
    private String m_tabName = null;
    private String m_slaveHostName = null;
    private AtomicBoolean m_isEditable = new AtomicBoolean(false);
    protected IEditorInput m_EditorInput;
    protected IEditorSite m_site = null;
    private ISharedImages m_sharedImages = Activator.getDefault().getWorkbench().getActiveWorkbenchWindow().getWorkbench().getSharedImages();

    public EditorTab(CTabFolder folder, String slaveOrNull, IEditorSite site, int index, String fileName, String srvPath, String tabName) {
        super(folder, 0, index);
        this.m_fileName = fileName;
        this.m_serverPath = srvPath;
        this.TAB_NAME = tabName;
        this.init(folder, slaveOrNull, site, index);
    }

    public EditorTab(CTabFolder folder, String slaveOrNull, IEditorSite site, int index) {
        super(folder, 0, index);
        this.init(folder, slaveOrNull, site, index);
    }

    private void init(CTabFolder folder, String slaveOrNull, IEditorSite site, int index) {
        this.m_folder = folder;
        this.m_slaveHostName = slaveOrNull;
        this.m_site = site;
        this.m_gui = new GUIDisplayElements();
        if (this.m_slaveHostName != null) {
            this.m_localDir = String.valueOf(Repository.getUserTmpDirectory()) + File.separator + "ssc" + File.separator + FileUtils.getValidFileName(this.m_slaveHostName);
        }
        if (this.m_slaveHostName != null) {
            this.setText(String.valueOf(this.TAB_NAME) + '@' + this.m_slaveHostName);
            this.m_tabName = String.valueOf(this.TAB_NAME) + '@' + this.m_slaveHostName;
        } else {
            this.setText(this.TAB_NAME);
            this.m_tabName = this.TAB_NAME;
        }
        this.setImage(null);
        Composite compInCTab = new Composite((Composite)this.m_folder, 0);
        GridLayout gl = new GridLayout(1, false);
        gl.verticalSpacing = 0;
        gl.horizontalSpacing = 0;
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        compInCTab.setLayout((Layout)gl);
        ScrolledComposite sc = new ScrolledComposite(compInCTab, 2816);
        sc.setAlwaysShowScrollBars(false);
        sc.setExpandHorizontal(true);
        sc.setExpandVertical(true);
        sc.setLayout((Layout)new GridLayout(1, false));
        sc.setLayoutData((Object)new GridData(4, 4, true, true));
        this.m_compEditor = new Composite((Composite)sc, 0);
        this.m_compEditor.setLayout((Layout)new GridLayout(1, false));
        this.createEditor();
        Composite lineComp = new Composite(compInCTab, 0);
        gl = new GridLayout(1, false);
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        lineComp.setLayout((Layout)gl);
        lineComp.setLayoutData((Object)new GridData(4, 128, true, false));
        Label line = new Label(lineComp, 259);
        line.setForeground(BMUI.color_darkGrey2);
        line.setLayoutData((Object)new GridData(4, 128, true, false));
        Composite compBtn = new Composite(compInCTab, 0);
        GridData gd = new GridData(16384, 16384, false, false);
        gd.verticalIndent = 10;
        compBtn.setLayoutData((Object)gd);
        if (this.isEditable()) {
            gl = new GridLayout(3, false);
            gl.horizontalSpacing = 0;
            compBtn.setLayout((Layout)gl);
            this.m_save_btn = this.m_gui.addButton(compBtn, SAVE, " Save ", false, 60, 0, 0, this);
            ((GridData)this.m_save_btn.getLayoutData()).horizontalAlignment = 4;
            this.m_save_btn.setImage(this.m_sharedImages.getImage("IMG_ETOOL_SAVE_EDIT"));
            this.m_undo_btn = this.m_gui.addButton(compBtn, UNDO, " Undo ", false, 60, 0, 0, this);
            ((GridData)this.m_undo_btn.getLayoutData()).horizontalAlignment = 4;
            this.m_undo_btn.setImage(this.m_sharedImages.getImage("IMG_TOOL_UNDO"));
            this.m_reload_btn = this.m_gui.addButton(compBtn, RELOAD, " Reload from Server ", true, 60, 0, 0, this);
            ((GridData)this.m_reload_btn.getLayoutData()).horizontalAlignment = 4;
            this.m_reload_btn.setImage(BMUI.IMAGE_REFRESH);
        } else {
            gl = new GridLayout(1, false);
            gl.horizontalSpacing = 0;
            compBtn.setLayout((Layout)gl);
            this.m_reload_btn = this.m_gui.addButton(compBtn, RELOAD, " Reload from Server ", true, 60, 0, 0, this);
            ((GridData)this.m_reload_btn.getLayoutData()).horizontalAlignment = 4;
            this.m_reload_btn.setImage(BMUI.IMAGE_REFRESH);
        }
        sc.setContent((Control)this.m_compEditor);
        sc.setMinSize(this.m_compEditor.computeSize(-1, -1, true));
        this.setControl((Control)compInCTab);
    }

    private void createEditor() {
        this.getFileFromServer();
        this.setEditable(Repository.getInstance().getRights(2004) == 3);
        this.m_se = this.isEditable() ? new SimpleEditor(new SimpleDocumentProvider()) : new SimpleEditor(new SimpleDocumentProviderReadOnly());
        this.m_se.addPropertyListener(this);
        this.m_se.addEditorMenuListener(this);
        try {
            this.m_se.init(this.m_site, this.createEditorInput(this.getTempFilePath()));
        }
        catch (PartInitException partInitException) {}
        try {
            this.m_se.createPartControl(this.m_compEditor);
        }
        catch (Throwable throwable) {}
        if (this.m_EditorInput == null) {
            this.m_EditorInput = this.createEditorInput(this.getTempFilePath());
        }
        this.m_se.setInput(this.m_EditorInput);
    }

    private IEditorInput createEditorInput(String path) {
        Path location = new Path(path);
        PathEditorInput input = new PathEditorInput((IPath)location);
        return input;
    }

    public void propertyChanged(Object source, int propId) {
        if (this.isEditable()) {
            IAction a = this.m_se.getAction(ITextEditorActionConstants.SAVE);
            if (a != null) {
                a.setEnabled(this.m_se.isDirty());
            }
            this.refreshTitle();
            this.checkButtonStatus();
        }
    }

    @Override
    public void editorContextMenuAboutToShow(IMenuManager menu) {
        ReloadAction reload = new ReloadAction();
        menu.add((IAction)reload);
    }

    protected void refreshTitle() {
        String title = this.getText();
        if (this.m_se.isDirty()) {
            if (!title.startsWith("* ")) {
                this.setText("* " + title);
            }
        } else if (title.startsWith("* ")) {
            this.setText(title.substring(2));
        }
    }

    private void checkButtonStatus() {
        this.m_gui.enableField(this.m_save_btn, this.m_se.isDirty());
        this.m_gui.enableField(this.m_undo_btn, this.m_se.isDirty());
    }

    private void getFileFromServer() {
        block16: {
            File tmp = new File(this.getTempFilePath());
            if (tmp.exists() && !tmp.delete()) {
                RTLogger.print(1, "Can't delete temp file: " + this.getTempFilePath());
            }
            ServerClientBatch scb = null;
            try {
                try {
                    scb = new ServerClientBatch("GETFILE");
                    scb.openSocket();
                    if (this.m_slaveHostName == null) {
                        scb.setCommand("GETFILE", null, new String[]{this.m_serverPath, BMUI.type_file, this.getTempDir()});
                    } else {
                        scb.setCommand("GETFILE_SLAVE", null, new String[]{this.m_serverPath, BMUI.type_file, this.m_slaveHostName, this.getTempDir()});
                    }
                    Object res = scb.runBatch();
                    if (scb.isSuccess() && res != null) {
                        this.setEditable(true);
                    } else {
                        this.setEditable(false);
                        RTLogger.print(5, "Error getting file from server");
                    }
                }
                catch (RuntimeException e) {
                    RTLogger.print(4, "Error loading file " + this.m_fileName, e);
                    try {
                        scb.close();
                    }
                    catch (Throwable throwable) {}
                    break block16;
                }
            }
            catch (Throwable throwable) {
                try {
                    scb.close();
                }
                catch (Throwable throwable2) {}
                throw throwable;
            }
            try {
                scb.close();
            }
            catch (Throwable throwable) {}
        }
    }

    void save(boolean doConfirm) {
        this.save(this.getTempFilePath(), doConfirm);
    }

    void save(String localTempFile, boolean doConfirm) {
        this.getSimpleEditor().getSite().getPage().saveEditor((IEditorPart)this.getSimpleEditor(), doConfirm);
        File file = new File(localTempFile);
        file.exists();
        try {
            this.putFileToServer(file, localTempFile);
            if (this.m_slaveHostName == null) {
                ActionClient ac = new ActionClient("RemoteAction", "RELOAD_HOSTS", "BOOM_SERVER", 30, null, null);
                ac.schedule(0L);
            } else {
                ActionClient ac = new ActionClient("RemoteAction", "RELOAD_HOSTS (BS:" + this.m_slaveHostName + ")", "BOOM_SERVER", 30, null, null);
                ac.schedule(0L);
            }
            this.refreshTitle();
            this.checkButtonStatus();
        }
        catch (Throwable e) {
            RTLogger.print(4, "Cannot send file " + localTempFile, e);
        }
    }

    private void putFileToServer(File file, String localPath) {
        block9: {
            if (this.m_slaveHostName == null) {
                ServerClient sc = null;
                try {
                    sc = new ServerClient("PUT_FILE", this.m_serverPath, new String[]{localPath});
                    sc.run();
                    if (sc.isSuccess()) {
                        RTLogger.print(5, "Uploading local File " + localPath + " to " + this.m_serverPath);
                        break block9;
                    }
                    RTLogger.print(5, "Error uploading local File " + localPath + " to " + this.m_serverPath);
                }
                catch (RuntimeException e) {
                    RTLogger.print(5, "Error uploading local File " + localPath + " to " + this.m_serverPath, e);
                }
            } else {
                ServerClient sc = null;
                try {
                    sc = new ServerClient("PUT_FILE_SLAVE", this.m_serverPath, new String[]{localPath, this.m_slaveHostName});
                    sc.run();
                    if (sc.isSuccess()) {
                        RTLogger.print(5, "Uploading local File " + localPath + " to " + this.m_serverPath);
                    } else {
                        RTLogger.print(5, "Error uploading local File " + localPath + " to " + this.m_serverPath);
                    }
                }
                catch (RuntimeException e) {
                    RTLogger.print(5, "Error uploading local File " + localPath + " to " + this.m_serverPath, e);
                }
            }
        }
    }

    public void refresh() {
        this.m_EditorInput = this.createEditorInput(this.getTempFilePath());
        this.m_se.setInput(this.m_EditorInput);
    }

    public void reloadFromServer() {
        this.getFileFromServer();
        this.refresh();
    }

    public String getTempFilePath() {
        return String.valueOf(this.getTempDir()) + this.m_fileName;
    }

    public String getTempDir() {
        return String.valueOf(this.m_localDir) + File.separator;
    }

    public String getTabName() {
        return this.m_tabName;
    }

    public SimpleEditor getSimpleEditor() {
        return this.m_se;
    }

    public boolean isEditable() {
        return this.m_isEditable.get();
    }

    public void setEditable(boolean isEditable) {
        this.m_isEditable.compareAndSet(!isEditable, isEditable);
    }

    public void dispose() {
        if (this.getSimpleEditor().isDirty()) {
            try {
                StringBuilder sb = new StringBuilder();
                sb.append("The file '").append(this.getTabName()).append("' has been modified. \n\nSave Changes? ");
                ShowDialog dialog = new ShowDialog(this.m_folder.getShell(), sb.toString());
                int res = dialog.open();
                if (res == 0) {
                    this.save(false);
                }
            }
            catch (Throwable throwable) {}
        }
        super.dispose();
    }

    public void widgetSelected(SelectionEvent e) {
        Object o = e.getSource();
        if (o instanceof Button) {
            Button btn = (Button)o;
            String name = (String)btn.getData();
            if (name.equals(SAVE)) {
                this.save(true);
            } else if (name.equals(UNDO)) {
                this.refresh();
            } else if (name.equals(RELOAD)) {
                this.reloadFromServer();
            }
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public class ReloadAction
    extends Action {
        public ReloadAction() {
            super("reloadFromServeraction");
            this.setText("Reload from Server");
            this.setId("reloadFromServeraction" + EditorTab.this.m_serverPath);
            this.setImageDescriptor(BMUI.IMAGE_DESCR_REFRESH);
        }

        public void run() {
            EditorTab.this.reloadFromServer();
        }
    }

    public class ShowDialog
    extends StatusDialog
    implements DisposeListener {
        private Composite comp;
        private Label icon;
        private Label text;
        private String msgText;

        public ShowDialog(Shell parentShell, String msg) {
            super(parentShell);
            this.comp = null;
            this.icon = null;
            this.text = null;
            this.msgText = "";
            this.setShellStyle(this.getShellStyle() | 0x10 | 0x80 | 0x400);
            this.setTitle(" Save File ");
            this.setImage(BMUI.IMAGE_PRODUCT);
            this.msgText = msg;
        }

        protected Control createDialogArea(Composite parent) {
            GUIDisplayElements gui = new GUIDisplayElements();
            this.comp = new Composite(parent, 0);
            this.comp.addDisposeListener((DisposeListener)this);
            GridLayout gl = new GridLayout(2, false);
            gl.marginHeight = 0;
            gl.marginTop = 5;
            gl.marginRight = 10;
            this.comp.setLayout((Layout)gl);
            this.comp.setLayoutData((Object)new GridData(4, 4, true, true));
            this.icon = new Label(this.comp, 128);
            this.icon.setImage(BMUI.IMAGE_QUESTION_MARK);
            this.icon.setLayoutData((Object)new GridData(16384, 128, false, false));
            this.text = gui.addTextField(this.comp, null, this.msgText, 1, 1, 10, 1, null);
            ((GridData)this.text.getLayoutData()).horizontalIndent = 5;
            return parent;
        }

        protected void createButtonsForButtonBar(Composite parent) {
            this.createButton(parent, 2, " Yes ", true);
            this.createButton(parent, 1, " No ", false);
        }

        protected void buttonPressed(int buttonId) {
            if (buttonId == 2) {
                super.okPressed();
            } else if (buttonId == 1) {
                super.cancelPressed();
            }
        }

        public void widgetDisposed(DisposeEvent e) {
            try {
                this.comp.dispose();
            }
            catch (Throwable throwable) {}
            try {
                this.icon.dispose();
            }
            catch (Throwable throwable) {}
            try {
                this.text.dispose();
            }
            catch (Throwable throwable) {}
        }

        public boolean close() {
            return super.close();
        }
    }
}

