/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.views.configuration;

import com.blixx.boom.engine.BMUI;
import com.blixx.boom.engine.Repository;
import com.blixx.boom.gui.dialogs.ShowMessageBox;
import com.blixx.boom.gui.dialogs.ShowSimpleDialog;
import com.blixx.boom.gui.settings.BrowserLabelManager;
import com.blixx.boom.gui.utils.GUIDisplayElements;
import com.blixx.boom.gui.views.FancyToolTipSupport;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class IndiBrowserConfigTab
extends CTabItem
implements SelectionListener {
    public static String m_serverPath = "srv/etc/cfg/browserLabels";
    private BrowserLabelManager m_browserLabelManager = null;
    private boolean m_isDirty = false;
    private boolean m_isReadOnly = false;
    private GUIDisplayElements m_gui = null;
    private CTabFolder m_folder = null;
    private ScrolledComposite m_sc = null;
    private Composite m_compositeInCTab = null;
    private Button m_save_btn = null;
    private Button m_undo_btn = null;
    private Button m_useDefault_btn = null;
    private Button m_reload_btn = null;
    private MsgBrowserTableProvider m_tableProvider = null;
    private TableViewer m_tableViewer = null;
    private TableEditor m_editor = null;
    private static String SAVE = "SAVE";
    private static String UNDO = "UNDO";
    private static String RELOAD = "RELOAD";
    private static String USE_DEFAULT = "USE_DEFAULT";
    private final int EDITABLE_COLUMN = 1;
    private static Map<String, String> m_mapping = null;

    public IndiBrowserConfigTab(CTabFolder parent, int index) {
        super(parent, 0, index);
        this.setText(m_serverPath);
        this.setImage(null);
        this.m_folder = parent;
        this.m_browserLabelManager = Repository.getInstance().getBrowserLabelManager();
        this.m_isReadOnly = Repository.getInstance().getRights(2004) <= 2;
        this.loadFromServer();
        this.m_gui = new GUIDisplayElements();
        this.createMainArea();
    }

    public void createMainArea() {
        if (this.m_compositeInCTab != null && !this.m_compositeInCTab.isDisposed()) {
            Control[] controls = this.m_compositeInCTab.getChildren();
            int i = 0;
            while (i < controls.length) {
                controls[i].dispose();
                ++i;
            }
        } else {
            this.m_compositeInCTab = new Composite((Composite)this.m_folder, 0);
            GridLayout gl = new GridLayout(2, false);
            gl.verticalSpacing = 0;
            gl.horizontalSpacing = 0;
            gl.marginWidth = 0;
            gl.marginHeight = 0;
            this.m_compositeInCTab.setLayout((Layout)gl);
        }
        if (m_mapping == null) {
            Text error = this.m_gui.addTextReadOnlyNoBorder(this.m_compositeInCTab, null, "Error getting custom labels from the server!", 2, 1, 10, 20, null);
            error.setForeground(BMUI.color_critical);
            this.m_reload_btn = this.m_gui.addButton(this.m_compositeInCTab, RELOAD, " Reload from Server ", true, 80, 20, 15, this);
            ((GridData)this.m_reload_btn.getLayoutData()).horizontalAlignment = 16384;
            ((GridData)this.m_reload_btn.getLayoutData()).horizontalIndent = 10;
            this.m_reload_btn.setImage(BMUI.IMAGE_REFRESH);
        } else {
            this.m_sc = new ScrolledComposite(this.m_compositeInCTab, 2816);
            this.m_sc.setAlwaysShowScrollBars(false);
            this.m_sc.setExpandHorizontal(true);
            this.m_sc.setExpandVertical(true);
            this.m_sc.setLayout((Layout)new GridLayout(1, false));
            this.m_sc.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
            Composite tblComp = new Composite((Composite)this.m_sc, 0);
            GridLayout gl = new GridLayout(1, false);
            gl.marginWidth = 0;
            gl.marginHeight = 0;
            tblComp.setLayout((Layout)gl);
            tblComp.setLayoutData((Object)new GridData(4, 128, true, false));
            this.createTable(tblComp);
            Composite btnComp = new Composite(this.m_compositeInCTab, 0);
            btnComp.setLayoutData((Object)new GridData(16384, 4, false, false));
            if (!this.m_isReadOnly) {
                btnComp.setLayout((Layout)new GridLayout(4, true));
                this.m_save_btn = this.m_gui.addButton(btnComp, SAVE, " Save ", false, 80, 20, 0, this);
                ((GridData)this.m_save_btn.getLayoutData()).horizontalAlignment = 4;
                ((GridData)this.m_save_btn.getLayoutData()).grabExcessHorizontalSpace = true;
                this.m_save_btn.setImage(BMUI.IMAGE_SAVE);
                this.m_undo_btn = this.m_gui.addButton(btnComp, UNDO, " Undo ", false, 80, 20, 0, this);
                ((GridData)this.m_undo_btn.getLayoutData()).horizontalAlignment = 4;
                ((GridData)this.m_undo_btn.getLayoutData()).grabExcessHorizontalSpace = true;
                this.m_useDefault_btn = this.m_gui.addButton(btnComp, USE_DEFAULT, " Use Default ", !this.m_isReadOnly, 80, 20, 0, this);
                ((GridData)this.m_useDefault_btn.getLayoutData()).horizontalAlignment = 4;
                ((GridData)this.m_useDefault_btn.getLayoutData()).grabExcessHorizontalSpace = true;
                this.m_reload_btn = this.m_gui.addButton(btnComp, RELOAD, " Reload ", true, 80, 20, 0, this);
                ((GridData)this.m_reload_btn.getLayoutData()).horizontalAlignment = 16384;
                ((GridData)this.m_reload_btn.getLayoutData()).grabExcessHorizontalSpace = true;
                this.m_reload_btn.setImage(BMUI.IMAGE_REFRESH);
                Text txt = this.m_gui.addTextReadOnlyNoBorder(this.m_compositeInCTab, null, "Changes will be visible after UI Restart!", 1, 1, 5, 0, null);
                ((GridData)txt.getLayoutData()).horizontalAlignment = 16384;
            } else {
                btnComp.setLayout((Layout)new GridLayout(1, true));
                this.m_reload_btn = this.m_gui.addButton(btnComp, RELOAD, " Reload ", true, 80, 20, 0, this);
                ((GridData)this.m_reload_btn.getLayoutData()).horizontalAlignment = 16384;
                ((GridData)this.m_reload_btn.getLayoutData()).grabExcessHorizontalSpace = true;
                this.m_reload_btn.setImage(BMUI.IMAGE_REFRESH);
            }
            this.m_sc.setContent((Control)tblComp);
            this.m_sc.setMinSize(tblComp.computeSize(-1, -1, true));
        }
        this.m_compositeInCTab.layout(true);
        this.setControl((Control)this.m_compositeInCTab);
    }

    private void createTable(Composite parent) {
        Table table = new Table(parent, 268503042);
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        table.setLayout((Layout)new GridLayout());
        table.setLayoutData((Object)new GridData(4, 4, true, true));
        TableColumn col1 = new TableColumn(table, 0);
        col1.setText("Default Labels");
        col1.setWidth(200);
        TableColumn col2 = new TableColumn(table, 0);
        col2.setText("Custom Labels");
        col2.setWidth(500);
        this.m_tableViewer = new TableViewer(table);
        this.m_tableProvider = new MsgBrowserTableProvider(m_mapping);
        this.m_tableViewer.setLabelProvider((IBaseLabelProvider)this.m_tableProvider);
        this.m_tableViewer.setContentProvider((IContentProvider)this.m_tableProvider);
        this.m_tableViewer.setInput((Object)this.m_tableProvider.getElements(null));
        this.m_browserLabelManager.setTableViewer(this.m_tableViewer);
        FancyToolTipSupport.enableFor((ColumnViewer)this.m_tableViewer, 2);
        table.setToolTipText("");
        if (!this.m_isReadOnly) {
            this.m_editor = new TableEditor(table);
            this.m_editor.horizontalAlignment = 16384;
            this.m_editor.grabHorizontal = true;
            table.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    Object o1 = e.getSource();
                    Widget o2 = e.item;
                    if (o1 != null && o1 instanceof Table && o2 != null && o2 instanceof TableItem) {
                        Table tbl = (Table)o1;
                        TableItem row = (TableItem)o2;
                        Control oldEditor = IndiBrowserConfigTab.this.m_editor.getEditor();
                        if (oldEditor != null) {
                            oldEditor.dispose();
                        }
                        Text newEditor = new Text((Composite)tbl, 0);
                        newEditor.setText(row.getText(1));
                        newEditor.addModifyListener(new ModifyListener(){

                            public void modifyText(ModifyEvent me) {
                                Text text = (Text)IndiBrowserConfigTab.this.m_editor.getEditor();
                                IndiBrowserConfigTab.this.m_editor.getItem().setText(1, text.getText());
                                IndiBrowserConfigTab.this.setDirty(true);
                            }
                        });
                        newEditor.selectAll();
                        newEditor.setFocus();
                        IndiBrowserConfigTab.this.m_editor.setEditor((Control)newEditor, row, 1);
                    }
                }
            });
        }
    }

    private void loadFromServer() {
        m_mapping = Repository.getInstance().fetchBrowserLabelFromServer();
        if (m_mapping != null && m_mapping.isEmpty()) {
            m_mapping = this.m_browserLabelManager.getDefaultMapping();
        }
    }

    private void reloadFromServer() {
        this.loadFromServer();
        this.createMainArea();
    }

    private void undo() {
        Control oldEditor = this.m_editor.getEditor();
        if (oldEditor != null) {
            oldEditor.dispose();
        }
        this.m_tableViewer.getTable().deselectAll();
        this.m_tableViewer.setInput((Object)this.m_tableProvider.getElements(this.m_browserLabelManager.getMapping()));
        this.m_tableViewer.refresh(true);
        this.setDirty(false);
    }

    public void useDefault() {
        Control oldEditor = this.m_editor.getEditor();
        if (oldEditor != null) {
            oldEditor.dispose();
        }
        this.m_tableViewer.setInput((Object)this.m_tableProvider.getElements(this.m_browserLabelManager.getDefaultMapping()));
        this.m_tableViewer.refresh(true);
        this.setDirty(true);
    }

    private void save() {
        Control oldEditor = this.m_editor.getEditor();
        if (oldEditor != null) {
            oldEditor.dispose();
        }
        this.m_tableViewer.getTable().deselectAll();
        boolean success = this.m_browserLabelManager.store();
        if (success) {
            this.setDirty(false);
        } else {
            new ShowMessageBox("Server Connection", "Error saving Custom Labels!\nPlease check if UI is still connected to the Server!", 2);
        }
    }

    private void setDirty(boolean isDirty) {
        this.m_isDirty = isDirty;
        this.m_gui.enableField(this.m_save_btn, isDirty);
        this.m_gui.enableField(this.m_undo_btn, isDirty);
        this.refreshTitle();
    }

    protected void refreshTitle() {
        String title = this.getText();
        if (this.m_isDirty) {
            if (!title.startsWith("* ")) {
                this.setText("* " + title);
            }
        } else if (title.startsWith("* ")) {
            this.setText(title.substring(2));
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        String name = "";
        Object obj = e.getSource();
        if (obj instanceof Button) {
            Button b = (Button)obj;
            name = (String)b.getData();
            if (name.equalsIgnoreCase(UNDO)) {
                this.undo();
            } else if (name.equalsIgnoreCase(SAVE)) {
                this.save();
            } else if (name.equalsIgnoreCase(USE_DEFAULT)) {
                this.useDefault();
            } else if (name.equalsIgnoreCase(RELOAD)) {
                this.reloadFromServer();
            }
        }
    }

    public void dispose() {
        if (this.m_isDirty) {
            try {
                StringBuilder sb = new StringBuilder();
                sb.append("The file '").append(m_serverPath).append("' has been modified.   \n\nSave Changes? ");
                ShowSimpleDialog dialog = new ShowSimpleDialog(this.getControl().getShell(), "Save Browser Configuration", sb.toString(), "Save", "No");
                int res = dialog.open();
                if (res == 0) {
                    this.save();
                }
            }
            catch (Throwable throwable) {}
        }
        super.dispose();
    }

    public class MsgBrowserTableProvider
    extends StyledCellLabelProvider
    implements IStructuredContentProvider {
        private Map<String, String> m_labelMapping = null;
        private Map<String, List<String>> m_elements = new TreeMap<String, List<String>>();

        public MsgBrowserTableProvider(Map<String, String> mapping) {
            this.m_labelMapping = mapping;
        }

        public Object[] getElements(Object mapping) {
            if (mapping != null && mapping instanceof Map) {
                this.m_labelMapping = (Map)mapping;
            }
            this.init();
            return this.m_elements.values().toArray();
        }

        public void init() {
            this.m_elements.clear();
            if (this.m_labelMapping != null) {
                for (Map.Entry<String, String> map : this.m_labelMapping.entrySet()) {
                    String name = map.getKey();
                    String label = map.getValue();
                    ArrayList<String> l = new ArrayList<String>();
                    l.add(name);
                    l.add(label);
                    this.m_elements.put(String.valueOf(name) + "=" + label, l);
                }
            }
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public String getToolTipText(Object element) {
            String tooltip = "";
            try {
                List l = (List)element;
                String defaultLabel = (String)l.get(0);
                tooltip = IndiBrowserConfigTab.this.m_browserLabelManager.getToolTipShort(defaultLabel);
            }
            catch (Exception exception) {}
            return tooltip;
        }

        public boolean useNativeToolTip(Object object) {
            return true;
        }

        public void update(ViewerCell cell) {
            try {
                int colIndex = cell.getColumnIndex();
                List l = (List)cell.getElement();
                cell.setText((String)l.get(colIndex));
            }
            catch (Exception exception) {}
            super.update(cell);
        }

        public void dispose() {
        }
    }
}

