/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.views.configuration;

import com.blixx.boom.engine.BMUI;
import com.blixx.boom.engine.Repository;
import com.blixx.boom.gui.utils.GUIDisplayElements;
import com.blixx.ctrl.sc.in.ScRemoteActionServer;
import com.blixx.log.RTLogger;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class LdapDialogAddUser
extends StatusDialog
implements ModifyListener {
    private Composite m_comp = null;
    private Text m_user_field = null;
    private Text m_output = null;
    public static String USER = "USER";

    public LdapDialogAddUser(Shell parentShell) {
        super(parentShell);
        this.setShellStyle(1264);
        this.setTitle("  Add LDAP User");
        this.setImage(BMUI.IMAGE_USER_ON_LDAP);
    }

    protected Control createDialogArea(Composite parent) {
        GUIDisplayElements gui = new GUIDisplayElements();
        GridLayout gl = new GridLayout(2, false);
        gl.marginHeight = 0;
        gl.marginTop = 15;
        gl.marginWidth = 10;
        this.m_comp = new Composite(parent, 0);
        this.m_comp.setLayout((Layout)gl);
        this.m_comp.setLayoutData((Object)new GridData(4, 4, true, true));
        this.m_user_field = gui.addInputFieldSingle(this.m_comp, USER, "User: ", "", 1, 1, 0, 0, 500, this);
        gui.addTextField(this.m_comp, null, "", 1, 1, 0, 0, null);
        gui.addTextField(this.m_comp, null, "Add multiple users separated by space!", 1, 1, 0, 0, BMUI.font_arial8_italic);
        gui.addTextReadOnlyNoBorder(this.m_comp, null, "Result:", 2, 1, 0, 5, null);
        String msg = "                               \n\n\n\n\n\n\n\n\n\n\n\n";
        this.m_output = gui.addInputFieldMultiLineNoWrap(this.m_comp, "", null, msg, 2, 1, 130, 350, 0, 0, null);
        ((GridData)this.m_output.getLayoutData()).verticalAlignment = 4;
        ((GridData)this.m_output.getLayoutData()).grabExcessVerticalSpace = true;
        ((GridData)this.m_output.getLayoutData()).verticalIndent = 5;
        gui.setEditable(this.m_output, false);
        return parent;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        Button add = this.createButton(parent, 0, "Add", false);
        add.setEnabled(false);
        add.setFocus();
        this.createButton(parent, 1, "Close", false);
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 1) {
            super.cancelPressed();
        } else if (buttonId == 0) {
            this.execute();
        }
    }

    private void execute() {
        String users = this.m_user_field.getText().trim();
        StringBuilder sb = new StringBuilder();
        sb.append("LDAP ADDUSER").append(" ");
        sb.append(users);
        StringBuilder sb_success = new StringBuilder();
        try {
            this.m_output.setText("Processing...");
            this.m_output.update();
            ScRemoteActionServer scr = new ScRemoteActionServer(Repository.getInstance(), null, sb.toString(), 20);
            scr.run();
            if (!scr.isSupported()) {
                return;
            }
            if (scr.isSuccess()) {
                String result = scr.getResultObject();
                if (result == null || result.toUpperCase().contains("ERROR")) {
                    sb_success.append("LDAP ADDUSER FAILED: users=").append(users);
                    this.m_output.setText("result==null! \n" + sb_success.toString());
                    RTLogger.print(4, sb_success.toString());
                } else {
                    this.m_output.setText(result);
                    sb_success.append("LDAP ADDUSER SUCCESSFUL: users=").append(users);
                    RTLogger.print(4, sb_success.toString());
                }
            } else {
                sb_success.append("LDAP ADDUSER FAILED: remoteActionSuccess==false users=").append(users);
                this.m_output.setText(sb_success.toString());
                RTLogger.print(4, sb_success.toString());
            }
        }
        catch (Exception e) {
            sb_success = new StringBuilder().append("LDAP ADDUSER FAILED: users=").append(users);
            RTLogger.print(4, sb_success.toString(), e);
        }
    }

    public boolean close() {
        try {
            this.m_user_field.dispose();
        }
        catch (Throwable throwable) {}
        try {
            this.m_output.dispose();
        }
        catch (Throwable throwable) {}
        try {
            this.m_comp.dispose();
        }
        catch (Throwable throwable) {}
        return super.close();
    }

    public void modifyText(ModifyEvent e) {
        Object obj = e.getSource();
        if (obj instanceof Text) {
            Text field = (Text)obj;
            String name = (String)field.getData();
            String value = field.getText().trim();
            if (name.equals(USER)) {
                if (value.length() > 0) {
                    this.getButton(0).setEnabled(true);
                } else {
                    this.getButton(0).setEnabled(false);
                }
            }
        }
    }
}

