/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.views.configuration;

import com.blixx.boom.engine.BMUI;
import com.blixx.boom.engine.Repository;
import com.blixx.boom.gui.utils.GUIDisplayElements;
import com.blixx.boom.gui.views.configuration.LdapTab;
import com.blixx.ctrl.sc.in.ScRemoteActionServer;
import com.blixx.log.RTLogger;
import java.util.Properties;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class LdapDialogImportUser
extends StatusDialog
implements ModifyListener {
    private Properties m_props = null;
    private Composite m_comp = null;
    private String m_ldapURL = null;
    private Text m_baseField = null;
    private Text m_userAttrField = null;
    private Text m_searchAttributeField = null;
    private Text m_searchDcField = null;
    private Text m_searchFilterField = null;
    private Text m_userField = null;
    private Text m_pwdField = null;
    private Text m_output = null;
    private boolean m_wasSimulationOK = false;
    private static final String DEFAULT_SEARCH_FILTER = "(&(objectClass=Person)(|(userprincipalname=*)(uid=*)))";

    public LdapDialogImportUser(Shell parentShell, Properties props) {
        super(parentShell);
        this.setShellStyle(1264);
        this.setTitle("  LDAP Import User");
        this.setImage(BMUI.IMAGE_USER_ON_LDAP);
        this.m_props = props;
        this.m_ldapURL = this.m_props.getProperty("LDAP_URL");
        if (!LdapTab.isURLValid(this.m_ldapURL)) {
            return;
        }
    }

    protected Control createDialogArea(Composite parent) {
        GUIDisplayElements gui = new GUIDisplayElements();
        GridLayout gl = new GridLayout(2, false);
        gl.marginHeight = 0;
        gl.marginTop = 15;
        gl.marginWidth = 10;
        this.m_comp = new Composite(parent, 0);
        this.m_comp.setLayout((Layout)gl);
        this.m_comp.setLayoutData((Object)new GridData(4, 4, true, true));
        gui.addTextReadOnlyNoBorder(this.m_comp, "LDAP_URL: ", this.m_ldapURL, 1, 1, 0, 0, null);
        this.m_baseField = gui.addInputFieldSingle(this.m_comp, "LDAP_BASE", "LDAP_BASE: ", this.m_props.getProperty("LDAP_BASE"), 1, 1, 0, 10, 350, null);
        this.m_userAttrField = gui.addInputFieldSingle(this.m_comp, "LDAP_USER_ATTR", "LDAP_USER_ATTR: ", this.m_props.getProperty("LDAP_USER_ATTR"), 1, 1, 0, 0, 350, null);
        this.m_searchAttributeField = gui.addInputFieldSingle(this.m_comp, "LDAP_SEARCH_KEY", "LDAP_SEARCH_KEY: ", this.m_props.getProperty("LDAP_USER_ATTR"), 1, 1, 0, 0, 350, null);
        this.m_searchDcField = gui.addInputFieldSingle(this.m_comp, "LDAP_SEARCH_DC", "LDAP_SEARCH_DC: ", this.m_props.getProperty("LDAP_BASE"), 1, 1, 0, 0, 350, null);
        this.m_searchFilterField = gui.addInputFieldSingle(this.m_comp, "LDAP_SEARCH_FILTER", "LDAP_SEARCH_FILTER: ", DEFAULT_SEARCH_FILTER, 1, 1, 0, 0, 350, null);
        this.m_userField = gui.addInputFieldSingle(this.m_comp, null, "User: ", null, 1, 1, 0, 5, 350, this);
        this.m_userField.setBackground(BMUI.color_critical);
        this.m_pwdField = gui.addInputFieldSingle(this.m_comp, null, "Password: ", null, 1, 1, 0, 0, 350, this);
        this.m_pwdField.setBackground(BMUI.color_critical);
        this.m_pwdField.setTextLimit(255);
        this.m_pwdField.setEchoChar('*');
        gui.addTextReadOnlyNoBorder(this.m_comp, null, "Result:", 2, 1, 0, 5, null);
        String msg = "                               \n\n\n\n\n\n\n\n\n\n\n\n";
        this.m_output = gui.addInputFieldMultiLineNoWrap(this.m_comp, "", null, msg, 2, 1, 130, 350, 0, 0, null);
        ((GridData)this.m_output.getLayoutData()).verticalAlignment = 4;
        ((GridData)this.m_output.getLayoutData()).grabExcessVerticalSpace = true;
        ((GridData)this.m_output.getLayoutData()).verticalIndent = 5;
        gui.setEditable(this.m_output, false);
        return parent;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        Button simulate = this.createButton(parent, 11, "Simulate", true);
        simulate.setEnabled(false);
        simulate.setFocus();
        Button test = this.createButton(parent, 0, "Import", false);
        test.setEnabled(false);
        this.createButton(parent, 1, "Close", false);
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 1) {
            super.cancelPressed();
        } else if (buttonId == 11) {
            this.execute(true);
        } else if (buttonId == 0) {
            this.execute(false);
        }
    }

    private void execute(boolean simulate) {
        String searchFilter;
        String usearchAttr;
        String userAttr;
        String searchDC;
        StringBuilder sb = new StringBuilder();
        if (simulate) {
            sb.append("LDAP IMPORT LDAP_TEST").append(" ");
        } else {
            sb.append("LDAP IMPORT LDAP").append(" ");
        }
        sb.append("LDAP_URL").append("=").append(this.m_ldapURL).append(" ");
        String base = this.m_baseField.getText().trim();
        if (base.length() > 0) {
            sb.append("LDAP_BASE").append("=\"").append(base).append("\" ");
        }
        if ((searchDC = this.m_searchDcField.getText().trim()).length() > 0) {
            sb.append("LDAP_SEARCH_DC").append("=\"").append(searchDC).append("\" ");
        }
        if ((userAttr = this.m_userAttrField.getText().trim()).length() > 0) {
            sb.append("LDAP_USER_ATTR").append("=\"").append(userAttr).append("\" ");
        }
        if ((usearchAttr = this.m_searchAttributeField.getText().trim()).length() > 0) {
            sb.append("LDAP_SEARCH_KEY").append("=\"").append(usearchAttr).append("\" ");
        }
        if ((searchFilter = this.m_searchFilterField.getText().trim()).length() > 0) {
            sb.append("LDAP_SEARCH_FILTER").append("=\"").append(searchFilter).append("\" ");
        }
        String user = this.m_userField.getText().trim();
        String pwd = this.m_pwdField.getText().trim();
        sb.append("LDAP_ADMIN").append("=\"").append(user).append("\" ").append("LDAP_ADMIN_PASS").append("=\"").append(pwd).append("\"");
        StringBuilder sb_success = new StringBuilder();
        try {
            this.m_output.setText("Processing...");
            this.m_output.update();
            ScRemoteActionServer scr = new ScRemoteActionServer(Repository.getInstance(), null, sb.toString(), 20);
            scr.run();
            if (!scr.isSupported()) {
                return;
            }
            if (scr.isSuccess()) {
                String result = scr.getResultObject();
                if (result == null || result.toUpperCase().contains("ERROR")) {
                    if (result == null) {
                        sb_success.append("LDAP AUTH FAILED: user=").append(user).append(" LDAP server=").append(this.m_ldapURL);
                    } else {
                        sb_success.append(result);
                    }
                    this.m_output.setText(sb_success.toString());
                    RTLogger.print(4, sb_success.toString());
                } else {
                    this.m_wasSimulationOK = true;
                    this.m_output.setText(result);
                    sb_success.append("LDAP IMPORT SUCCESSFUL: user=").append(user).append("LDAP-Server=").append(this.m_ldapURL);
                    RTLogger.print(4, sb_success.toString());
                }
            } else {
                sb_success.append("LDAP IMPORT FAILED: remoteActionSuccess==false user=").append(user).append(" LDAP-Server=").append(this.m_ldapURL);
                this.m_output.setText(sb_success.toString());
                RTLogger.print(4, sb_success.toString());
            }
            this.checkButtonsAndFields();
        }
        catch (Exception e) {
            sb_success = new StringBuilder().append("LDAP IMPORT FAILED: user=").append(user).append(" LDAP-Server=").append(this.m_ldapURL);
            RTLogger.print(4, sb_success.toString(), e);
        }
    }

    private void checkButtonsAndFields() {
        boolean isValid = true;
        if (this.m_userField.getText().trim().length() > 0) {
            this.m_userField.setBackground(BMUI.color_white);
        } else {
            this.m_userField.setBackground(BMUI.color_critical);
            isValid = false;
        }
        if (this.m_pwdField.getText().trim().length() > 0) {
            this.m_pwdField.setBackground(BMUI.color_white);
        } else {
            this.m_pwdField.setBackground(BMUI.color_critical);
            isValid = false;
        }
        this.getButton(11).setEnabled(isValid);
        this.getButton(0).setEnabled(isValid && this.m_wasSimulationOK);
    }

    public boolean close() {
        try {
            this.m_baseField.dispose();
        }
        catch (Throwable throwable) {}
        try {
            this.m_userAttrField.dispose();
        }
        catch (Throwable throwable) {}
        try {
            this.m_searchAttributeField.dispose();
        }
        catch (Throwable throwable) {}
        try {
            this.m_searchDcField.dispose();
        }
        catch (Throwable throwable) {}
        try {
            this.m_searchFilterField.dispose();
        }
        catch (Throwable throwable) {}
        try {
            this.m_userField.dispose();
        }
        catch (Throwable throwable) {}
        try {
            this.m_pwdField.dispose();
        }
        catch (Throwable throwable) {}
        try {
            this.m_output.dispose();
        }
        catch (Throwable throwable) {}
        try {
            this.m_comp.dispose();
        }
        catch (Throwable throwable) {}
        return super.close();
    }

    public void modifyText(ModifyEvent e) {
        this.checkButtonsAndFields();
    }
}

