/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.views.configuration;

import com.blixx.boom.engine.BMUI;
import com.blixx.boom.engine.Repository;
import com.blixx.boom.gui.Activator;
import com.blixx.boom.gui.dialogs.ShowMessageBox;
import com.blixx.boom.gui.utils.GUIDisplayElements;
import com.blixx.boom.gui.views.configuration.LdapDialogImportUser;
import com.blixx.boom.gui.views.configuration.LdapDialogTestConfig;
import com.blixx.boom.gui.views.configuration.LdapTab;
import com.blixx.ctrl.sc.in.ScRemoteActionServer;
import com.blixx.log.RTLogger;
import java.util.Properties;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.ISharedImages;

public class LdapSubTab
extends CTabItem
implements ModifyListener,
SelectionListener {
    private boolean m_isDirty = false;
    private boolean m_isNew = false;
    private boolean m_isReadOnly = false;
    private boolean m_isAuthOK = false;
    private GUIDisplayElements m_gui = null;
    private LdapTab m_ldapTab = null;
    private CTabFolder m_folder = null;
    private Composite m_compInTab = null;
    private Composite m_detailsComp = null;
    private Text m_ldap_url_field = null;
    private Text m_ldap_base_field = null;
    private Text m_ldap_user_attr_field = null;
    private Text m_ldap_expire_field = null;
    private Text m_errorMsg = null;
    private Button m_enable_btn = null;
    private Button m_disable_btn = null;
    private Button m_save_btn = null;
    private Button m_undo_btn = null;
    private Button m_test_btn = null;
    private Button m_import_btn = null;
    private static String SAVE_BTN = "SAVE";
    private static String UNDO_BTN = "UNDO";
    private static String TEST_BTN = "TEST";
    private static String IMPORT_BTN = "IMPORT";
    private Properties m_properties_orig = null;
    private Properties m_properties = null;
    private ISharedImages m_sharedImages = Activator.getDefault().getWorkbench().getActiveWorkbenchWindow().getWorkbench().getSharedImages();
    public static final String LDAP_ADMIN = "LDAP_ADMIN";
    public static final String LDAP_ADMIN_PASS = "LDAP_ADMIN_PASS";
    public static final String LDAP_PASS = "LDAP_PASS";
    public static final String LDAP_USER = "LDAP_USER";
    public static final String LDAP_URL = "LDAP_URL";
    public static final String LDAP_USER_ATTR = "LDAP_USER_ATTR";
    public static final String LDAP_SEARCH_KEY = "LDAP_SEARCH_KEY";
    public static final String LDAP_SEARCH_FILTER = "LDAP_SEARCH_FILTER";
    public static final String LDAP_EXPIRE = "LDAP_EXPIRE";
    public static final String LDAP_BASE = "LDAP_BASE";
    public static final String LDAP_SEARCH_DC = "LDAP_SEARCH_DC";
    public static final String LDAP_ENABLED = "ENABLED";
    public static final String DISABLED = "DISABLED";
    public static final String IS_AUTH_OK = "AUTH_OK";

    public LdapSubTab(LdapTab ldapTab, CTabFolder folder, Properties properties, boolean isNew, boolean isReadOnly) {
        super(folder, 64);
        this.m_ldapTab = ldapTab;
        this.m_folder = folder;
        this.m_properties = properties;
        this.m_properties_orig = this.cloneProperties(this.m_properties);
        String url = this.m_properties.getProperty(LDAP_URL);
        this.setText(url);
        this.setData(LDAP_URL, url);
        this.m_isReadOnly = isReadOnly;
        this.m_isNew = isNew;
        this.m_isAuthOK = !isNew;
        this.createContent();
        this.setDirty(isNew);
    }

    public void createContent() {
        this.m_gui = new GUIDisplayElements();
        Boolean enabled = new Boolean(this.m_properties.getProperty(LDAP_ENABLED));
        String ldap_url = this.m_properties.getProperty(LDAP_URL);
        String ldap_base = this.m_properties.getProperty(LDAP_BASE);
        String ldap_user_attr = this.m_properties.getProperty(LDAP_USER_ATTR);
        String ldap_expire = this.m_properties.getProperty(LDAP_EXPIRE);
        if (!LdapTab.isExpireValid(ldap_expire)) {
            ldap_expire = "";
        }
        this.m_compInTab = new Composite((Composite)this.m_folder, 0);
        GridLayout gl = new GridLayout(2, false);
        gl.horizontalSpacing = 0;
        gl.marginWidth = 0;
        this.m_compInTab.setLayout((Layout)gl);
        this.m_compInTab.setLayoutData((Object)new GridData(4, 4, true, true));
        this.m_detailsComp = new Composite(this.m_compInTab, 0);
        gl = new GridLayout(2, false);
        gl.marginWidth = 10;
        this.m_detailsComp.setLayout((Layout)gl);
        this.m_detailsComp.setLayoutData((Object)new GridData(4, 4, true, false));
        this.m_ldap_url_field = this.m_gui.addInputFieldSingle(this.m_detailsComp, LDAP_URL, "LDAP_URL: ", ldap_url, 1, 1, 0, 0, 60, this);
        boolean isURLValid = LdapTab.isURLValid(ldap_url);
        if (!this.m_isReadOnly && this.isNew() && !isURLValid) {
            this.m_ldap_url_field.setBackground(BMUI.color_critical);
        } else {
            this.m_gui.setEditable(this.m_ldap_url_field, false);
            this.m_gui.enableField(this.m_ldap_url_field, false);
        }
        this.m_ldap_base_field = this.m_gui.addInputFieldSingle(this.m_detailsComp, LDAP_BASE, "LDAP_BASE: ", ldap_base == null ? "" : ldap_base, 1, 1, 0, 0, 60, this);
        this.m_ldap_user_attr_field = this.m_gui.addInputFieldSingle(this.m_detailsComp, LDAP_USER_ATTR, "LDAP_USER_ATTR: ", ldap_user_attr == null ? "" : ldap_user_attr, 1, 1, 0, 0, 60, this);
        this.m_ldap_expire_field = this.m_gui.addInputFieldSingle(this.m_detailsComp, LDAP_EXPIRE, "LDAP_EXPIRE (min): ", ldap_expire, 1, 1, 0, 0, 60, this);
        Composite radioComp = new Composite(this.m_detailsComp, 0);
        radioComp.setLayout((Layout)new GridLayout(2, false));
        radioComp.setLayoutData((Object)new GridData(4, 4, false, false, 2, 1));
        this.m_enable_btn = this.m_gui.addRadioButton(radioComp, LDAP_ENABLED, "Enable", enabled, 1, 1, 0, 8, this);
        this.m_disable_btn = this.m_gui.addRadioButton(radioComp, DISABLED, "Disable", enabled == false, 1, 1, 0, 8, this);
        if (this.m_isReadOnly) {
            this.m_gui.setEditable(this.m_ldap_base_field, false);
            this.m_gui.setEditable(this.m_ldap_user_attr_field, false);
            this.m_gui.setEditable(this.m_ldap_expire_field, false);
            this.m_gui.enableField(this.m_enable_btn, false);
            this.m_gui.enableField(this.m_disable_btn, false);
        } else {
            this.m_ldap_base_field.addListener(2, GUIDisplayElements.ctrlListener);
            this.m_ldap_user_attr_field.addListener(2, GUIDisplayElements.ctrlListener);
            this.m_ldap_expire_field.addListener(2, GUIDisplayElements.ctrlListener);
        }
        if (!this.m_isReadOnly) {
            Composite buttonComp = new Composite(this.m_detailsComp, 0);
            gl = new GridLayout(5, false);
            gl.marginWidth = 0;
            gl.marginTop = 5;
            buttonComp.setLayout((Layout)gl);
            buttonComp.setLayoutData((Object)new GridData(4, 4, false, false, 2, 1));
            this.m_save_btn = this.m_gui.addButton(buttonComp, SAVE_BTN, " Save ", true, 60, 10, 0, this);
            ((GridData)this.m_save_btn.getLayoutData()).horizontalAlignment = 4;
            this.m_save_btn.setImage(this.m_sharedImages.getImage("IMG_ETOOL_SAVE_EDIT"));
            this.m_undo_btn = this.m_gui.addButton(buttonComp, UNDO_BTN, " Undo ", false, 60, 0, 0, this);
            ((GridData)this.m_undo_btn.getLayoutData()).horizontalAlignment = 4;
            this.m_undo_btn.setImage(this.m_sharedImages.getImage("IMG_TOOL_UNDO"));
            this.m_test_btn = this.m_gui.addButton(buttonComp, TEST_BTN, " Test Configuration ", false, 60, 0, 0, this);
            ((GridData)this.m_test_btn.getLayoutData()).horizontalAlignment = 4;
            this.m_import_btn = this.m_gui.addButton(buttonComp, IMPORT_BTN, " Import User ", true, 60, 0, 0, this);
            ((GridData)this.m_import_btn.getLayoutData()).horizontalAlignment = 4;
            this.m_import_btn.setImage(BMUI.IMAGE_IMPORT);
            this.m_errorMsg = this.m_gui.addTextReadOnlyNoBorder(buttonComp, null, "", 1, 1, 10, 0, null);
            this.m_errorMsg.setForeground(BMUI.color_critical);
            ((GridData)this.m_errorMsg.getLayoutData()).horizontalAlignment = 4;
            ((GridData)this.m_errorMsg.getLayoutData()).grabExcessHorizontalSpace = true;
            this.checkErrorMessage(ldap_url);
        }
        this.setControl((Control)this.m_compInTab);
    }

    public void testConfig() {
        String url = this.m_properties.getProperty(LDAP_URL);
        if (LdapTab.isURLValid(url)) {
            LdapDialogTestConfig dialog = new LdapDialogTestConfig(Display.getCurrent().getActiveShell(), this.m_properties);
            dialog.open();
            this.m_isAuthOK = dialog.wasSuccessful();
            this.checkButtonStatus();
        }
    }

    public void importUser() {
        String url = this.m_properties.getProperty(LDAP_URL);
        if (LdapTab.isURLValid(url)) {
            LdapDialogImportUser dialog = new LdapDialogImportUser(Display.getCurrent().getActiveShell(), this.m_properties);
            dialog.open();
        }
    }

    public void undo() {
        Boolean isEnabled = new Boolean(this.m_properties_orig.getProperty(LDAP_ENABLED));
        String ldap_url = this.m_properties_orig.getProperty(LDAP_URL);
        if (ldap_url == null) {
            ldap_url = "";
        }
        String ldap_base = this.m_properties_orig.getProperty(LDAP_BASE);
        String ldap_user_attr = this.m_properties_orig.getProperty(LDAP_USER_ATTR);
        String ldap_expire = this.m_properties_orig.getProperty(LDAP_EXPIRE);
        try {
            Integer.parseInt(ldap_expire);
        }
        catch (NumberFormatException numberFormatException) {
            ldap_expire = "";
        }
        this.m_ldap_url_field.setText(ldap_url);
        this.m_ldap_base_field.setText(ldap_base == null ? "" : ldap_base);
        this.m_ldap_user_attr_field.setText(ldap_user_attr == null ? "" : ldap_user_attr);
        this.m_ldap_expire_field.setText(ldap_expire);
        this.m_enable_btn.setSelection(isEnabled.booleanValue());
        this.m_disable_btn.setSelection(isEnabled == false);
        if (this.isNew()) {
            this.setDirty(true);
            if (LdapTab.isURLValid(ldap_url) && !this.m_ldapTab.doesURLExist(ldap_url)) {
                this.m_ldap_url_field.setBackground(BMUI.color_white);
            } else {
                this.m_ldap_url_field.setBackground(BMUI.color_critical);
            }
        } else {
            this.setDirty(false);
        }
    }

    public void save() {
        StringBuilder sb2 = new StringBuilder();
        for (String key : this.m_properties.stringPropertyNames()) {
            String value = this.m_properties.getProperty(key);
            sb2.append(key).append("=").append(value).append(" ");
        }
        String props2save = sb2.toString().trim();
        boolean success = false;
        try {
            String action = "LDAP SAVECONFIG " + props2save;
            ScRemoteActionServer scr = new ScRemoteActionServer(Repository.getInstance(), props2save, action, 20);
            scr.run();
            if (scr.isSuccess()) {
                String res = scr.getResultObject();
                if (res != null && res.equals("\nOK.")) {
                    success = true;
                } else {
                    RTLogger.print(4, "Error getting ldap configuration from server ");
                }
            } else {
                RTLogger.print(4, "Error getting ldap configuration from server ");
            }
        }
        catch (Exception e) {
            RTLogger.print(4, "Error getting ldap configuration from server ", e);
        }
        if (!success) {
            new ShowMessageBox("Load LDAP Configuration", "Error loading LDAP Configuration from the server.", 1);
        }
        if (success) {
            this.setDirty(false);
            boolean hasDirtyTabs = false;
            if (this.m_folder != null && !this.m_folder.isDisposed()) {
                CTabItem[] items = this.m_folder.getItems();
                int i = 0;
                while (i < items.length) {
                    LdapSubTab tab = (LdapSubTab)items[i];
                    if (tab.isDirty()) {
                        hasDirtyTabs = true;
                        break;
                    }
                    ++i;
                }
            }
            if (!hasDirtyTabs && !this.m_ldapTab.isDirty()) {
                this.m_ldapTab.reload(false);
            }
        } else {
            new ShowMessageBox("Save", "Error saving LDAP Configuration", 1);
            return;
        }
        this.m_ldapTab.refreshTable();
    }

    public Properties cloneProperties(Properties props) {
        String enabled = props.getProperty(LDAP_ENABLED);
        String url = props.getProperty(LDAP_URL);
        String base = props.getProperty(LDAP_BASE);
        String user_attr = props.getProperty(LDAP_USER_ATTR);
        String expire = props.getProperty(LDAP_EXPIRE);
        Properties p_new = new Properties();
        p_new.put(LDAP_ENABLED, enabled == null ? "false" : enabled);
        p_new.put(LDAP_URL, url == null ? "false" : url);
        p_new.put(LDAP_BASE, base == null ? "false" : base);
        p_new.put(LDAP_USER_ATTR, user_attr == null ? "false" : user_attr);
        p_new.put(LDAP_EXPIRE, expire == null ? "false" : expire);
        return p_new;
    }

    public boolean isValid() {
        boolean isValid = false;
        try {
            String expire = this.m_ldap_expire_field.getText();
            String url = this.m_ldap_url_field.getText();
            if (this.m_isNew && this.m_ldapTab.doesURLExist(url)) {
                isValid = false;
            } else if (LdapTab.isURLValid(url) && LdapTab.isExpireValid(expire)) {
                isValid = true;
            }
        }
        catch (Exception exception) {}
        return isValid;
    }

    public boolean isNew() {
        return this.m_isNew;
    }

    public boolean isAuthOK() {
        return this.m_isAuthOK;
    }

    public void checkButtonStatus() {
        this.m_gui.enableField(this.m_save_btn, this.isDirty() && this.isValid() && this.m_isAuthOK);
        this.m_gui.enableField(this.m_undo_btn, this.isDirty());
        this.m_gui.enableField(this.m_test_btn, this.isValid());
        this.m_gui.enableField(this.m_import_btn, this.isValid() && this.m_isAuthOK);
        this.checkErrorMessage(this.m_ldap_url_field.getText().trim());
    }

    public void checkErrorMessage(String url) {
        boolean isURLValid = LdapTab.isURLValid(url);
        if (!isURLValid) {
            this.m_errorMsg.setText("Invalid or duplicate URL!");
            this.m_errorMsg.setVisible(true);
        } else if (!this.isAuthOK()) {
            this.m_errorMsg.setText("You have to test configuration before you can save it!");
            this.m_errorMsg.setVisible(true);
        } else {
            this.m_errorMsg.setVisible(false);
        }
    }

    public void setDirty(boolean isDirty) {
        if (this.m_isReadOnly) {
            return;
        }
        this.m_isDirty = isDirty;
        this.checkButtonStatus();
        String title = this.getText();
        if (isDirty) {
            if (!title.startsWith("* ")) {
                this.setText("* " + title);
            }
        } else if (title.startsWith("* ")) {
            this.setText(title.substring(2));
        }
    }

    public boolean isDirty() {
        return this.m_isDirty;
    }

    public void modifyText(ModifyEvent e) {
        Object o = e.getSource();
        if (o instanceof Text) {
            Text field = (Text)o;
            String name = (String)field.getData();
            String value = field.getText().trim();
            if (name.equals(LDAP_URL)) {
                boolean isURLValid = LdapTab.isURLValid(value);
                this.checkErrorMessage(value);
                if (this.isNew()) {
                    this.m_properties.setProperty(name, value);
                    if (!this.m_ldapTab.doesURLExist(value) && isURLValid) {
                        field.setBackground(BMUI.color_white);
                        field.setToolTipText("");
                    } else {
                        field.setBackground(BMUI.color_critical);
                        field.setToolTipText("URL does already exist!");
                    }
                }
            } else if (name.equals(LDAP_BASE)) {
                this.m_properties.setProperty(name, value);
            } else if (name.equals(LDAP_USER_ATTR)) {
                this.m_properties.setProperty(name, value);
            } else if (name.equals(LDAP_EXPIRE)) {
                this.m_properties.setProperty(name, value);
                if (LdapTab.isExpireValid(value)) {
                    field.setBackground(BMUI.color_white);
                } else {
                    field.setBackground(BMUI.color_critical);
                }
            }
        }
        this.setDirty(true);
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        String name = "";
        if (e.getSource() instanceof Button) {
            Button btn = (Button)e.getSource();
            name = (String)btn.getData();
            if (name.equals(LDAP_ENABLED)) {
                boolean isEnabled = btn.getSelection();
                this.m_properties.setProperty(LDAP_ENABLED, "" + isEnabled);
                this.setDirty(true);
            } else if (name.equals(SAVE_BTN)) {
                this.save();
            } else if (name.equals(UNDO_BTN)) {
                this.undo();
            } else if (name.equals(TEST_BTN)) {
                this.testConfig();
            } else if (name.equals(IMPORT_BTN)) {
                this.importUser();
            }
        }
    }
}

