/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.views.configuration;

import com.blixx.boom.engine.BMUI;
import com.blixx.boom.engine.ICommandListener;
import com.blixx.boom.engine.Repository;
import com.blixx.boom.engine.UIJob;
import com.blixx.boom.engine.UIJobManager;
import com.blixx.boom.gui.Activator;
import com.blixx.boom.gui.dialogs.ShowMessageBox;
import com.blixx.boom.gui.dialogs.ShowSimpleDialog;
import com.blixx.boom.gui.utils.GUIDisplayElements;
import com.blixx.boom.gui.views.configuration.ConfigurationView;
import com.blixx.boom.gui.views.configuration.LdapDialogAddUser;
import com.blixx.boom.gui.views.configuration.LdapSubTab;
import com.blixx.boom.gui.views.configuration.LdapTableProvider;
import com.blixx.ctrl.sc.in.ScGetFileAsString;
import com.blixx.ctrl.sc.in.ScRemoteActionServer;
import com.blixx.log.RTLogger;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabFolder2Listener;
import org.eclipse.swt.custom.CTabFolderEvent;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbenchPartSite;

public class LdapTab
extends CTabItem
implements Listener,
SelectionListener,
ICommandListener {
    private LdapTab m_tab = null;
    private String m_serverPath = "srv/ldap/";
    private CTabFolder m_parent = null;
    private CTabFolder m_subFolder = null;
    private static Map<String, LdapSubTab> m_cTabList = null;
    private boolean m_isDirty = false;
    private boolean m_isReadOnly = false;
    private GUIDisplayElements m_gui = null;
    private Composite m_compositeInCTab = null;
    private Composite m_topComp = null;
    private Composite m_ldapDetailsComp = null;
    private ScrolledComposite m_sc = null;
    private TableViewer m_tableViewer = null;
    private LdapTableProvider m_tableProvider = null;
    private Button m_up_btn = null;
    private Button m_down_btn = null;
    private Button m_top_btn = null;
    private Button m_bottom_btn = null;
    private Button m_save_order_btn = null;
    private Button m_edit_btn = null;
    private Button m_add_btn = null;
    private Button m_dup_btn = null;
    private Button m_del_btn = null;
    private Button m_reload_btn = null;
    private Button m_addUser_btn = null;
    private static String UP_BTN = "UP_BTN";
    private static String DOWN_BTN = "DOWN_BTN";
    private static String TOP_BTN = "TOP_BTN";
    private static String BOTTOM_BTN = "BOTTOM_BTN";
    private static String SAVE_ORDER_BTN = "SAVE_ORDER_BTN";
    private static String EDIT_BTN = "EDIT_BTN";
    private static String ADD_BTN = "ADD_BTN";
    private static String DUP_BTN = "DUP_BTN";
    private static String DEL_BTN = "DEL_BTN";
    private static String RELOAD_BTN = "RELOAD_BTN";
    private static String ADD_USER_BTN = "ADD_USER";
    public static String FILE_NAME = "FILE_NAME";
    private static String CLOSE = "CLOSE";
    private static String CLOSE_ALL = "CLOSE_ALL";
    private static String CLOSE_OTHERS = "CLOSE_OTHERS";
    private ISharedImages m_sharedImages = Activator.getDefault().getWorkbench().getActiveWorkbenchWindow().getWorkbench().getSharedImages();
    private Map<String, Properties> m_ldapConfig = new LinkedHashMap<String, Properties>();
    private List<String> m_ldapOrder = new ArrayList<String>();

    public LdapTab(CTabFolder parent, int index) {
        super(parent, 0, index);
        this.setText("LDAP");
        this.m_parent = parent;
        this.m_tab = this;
        this.m_isReadOnly = Repository.getInstance().getRights(2004) < 3;
        m_cTabList = new HashMap<String, LdapSubTab>();
        this.m_gui = new GUIDisplayElements();
        this.loadConfigList();
        this.createMainArea();
        Repository.getInstance().getCmdRouter().addCmdListener("REFRESH_LDAP_SERVERSE", this);
    }

    public void createMainArea() {
        this.m_compositeInCTab = new Composite((Composite)this.m_parent, 0);
        GridLayout gl = new GridLayout(1, false);
        gl.verticalSpacing = 0;
        gl.horizontalSpacing = 0;
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        this.m_compositeInCTab.setLayout((Layout)gl);
        this.m_compositeInCTab.setLayoutData((Object)new GridData(4, 4, true, true));
        this.m_sc = new ScrolledComposite(this.m_compositeInCTab, 2816);
        this.m_sc.setAlwaysShowScrollBars(false);
        this.m_sc.setExpandHorizontal(true);
        this.m_sc.setExpandVertical(true);
        gl = new GridLayout(1, false);
        gl.marginLeft = 40;
        this.m_sc.setLayout((Layout)gl);
        this.m_sc.setLayoutData((Object)new GridData(4, 4, true, true));
        this.m_sc.addListener(37, new Listener(){

            public void handleEvent(Event event) {
                ScrolledComposite sc = (ScrolledComposite)event.widget;
                sc.getVerticalBar().setIncrement(event.count * 4);
            }
        });
        this.m_topComp = new Composite((Composite)this.m_sc, 0);
        gl = new GridLayout(2, false);
        this.m_topComp.setLayout((Layout)gl);
        this.m_topComp.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createOverviewTable(this.m_topComp);
        this.m_sc.setContent((Control)this.m_topComp);
        this.m_sc.setMinSize(this.m_topComp.computeSize(-1, -1, true));
        this.setControl((Control)this.m_compositeInCTab);
    }

    private void createOverviewTable(Composite parent) {
        this.m_gui.addTextReadOnlyNoBorder(parent, null, "LDAP Configurations", 2, 1, 0, 5, BMUI.font_arial8_bold);
        Composite tableComp = new Composite(parent, 0);
        tableComp.setLayout((Layout)new GridLayout(1, false));
        tableComp.setLayoutData((Object)new GridData(4, 4, true, false));
        Table tbl = new Table(tableComp, 268503810);
        tbl.setHeaderVisible(true);
        tbl.setLinesVisible(true);
        tbl.setLayoutData((Object)new GridData(4, 4, true, true));
        TableColumn col0 = new TableColumn(tbl, 16384);
        col0.setText("Status");
        col0.setWidth(25);
        TableColumn col1 = new TableColumn(tbl, 16384);
        col1.setText("LDAP Configuration");
        col1.setWidth(0);
        TableColumn col2 = new TableColumn(tbl, 16384);
        col2.setText("LDAP URL");
        col2.setWidth(500);
        this.m_tableViewer = new TableViewer(tbl);
        this.m_tableProvider = new LdapTableProvider(this.m_ldapConfig, this.m_ldapOrder);
        this.m_tableViewer.setLabelProvider((IBaseLabelProvider)this.m_tableProvider);
        this.m_tableViewer.setContentProvider((IContentProvider)this.m_tableProvider);
        this.m_tableViewer.setInput((Object)this.m_tableProvider.getElements(null));
        this.m_tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                LdapTab.this.checkButtonStatus();
            }
        });
        this.m_tableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                LdapTab.this.edit();
            }
        });
        this.createContentMenu(this.m_tableViewer);
        if (!this.m_isReadOnly) {
            Composite btnBottomRight = new Composite(parent, 0);
            GridLayout gl = new GridLayout(1, true);
            gl.marginWidth = 0;
            gl.marginHeight = 0;
            btnBottomRight.setLayout((Layout)gl);
            btnBottomRight.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
            this.m_top_btn = this.m_gui.addButton(btnBottomRight, TOP_BTN, " Top ", false, 60, 0, 0, this);
            ((GridData)this.m_top_btn.getLayoutData()).horizontalAlignment = 4;
            this.m_up_btn = this.m_gui.addButton(btnBottomRight, UP_BTN, " Up ", false, 60, 0, 0, this);
            ((GridData)this.m_up_btn.getLayoutData()).horizontalAlignment = 4;
            this.m_down_btn = this.m_gui.addButton(btnBottomRight, DOWN_BTN, " Down ", false, 60, 10, 0, this);
            ((GridData)this.m_down_btn.getLayoutData()).horizontalAlignment = 4;
            this.m_bottom_btn = this.m_gui.addButton(btnBottomRight, BOTTOM_BTN, " Bottom ", false, 60, 10, 0, this);
            ((GridData)this.m_bottom_btn.getLayoutData()).horizontalAlignment = 4;
            this.m_save_order_btn = this.m_gui.addButton(btnBottomRight, SAVE_ORDER_BTN, " Save Order", false, 60, 10, 0, this);
            ((GridData)this.m_save_order_btn.getLayoutData()).horizontalAlignment = 4;
            this.m_save_order_btn.setImage(this.m_sharedImages.getImage("IMG_ETOOL_SAVE_EDIT"));
            Composite btnBottomComp = new Composite(parent, 0);
            gl = new GridLayout(6, true);
            gl.marginWidth = 0;
            gl.marginHeight = 0;
            btnBottomComp.setLayout((Layout)gl);
            btnBottomComp.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 2, 1));
            this.m_add_btn = this.m_gui.addButton(btnBottomComp, ADD_BTN, "Add", true, 50, 10, 0, this);
            ((GridData)this.m_add_btn.getLayoutData()).horizontalAlignment = 4;
            this.m_add_btn.setImage(this.m_sharedImages.getImage("IMG_OBJ_ADD"));
            this.m_edit_btn = this.m_gui.addButton(btnBottomComp, EDIT_BTN, "Edit", false, 50, 10, 0, this);
            ((GridData)this.m_edit_btn.getLayoutData()).horizontalAlignment = 4;
            this.m_del_btn = this.m_gui.addButton(btnBottomComp, DEL_BTN, "Delete ", false, 50, 10, 0, this);
            ((GridData)this.m_del_btn.getLayoutData()).horizontalAlignment = 4;
            this.m_del_btn.setImage(this.m_sharedImages.getImage("IMG_TOOL_DELETE"));
            this.m_dup_btn = this.m_gui.addButton(btnBottomComp, DUP_BTN, "Duplicate", false, 50, 10, 0, this);
            ((GridData)this.m_dup_btn.getLayoutData()).horizontalAlignment = 4;
            this.m_dup_btn.setImage(this.m_sharedImages.getImage("IMG_TOOL_COPY"));
            this.m_reload_btn = this.m_gui.addButton(btnBottomComp, RELOAD_BTN, "Reload ", true, 50, 10, 0, this);
            ((GridData)this.m_reload_btn.getLayoutData()).horizontalAlignment = 4;
            ((GridData)this.m_reload_btn.getLayoutData()).horizontalIndent = 20;
            this.m_reload_btn.setImage(BMUI.IMAGE_REFRESH);
            this.m_addUser_btn = this.m_gui.addButton(btnBottomComp, ADD_USER_BTN, "Add User", true, 60, 0, 0, this);
            ((GridData)this.m_addUser_btn.getLayoutData()).horizontalAlignment = 4;
            this.m_addUser_btn.setImage(this.m_sharedImages.getImage("IMG_OBJ_ADD"));
        } else {
            Composite btnBottomComp = new Composite(parent, 0);
            GridLayout gl = new GridLayout(2, true);
            gl.marginWidth = 0;
            gl.marginHeight = 0;
            btnBottomComp.setLayout((Layout)gl);
            btnBottomComp.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 2, 1));
            this.m_edit_btn = this.m_gui.addButton(btnBottomComp, EDIT_BTN, " Open ", false, 50, 10, 0, this);
            ((GridData)this.m_edit_btn.getLayoutData()).horizontalAlignment = 4;
            this.m_reload_btn = this.m_gui.addButton(btnBottomComp, RELOAD_BTN, " Reload ", true, 50, 10, 0, this);
            ((GridData)this.m_reload_btn.getLayoutData()).horizontalAlignment = 4;
            this.m_reload_btn.setImage(BMUI.IMAGE_REFRESH);
        }
    }

    public void createContentMenu(TableViewer tableViewer) {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(false);
        Menu menu = menuMgr.createContextMenu(tableViewer.getControl());
        tableViewer.getControl().setMenu(menu);
        IWorkbenchPartSite site = ConfigurationView.getInstance().getSite();
        site.registerContextMenu(menuMgr, (ISelectionProvider)tableViewer);
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                try {
                    manager.add((IAction)new ReloadAction(LdapTab.this.m_tab));
                    manager.add((IContributionItem)new Separator());
                    if (!LdapTab.this.m_isReadOnly) {
                        manager.add((IAction)new AddAction(LdapTab.this.m_tab));
                    }
                    manager.add((IAction)new EditAction(LdapTab.this.m_tab, LdapTab.this.m_tableViewer, LdapTab.this.m_isReadOnly));
                    if (!LdapTab.this.m_isReadOnly) {
                        manager.add((IAction)new DeleteAction(LdapTab.this.m_tab, LdapTab.this.m_tableViewer));
                        manager.add((IAction)new DuplicateAction(LdapTab.this.m_tab, LdapTab.this.m_tableViewer));
                    }
                }
                catch (RuntimeException runtimeException) {}
            }
        });
    }

    private void createSubFolder() {
        if (this.m_ldapDetailsComp == null || this.m_ldapDetailsComp.isDisposed()) {
            this.m_ldapDetailsComp = new Composite(this.m_topComp, 0);
            GridLayout gl = new GridLayout(1, false);
            gl.verticalSpacing = 0;
            gl.horizontalSpacing = 0;
            gl.marginWidth = 0;
            gl.marginHeight = 0;
            this.m_ldapDetailsComp.setLayout((Layout)gl);
            this.m_ldapDetailsComp.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        }
        if (this.m_subFolder == null || this.m_subFolder.isDisposed()) {
            this.m_gui.addTextReadOnlyNoBorder(this.m_ldapDetailsComp, null, "LDAP Details", 1, 1, 0, 15, BMUI.font_arial8_bold);
            this.m_subFolder = new CTabFolder(this.m_ldapDetailsComp, 2816);
            this.m_subFolder.setSimple(false);
            this.m_subFolder.setMinimizeVisible(false);
            this.m_subFolder.setMaximizeVisible(false);
            this.m_subFolder.setBorderVisible(false);
            this.m_subFolder.setBackground(BMUI.color_unknown);
            GridData gd = new GridData(4, 4, true, true);
            gd.verticalIndent = 10;
            this.m_subFolder.setLayoutData((Object)gd);
            this.m_subFolder.addListener(35, new Listener(){

                public void handleEvent(Event event) {
                    Point point = LdapTab.this.m_subFolder.getDisplay().map(null, (Control)LdapTab.this.m_subFolder, new Point(event.x, event.y));
                    CTabItem cTabItem = LdapTab.this.m_subFolder.getItem(point);
                    if (cTabItem != null && cTabItem instanceof LdapSubTab) {
                        LdapSubTab tab = (LdapSubTab)cTabItem;
                        LdapTab.this.m_subFolder.setSelection((CTabItem)tab);
                    }
                }
            });
            this.m_subFolder.addCTabFolder2Listener(new CTabFolder2Listener(){

                public void close(CTabFolderEvent event) {
                    LdapTab.this.closeTab((LdapSubTab)event.item);
                }

                public void minimize(CTabFolderEvent event) {
                    LdapTab.this.m_subFolder.setMinimized(true);
                    LdapTab.this.m_ldapDetailsComp.layout(true);
                }

                public void maximize(CTabFolderEvent event) {
                    LdapTab.this.m_subFolder.setMaximized(true);
                    LdapTab.this.m_subFolder.setLayoutData((Object)new GridData(4, 4, true, true));
                    LdapTab.this.m_ldapDetailsComp.layout(true);
                }

                public void restore(CTabFolderEvent event) {
                    LdapTab.this.m_subFolder.setMinimized(false);
                    LdapTab.this.m_subFolder.setMaximized(false);
                    LdapTab.this.m_subFolder.setLayoutData((Object)new GridData(4, 4, true, false));
                    LdapTab.this.m_ldapDetailsComp.layout(true);
                }

                public void showList(CTabFolderEvent event) {
                }
            });
            this.createSubFolderContentMenu();
        }
    }

    public void createSubFolderContentMenu() {
        Menu menu = new Menu((Control)this.m_subFolder);
        menu.addMenuListener(new MenuListener(){

            public void menuHidden(MenuEvent e) {
            }

            public void menuShown(MenuEvent e) {
                block5: {
                    int count;
                    MenuItem[] mi;
                    block4: {
                        Menu menu = (Menu)e.getSource();
                        mi = menu.getItems();
                        count = LdapTab.this.m_subFolder.getItemCount();
                        if (count != 1) break block4;
                        int index = 0;
                        while (index < mi.length) {
                            if (mi[index].getData().equals(CLOSE)) {
                                mi[index].setEnabled(true);
                            } else {
                                mi[index].setEnabled(false);
                            }
                            ++index;
                        }
                        break block5;
                    }
                    if (count <= 1) break block5;
                    int index = 0;
                    while (index < mi.length) {
                        mi[index].setEnabled(true);
                        ++index;
                    }
                }
            }
        });
        MenuItem mi_close = new MenuItem(menu, -1);
        mi_close.setText("Close");
        mi_close.setData((Object)CLOSE);
        mi_close.addListener(13, (Listener)this.m_tab);
        MenuItem mi_closeOthers = new MenuItem(menu, -1);
        mi_closeOthers.setText("Close Others");
        mi_closeOthers.setData((Object)CLOSE_OTHERS);
        mi_closeOthers.addListener(13, (Listener)this.m_tab);
        MenuItem mi_closeAll = new MenuItem(menu, -1);
        mi_closeAll.setText("Close All");
        mi_closeAll.setData((Object)CLOSE_ALL);
        mi_closeAll.addListener(13, (Listener)this.m_tab);
        this.m_subFolder.setMenu(menu);
    }

    private LdapSubTab openCTab(Properties ldapProps, boolean isNew, boolean isReadOnly) {
        this.createSubFolder();
        LdapSubTab tab = new LdapSubTab(this, this.m_subFolder, ldapProps, isNew, isReadOnly);
        m_cTabList.put(ldapProps.getProperty("LDAP_URL"), tab);
        this.setControl((Control)this.m_compositeInCTab);
        this.m_subFolder.setSelection((CTabItem)tab);
        this.m_sc.setContent((Control)this.m_topComp);
        this.m_sc.setMinSize(this.m_topComp.computeSize(-1, -1, true));
        this.setControl((Control)this.m_compositeInCTab);
        return tab;
    }

    public boolean loadConfigList() {
        ScRemoteActionServer scr;
        boolean success;
        block17: {
            success = false;
            scr = new ScRemoteActionServer(Repository.getInstance(), null, "LDAP LIST", 20);
            scr.run();
            if (scr.isSupported()) break block17;
            return false;
        }
        try {
            if (scr.isSuccess()) {
                String res = scr.getResultObject();
                if (res != null && res.trim().length() > 0) {
                    Properties props = null;
                    this.m_ldapConfig.clear();
                    this.m_ldapOrder.clear();
                    String[] slpit = res.split("\n");
                    int i = 0;
                    while (i < slpit.length) {
                        String line = slpit[i];
                        if (line.startsWith("---")) {
                            String fileName = line.substring(3, line.length() - 3).trim();
                            props = new Properties();
                            props.put(FILE_NAME, fileName);
                            this.m_ldapOrder.add(fileName);
                        } else if (line.startsWith("LDAP_URL")) {
                            ByteArrayOutputStream os = new ByteArrayOutputStream();
                            os.write(line.getBytes());
                            ByteArrayInputStream is = new ByteArrayInputStream(os.toByteArray());
                            props.load(is);
                            this.m_ldapConfig.put(props.getProperty("LDAP_URL"), props);
                        } else if (line.startsWith("ENABLED")) {
                            String isEnabled = line.substring(line.indexOf("=") + 1, line.length());
                            props.put("ENABLED", isEnabled.trim());
                        }
                        ++i;
                    }
                    success = true;
                } else if (res == null) {
                    RTLogger.print(4, "Error getting ldap configuration from server ");
                } else {
                    success = true;
                }
            } else {
                RTLogger.print(4, "Error getting ldap configuration from server ");
            }
        }
        catch (Exception e) {
            RTLogger.print(4, "Error getting ldap configuration from server ", e);
        }
        if (success) {
            this.setDirty(false);
        } else {
            new ShowMessageBox("Load LDAP Configuration", "Error loading LDAP Configuration from the server.", 1);
        }
        return success;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Properties loadLDAP(String fileName) {
        ScGetFileAsString scf;
        Properties ldap_props;
        InputStream is;
        String serverPath;
        block20: {
            if (fileName == null || fileName.length() == 0) {
                return null;
            }
            serverPath = String.valueOf(this.m_serverPath) + fileName;
            is = null;
            ldap_props = null;
            scf = new ScGetFileAsString(Repository.getInstance(), serverPath, BMUI.type_file);
            scf.run();
            if (scf.isSupported()) break block20;
            try {
                if (is == null) return null;
                is.close();
                return null;
            }
            catch (IOException iOException) {}
            return null;
        }
        try {
            try {
                if (!scf.isFileExists()) {
                    RTLogger.print(4, "LDAP config file does not exist " + serverPath);
                } else if (scf.isSuccess()) {
                    String res = scf.getResultObject();
                    if (res != null) {
                        is = new ByteArrayInputStream(res.getBytes());
                        ldap_props = new Properties();
                        ldap_props.load(is);
                    } else {
                        RTLogger.print(4, "error getting LDAP config file " + serverPath);
                    }
                } else {
                    RTLogger.print(4, "error getting LDAP config file " + serverPath);
                }
            }
            catch (Exception e) {
                RTLogger.print(4, "Error getting LDAP config file " + serverPath, e);
                try {
                    if (is == null) return ldap_props;
                    is.close();
                    return ldap_props;
                }
                catch (IOException iOException) {}
                return ldap_props;
            }
        }
        catch (Throwable throwable) {
            try {
                if (is == null) throw throwable;
                is.close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            if (is == null) return ldap_props;
            is.close();
            return ldap_props;
        }
        catch (IOException iOException) {}
        return ldap_props;
    }

    public void reload(boolean doCheckDirty) {
        if (doCheckDirty) {
            String msg = null;
            if (this.m_subFolder != null && !this.m_subFolder.isDisposed()) {
                CTabItem[] items = this.m_subFolder.getItems();
                int i = 0;
                while (i < items.length) {
                    LdapSubTab tab = (LdapSubTab)items[i];
                    if (tab.isDirty()) {
                        msg = "LDAP Details has been changed but not yet saved! \nIf you don't want to loose changes you have to save them first!\n ";
                    }
                    ++i;
                }
            }
            if (msg == null && this.m_isDirty) {
                msg = "LDAP Order has been changed but not yet saved! \nIf you don't want to loose changes you have to save them first!\n ";
            }
            if (msg != null) {
                ShowSimpleDialog dialog = new ShowSimpleDialog(Display.getCurrent().getActiveShell(), "Reload Configuration", msg, "Continue", "Cancel");
                dialog.setBlockOnOpen(true);
                int res = dialog.open();
                if (res == 1) {
                    return;
                }
            }
        }
        this.loadConfigList();
        this.refreshTable();
        this.checkButtonStatus();
        if (this.m_subFolder == null || this.m_subFolder.isDisposed() || this.m_subFolder.getItems().length == 0) {
            return;
        }
        LdapSubTab tab_selected = this.getCurrentTab();
        String url_selected = null;
        if (tab_selected != null) {
            url_selected = (String)tab_selected.getData("LDAP_URL");
        }
        ArrayList<String> openTabs = new ArrayList<String>();
        if (this.m_subFolder != null && !this.m_subFolder.isDisposed()) {
            CTabItem[] items = this.m_subFolder.getItems();
            int i = 0;
            while (i < items.length) {
                LdapSubTab openTab = (LdapSubTab)items[i];
                String url = (String)openTab.getData("LDAP_URL");
                if (url != null) {
                    openTabs.add(url);
                }
                this.closeTab(openTab);
                ++i;
            }
        }
        for (String url : openTabs) {
            if (!this.m_ldapConfig.containsKey(url)) continue;
            Properties p = this.m_ldapConfig.get(url);
            Properties ldapProps = this.loadLDAP(p.getProperty(FILE_NAME));
            if (ldapProps == null) {
                new ShowMessageBox("Error", "Error getting LDAP Config file from the server!", 1);
                return;
            }
            LdapSubTab tab = this.openCTab(ldapProps, false, this.m_isReadOnly);
            if (!url.equals(url_selected)) continue;
            tab_selected = tab;
        }
        try {
            if (tab_selected != null) {
                this.m_subFolder.setSelection((CTabItem)tab_selected);
            } else {
                this.m_subFolder.setSelection(0);
            }
        }
        catch (Exception exception) {}
    }

    public void addUser() {
        LdapDialogAddUser dialog = new LdapDialogAddUser(Display.getCurrent().getActiveShell());
        dialog.open();
    }

    public void saveOrder() {
        List<String> newOrder = this.m_tableProvider.getOrder();
        StringBuilder sb = new StringBuilder();
        sb.append("LDAP SAVEORDER ");
        int i = 0;
        while (i < newOrder.size()) {
            String url = newOrder.get(i);
            if (url != null && url.length() > 0) {
                sb.append("\"").append(url).append("\"").append(" ");
            }
            ++i;
        }
        boolean success = false;
        try {
            ScRemoteActionServer scr = new ScRemoteActionServer(Repository.getInstance(), null, sb.toString(), 20);
            scr.run();
            if (!scr.isSupported()) {
                success = false;
            }
            if (scr.isSuccess()) {
                String res = scr.getResultObject();
                if (res != null && res.trim().length() > 0) {
                    if (res.contains("Error")) {
                        RTLogger.print(4, "Error saving ldap order to server! " + res);
                    } else {
                        success = true;
                    }
                } else {
                    RTLogger.print(4, "Error saving ldap order to server!");
                }
            } else {
                RTLogger.print(4, "Error saving ldap order to server!");
            }
        }
        catch (Exception e) {
            RTLogger.print(4, "Error saving ldap order to server!", e);
        }
        if (success) {
            this.setDirty(false);
        } else {
            new ShowMessageBox("Save LDAP Order", "Error saving LDAP order to the server!", 1);
        }
        this.checkButtonStatus();
    }

    public void setTableSelection(int index) {
        if (this.m_tableViewer != null) {
            if (this.m_tableViewer.getTable().getItemCount() == 0) {
                return;
            }
            if (index > 0) {
                this.m_tableViewer.getTable().select(index);
                this.m_tableViewer.getTable().setSelection(index);
            } else {
                this.m_tableViewer.getTable().select(0);
                this.m_tableViewer.getTable().setSelection(0);
            }
            this.checkButtonStatus();
        }
    }

    public boolean doesURLExist(String url) {
        return this.m_ldapConfig.containsKey(url);
    }

    public static boolean isURLValid(String url) {
        if (url == null || url.length() == 0) {
            return false;
        }
        boolean valid = false;
        try {
            if (url.startsWith("ldap")) {
                url = "http" + url.substring(4, url.length());
            }
            new URL(url);
            valid = true;
        }
        catch (MalformedURLException malformedURLException) {
            RTLogger.print(4, "ldap configuration invlalid URL " + url);
        }
        return valid;
    }

    public static boolean isExpireValid(String expire) {
        boolean isValid = false;
        if (expire == null || expire.length() == 0) {
            isValid = true;
        } else {
            try {
                Integer.parseInt(expire);
                isValid = true;
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return isValid;
    }

    private void edit() {
        StructuredSelection ssel = (StructuredSelection)this.m_tableViewer.getSelection();
        Properties selection = (Properties)ssel.getFirstElement();
        String fileName = selection.getProperty(FILE_NAME);
        String url = selection.getProperty("LDAP_URL");
        if (m_cTabList.containsKey(url)) {
            LdapSubTab tab = m_cTabList.get(url);
            this.m_subFolder.setSelection((CTabItem)tab);
        } else {
            Properties ldapProps = this.loadLDAP(fileName);
            if (ldapProps == null) {
                new ShowMessageBox("Error", "Error getting LDAP Config file from the server!", 1);
                return;
            }
            this.openCTab(ldapProps, false, this.m_isReadOnly);
        }
    }

    private void duplicate() {
        StructuredSelection ssel = (StructuredSelection)this.m_tableViewer.getSelection();
        Properties selection = (Properties)ssel.getFirstElement();
        String fileName = selection.getProperty(FILE_NAME);
        Properties ldapProps = this.loadLDAP(fileName);
        if (ldapProps == null) {
            new ShowMessageBox("Error", "Error getting LDAP Config file from the server!", 1);
            return;
        }
        Properties props_new = new Properties(ldapProps);
        props_new.put("ENABLED", "false");
        props_new.put("LDAP_URL", "dup_" + System.currentTimeMillis());
        this.openCTab(props_new, true, this.m_isReadOnly);
    }

    private void add() {
        Properties ldapProps_new = new Properties();
        ldapProps_new.put("ENABLED", "false");
        ldapProps_new.put("LDAP_URL", "new_" + System.currentTimeMillis());
        ldapProps_new.put("LDAP_BASE", "");
        ldapProps_new.put("LDAP_USER_ATTR", "");
        ldapProps_new.put("LDAP_EXPIRE", "");
        this.openCTab(ldapProps_new, true, this.m_isReadOnly);
    }

    public boolean delete() {
        StructuredSelection ssel = (StructuredSelection)this.m_tableViewer.getSelection();
        if (ssel.isEmpty()) {
            return false;
        }
        ArrayList<String> urls2Delete = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        sb.append("LDAP DELETECONFIG ");
        for (Properties ldapProps : ssel) {
            String url = ldapProps.getProperty("LDAP_URL");
            if (url == null || url.length() <= 0) continue;
            urls2Delete.add(url);
            sb.append(url).append(" ");
        }
        String errorMsg = "Error deleting LDAP configuration!";
        boolean success = false;
        try {
            ScRemoteActionServer scr = new ScRemoteActionServer(Repository.getInstance(), null, sb.toString(), 20);
            scr.run();
            if (!scr.isSupported()) {
                success = false;
            }
            if (scr.isSuccess()) {
                String res = scr.getResultObject();
                if (res != null && res.trim().length() > 0) {
                    if (res.contains("not found")) {
                        errorMsg = String.valueOf(res) + "!";
                        RTLogger.print(4, "Error deleting LDAP configuration " + urls2Delete + " " + res);
                    } else {
                        success = true;
                    }
                } else {
                    RTLogger.print(4, "Error deleting LDAP configuration " + urls2Delete);
                }
            } else {
                RTLogger.print(4, "Error deleting LDAP configuration " + urls2Delete);
            }
        }
        catch (Exception e) {
            RTLogger.print(4, "Error deleting LDAP configuration " + urls2Delete, e);
        }
        if (success) {
            int i = 0;
            while (i < urls2Delete.size()) {
                String url = (String)urls2Delete.get(i);
                this.closeTab(m_cTabList.get(url));
                this.m_ldapConfig.remove(url);
                ++i;
            }
        } else {
            new ShowMessageBox("Delete LDAP Configuration", errorMsg, 1);
        }
        this.refreshTable();
        this.checkButtonStatus();
        return success;
    }

    public void moveConfig(String type) {
        int selIndex = this.m_tableViewer.getTable().getSelectionIndex();
        if (selIndex == -1) {
            this.checkButtonStatus();
            return;
        }
        boolean moved = this.m_tableProvider.move(type, selIndex);
        if (moved) {
            this.setDirty(true);
            this.m_tableViewer.setInput((Object)this.m_tableProvider.getElements(null));
            this.m_tableViewer.getTable().layout(true);
            int total = this.m_tableViewer.getTable().getItemCount();
            if (type.equals("TOP")) {
                this.setTableSelection(0);
            } else if (type.equals("UP")) {
                this.setTableSelection(selIndex - 1);
            } else if (type.equals("DOWN")) {
                this.setTableSelection(selIndex + 1);
            } else if (type.equals("BOTTOM")) {
                this.setTableSelection(total - 1);
            }
        }
        this.checkButtonStatus();
    }

    public void refreshTable() {
        int selIindex = this.m_tableViewer.getTable().getSelectionIndex();
        this.m_tableProvider.updateOrder(this.m_ldapOrder);
        this.m_tableViewer.setInput((Object)this.m_tableProvider.getElements(this.m_ldapConfig));
        this.m_tableViewer.getTable().layout(true);
        try {
            this.m_tableViewer.getTable().select(selIindex);
        }
        catch (Exception exception) {
            this.m_tableViewer.getTable().deselectAll();
        }
    }

    public void checkButtonStatus() {
        int selIndex = this.m_tableViewer.getTable().getSelectionIndex();
        int selCount = this.m_tableViewer.getTable().getSelectionCount();
        int total = this.m_tableViewer.getTable().getItemCount();
        if (selCount == 1) {
            this.m_gui.enableField(this.m_edit_btn, true);
            this.m_gui.enableField(this.m_dup_btn, true);
            this.m_gui.enableField(this.m_del_btn, true);
            if (selIndex == 0) {
                this.m_gui.enableField(this.m_top_btn, false);
                this.m_gui.enableField(this.m_up_btn, false);
                this.m_gui.enableField(this.m_down_btn, true);
                this.m_gui.enableField(this.m_bottom_btn, true);
            } else if (selIndex == total - 1) {
                this.m_gui.enableField(this.m_top_btn, true);
                this.m_gui.enableField(this.m_up_btn, true);
                this.m_gui.enableField(this.m_down_btn, false);
                this.m_gui.enableField(this.m_bottom_btn, false);
            } else {
                this.m_gui.enableField(this.m_top_btn, true);
                this.m_gui.enableField(this.m_up_btn, true);
                this.m_gui.enableField(this.m_down_btn, true);
                this.m_gui.enableField(this.m_bottom_btn, true);
            }
        } else if (selCount > 1) {
            this.m_gui.enableField(this.m_edit_btn, false);
            this.m_gui.enableField(this.m_dup_btn, false);
            this.m_gui.enableField(this.m_del_btn, true);
            this.m_gui.enableField(this.m_top_btn, false);
            this.m_gui.enableField(this.m_up_btn, false);
            this.m_gui.enableField(this.m_down_btn, false);
            this.m_gui.enableField(this.m_bottom_btn, false);
        } else {
            this.m_gui.enableField(this.m_edit_btn, false);
            this.m_gui.enableField(this.m_dup_btn, false);
            this.m_gui.enableField(this.m_del_btn, false);
            this.m_gui.enableField(this.m_top_btn, false);
            this.m_gui.enableField(this.m_up_btn, false);
            this.m_gui.enableField(this.m_down_btn, false);
            this.m_gui.enableField(this.m_bottom_btn, false);
        }
        this.m_gui.enableField(this.m_save_order_btn, this.m_isDirty);
    }

    public void setDirty(boolean isDirty) {
        this.m_isDirty = isDirty;
        String title = this.getText();
        if (isDirty) {
            if (!title.startsWith("* ")) {
                this.setText("* " + title);
            }
        } else if (title.startsWith("* ")) {
            this.setText(title.substring(2));
        }
    }

    public boolean isDirty() {
        return this.m_isDirty;
    }

    private LdapSubTab getCurrentTab() {
        if (this.m_subFolder != null && !this.m_subFolder.isDisposed()) {
            return (LdapSubTab)this.m_subFolder.getSelection();
        }
        return null;
    }

    public void closeTab(LdapSubTab tab) {
        if (tab != null && !tab.isDisposed()) {
            tab.setDirty(false);
            m_cTabList.remove(tab.getText());
            tab.dispose();
            if (this.m_subFolder.getItems().length == 0) {
                Control[] controls = this.m_ldapDetailsComp.getChildren();
                int i = 0;
                while (i < controls.length) {
                    controls[i].dispose();
                    ++i;
                }
            }
        }
    }

    public void handleEvent(Event event) {
        block4: {
            String name;
            block5: {
                block3: {
                    name = (String)event.widget.getData();
                    if (!name.equals(CLOSE)) break block3;
                    this.closeTab(this.getCurrentTab());
                    break block4;
                }
                if (!name.equals(CLOSE_OTHERS)) break block5;
                LdapSubTab selected = this.getCurrentTab();
                CTabItem[] cTabs = this.m_subFolder.getItems();
                int index = 0;
                while (index < cTabs.length) {
                    LdapSubTab tab = (LdapSubTab)cTabs[index];
                    if (!((Object)((Object)tab)).equals((Object)selected)) {
                        this.closeTab(tab);
                    }
                    ++index;
                }
                break block4;
            }
            if (!name.equals(CLOSE_ALL)) break block4;
            CTabItem[] cTabs = this.m_subFolder.getItems();
            int i = 0;
            while (i < cTabs.length) {
                LdapSubTab tab = (LdapSubTab)cTabs[i];
                this.closeTab(tab);
                ++i;
            }
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        String name = "";
        Object o = e.getSource();
        if (o instanceof Button) {
            Button b = (Button)o;
            name = (String)b.getData();
            if (name.equals(EDIT_BTN)) {
                this.edit();
            } else if (name.equals(ADD_BTN)) {
                this.add();
            } else if (name.equals(DUP_BTN)) {
                this.duplicate();
            } else if (name.equals(DEL_BTN)) {
                this.delete();
            } else if (name.equals(RELOAD_BTN)) {
                this.reload(true);
            } else if (name.equals(ADD_USER_BTN)) {
                this.addUser();
            } else if (name.equals(TOP_BTN)) {
                this.moveConfig("TOP");
            } else if (name.equals(UP_BTN)) {
                this.moveConfig("UP");
            } else if (name.equals(DOWN_BTN)) {
                this.moveConfig("DOWN");
            } else if (name.equals(BOTTOM_BTN)) {
                this.moveConfig("BOTTOM");
            } else if (name.equals(SAVE_ORDER_BTN)) {
                this.saveOrder();
            }
        }
    }

    @Override
    public void onCommand(String command, String action) {
        if ("REFRESH_LDAP_SERVERSE".equals(command)) {
            UIJob ui = new UIJob("LDAPrefresh"){

                @Override
                public IStatus runInUIThread(IProgressMonitor monitor) {
                    LdapTab.this.loadConfigList();
                    LdapTab.this.refreshTable();
                    return Status.OK_STATUS;
                }
            };
            UIJobManager.getInstance().schedule(ui);
        }
    }

    public void dispose() {
        boolean isSubFolderDirty = false;
        if (this.m_subFolder != null && !this.m_subFolder.isDisposed()) {
            CTabItem[] items = this.m_subFolder.getItems();
            int i = 0;
            while (i < items.length) {
                LdapSubTab subTab = (LdapSubTab)items[i];
                if (subTab.isDirty()) {
                    isSubFolderDirty = true;
                    break;
                }
                ++i;
            }
        }
        if (this.m_isDirty || isSubFolderDirty) {
            try {
                ShowSimpleDialog dialog = new ShowSimpleDialog(this.getControl().getShell(), "Save LDAP", " LDAP Configuration has been modified. \n\nSave changes?", "Save", "No");
                int res = dialog.open();
                if (res == 0) {
                    if (this.m_isDirty) {
                        this.saveOrder();
                    }
                    if (isSubFolderDirty && this.m_subFolder != null && !this.m_subFolder.isDisposed()) {
                        CTabItem[] items = this.m_subFolder.getItems();
                        int i = 0;
                        while (i < items.length) {
                            LdapSubTab subTab = (LdapSubTab)items[i];
                            if (subTab.isDirty() && subTab.isValid() && subTab.isAuthOK()) {
                                subTab.save();
                            }
                            ++i;
                        }
                    }
                }
            }
            catch (Throwable throwable) {}
        }
        super.dispose();
    }

    public class AddAction
    extends Action {
        private LdapTab ldapTab;

        public AddAction(LdapTab tab) {
            super("Add");
            this.ldapTab = null;
            this.setText("Add");
            this.setId("Add");
            this.setImageDescriptor(LdapTab.this.m_sharedImages.getImageDescriptor("IMG_OBJ_ADD"));
            this.ldapTab = tab;
        }

        public void run() {
            if (!this.isEnabled()) {
                return;
            }
            this.ldapTab.add();
        }
    }

    public class DeleteAction
    extends Action {
        private LdapTab ldapTab;

        public DeleteAction(LdapTab tab, TableViewer tv) {
            super("Delete");
            this.ldapTab = null;
            this.setText("Delete");
            this.setId("Delete");
            this.setImageDescriptor(LdapTab.this.m_sharedImages.getImageDescriptor("IMG_TOOL_DELETE"));
            this.ldapTab = tab;
            StructuredSelection ssel = (StructuredSelection)tv.getSelection();
            if (ssel.isEmpty()) {
                this.setEnabled(false);
            }
        }

        public void run() {
            if (!this.isEnabled()) {
                return;
            }
            this.ldapTab.delete();
        }
    }

    public class DuplicateAction
    extends Action {
        private LdapTab ldapTab;

        public DuplicateAction(LdapTab tab, TableViewer tv) {
            super("Duplicate");
            this.ldapTab = null;
            this.setText("Duplicate");
            this.setId("Duplicate");
            this.setImageDescriptor(LdapTab.this.m_sharedImages.getImageDescriptor("IMG_TOOL_COPY"));
            this.ldapTab = tab;
            StructuredSelection ssel = (StructuredSelection)tv.getSelection();
            if (ssel.isEmpty() || ssel.size() > 1) {
                this.setEnabled(false);
            }
        }

        public void run() {
            if (!this.isEnabled()) {
                return;
            }
            this.ldapTab.duplicate();
        }
    }

    public class EditAction
    extends Action {
        private LdapTab ldapTab;

        public EditAction(LdapTab tab, TableViewer tv, boolean isReadOnly) {
            super("Edit");
            this.ldapTab = null;
            this.setText(isReadOnly ? "Open" : "Edit");
            this.setId("Edit");
            this.ldapTab = tab;
            StructuredSelection ssel = (StructuredSelection)tv.getSelection();
            if (ssel.isEmpty() || ssel.size() > 1) {
                this.setEnabled(false);
            }
        }

        public void run() {
            if (!this.isEnabled()) {
                return;
            }
            this.ldapTab.edit();
        }
    }

    public class ReloadAction
    extends Action {
        private LdapTab ldapTab;

        public ReloadAction(LdapTab tab) {
            super("Reload");
            this.ldapTab = null;
            this.setText("Reload");
            this.setId("Reload");
            this.setImageDescriptor(BMUI.IMAGE_DESCR_REFRESH);
            this.ldapTab = tab;
        }

        public void run() {
            this.ldapTab.reload(true);
        }
    }
}

