/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.views.configuration;

import com.blixx.boom.engine.BMUI;
import com.blixx.boom.gui.views.configuration.LdapTab;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;

public class LdapTableProvider
implements IStructuredContentProvider,
ITableLabelProvider {
    private Map<String, Properties> m_elements = new TreeMap<String, Properties>();
    private List<String> m_order = new ArrayList<String>();
    private Map<String, String> m_fileNameUrl = new HashMap<String, String>();
    public static final String TOP = "TOP";
    public static final String UP = "UP";
    public static final String DOWN = "DOWN";
    public static final String BOTTOM = "BOTTOM";

    public LdapTableProvider(Map<String, Properties> ldapCfg, List<String> order) {
        this.m_elements = ldapCfg;
        this.updateOrder(order);
        this.updateMetric();
    }

    public Object[] getElements(Object ldapCfg) {
        if (ldapCfg != null && ldapCfg instanceof Map) {
            this.m_elements = (Map)ldapCfg;
            this.updateMetric();
        }
        return this.getElementsWithCorrectOrder();
    }

    public Object[] getElementsWithCorrectOrder() {
        Object[] elements = new Object[this.m_order.size()];
        int i = 0;
        while (i < this.m_order.size()) {
            String fileName = this.m_order.get(i);
            Properties props = this.getProps(fileName);
            if (props != null) {
                elements[i] = props;
            }
            ++i;
        }
        return elements;
    }

    public void updateOrder(List<String> order) {
        this.m_order = order;
    }

    public void updateMetric() {
        this.m_fileNameUrl.clear();
        for (String url : this.m_elements.keySet()) {
            Properties props = this.m_elements.get(url);
            String fileName = props.getProperty(LdapTab.FILE_NAME);
            this.m_fileNameUrl.put(fileName, url);
        }
    }

    public boolean move(String type, int selIndex) {
        if (selIndex == -1) {
            return false;
        }
        boolean moved = false;
        if (TOP.equals(type)) {
            moved = this.moveToTop(selIndex);
        } else if (UP.equals(type)) {
            moved = this.moveUp(selIndex);
        } else if (DOWN.equals(type)) {
            moved = this.moveDown(selIndex);
        } else if (BOTTOM.equals(type)) {
            moved = this.moveToBottom(selIndex);
        }
        return moved;
    }

    private boolean moveToTop(int selIndex) {
        String fileName;
        boolean moved = false;
        if (selIndex != 0 && selIndex > 0 && (fileName = this.m_order.remove(selIndex)) != null) {
            this.m_order.add(0, fileName);
            moved = true;
        }
        return moved;
    }

    private boolean moveUp(int selIndex) {
        boolean moved = false;
        if (selIndex != 0 && selIndex > 0) {
            String fileName = this.m_order.remove(selIndex);
            this.m_order.add(selIndex - 1, fileName);
            moved = true;
        }
        return moved;
    }

    private boolean moveDown(int selIndex) {
        String fileName;
        boolean moved = false;
        int total = this.m_elements.size();
        if (selIndex != total - 1 && selIndex > -1 && (fileName = this.m_order.remove(selIndex)) != null) {
            this.m_order.add(selIndex + 1, fileName);
            moved = true;
        }
        return moved;
    }

    private boolean moveToBottom(int selIndex) {
        String fileName;
        int count = this.m_elements.size();
        if (selIndex != count - 1 && selIndex < count - 1 && (fileName = this.m_order.remove(selIndex)) != null) {
            this.m_order.add(count - 1, fileName);
            return true;
        }
        return false;
    }

    public List<String> getOrder() {
        ArrayList<String> newOrder = new ArrayList<String>();
        int i = 0;
        while (i < this.m_order.size()) {
            String fileName = this.m_order.get(i);
            Properties props = this.getProps(fileName);
            try {
                String url = props.getProperty("LDAP_URL");
                newOrder.add(url);
            }
            catch (Exception exception) {}
            ++i;
        }
        return newOrder;
    }

    private Properties getProps(String fileName) {
        if (this.m_elements != null) {
            for (String url : this.m_elements.keySet()) {
                Properties props = this.m_elements.get(url);
                if (props == null || !fileName.equals(props.getProperty(LdapTab.FILE_NAME))) continue;
                return props;
            }
        }
        return null;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public Image getColumnImage(Object element, int columnIndex) {
        if (element == null) {
            return null;
        }
        Properties p = (Properties)element;
        Image image = null;
        switch (columnIndex) {
            case 0: {
                image = new Boolean(p.getProperty("ENABLED")) != false ? BMUI.IMAGE_ACCEPT_GREEN : BMUI.IMAGE_CANCEL_ROUND;
            }
        }
        return image;
    }

    public String getColumnText(Object element, int colIndex) {
        if (element == null) {
            return "";
        }
        Properties p = (Properties)element;
        String res = "";
        switch (colIndex) {
            case 0: {
                break;
            }
            case 1: {
                res = p.getProperty(LdapTab.FILE_NAME);
                break;
            }
            case 2: {
                res = p.getProperty("LDAP_URL");
            }
        }
        return res;
    }

    public void dispose() {
    }
}

