/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.views.configuration;

import com.blixx.boom.engine.BMUI;
import com.blixx.boom.engine.Repository;
import com.blixx.boom.engine.ServerClientBatch;
import com.blixx.boom.gui.utils.GUIDisplayElements;
import com.blixx.log.RTLogger;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.LinkedHashMap;
import java.util.Properties;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class ProductPropertyTab
extends CTabItem
implements SelectionListener {
    private static final String RELOAD_BUTTON = "RELOAD_BUTTON";
    private CTabFolder m_folder = null;
    private String m_slaveHostName = null;
    private GUIDisplayElements m_gui = null;
    private Composite m_compositeInCTab = null;
    private ScrolledComposite m_sc = null;
    private Composite m_mainComp = null;
    public static String TAB_NAME = "boom.props";
    private String m_serverPath = "/../../boom.props";
    private String m_fileName = "boom.props";
    private String m_localDir = Repository.getUserTmpDirectory();
    private Properties m_props = new Properties();
    public static LinkedHashMap<String, String> m_params = new LinkedHashMap();

    static {
        m_params.put("AGENT_PORT", "23021");
        m_params.put("AUTO_APPROVAL", "false");
        m_params.put("AUTO_ARCHIVE_DAYS", "-1");
        m_params.put("AUTO_BACKUP", "true");
        m_params.put("AUTO_CLOSE_DAYS", "-1");
        m_params.put("AUTO_DELETE_DAYS", "-1");
        m_params.put("CLUSTER_NODES", "");
        m_params.put("GUI_PORT", "23022");
        m_params.put("HB_CTIMEOUT", "10000");
        m_params.put("HB_INTERVAL", "10");
        m_params.put("HB_RTIMEOUT", "10000");
        m_params.put("HTTP_PORT", "8888");
        m_params.put("INSTRUCTION_SERVER", "");
        m_params.put("LOGLEVEL", "1");
        m_params.put("MAIN_SERVER_PORT", "23020");
        m_params.put("MAX_AGENT_THREADS", "0");
        m_params.put("MAX_DEPLOY_THREADS", "10");
        m_params.put("SHORT_LABELS", "false");
        m_params.put("SSL_KEYSTORE", "");
    }

    public ProductPropertyTab(CTabFolder parent, String slaveOrNull) {
        super(parent, 0, 0);
        this.m_folder = parent;
        this.m_slaveHostName = slaveOrNull;
        if (this.m_slaveHostName != null) {
            this.setText(String.valueOf(TAB_NAME) + '@' + this.m_slaveHostName);
        } else {
            this.setText(TAB_NAME);
        }
        this.setImage(null);
        this.createMainArea();
    }

    public void createCompositeContent(Composite parent) {
        for (String name : m_params.keySet()) {
            String value = this.m_props.getProperty(name, m_params.get(name));
            this.m_gui.addTextReadOnly(parent, name, value, 9, 1, 0, 0, null, BMUI.font_arial7);
        }
    }

    public void createMainArea() {
        this.m_gui = new GUIDisplayElements();
        this.m_compositeInCTab = new Composite((Composite)this.m_folder, 0);
        GridLayout gl = new GridLayout(2, false);
        gl.verticalSpacing = 0;
        gl.horizontalSpacing = 0;
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        this.m_compositeInCTab.setLayout((Layout)gl);
        this.m_sc = new ScrolledComposite(this.m_compositeInCTab, 2816);
        this.m_sc.setAlwaysShowScrollBars(false);
        this.m_sc.setExpandHorizontal(true);
        this.m_sc.setExpandVertical(true);
        this.m_sc.setLayout((Layout)new GridLayout(1, false));
        this.m_sc.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        this.undo();
        Composite lineComp = new Composite(this.m_compositeInCTab, 0);
        gl = new GridLayout(1, false);
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        lineComp.setLayout((Layout)gl);
        lineComp.setLayoutData((Object)new GridData(4, 128, true, false, 2, 1));
        Label line = new Label(lineComp, 259);
        line.setForeground(BMUI.color_darkGrey2);
        line.setLayoutData((Object)new GridData(4, 128, true, false, 2, 1));
        Composite btnCompLeft = new Composite(this.m_compositeInCTab, 0);
        btnCompLeft.setLayout((Layout)new GridLayout(3, true));
        btnCompLeft.setLayoutData((Object)new GridData(16384, 4, false, false));
        Composite btnCompRight = new Composite(this.m_compositeInCTab, 0);
        btnCompRight.setLayout((Layout)new GridLayout(2, true));
        btnCompRight.setLayoutData((Object)new GridData(131072, 4, false, false));
        Button m_undo_btn = this.m_gui.addButton(btnCompRight, RELOAD_BUTTON, "Reload", true, 90, 30, 0, this);
        m_undo_btn.setLayoutData((Object)new GridData(4, 128, false, false, 1, 1));
        this.setControl((Control)this.m_compositeInCTab);
    }

    /*
     * Loose catch block
     */
    private void getFileFromServer() {
        block56: {
            ServerClientBatch scb = null;
            InputStreamReader fr = null;
            BufferedReader br = null;
            File file = null;
            try {
                scb = new ServerClientBatch("GETFILE");
                scb.openSocket();
                if (this.m_slaveHostName == null) {
                    scb.setCommand("GETFILE", null, new String[]{this.m_serverPath, BMUI.type_file, String.valueOf(this.m_localDir) + File.separator});
                } else {
                    scb.setCommand("GETFILE_SLAVE", null, new String[]{this.m_serverPath, BMUI.type_file, this.m_slaveHostName, String.valueOf(this.m_localDir) + File.separator});
                }
                Object res = scb.runBatch();
                if (scb.isSuccess() && res != null) {
                    file = new File(String.valueOf(this.m_localDir) + File.separator + this.m_fileName);
                    if (!file.exists()) {
                        RTLogger.print(5, "file tmp/hosts does not exist");
                    } else if (!file.canRead()) {
                        RTLogger.print(5, "Cannot read file tmp/hosts");
                    } else {
                        this.m_props.clear();
                        fr = new FileReader(file);
                        br = new BufferedReader(fr);
                        this.m_props.load(br);
                    }
                } else {
                    RTLogger.print(5, "Error getting file from server");
                }
            }
            catch (RuntimeException e) {
                RTLogger.print(4, "Error loading file " + this.m_fileName, e);
                try {
                    scb.close();
                }
                catch (Throwable throwable) {}
                try {
                    br.close();
                }
                catch (Throwable throwable) {}
                try {
                    fr.close();
                }
                catch (Throwable throwable) {}
                try {
                    file.delete();
                }
                catch (Throwable throwable) {}
                break block56;
            }
            catch (FileNotFoundException e) {
                RTLogger.print(4, "file not found " + this.m_fileName, e);
                try {
                    scb.close();
                }
                catch (Throwable throwable) {}
                try {
                    br.close();
                }
                catch (Throwable throwable) {}
                try {
                    fr.close();
                }
                catch (Throwable throwable) {}
                try {
                    file.delete();
                }
                catch (Throwable throwable) {}
                break block56;
            }
            catch (IOException e) {
                RTLogger.print(4, "IO error loading file " + this.m_fileName, e);
                {
                    catch (Throwable throwable) {
                        try {
                            scb.close();
                        }
                        catch (Throwable throwable2) {}
                        try {
                            br.close();
                        }
                        catch (Throwable throwable3) {}
                        try {
                            fr.close();
                        }
                        catch (Throwable throwable4) {}
                        try {
                            file.delete();
                        }
                        catch (Throwable throwable5) {}
                        throw throwable;
                    }
                }
                try {
                    scb.close();
                }
                catch (Throwable throwable) {}
                try {
                    br.close();
                }
                catch (Throwable throwable) {}
                try {
                    fr.close();
                }
                catch (Throwable throwable) {}
                try {
                    file.delete();
                }
                catch (Throwable throwable) {}
                break block56;
            }
            try {
                scb.close();
            }
            catch (Throwable throwable) {}
            try {
                br.close();
            }
            catch (Throwable throwable) {}
            try {
                fr.close();
            }
            catch (Throwable throwable) {}
            try {
                file.delete();
            }
            catch (Throwable throwable) {}
        }
    }

    private void undo() {
        this.getFileFromServer();
        try {
            this.m_mainComp.dispose();
        }
        catch (Throwable throwable) {}
        this.m_mainComp = new Composite((Composite)this.m_sc, 0);
        GridLayout gl = new GridLayout(10, false);
        gl.marginWidth = 1;
        gl.marginHeight = 1;
        gl.marginBottom = 5;
        gl.verticalSpacing = 1;
        this.m_mainComp.setLayout((Layout)gl);
        this.m_mainComp.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createCompositeContent(this.m_mainComp);
        this.m_sc.setContent((Control)this.m_mainComp);
        this.m_sc.setMinSize(this.m_mainComp.computeSize(-1, -1, true));
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        Button b;
        String name = "";
        if (e.getSource() instanceof Button && (name = (String)(b = (Button)e.getSource()).getData()).equalsIgnoreCase(RELOAD_BUTTON)) {
            b.setEnabled(false);
            try {
                try {
                    this.undo();
                }
                catch (Throwable throwable) {
                    b.setEnabled(true);
                }
            }
            finally {
                b.setEnabled(true);
            }
        }
    }
}

