/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.views.configuration;

import com.blixx.boom.engine.BMUI;
import com.blixx.boom.gui.utils.GUIDisplayElements;
import com.blixx.boom.gui.views.configuration.ResultHostTreeObject;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ResultHostAliasDialog
extends StatusDialog
implements ModifyListener {
    private Composite m_mainComp = null;
    private String m_actionType = null;
    private ResultHostTreeObject m_hostObject = null;
    private String m_hostName = null;
    private Text m_agentID_field = null;
    private Text m_alias_field = null;
    private GUIDisplayElements m_gui = null;
    private String m_agentID = null;
    private String m_alias = null;
    public static String ADD = "Add";
    public static String EDIT = "Edit";
    public static String AGENT_ID = "AGENT_ID";
    public static String ALIAS = "ALIAS";

    public ResultHostAliasDialog(String actionType, ResultHostTreeObject hostObject) {
        super(Display.getCurrent().getActiveShell());
        this.setShellStyle(this.getShellStyle() | 0x10 | 0x80 | 0x400);
        this.setImage(null);
        this.setTitle("  " + actionType + " Alias");
        this.m_actionType = actionType;
        this.m_hostObject = hostObject;
    }

    public ResultHostAliasDialog(String actionType, String hostName) {
        super(Display.getCurrent().getActiveShell());
        this.setShellStyle(this.getShellStyle() | 0x10 | 0x80 | 0x400);
        this.setImage(null);
        this.setTitle("  " + actionType + " Alias");
        this.m_actionType = actionType;
        this.m_hostName = hostName;
    }

    protected Control createDialogArea(Composite parent) {
        this.m_gui = new GUIDisplayElements();
        this.m_gui.centerShell(parent.getShell(), Display.getCurrent());
        this.m_mainComp = new Composite(parent, 0);
        GridLayout gl = new GridLayout(2, false);
        gl.marginWidth = 10;
        gl.marginTop = 10;
        this.m_mainComp.setLayout((Layout)gl);
        GridData gd = new GridData(4, 4, true, true);
        gd.widthHint = 400;
        this.m_mainComp.setLayoutData((Object)gd);
        if (this.m_actionType.equals(EDIT) && this.m_hostObject != null) {
            this.m_agentID = this.m_hostObject.getAgentID();
            this.m_alias = this.m_hostObject.getAliasName();
        }
        if (this.m_hostObject != null) {
            this.m_gui.addTextReadOnlyNoBorder(this.m_mainComp, "Result Host: ", this.m_hostObject.getHostName(), 1, 1, 1, 1, BMUI.font_arial8);
        } else if (this.m_hostName != null) {
            this.m_gui.addTextReadOnlyNoBorder(this.m_mainComp, "Result Host: ", this.m_hostName, 1, 1, 1, 1, BMUI.font_arial8);
        }
        this.m_alias_field = this.m_gui.addInputFieldSingle(this.m_mainComp, ALIAS, "Incoming Host Alias: ", this.m_alias, 1, 1, 1, 1, 60, this);
        this.m_agentID_field = this.m_gui.addInputFieldSingle(this.m_mainComp, AGENT_ID, "(Optional) AgentID: ", this.m_agentID, 1, 1, 1, 1, 60, this);
        return this.m_mainComp;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        Button b = this.createButton(parent, 0, "Save", true);
        b.setEnabled(false);
        this.createButton(parent, 1, "Cancel", false);
    }

    protected void cancelPressed() {
        try {
            this.m_mainComp.dispose();
        }
        catch (Exception exception) {}
        super.cancelPressed();
    }

    protected void okPressed() {
        try {
            this.m_mainComp.dispose();
        }
        catch (Exception exception) {}
        super.okPressed();
    }

    public List<String> getResult() {
        ArrayList<String> result = new ArrayList<String>();
        result.add(this.m_agentID);
        result.add(this.m_alias);
        return result;
    }

    public void modifyText(ModifyEvent e) {
        if (e.getSource() instanceof Text) {
            Text field = (Text)e.getSource();
            String name = (String)field.getData();
            boolean isValid = true;
            if (name.equals(AGENT_ID)) {
                this.m_agentID = this.m_agentID_field.getText().trim();
            } else if (name.equals(ALIAS)) {
                this.m_alias = this.m_alias_field.getText().trim();
            }
            if (this.m_alias == null || this.m_alias.length() == 0) {
                isValid = false;
            }
            this.getButton(0).setEnabled(isValid);
        }
    }
}

