/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.views.configuration;

import com.blixx.boom.engine.BMUI;
import com.blixx.boom.gui.utils.GUIDisplayElements;
import com.blixx.boom.gui.views.configuration.ResultHostAliasDialog;
import com.blixx.boom.gui.views.configuration.ResultHostTreeObject;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class ResultHostDialog
extends StatusDialog
implements ModifyListener,
SelectionListener {
    private Composite m_mainComp = null;
    private String m_actionType = null;
    private String m_origHostName = null;
    private String m_hostName = null;
    private ResultHostTreeObject m_hostObject = null;
    private Table m_table = null;
    private TableViewer m_tableViewer = null;
    private TableProvider m_tableProvider = null;
    private GUIDisplayElements m_gui = null;
    private Button m_del_btn = null;
    private int m_colIndex = -1;
    public static String ADD = "Add";
    public static String EDIT = "Edit";
    public static String ADD_BTN = "ADD_BTN";
    public static String DEL_BTN = "DEL_BTN";
    public static String HOST = "HOST";

    public ResultHostDialog(String actionType, ResultHostTreeObject hostObject) {
        super(Display.getCurrent().getActiveShell());
        this.setShellStyle(this.getShellStyle() | 0x10 | 0x80 | 0x400);
        this.setImage(null);
        this.setTitle("  " + actionType + " Result Host");
        this.m_actionType = actionType;
        if (this.m_actionType.equals(EDIT) && hostObject != null) {
            this.m_hostObject = hostObject;
            this.m_hostName = this.m_origHostName = this.m_hostObject.getHostName();
        } else {
            this.m_origHostName = "";
            this.m_hostName = "";
        }
    }

    protected Control createDialogArea(Composite parent) {
        this.m_gui = new GUIDisplayElements();
        this.m_gui.centerShell(parent.getShell(), Display.getCurrent());
        this.m_mainComp = new Composite(parent, 0);
        GridLayout gl = new GridLayout(2, false);
        gl.marginWidth = 10;
        gl.marginTop = 5;
        this.m_mainComp.setLayout((Layout)gl);
        GridData gd = new GridData(4, 4, true, true);
        gd.widthHint = 590;
        gd.heightHint = 300;
        this.m_mainComp.setLayoutData((Object)gd);
        this.m_gui.addInputFieldSingle(this.m_mainComp, HOST, "Result Host: ", this.m_origHostName, 1, 1, 1, 1, 60, this);
        Label alias = this.m_gui.addTextField(this.m_mainComp, null, "Incoming Hosts: ", 1, 1, 1, 1, BMUI.font_arial8);
        ((GridData)alias.getLayoutData()).verticalAlignment = 128;
        Composite tableComp = new Composite(this.m_mainComp, 0);
        gl = new GridLayout(2, false);
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        tableComp.setLayout((Layout)gl);
        tableComp.setLayoutData((Object)new GridData(4, 4, true, true));
        this.m_table = new Table(tableComp, 68386);
        this.m_table.setHeaderVisible(true);
        this.m_table.setLinesVisible(true);
        gl = new GridLayout(1, false);
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        this.m_table.setLayout((Layout)gl);
        this.m_table.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        TableColumn col0 = new TableColumn(this.m_table, 16384);
        col0.setText("");
        col0.setWidth(30);
        TableColumn col2 = new TableColumn(this.m_table, 16384);
        col2.setText("Incoming Host Alias");
        col2.setWidth(250);
        TableColumn col1 = new TableColumn(this.m_table, 16384);
        col1.setText("Agent ID (optional)");
        col1.setWidth(250);
        this.m_tableViewer = new TableViewer(this.m_table);
        this.m_tableProvider = new TableProvider(this.m_tableViewer, this.m_hostObject);
        this.m_tableViewer.setUseHashlookup(true);
        this.m_tableViewer.setContentProvider((IContentProvider)this.m_tableProvider);
        this.m_tableViewer.setLabelProvider((IBaseLabelProvider)this.m_tableProvider);
        this.m_tableViewer.setInput((Object)this.m_tableProvider.getElements(null));
        final TableEditor editor = new TableEditor(this.m_table);
        editor.horizontalAlignment = 16384;
        editor.grabHorizontal = true;
        this.m_table.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                if (e.button == 1) {
                    Table t = (Table)e.getSource();
                    ResultHostDialog.this.m_colIndex = ResultHostDialog.this.getColumnIndex(t, e.x);
                }
            }

            public void mouseUp(MouseEvent e) {
            }
        });
        this.m_table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableItem item;
                Control oldEditor = editor.getEditor();
                if (oldEditor != null) {
                    oldEditor.dispose();
                }
                if ((item = (TableItem)e.item) == null || ResultHostDialog.this.m_colIndex < 0) {
                    return;
                }
                if (ResultHostDialog.this.m_colIndex == 0) {
                    ResultHostDialog.this.checkDelBtnStatus();
                } else {
                    Text newEditor = new Text((Composite)ResultHostDialog.this.m_table, 0);
                    newEditor.setText(item.getText(ResultHostDialog.this.m_colIndex));
                    newEditor.addModifyListener(new ModifyListener(){

                        public void modifyText(ModifyEvent me) {
                            String text_new;
                            String text_old;
                            Object obj = me.getSource();
                            if (obj instanceof Text && !(text_old = editor.getItem().getText(ResultHostDialog.this.m_colIndex)).equals(text_new = ((Text)editor.getEditor()).getText().trim())) {
                                editor.getItem().setText(ResultHostDialog.this.m_colIndex, text_new);
                                ResultHostDialog.this.editAlias(ResultHostDialog.this.m_table.getSelectionIndex(), ResultHostDialog.this.m_colIndex, text_new);
                                ResultHostDialog.this.checkSaveBtnStatus();
                            }
                        }
                    });
                    newEditor.selectAll();
                    newEditor.setFocus();
                    editor.setEditor((Control)newEditor, item, ResultHostDialog.this.m_colIndex);
                }
            }
        });
        this.m_gui.addButton(tableComp, ADD_BTN, " Add ", true, this);
        this.m_del_btn = this.m_gui.addButton(tableComp, DEL_BTN, " Delete ", false, this);
        return this.m_mainComp;
    }

    public void deleteAlias() {
        ArrayList<Integer> selIndices = new ArrayList<Integer>();
        int total = this.m_table.getItemCount();
        int i = 0;
        while (i < total) {
            TableItem ti = this.m_table.getItem(i);
            if (ti.getChecked()) {
                selIndices.add(i);
            }
            ++i;
        }
        this.m_tableProvider.remove(selIndices);
    }

    public void addAlias() {
        ResultHostAliasDialog dialog = new ResultHostAliasDialog(ResultHostAliasDialog.ADD, this.m_hostName);
        dialog.setBlockOnOpen(true);
        int value = dialog.open();
        if (value == 0) {
            List<String> result = dialog.getResult();
            this.m_tableProvider.add(result);
        }
    }

    public void editAlias(int rowIndex, int m_colIndex, String text) {
        this.m_tableProvider.edit(rowIndex, m_colIndex, text);
    }

    public int getColumnIndex(Table t, int position) {
        int colIndex = -1;
        int start = 0;
        int end = 0;
        LinkedHashMap<Integer, Integer> m = new LinkedHashMap<Integer, Integer>();
        TableColumn[] colList = t.getColumns();
        int index = 0;
        while (index < t.getColumnCount()) {
            m.put(index, colList[index].getWidth());
            ++index;
        }
        index = 0;
        while (index < m.size()) {
            if (index > 0) {
                start += Integer.valueOf(((Integer)m.get(index - 1)).toString()).intValue();
            }
            end = start + Integer.valueOf(((Integer)m.get(index)).toString());
            if (position >= start && position <= end) {
                colIndex = index;
                break;
            }
            ++index;
        }
        return colIndex;
    }

    public void checkDelBtnStatus() {
        boolean enable = false;
        TableItem[] items = this.m_table.getItems();
        int i = 0;
        while (i < items.length) {
            if (items[i].getChecked()) {
                enable = true;
                break;
            }
            ++i;
        }
        this.m_gui.enableField(this.m_del_btn, enable);
    }

    public void checkSaveBtnStatus() {
        if (this.m_hostName != null && this.m_hostName.length() > 0 && this.m_table.getItems().length > 0) {
            this.getButton(0).setEnabled(true);
        } else {
            this.getButton(0).setEnabled(false);
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        Button b = this.createButton(parent, 0, "Save", true);
        b.setEnabled(false);
        this.createButton(parent, 1, "Cancel", false);
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            super.okPressed();
        } else {
            super.cancelPressed();
        }
    }

    protected void cancelPressed() {
        try {
            this.m_mainComp.dispose();
        }
        catch (Exception exception) {}
        super.cancelPressed();
    }

    protected void okPressed() {
        try {
            this.m_mainComp.dispose();
        }
        catch (Exception exception) {}
        super.okPressed();
    }

    public String getHostName() {
        return this.m_hostName;
    }

    public List<String> getAliases() {
        return this.m_tableProvider.getResult();
    }

    public void modifyText(ModifyEvent e) {
        Object obj = e.getSource();
        if (obj instanceof Text) {
            Text field = (Text)obj;
            String name = (String)field.getData();
            if (name.equals(HOST)) {
                this.m_hostName = field.getText().trim();
            }
            this.checkSaveBtnStatus();
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        Object obj = e.getSource();
        if (obj instanceof Button) {
            Button btn = (Button)obj;
            String name = (String)btn.getData();
            if (name.equals(ADD_BTN)) {
                this.addAlias();
                this.checkSaveBtnStatus();
            } else if (name.equals(DEL_BTN)) {
                this.deleteAlias();
                this.checkSaveBtnStatus();
            }
        }
    }

    private class TableProvider
    implements IStructuredContentProvider,
    ITableLabelProvider {
        private TableViewer m_tv = null;
        private ResultHostTreeObject m_hostObj = null;
        private List<String[]> m_elements = new ArrayList<String[]>();

        public TableProvider(TableViewer tv, ResultHostTreeObject hostObject) {
            this.m_tv = tv;
            this.m_hostObj = hostObject;
            this.init();
        }

        public void init() {
            if (this.m_hostObj != null && this.m_hostObj.getAliases().size() > 0) {
                List<ResultHostTreeObject> children = this.m_hostObj.getAliases();
                for (ResultHostTreeObject mto : children) {
                    String[] list = new String[]{mto.getAgentID(), mto.getAliasName()};
                    this.m_elements.add(list);
                }
            }
        }

        public void update() {
            this.m_elements.clear();
            TableItem[] items = this.m_tv.getTable().getItems();
            int i = 0;
            while (i < items.length) {
                TableItem ti = items[i];
                String[] list = new String[]{ti.getText(2), ti.getText(1)};
                this.m_elements.add(list);
                ++i;
            }
        }

        public void add(List<String> result) {
            TableItem ti = new TableItem(ResultHostDialog.this.m_tableViewer.getTable(), 0, ResultHostDialog.this.m_tableViewer.getTable().getItemCount());
            String agentID = result.get(0);
            String alias = result.get(1);
            ti.setText(1, alias);
            if (agentID == null) {
                agentID = "";
            }
            ti.setText(2, agentID);
            this.update();
        }

        public void edit(int rowIndex, int colIndes, String text) {
            TableItem ti = ResultHostDialog.this.m_tableViewer.getTable().getItem(rowIndex);
            ti.setText(colIndes, text);
            this.update();
        }

        public void remove(List<Integer> selIndices) {
            int[] indices = new int[selIndices.size()];
            int i = 0;
            while (i < selIndices.size()) {
                int index;
                indices[i] = index = selIndices.get(i).intValue();
                ++i;
            }
            ResultHostDialog.this.m_tableViewer.getTable().remove(indices);
            this.update();
        }

        public Object[] getElements(Object inputElement) {
            if (this.m_elements == null) {
                return null;
            }
            return this.m_elements.toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            String result = null;
            if (element instanceof ResultHostTreeObject) {
                ResultHostTreeObject mto = (ResultHostTreeObject)element;
                switch (columnIndex) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        result = mto.getAliasName();
                        break;
                    }
                    case 2: {
                        result = mto.getAgentID();
                    }
                }
            } else if (element instanceof String[]) {
                String[] elem = (String[])element;
                switch (columnIndex) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        try {
                            result = elem[1];
                        }
                        catch (Throwable throwable) {}
                        break;
                    }
                    case 2: {
                        try {
                            result = elem[0];
                            break;
                        }
                        catch (Throwable throwable) {}
                    }
                }
            }
            return result;
        }

        public List<String> getResult() {
            StringBuffer sb = null;
            ArrayList<String> list = new ArrayList<String>();
            for (String[] strList : this.m_elements) {
                sb = new StringBuffer();
                if (strList[0] != null && strList[0].length() > 0) {
                    sb.append(strList[0]).append('|').append(strList[1]);
                } else {
                    sb.append(strList[1]);
                }
                list.add(sb.toString());
            }
            return list;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }
}

