/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.views.configuration;

import com.blixx.boom.engine.BMUI;
import com.blixx.boom.gui.views.configuration.ResultHostTreeObject;
import com.blixx.shared.utils.StrUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;

public class ResultHostManager
extends StyledCellLabelProvider
implements ITreeContentProvider {
    private Map<String, List<String>> m_headers = new LinkedHashMap<String, List<String>>();
    private Map<String, List<String>> m_hostsMap = new LinkedHashMap<String, List<String>>();
    private ResultHostTreeObject m_root = null;

    public ResultHostManager(List<String> hosts) {
        this.init(hosts);
        this.createRoot();
    }

    public void init(List<String> hosts) {
        if (hosts == null) {
            return;
        }
        ArrayList<String> aliasList = null;
        this.m_headers.clear();
        this.m_hostsMap.clear();
        LinkedList<String> comments = new LinkedList<String>();
        int i = 0;
        while (i < hosts.size()) {
            String line = hosts.get(i);
            if (line.trim().startsWith("#") || line.trim().length() == 0) {
                comments.add(line);
            } else {
                String resultHost = null;
                aliasList = new ArrayList<String>();
                StrUtils su = new StrUtils();
                String[] split = su.processQuoted(line);
                if (split.length > 0) {
                    resultHost = su.removeQuotes(split[0]);
                    int ii = 1;
                    while (ii < split.length) {
                        aliasList.add(su.removeQuotes(split[ii]));
                        ++ii;
                    }
                }
                if (aliasList.size() == 0) {
                    aliasList.add("");
                }
                this.m_hostsMap.put(resultHost, aliasList);
                this.m_headers.put(resultHost, comments);
                comments = new LinkedList();
            }
            ++i;
        }
        this.m_headers.put("", comments);
    }

    public ResultHostTreeObject createRoot() {
        this.m_root = new ResultHostTreeObject(null, ResultHostTreeObject.ROOT, "");
        for (String resultHost : this.m_hostsMap.keySet()) {
            List<String> alias = this.m_hostsMap.get(resultHost);
            this.m_root.addHost(resultHost);
            ResultHostTreeObject hostObj = this.m_root.getHost(resultHost);
            int i = 0;
            while (i < alias.size()) {
                hostObj.addAlias(alias.get(i));
                ++i;
            }
        }
        return this.m_root;
    }

    public void reset(List<String> hosts) {
        this.init(hosts);
        this.createRoot();
    }

    public ResultHostTreeObject getRoot() {
        return this.m_root;
    }

    public void addHost(String hostName, List<String> alias) {
        this.m_hostsMap.put(hostName, alias);
        this.createRoot();
    }

    public void removeHost(String hostName) {
        if (this.m_hostsMap.containsKey(hostName)) {
            this.m_hostsMap.remove(hostName);
            this.createRoot();
        }
    }

    public void removeHosts(List<ResultHostTreeObject> hosts) {
        boolean changed = false;
        for (ResultHostTreeObject host : hosts) {
            String hostName = host.getHostName();
            if (!this.m_hostsMap.containsKey(hostName)) continue;
            this.m_hostsMap.remove(hostName);
            changed = true;
        }
        if (changed) {
            this.createRoot();
        }
    }

    public void updateHost(String hostNameOld, String hostName, List<String> alias) {
        this.removeHost(hostNameOld);
        this.m_hostsMap.put(hostName, alias);
        this.m_headers.put(hostName, this.m_headers.get(hostNameOld));
        this.createRoot();
    }

    public void addAlias(String hostName, String alias) {
        List<String> al = this.m_hostsMap.get(hostName);
        al.add(alias);
        this.m_hostsMap.put(hostName, al);
        this.createRoot();
    }

    public void editAlias(String hostName, String alias_old, String alias_new) {
        boolean changed = false;
        List<String> al = this.m_hostsMap.get(hostName);
        int i = 0;
        while (i < al.size()) {
            String aliasExist = al.get(i);
            if (aliasExist.equals(alias_old)) {
                al.remove(i);
                al.add(i, alias_new);
                changed = true;
                break;
            }
            ++i;
        }
        if (changed) {
            this.createRoot();
        }
    }

    public boolean deleteAliases(String hostName, List<String> aliases) {
        boolean changed = false;
        int i = 0;
        while (i < aliases.size()) {
            String alias2Del = aliases.get(i);
            if (this.deleteAliasIfExist(hostName, alias2Del)) {
                changed = true;
            }
            ++i;
        }
        if (changed) {
            this.createRoot();
        }
        return changed;
    }

    private boolean deleteAliasIfExist(String hostName, String alias) {
        boolean deleted = false;
        List<String> al = this.m_hostsMap.get(hostName);
        Iterator<String> it = al.iterator();
        while (it.hasNext()) {
            String aliasExist = it.next();
            if (!alias.equals(aliasExist)) continue;
            it.remove();
            deleted = true;
            break;
        }
        return deleted;
    }

    public List<String> getHosts() {
        Pattern spacesIn = Pattern.compile(".*[\\s\"]+.*");
        StringBuffer sb = null;
        ArrayList<String> hostList = new ArrayList<String>();
        for (String resultHost : this.m_hostsMap.keySet()) {
            List<String> comments = this.m_headers.get(resultHost);
            if (comments != null && comments.size() > 0) {
                for (String comment : comments) {
                    hostList.add(comment);
                }
            }
            sb = new StringBuffer();
            sb.append(resultHost);
            List<String> alias = this.m_hostsMap.get(resultHost);
            int i = 0;
            while (i < alias.size()) {
                String aliasStr = alias.get(i);
                Matcher m = spacesIn.matcher(aliasStr);
                if (m.matches()) {
                    sb.append(" ").append('\"').append(aliasStr).append('\"');
                } else {
                    sb.append(" ").append(aliasStr);
                }
                ++i;
            }
            hostList.add(sb.toString());
        }
        List<String> comments = this.m_headers.get("");
        HashMap<String, List<String>> commentsFromDeletedHosts = new HashMap<String, List<String>>(this.m_headers);
        commentsFromDeletedHosts.keySet().removeAll(this.m_hostsMap.keySet());
        for (Map.Entry en : commentsFromDeletedHosts.entrySet()) {
            comments.addAll((Collection)en.getValue());
            comments.add("");
        }
        if (comments != null && comments.size() > 0) {
            hostList.addAll(0, comments);
        }
        return hostList;
    }

    public Object[] getChildren(Object parentElement) {
        return ((ResultHostTreeObject)parentElement).getAliases().toArray();
    }

    public Object getParent(Object element) {
        if (element == null) {
            return null;
        }
        return ((ResultHostTreeObject)element).getParent();
    }

    public boolean hasChildren(Object element) {
        return ((ResultHostTreeObject)element).getAliases().size() > 0;
    }

    public Object[] getElements(Object inputElement) {
        return ((ResultHostTreeObject)inputElement).getAliasesRecursive().toArray();
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public void update(ViewerCell cell) {
        Object element = cell.getElement();
        if (element instanceof ResultHostTreeObject) {
            ResultHostTreeObject host = (ResultHostTreeObject)element;
            int colIndex = cell.getColumnIndex();
            String text = "";
            switch (colIndex) {
                case 0: {
                    text = host.getHostName();
                    if (host.isHost()) {
                        cell.setText(text);
                        cell.setBackground(BMUI.color_lightGrey);
                        break;
                    }
                    cell.setText(text);
                    break;
                }
                case 2: {
                    if (host.isHost()) {
                        cell.setBackground(BMUI.color_lightGrey);
                        break;
                    }
                    if (!host.isAlias()) break;
                    cell.setText(host.getAgentID());
                    break;
                }
                case 1: {
                    if (host.isHost()) {
                        cell.setBackground(BMUI.color_lightGrey);
                        break;
                    }
                    if (!host.isAlias()) break;
                    cell.setText(host.getAliasName());
                    break;
                }
                case 3: {
                    List<String> list = this.m_headers.get(host.getHostName());
                    if (list == null) break;
                    StringBuffer sb = new StringBuffer();
                    for (String line : list) {
                        sb.append(line).append('\n');
                    }
                    cell.setText(sb.toString());
                }
            }
        }
        super.update(cell);
    }
}

