/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.views.configuration;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class ResultHostTreeObject {
    private ResultHostTreeObject m_parent;
    private String m_hostName = "";
    private String m_agentID = "";
    private String m_alias = "";
    private int m_type = -1;
    private List<ResultHostTreeObject> m_children = new ArrayList<ResultHostTreeObject>();
    public static int ROOT = -1;
    public static int HOST = 0;
    public static int ALIAS = 1;

    public ResultHostTreeObject(ResultHostTreeObject parent, int type, String name) {
        this.m_parent = parent;
        this.m_type = type;
        switch (this.m_type) {
            case -1: {
                break;
            }
            case 0: {
                this.m_hostName = name;
                break;
            }
            case 1: {
                String[] split = name.split("\\|");
                if (split.length == 1) {
                    this.m_alias = split[0];
                    break;
                }
                if (split.length != 2) break;
                this.m_agentID = split[0];
                this.m_alias = split[1];
            }
        }
    }

    public boolean isRoot() {
        return this.m_type == -1;
    }

    public boolean isHost() {
        return this.m_type == 0;
    }

    public boolean isAlias() {
        return this.m_type == 1;
    }

    public ResultHostTreeObject getParent() {
        return this.m_parent;
    }

    public int getType() {
        return this.m_type;
    }

    public ResultHostTreeObject getHost(String name) {
        for (ResultHostTreeObject host : this.m_children) {
            if (!name.equals(host.getHostName())) continue;
            return host;
        }
        return null;
    }

    public String getHostName() {
        String resultHost = "";
        switch (this.m_type) {
            case -1: {
                break;
            }
            case 0: {
                resultHost = this.m_hostName;
                break;
            }
            case 1: {
                resultHost = this.m_parent.getHostName();
            }
        }
        return resultHost;
    }

    public void setHostName(String name) {
        this.m_hostName = name;
    }

    public void addHost(String name) {
        if (this.m_type == -1) {
            this.m_children.add(new ResultHostTreeObject(this, HOST, name));
        }
    }

    public List<ResultHostTreeObject> getAliases() {
        return this.m_children;
    }

    public List<ResultHostTreeObject> getAliasesRecursive() {
        LinkedList<ResultHostTreeObject> res = new LinkedList<ResultHostTreeObject>();
        if (this.m_children == null || this.m_children.size() == 0) {
            return res;
        }
        for (ResultHostTreeObject hto : this.m_children) {
            if (hto.isAlias()) {
                res.add(hto);
            }
            res.addAll(hto.getAliasesRecursive());
        }
        return res;
    }

    public String getAliasName() {
        return this.m_alias;
    }

    public void addAlias(String fullName) {
        if (this.isHost()) {
            this.m_children.add(new ResultHostTreeObject(this, ALIAS, fullName));
        }
    }

    public void removeAliases(List<ResultHostTreeObject> elements) {
        if (this.isHost()) {
            int i = 0;
            while (i < elements.size()) {
                ResultHostTreeObject mto = elements.get(i);
                if (this.m_children.contains(mto)) {
                    this.m_children.remove(mto);
                }
                ++i;
            }
        }
    }

    public void removeAllAliases() {
        if (this.isHost()) {
            this.m_children.clear();
        }
    }

    public String getAgentID() {
        return this.m_agentID;
    }
}

