/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.views.configuration;

import com.blixx.boom.engine.ActionClient;
import com.blixx.boom.engine.BMUI;
import com.blixx.boom.engine.Repository;
import com.blixx.boom.engine.ServerClient;
import com.blixx.boom.engine.ServerClientBatch;
import com.blixx.boom.gui.utils.GUIDisplayElements;
import com.blixx.boom.gui.views.configuration.ConfigurationView;
import com.blixx.boom.gui.views.configuration.ResultHostAliasDialog;
import com.blixx.boom.gui.views.configuration.ResultHostDialog;
import com.blixx.boom.gui.views.configuration.ResultHostManager;
import com.blixx.boom.gui.views.configuration.ResultHostTreeObject;
import com.blixx.log.RTLogger;
import com.blixx.shared.utils.FileUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IWorkbenchPartSite;

public class ResultHostsTab
extends CTabItem
implements SelectionListener {
    private CTabFolder m_folder = null;
    private TableViewer m_tableViewer = null;
    private ResultHostManager m_hostManager = null;
    private List<String> m_hosts_orig = new ArrayList<String>();
    private List<String> m_hosts = new ArrayList<String>();
    private GUIDisplayElements m_gui = null;
    private Composite m_compositeInCTab = null;
    private ScrolledComposite m_sc = null;
    private Composite m_mainComp = null;
    private Button m_edit_btn = null;
    private Button m_add_btn = null;
    private Button m_delete_btn = null;
    private Button m_save_btn = null;
    private Button m_undo_btn = null;
    private static String EDIT = "EDIT";
    private static String ADD = "ADD";
    private static String DEL = "DEL";
    private static String EDIT_HOST_BTN = "EDIT_HOST_BTN";
    private static String ADD_HOST_BTN = "ADD_HOST_BTN";
    private static String DEL_HOST_BTN = "DELETE_HOST_BTN";
    private static String SAVE_BTN = "SAVE_BTN";
    private static String UNDO_BTN = "UNDO_BTN";
    public static String TAB_NAME = "srv/etc/hosts";
    private String m_serverPath = "srv/etc/hosts";
    private String m_fileName = "hosts";
    private String m_localDir = Repository.getUserTmpDirectory();
    private String m_slaveHostName = null;

    public ResultHostsTab(CTabFolder parent, String slaveOrNull) {
        super(parent, 0, 0);
        this.m_slaveHostName = slaveOrNull;
        if (this.m_slaveHostName != null) {
            this.m_localDir = String.valueOf(this.m_localDir) + File.separator + "ssc" + File.separator + FileUtils.getValidFileName(this.m_slaveHostName);
        }
        this.m_folder = parent;
        if (this.m_slaveHostName != null) {
            this.setText(String.valueOf(TAB_NAME) + '@' + this.m_slaveHostName);
        } else {
            this.setText(TAB_NAME);
        }
        this.setImage(null);
        this.getFileFromServer();
        this.m_hostManager = new ResultHostManager(this.m_hosts);
        this.createMainArea();
    }

    public void createMainArea() {
        this.m_gui = new GUIDisplayElements();
        this.m_compositeInCTab = new Composite((Composite)this.m_folder, 0);
        GridLayout gl = new GridLayout(2, false);
        gl.verticalSpacing = 0;
        gl.horizontalSpacing = 0;
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        this.m_compositeInCTab.setLayout((Layout)gl);
        this.m_sc = new ScrolledComposite(this.m_compositeInCTab, 2816);
        this.m_sc.setAlwaysShowScrollBars(false);
        this.m_sc.setExpandHorizontal(true);
        this.m_sc.setExpandVertical(true);
        this.m_sc.setLayout((Layout)new GridLayout(1, false));
        this.m_sc.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        this.m_mainComp = new Composite((Composite)this.m_sc, 0);
        gl = new GridLayout(1, false);
        gl.marginWidth = 1;
        gl.marginHeight = 1;
        gl.marginBottom = 5;
        gl.verticalSpacing = 1;
        this.m_mainComp.setLayout((Layout)gl);
        this.m_mainComp.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createTable(this.m_mainComp);
        Composite lineComp = new Composite(this.m_compositeInCTab, 0);
        gl = new GridLayout(1, false);
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        lineComp.setLayout((Layout)gl);
        lineComp.setLayoutData((Object)new GridData(4, 128, true, false, 2, 1));
        Label line = new Label(lineComp, 259);
        line.setForeground(BMUI.color_darkGrey2);
        line.setLayoutData((Object)new GridData(4, 128, true, false, 2, 1));
        Composite btnCompLeft = new Composite(this.m_compositeInCTab, 0);
        btnCompLeft.setLayout((Layout)new GridLayout(3, true));
        btnCompLeft.setLayoutData((Object)new GridData(16384, 4, false, false));
        this.m_add_btn = this.m_gui.addButton(btnCompLeft, ADD_HOST_BTN, "&Add Host", true, 90, 30, 0, this);
        this.m_add_btn.setLayoutData((Object)new GridData(4, 128, false, false, 1, 1));
        this.m_edit_btn = this.m_gui.addButton(btnCompLeft, EDIT_HOST_BTN, "&Edit Host", false, 90, 30, 0, this);
        this.m_edit_btn.setLayoutData((Object)new GridData(4, 128, false, false, 1, 1));
        this.m_delete_btn = this.m_gui.addButton(btnCompLeft, DEL_HOST_BTN, "&Delete Host", false, 90, 30, 0, this);
        this.m_delete_btn.setLayoutData((Object)new GridData(4, 128, false, false, 1, 1));
        Composite btnCompRight = new Composite(this.m_compositeInCTab, 0);
        btnCompRight.setLayout((Layout)new GridLayout(2, true));
        btnCompRight.setLayoutData((Object)new GridData(131072, 4, false, false));
        this.m_save_btn = this.m_gui.addButton(btnCompRight, SAVE_BTN, "&Save Configuration", false, 90, 30, 0, this);
        this.m_save_btn.setLayoutData((Object)new GridData(4, 128, false, false, 1, 1));
        this.m_undo_btn = this.m_gui.addButton(btnCompRight, UNDO_BTN, "Reload", true, 90, 30, 0, this);
        this.m_undo_btn.setLayoutData((Object)new GridData(4, 128, false, false, 1, 1));
        this.m_sc.setContent((Control)this.m_mainComp);
        this.m_sc.setMinSize(this.m_mainComp.computeSize(-1, -1, true));
        this.setControl((Control)this.m_compositeInCTab);
    }

    private void createTable(Composite parentComp) {
        Table table = new Table(parentComp, 268503042);
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        table.setLayout((Layout)new GridLayout());
        table.setLayoutData((Object)new GridData(4, 4, true, true));
        TableColumn col0 = new TableColumn(table, 0);
        col0.setWidth(200);
        col0.setMoveable(false);
        col0.setText("Result Host");
        TableColumn col2 = new TableColumn(table, 0);
        col2.setWidth(200);
        col2.setMoveable(false);
        col2.setText("Incoming Host Alias");
        TableColumn col1 = new TableColumn(table, 0);
        col1.setWidth(200);
        col1.setMoveable(false);
        col1.setText("Agent ID (optional)");
        TableColumn col3 = new TableColumn(table, 0);
        col3.setWidth(200);
        col3.setMoveable(false);
        col3.setText("Comments");
        this.m_tableViewer = new TableViewer(table);
        this.m_tableViewer.setLabelProvider((IBaseLabelProvider)this.m_hostManager);
        this.m_tableViewer.setContentProvider((IContentProvider)this.m_hostManager);
        this.m_tableViewer.setInput((Object)this.m_hostManager.getRoot());
        this.m_tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                StructuredSelection ssel = (StructuredSelection)ResultHostsTab.this.m_tableViewer.getSelection();
                ResultHostsTab.this.m_gui.enableField(ResultHostsTab.this.m_delete_btn, !ssel.isEmpty());
                ResultHostsTab.this.m_gui.enableField(ResultHostsTab.this.m_edit_btn, !ssel.isEmpty());
            }
        });
        final ResultHostsTab tabThis = this;
        table.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent event) {
                Point point;
                Tree tree;
                TreeItem item;
                Object obj = event.getSource();
                if (obj instanceof Tree && (item = (tree = (Tree)obj).getItem(point = new Point(event.x, event.y))) == null) {
                    tabThis.deselectAll();
                }
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
        this.m_tableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                TableViewer tv;
                Object o;
                Object obj = event.getSource();
                if (obj instanceof TableViewer && (o = ((StructuredSelection)(tv = (TableViewer)obj).getSelection()).getFirstElement()) instanceof ResultHostTreeObject) {
                    ProccessHostAction editHost = new ProccessHostAction(tabThis, EDIT);
                    editHost.run();
                }
            }
        });
        this.createContentMenu();
    }

    public void createContentMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        Menu menu = menuMgr.createContextMenu(this.m_tableViewer.getControl());
        this.m_tableViewer.getControl().setMenu(menu);
        IWorkbenchPartSite site = ConfigurationView.getInstance().getSite();
        site.registerContextMenu(menuMgr, (ISelectionProvider)this.m_tableViewer);
        final ResultHostsTab tabThis = this;
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                try {
                    manager.add((IAction)new RefreshAction(tabThis));
                    manager.add((IContributionItem)new Separator());
                    manager.add((IAction)new ProccessHostAction(tabThis, ADD));
                    manager.add((IAction)new ProccessHostAction(tabThis, EDIT));
                    manager.add((IAction)new ProccessHostAction(tabThis, DEL));
                    manager.add((IContributionItem)new Separator());
                    manager.add((IAction)new ProccessAliasAction((Viewer)ResultHostsTab.this.m_tableViewer, ADD));
                    manager.add((IAction)new ProccessAliasAction((Viewer)ResultHostsTab.this.m_tableViewer, EDIT));
                    manager.add((IAction)new ProccessAliasAction((Viewer)ResultHostsTab.this.m_tableViewer, DEL));
                }
                catch (RuntimeException e) {
                    RTLogger.print(5, "", e);
                }
            }
        });
    }

    private void refreshTab() {
        this.m_tableViewer.setInput((Object)this.m_hostManager.getRoot());
    }

    private void deselectAll() {
        this.m_tableViewer.getTable().deselectAll();
        this.m_gui.enableField(this.m_edit_btn, false);
        this.m_gui.enableField(this.m_delete_btn, false);
    }

    private void enableButtons(boolean enable) {
        this.m_gui.enableField(this.m_save_btn, enable);
        if (enable && !this.getText().endsWith("*")) {
            this.setText(String.valueOf(this.getText()) + " *");
        } else if (!enable && this.getText().endsWith("*")) {
            this.setText(this.getText().substring(0, this.getText().length() - 2));
        }
    }

    private void undo() {
        this.getFileFromServer();
        this.m_hostManager.reset(this.m_hosts_orig);
        this.refreshTab();
        this.enableButtons(false);
    }

    private void save() {
        block29: {
            String localPath = this.getTempFilePath();
            File file = new File(localPath);
            if (file.exists()) {
                try {
                    file.delete();
                }
                catch (Exception exception) {
                    RTLogger.print(4, "cannot delete file " + localPath);
                    return;
                }
            }
            try {
                file.createNewFile();
            }
            catch (IOException iOException) {
                RTLogger.print(4, "cannot create file " + localPath);
                return;
            }
            FileWriter fw = null;
            BufferedWriter out = null;
            try {
                try {
                    ActionClient ac;
                    fw = new FileWriter(file);
                    out = new BufferedWriter(fw);
                    ArrayList<String> lines = new ArrayList<String>();
                    lines.addAll(this.m_hostManager.getHosts());
                    for (String line : lines) {
                        out.write(String.valueOf(line) + "\n");
                    }
                    try {
                        out.close();
                    }
                    catch (Throwable throwable) {}
                    try {
                        fw.close();
                    }
                    catch (Throwable throwable) {}
                    this.putFileToServer(file, localPath);
                    if (this.m_slaveHostName == null) {
                        ac = new ActionClient("RemoteAction", "RELOAD_HOSTS", "BOOM_SERVER", 30, null, null);
                        ac.schedule(0L);
                    } else {
                        ac = new ActionClient("RemoteAction", "RELOAD_HOSTS (BS:" + this.m_slaveHostName + ")", "BOOM_SERVER", 30, null, null);
                        ac.schedule(0L);
                    }
                    this.enableButtons(false);
                }
                catch (IOException e) {
                    RTLogger.print(4, "Cannot write to file " + localPath, e);
                    try {
                        out.close();
                    }
                    catch (Throwable throwable) {}
                    try {
                        fw.close();
                    }
                    catch (Throwable throwable) {}
                    break block29;
                }
            }
            catch (Throwable throwable) {
                try {
                    out.close();
                }
                catch (Throwable throwable2) {}
                try {
                    fw.close();
                }
                catch (Throwable throwable3) {}
                throw throwable;
            }
            try {
                out.close();
            }
            catch (Throwable throwable) {}
            try {
                fw.close();
            }
            catch (Throwable throwable) {}
        }
    }

    /*
     * Loose catch block
     */
    private void getFileFromServer() {
        block48: {
            ServerClientBatch scb = null;
            InputStreamReader fr = null;
            BufferedReader br = null;
            try {
                scb = new ServerClientBatch("GETFILE");
                scb.openSocket();
                if (this.m_slaveHostName == null) {
                    scb.setCommand("GETFILE", null, new String[]{this.m_serverPath, BMUI.type_file, this.getTempDir()});
                } else {
                    scb.setCommand("GETFILE_SLAVE", null, new String[]{this.m_serverPath, BMUI.type_file, this.m_slaveHostName, this.getTempDir()});
                }
                Object res = scb.runBatch();
                if (scb.isSuccess() && res != null) {
                    File file = new File(this.getTempFilePath());
                    if (!file.exists()) {
                        RTLogger.print(5, "file tmp/hosts does not exist");
                    } else if (!file.canRead()) {
                        RTLogger.print(5, "Cannot read file tmp/hosts");
                    } else {
                        this.m_hosts_orig.clear();
                        this.m_hosts.clear();
                        fr = new FileReader(file);
                        br = new BufferedReader(fr);
                        boolean eof = false;
                        while (!eof) {
                            String line = br.readLine();
                            if (line != null) {
                                if (line.length() == 0) continue;
                                this.m_hosts_orig.add(line);
                                this.m_hosts.add(line);
                                continue;
                            }
                            eof = true;
                        }
                    }
                } else {
                    RTLogger.print(5, "Error getting file from server");
                }
            }
            catch (RuntimeException e) {
                RTLogger.print(4, "Error loading file " + this.m_fileName, e);
                try {
                    scb.close();
                }
                catch (Throwable throwable) {}
                try {
                    br.close();
                }
                catch (Throwable throwable) {}
                try {
                    fr.close();
                }
                catch (Throwable throwable) {}
                break block48;
            }
            catch (FileNotFoundException e) {
                RTLogger.print(4, "file not found " + this.m_fileName, e);
                try {
                    scb.close();
                }
                catch (Throwable throwable) {}
                try {
                    br.close();
                }
                catch (Throwable throwable) {}
                try {
                    fr.close();
                }
                catch (Throwable throwable) {}
                break block48;
            }
            catch (IOException e) {
                RTLogger.print(4, "IO error loading file " + this.m_fileName, e);
                {
                    catch (Throwable throwable) {
                        try {
                            scb.close();
                        }
                        catch (Throwable throwable2) {}
                        try {
                            br.close();
                        }
                        catch (Throwable throwable3) {}
                        try {
                            fr.close();
                        }
                        catch (Throwable throwable4) {}
                        throw throwable;
                    }
                }
                try {
                    scb.close();
                }
                catch (Throwable throwable) {}
                try {
                    br.close();
                }
                catch (Throwable throwable) {}
                try {
                    fr.close();
                }
                catch (Throwable throwable) {}
                break block48;
            }
            try {
                scb.close();
            }
            catch (Throwable throwable) {}
            try {
                br.close();
            }
            catch (Throwable throwable) {}
            try {
                fr.close();
            }
            catch (Throwable throwable) {}
        }
    }

    private void putFileToServer(File file, String localPath) {
        block9: {
            if (this.m_slaveHostName == null) {
                ServerClient sc = null;
                try {
                    sc = new ServerClient("PUT_FILE", this.m_serverPath, new String[]{localPath});
                    sc.run();
                    if (sc.isSuccess()) {
                        RTLogger.print(5, "Uploading local File " + localPath + " to " + this.m_serverPath);
                        break block9;
                    }
                    RTLogger.print(5, "Error uploading local File " + localPath + " to " + this.m_serverPath);
                }
                catch (RuntimeException e) {
                    RTLogger.print(5, "Error uploading local File " + localPath + " to " + this.m_serverPath, e);
                }
            } else {
                ServerClient sc = null;
                try {
                    sc = new ServerClient("PUT_FILE_SLAVE", this.m_serverPath, new String[]{localPath, this.m_slaveHostName});
                    sc.run();
                    if (sc.isSuccess()) {
                        RTLogger.print(5, "Uploading local File " + localPath + " to " + this.m_serverPath);
                    } else {
                        RTLogger.print(5, "Error uploading local File " + localPath + " to " + this.m_serverPath);
                    }
                }
                catch (RuntimeException e) {
                    RTLogger.print(5, "Error uploading local File " + localPath + " to " + this.m_serverPath, e);
                }
            }
        }
    }

    public ResultHostManager getHostManager() {
        return this.m_hostManager;
    }

    public TableViewer getTreeViewer() {
        return this.m_tableViewer;
    }

    public void dispose() {
        super.dispose();
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        String name = "";
        if (e.getSource() instanceof Button) {
            Button b = (Button)e.getSource();
            name = (String)b.getData();
            if (name.equalsIgnoreCase(EDIT_HOST_BTN)) {
                ProccessHostAction action = new ProccessHostAction(this, EDIT);
                action.run();
            } else if (name.equalsIgnoreCase(ADD_HOST_BTN)) {
                ProccessHostAction action = new ProccessHostAction(this, ADD);
                action.run();
            } else if (name.equalsIgnoreCase(DEL_HOST_BTN)) {
                ProccessHostAction action = new ProccessHostAction(this, DEL);
                action.run();
            } else if (name.equalsIgnoreCase(SAVE_BTN)) {
                b.setEnabled(false);
                try {
                    try {
                        this.save();
                    }
                    catch (Throwable throwable) {
                        b.setEnabled(true);
                    }
                }
                finally {
                    b.setEnabled(true);
                }
            } else if (name.equalsIgnoreCase(UNDO_BTN)) {
                b.setEnabled(false);
                try {
                    try {
                        this.undo();
                    }
                    catch (Throwable throwable) {
                        b.setEnabled(true);
                    }
                }
                finally {
                    b.setEnabled(true);
                }
            }
        }
    }

    public String getTempFilePath() {
        return String.valueOf(this.getTempDir()) + this.m_fileName;
    }

    public String getTempDir() {
        return String.valueOf(this.m_localDir) + File.separator;
    }

    public class ProccessAliasAction
    extends Action {
        private String m_type;
        private Viewer m_tv;
        private ResultHostTreeObject m_host;
        private List<ResultHostTreeObject> m_elements;

        public ProccessAliasAction(Viewer treeViewer, String type) {
            Object o;
            super("proccessaliasaction");
            this.m_type = null;
            this.m_tv = null;
            this.m_host = null;
            this.m_elements = new ArrayList<ResultHostTreeObject>();
            this.setId("proccessaliasaction");
            this.setText("Proccess Alias");
            this.m_tv = treeViewer;
            this.m_type = type;
            if (this.m_tv == null || this.m_type == null) {
                this.setEnabled(false);
                return;
            }
            this.setTitle();
            if (Repository.getInstance().getRights(2004) < 3 || this.m_tv == null) {
                this.setEnabled(false);
                return;
            }
            StructuredSelection ssel = (StructuredSelection)ResultHostsTab.this.getTreeViewer().getSelection();
            if (this.m_type.equals(EDIT)) {
                ResultHostTreeObject mto;
                Object obj;
                if (!ssel.isEmpty() && ssel.size() == 1 && (obj = ssel.getFirstElement()) instanceof ResultHostTreeObject && (mto = (ResultHostTreeObject)obj).isAlias()) {
                    this.m_host = mto.getParent();
                    this.m_elements.add(mto);
                }
            } else if (this.m_type.equals(DEL)) {
                if (!ssel.isEmpty()) {
                    for (Object obj : ssel) {
                        ResultHostTreeObject mto;
                        if (!(obj instanceof ResultHostTreeObject) || !(mto = (ResultHostTreeObject)obj).isAlias()) continue;
                        if (this.m_host != null && !this.m_host.equals(mto.getParent())) {
                            this.setEnabled(false);
                            return;
                        }
                        this.m_host = mto.getParent();
                        this.m_elements.add(mto);
                    }
                }
            } else if (this.m_type.equals(ADD) && !ssel.isEmpty() && (o = ssel.getFirstElement()) instanceof ResultHostTreeObject) {
                ResultHostTreeObject mto = (ResultHostTreeObject)o;
                if (mto.isHost()) {
                    this.m_host = mto;
                } else if (mto.isAlias()) {
                    this.m_host = mto.getParent();
                }
            }
            if (this.m_type.equals(ADD)) {
                if (this.m_host == null) {
                    this.setEnabled(false);
                    return;
                }
            } else if (this.m_host == null || this.m_elements.size() == 0) {
                this.setEnabled(false);
                return;
            }
        }

        public void run() {
            if (this.m_type.equals(EDIT)) {
                ResultHostAliasDialog dialog = new ResultHostAliasDialog(ResultHostAliasDialog.EDIT, this.m_elements.get(0));
                dialog.setBlockOnOpen(true);
                int value = dialog.open();
                if (value == 0) {
                    List<String> alias = dialog.getResult();
                    StringBuffer alias_new = new StringBuffer();
                    if (alias.get(0) != null && alias.get(0).length() > 0) {
                        alias_new.append(alias.get(0)).append('|').append(alias.get(1));
                    } else {
                        alias_new.append(alias.get(1));
                    }
                    ResultHostTreeObject mto = this.m_elements.get(0);
                    StringBuffer alias_old = new StringBuffer();
                    if (mto.getAgentID() != null && mto.getAgentID().length() > 0) {
                        alias_old.append(mto.getAgentID()).append('|').append(mto.getAliasName());
                    } else {
                        alias_old.append(mto.getAliasName());
                    }
                    ResultHostsTab.this.getHostManager().editAlias(this.m_host.getHostName(), alias_old.toString(), alias_new.toString());
                    ResultHostsTab.this.refreshTab();
                    ResultHostsTab.this.enableButtons(true);
                }
            } else if (this.m_type.equals(DEL)) {
                ArrayList<String> aliases = new ArrayList<String>();
                StringBuffer sb = null;
                int i = 0;
                while (i < this.m_elements.size()) {
                    ResultHostTreeObject mto = this.m_elements.get(i);
                    sb = new StringBuffer();
                    if (mto.getAgentID() != null && mto.getAgentID().length() > 0) {
                        sb.append(mto.getAgentID()).append('|').append(mto.getAliasName());
                    } else {
                        sb.append(mto.getAliasName());
                    }
                    aliases.add(sb.toString());
                    ++i;
                }
                if (ResultHostsTab.this.getHostManager().deleteAliases(this.m_host.getHostName(), aliases)) {
                    ResultHostsTab.this.refreshTab();
                    ResultHostsTab.this.enableButtons(true);
                }
            } else if (this.m_type.equals(ADD)) {
                ResultHostAliasDialog dialog = new ResultHostAliasDialog(ResultHostAliasDialog.ADD, null);
                dialog.setBlockOnOpen(true);
                int value = dialog.open();
                if (value == 0) {
                    List<String> alias = dialog.getResult();
                    StringBuffer sb = new StringBuffer();
                    if (alias.get(0) != null && alias.get(0).length() > 0) {
                        sb.append(alias.get(0)).append('|').append(alias.get(1));
                    } else {
                        sb.append(alias.get(1));
                    }
                    ResultHostsTab.this.getHostManager().addAlias(this.m_host.getHostName(), sb.toString());
                    ResultHostsTab.this.refreshTab();
                    ResultHostsTab.this.enableButtons(true);
                }
            }
        }

        private void setTitle() {
            if (this.m_type.equals(EDIT)) {
                this.setText("Edit Alias");
            } else if (this.m_type.equals(DEL)) {
                this.setText("Delete Alias");
            } else if (this.m_type.equals(ADD)) {
                this.setText("Add Alias");
            }
        }
    }

    public class ProccessHostAction
    extends Action {
        private ResultHostsTab m_tab;
        private String m_type;
        private List<ResultHostTreeObject> m_elements;

        public ProccessHostAction(ResultHostsTab tab, String type) {
            super("proccesshostaction");
            this.m_tab = null;
            this.m_type = null;
            this.m_elements = new ArrayList<ResultHostTreeObject>();
            this.setId("proccesshostaction");
            this.setText("Proccess Host");
            this.m_tab = tab;
            this.m_type = type;
            if (this.m_tab == null || this.m_type == null) {
                this.setEnabled(false);
                return;
            }
            this.setTitle();
            if (Repository.getInstance().getRights(2004) < 3) {
                this.setEnabled(false);
                return;
            }
            StructuredSelection ssel = (StructuredSelection)this.m_tab.getTreeViewer().getSelection();
            if (this.m_type.equals(EDIT)) {
                Object obj;
                if (!ssel.isEmpty() && ssel.size() == 1 && (obj = ssel.getFirstElement()) instanceof ResultHostTreeObject) {
                    ResultHostTreeObject mto = (ResultHostTreeObject)obj;
                    if (mto.isHost()) {
                        this.m_elements.add(mto);
                    } else if (mto.isAlias()) {
                        this.m_elements.add(mto.getParent());
                    }
                }
            } else if (this.m_type.equals(DEL)) {
                if (!ssel.isEmpty()) {
                    for (Object obj : ssel) {
                        if (!(obj instanceof ResultHostTreeObject)) continue;
                        ResultHostTreeObject mto = (ResultHostTreeObject)obj;
                        if (mto.isHost()) {
                            this.m_elements.add(mto);
                            continue;
                        }
                        if (!mto.isAlias()) continue;
                        this.m_elements.add(mto.getParent());
                    }
                }
            } else {
                this.m_type.equals(ADD);
            }
            if (this.m_elements.size() == 0 && !this.m_type.equals(ADD)) {
                this.setEnabled(false);
                return;
            }
        }

        public void run() {
            if (this.m_type.equals(EDIT)) {
                ResultHostTreeObject hostObj = this.m_elements.get(0);
                String hostNameOld = hostObj.getHostName();
                ResultHostDialog dialog = new ResultHostDialog(ResultHostDialog.EDIT, hostObj);
                dialog.setBlockOnOpen(true);
                int value = dialog.open();
                if (value == 0) {
                    this.m_tab.getHostManager().updateHost(hostNameOld, dialog.getHostName(), dialog.getAliases());
                    ResultHostsTab.this.refreshTab();
                    ResultHostsTab.this.enableButtons(true);
                }
            } else if (this.m_type.equals(DEL)) {
                this.m_tab.getHostManager().removeHosts(this.m_elements);
                ResultHostsTab.this.refreshTab();
                ResultHostsTab.this.enableButtons(true);
            } else if (this.m_type.equals(ADD)) {
                ResultHostDialog dialog = new ResultHostDialog(this.m_type, null);
                dialog.setBlockOnOpen(true);
                int value = dialog.open();
                if (value == 0) {
                    this.m_tab.getHostManager().addHost(dialog.getHostName(), dialog.getAliases());
                    ResultHostsTab.this.refreshTab();
                    ResultHostsTab.this.enableButtons(true);
                }
            }
        }

        private void setTitle() {
            if (this.m_type.equals(EDIT)) {
                this.setText("Edit Host");
            } else if (this.m_type.equals(DEL)) {
                this.setText("Delete Host");
            } else if (this.m_type.equals(ADD)) {
                this.setText("Add Host");
            }
        }
    }

    public class RefreshAction
    extends Action {
        private ResultHostsTab m_tab;

        public RefreshAction(ResultHostsTab tab) {
            super("refreshaction");
            this.m_tab = null;
            this.setText("Refresh");
            this.setId("refreshaction");
            this.setImageDescriptor(BMUI.IMAGE_DESCR_REFRESH);
            this.m_tab = tab;
        }

        public void run() {
            this.m_tab.refreshTab();
        }
    }
}

