/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.views.configuration;

import com.blixx.boom.engine.AgentCard;
import com.blixx.boom.engine.BMUI;
import com.blixx.boom.engine.JobManager;
import com.blixx.boom.engine.Repository;
import com.blixx.boom.engine.UIJob;
import com.blixx.boom.engine.UIJobManager;
import com.blixx.boom.gui.Activator;
import com.blixx.boom.gui.dialogs.AgentTreeDialog;
import com.blixx.boom.gui.dialogs.ShowMessageBox;
import com.blixx.boom.gui.dialogs.ShowSimpleDialog;
import com.blixx.boom.gui.dialogs.SnmpV3ImportUserDialog;
import com.blixx.boom.gui.utils.GUIDisplayElements;
import com.blixx.boom.gui.views.FancyToolTipSupport;
import com.blixx.boom.gui.views.configuration.ConfigurationView;
import com.blixx.ctrl.sc.ICmdPostProcess;
import com.blixx.ctrl.sc.ServerClient;
import com.blixx.ctrl.sc.in.ScGetSNMPV3Users;
import com.blixx.ctrl.sc.in.ScSetSNMPV3Users;
import com.blixx.log.RTLogger;
import com.blixx.shared.Cryptor;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbenchPartSite;

public class SnmpV3Tab
extends CTabItem
implements SelectionListener,
MouseListener {
    public static final String VIEW_TITLE = "SNMP v3 Users";
    public static final String COMMENT = "comment";
    public static final String PRIV_EN_PASS = "privEnPass";
    public static final String PRIV_PASS = "privPass";
    public static final String PRIV_TYPE = "privType";
    public static final String AUTH_EN_PASS = "authEnPass";
    public static final String AUTH_PASS = "authPass";
    public static final String AUTH_TYPE = "authType";
    public static final String ENGINE_ID = "engineID";
    public static final String USER = "user";
    public static final String NONE = "none";
    public static final String[] comboAuth = new String[]{"MD5", "SHA", "HMAC192SHA256", "HMAC384SHA512", "none"};
    public static final String[] comboPriv = new String[]{"DES", "3DES", "AES", "AES128", "AES192", "AES256", "AES192p", "AES256p", "none"};
    public static List<String> auTypes_accepted = new ArrayList<String>(Arrays.asList("MD5", "SHA", "HMAC192SHA256", "HMAC384SHA512", ""));
    public static List<String> prTypes_accepted = new ArrayList<String>(Arrays.asList("DES", "3DES", "AES", "AES128", "AES192", "AES256", "AES192p", "AES256p", ""));
    private int authType_NONE = 4;
    private int privType_NONE = 8;
    private CTabFolder m_parent = null;
    private boolean m_isDirty = false;
    private boolean m_isReadOnly = false;
    private GUIDisplayElements m_gui = null;
    private Composite m_compositeInCTab = null;
    private ScrolledComposite m_sc = null;
    private TableViewer m_tableViewer = null;
    private ContentAndLabelProvider m_tableProvider = null;
    private JsonArray m_snmpUsers = null;
    private Button m_save_btn = null;
    private Button m_add_btn = null;
    private Button m_edit_btn = null;
    private Button m_dup_btn = null;
    private Button m_del_btn = null;
    private Button m_reload_btn = null;
    private Button m_undo_btn = null;
    private Button m_import_btn = null;
    private static String SAVE = "SAVE";
    private static String UNDO = "UNDO";
    private static String RELOAD = "RELOAD";
    private static String ADD = "ADD";
    private static String DELETE = "DELETE";
    private static String DUPLICATE = "DUPLICATE";
    private static String EDIT = "EDIT";
    private static String IMPORT = "IMPORT";
    public static final String ANY_AGENT_STAR = "*";
    public static final String ANY_AGENT = "Any Agent";
    protected static final String APPLY_FILTER = "APPLY_FILTER";
    protected static final String REMOVE_FILTER = "REMOVE_FILTER";
    private Text m_searchText = null;
    private Label m_searchIcon = null;
    private ISharedImages m_sharedImages = Activator.getDefault().getWorkbench().getActiveWorkbenchWindow().getWorkbench().getSharedImages();
    public Listener sortListener = new Listener(){

        public void handleEvent(Event e) {
            if (e.type == 13) {
                TableColumn sortColumn = SnmpV3Tab.this.m_tableViewer.getTable().getSortColumn();
                TableColumn currentColumn = (TableColumn)e.widget;
                int dir = SnmpV3Tab.this.m_tableViewer.getTable().getSortDirection();
                if (sortColumn == currentColumn) {
                    dir = dir == 128 ? 1024 : 128;
                } else {
                    SnmpV3Tab.this.m_tableViewer.getTable().setSortColumn(currentColumn);
                    dir = 128;
                }
                SnmpV3Tab.this.m_tableViewer.getTable().setSortDirection(dir);
                SnmpV3Tab.this.m_tableViewer.refresh(true);
            }
        }
    };

    public SnmpV3Tab(CTabFolder parent, int style) {
        super(parent, style);
        this.setText(VIEW_TITLE);
        this.m_parent = parent;
        this.m_gui = new GUIDisplayElements();
        this.loadFromServer();
        this.createMainArea();
    }

    public void createMainArea() {
        if (this.m_compositeInCTab != null && !this.m_compositeInCTab.isDisposed()) {
            Control[] controls = this.m_compositeInCTab.getChildren();
            int i = 0;
            while (i < controls.length) {
                controls[i].dispose();
                ++i;
            }
        } else {
            this.m_compositeInCTab = new Composite((Composite)this.m_parent, 0);
            GridLayout gl = new GridLayout(3, false);
            gl.verticalSpacing = 0;
            gl.horizontalSpacing = 0;
            gl.marginWidth = 0;
            gl.marginHeight = 0;
            this.m_compositeInCTab.setLayout((Layout)gl);
        }
        if (this.m_snmpUsers == null) {
            Text error = this.m_gui.addTextReadOnlyNoBorder(this.m_compositeInCTab, null, "Error getting snmp users from the server!", 3, 1, 10, 20, null);
            error.setForeground(BMUI.color_critical);
            this.m_reload_btn = this.m_gui.addButton(this.m_compositeInCTab, RELOAD, " Reload from Server ", true, 80, 20, 15, this);
            ((GridData)this.m_reload_btn.getLayoutData()).horizontalAlignment = 16384;
            ((GridData)this.m_reload_btn.getLayoutData()).horizontalIndent = 10;
            this.m_reload_btn.setImage(BMUI.IMAGE_REFRESH);
        } else {
            this.createFilterSection(this.m_compositeInCTab);
            this.m_sc = new ScrolledComposite(this.m_compositeInCTab, 2816);
            this.m_sc.setAlwaysShowScrollBars(false);
            this.m_sc.setExpandHorizontal(true);
            this.m_sc.setExpandVertical(true);
            this.m_sc.setLayout((Layout)new GridLayout(1, false));
            this.m_sc.setLayoutData((Object)new GridData(4, 4, true, true, 3, 1));
            Composite tblComp = new Composite((Composite)this.m_sc, 0);
            GridLayout gl = new GridLayout(1, false);
            gl.marginWidth = 0;
            gl.marginHeight = 0;
            tblComp.setLayout((Layout)gl);
            tblComp.setLayoutData((Object)new GridData(4, 128, true, false));
            try {
                this.createTable(tblComp);
            }
            catch (Exception e) {
                RTLogger.print(1, "Error creating table. Input: " + this.m_snmpUsers, e);
            }
            if (!this.m_isReadOnly) {
                Composite btnComp1 = new Composite(this.m_compositeInCTab, 0);
                btnComp1.setLayoutData((Object)new GridData(16384, 4, false, false));
                gl = new GridLayout(4, true);
                gl.horizontalSpacing = 3;
                btnComp1.setLayout((Layout)gl);
                this.m_save_btn = this.m_gui.addButton(btnComp1, SAVE, "Save ", false, 60, 10, 0, this);
                ((GridData)this.m_save_btn.getLayoutData()).horizontalAlignment = 4;
                ((GridData)this.m_save_btn.getLayoutData()).grabExcessHorizontalSpace = true;
                this.m_save_btn.setImage(this.m_sharedImages.getImage("IMG_ETOOL_SAVE_EDIT"));
                this.m_undo_btn = this.m_gui.addButton(btnComp1, UNDO, "Undo ", false, 60, 10, 0, this);
                ((GridData)this.m_undo_btn.getLayoutData()).horizontalAlignment = 4;
                ((GridData)this.m_undo_btn.getLayoutData()).grabExcessHorizontalSpace = true;
                this.m_undo_btn.setImage(this.m_sharedImages.getImage("IMG_TOOL_UNDO"));
                this.m_reload_btn = this.m_gui.addButton(btnComp1, RELOAD, "Reload  ", true, 60, 10, 0, this);
                ((GridData)this.m_reload_btn.getLayoutData()).horizontalAlignment = 4;
                ((GridData)this.m_reload_btn.getLayoutData()).grabExcessHorizontalSpace = true;
                this.m_reload_btn.setImage(BMUI.IMAGE_REFRESH);
                this.m_import_btn = this.m_gui.addButton(btnComp1, IMPORT, "Import  ", true, 60, 10, 0, this);
                ((GridData)this.m_import_btn.getLayoutData()).horizontalAlignment = 4;
                ((GridData)this.m_import_btn.getLayoutData()).grabExcessHorizontalSpace = true;
                this.m_import_btn.setImage(BMUI.IMAGE_IMPORT);
                Composite btnComp2 = new Composite(this.m_compositeInCTab, 0);
                btnComp2.setLayoutData((Object)new GridData(16384, 4, false, false));
                gl = new GridLayout(4, true);
                gl.marginLeft = 15;
                gl.horizontalSpacing = 3;
                btnComp2.setLayout((Layout)gl);
                this.m_add_btn = this.m_gui.addButton(btnComp2, ADD, "Add", true, 60, 10, 0, this);
                ((GridData)this.m_add_btn.getLayoutData()).horizontalAlignment = 4;
                ((GridData)this.m_add_btn.getLayoutData()).grabExcessHorizontalSpace = true;
                this.m_add_btn.setImage(this.m_sharedImages.getImage("IMG_OBJ_ADD"));
                this.m_edit_btn = this.m_gui.addButton(btnComp2, EDIT, "Edit", false, 60, 10, 0, this);
                ((GridData)this.m_edit_btn.getLayoutData()).horizontalAlignment = 4;
                ((GridData)this.m_edit_btn.getLayoutData()).grabExcessHorizontalSpace = true;
                this.m_del_btn = this.m_gui.addButton(btnComp2, DELETE, "Delete", false, 60, 10, 0, this);
                ((GridData)this.m_del_btn.getLayoutData()).horizontalAlignment = 4;
                ((GridData)this.m_del_btn.getLayoutData()).grabExcessHorizontalSpace = true;
                this.m_del_btn.setImage(this.m_sharedImages.getImage("IMG_TOOL_DELETE"));
                this.m_dup_btn = this.m_gui.addButton(btnComp2, DUPLICATE, " Duplicate ", false, 60, 10, 0, this);
                ((GridData)this.m_dup_btn.getLayoutData()).horizontalAlignment = 4;
                ((GridData)this.m_dup_btn.getLayoutData()).grabExcessHorizontalSpace = true;
                this.m_dup_btn.setImage(this.m_sharedImages.getImage("IMG_TOOL_COPY"));
                Text txt = this.m_gui.addTextReadOnlyNoBorder(this.m_compositeInCTab, null, "File:  SNMP/snmp/users.asf", 1, 1, 10, 0, null);
                ((GridData)txt.getLayoutData()).horizontalAlignment = 16384;
            } else {
                Composite btnComp = new Composite(this.m_compositeInCTab, 0);
                btnComp.setLayoutData((Object)new GridData(16384, 4, false, false));
                btnComp.setLayout((Layout)new GridLayout(1, true));
                this.m_reload_btn = this.m_gui.addButton(btnComp, RELOAD, "Reload ", true, 60, 10, 0, this);
                ((GridData)this.m_reload_btn.getLayoutData()).horizontalAlignment = 4;
                ((GridData)this.m_reload_btn.getLayoutData()).grabExcessHorizontalSpace = true;
                this.m_reload_btn.setImage(BMUI.IMAGE_REFRESH);
            }
            this.m_sc.setContent((Control)tblComp);
            this.m_sc.setMinSize(tblComp.computeSize(-1, -1, true));
        }
        this.m_compositeInCTab.layout(true);
        this.setControl((Control)this.m_compositeInCTab);
    }

    public void createFilterSection(Composite parent) {
        GUIDisplayElements gui = new GUIDisplayElements();
        Composite filterComp = new Composite(parent, 0);
        filterComp.setLayout((Layout)new GridLayout(4, false));
        filterComp.setLayoutData((Object)new GridData(4, 128, true, false, 3, 1));
        this.m_searchIcon = new Label(filterComp, 0);
        this.m_searchIcon.setImage(BMUI.IMAGE_FILTERED_14x14);
        this.m_searchIcon.setEnabled(false);
        this.m_searchText = new Text(filterComp, 0);
        GridData gd = new GridData(4, 0x1000000, true, false);
        gd.minimumWidth = 10;
        this.m_searchText.setLayoutData((Object)gd);
        gui.addDefaultTextContentMenu(this.m_searchText, true);
        this.m_searchText.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
                if (e.widget instanceof Text && (e.keyCode == 13 || e.keyCode == 13 || e.keyCode == 13 || e.keyCode == 0x1000050)) {
                    SnmpV3Tab.this.applyFilter();
                }
            }
        });
        Label runIcon = new Label(filterComp, 0);
        runIcon.setImage(BMUI.IMAGE_RUN);
        runIcon.setData((Object)APPLY_FILTER);
        runIcon.addMouseListener((MouseListener)this);
        runIcon.setToolTipText("Run Filter");
        Label delIcon = new Label(filterComp, 0);
        delIcon.setImage(BMUI.IMAGE_DEL_14x14);
        delIcon.setData((Object)REMOVE_FILTER);
        delIcon.addMouseListener((MouseListener)this);
        delIcon.setToolTipText("Remove Filter");
    }

    public void createTable(Composite parent) {
        Composite tableComp = new Composite(parent, 0);
        GridLayout gl = new GridLayout(1, false);
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        gl.verticalSpacing = 0;
        gl.horizontalSpacing = 0;
        tableComp.setLayout((Layout)gl);
        tableComp.setLayoutData((Object)new GridData(4, 4, true, true));
        Table table = new Table(tableComp, 268503042);
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        table.setLayout((Layout)new GridLayout());
        table.setLayoutData((Object)new GridData(4, 4, true, true));
        TableColumn col1 = new TableColumn(table, 0);
        col1.setText("Agent");
        col1.setData((Object)Column.AGENTNAME);
        col1.setWidth(150);
        col1.addListener(13, this.sortListener);
        TableColumn col2 = new TableColumn(table, 0);
        col2.setText("AgentID");
        col2.setData((Object)Column.AGENTID);
        col2.setWidth(150);
        col2.addListener(13, this.sortListener);
        TableColumn col3 = new TableColumn(table, 0);
        col3.setText("EngineID");
        col3.setData((Object)Column.ENGINEID);
        col3.setWidth(80);
        col3.addListener(13, this.sortListener);
        TableColumn col4 = new TableColumn(table, 0);
        col4.setText("User");
        col4.setData((Object)Column.USER);
        col4.setWidth(100);
        col4.addListener(13, this.sortListener);
        TableColumn col5 = new TableColumn(table, 0);
        col5.setText("AuthType");
        col5.setData((Object)Column.AUTHTYPE);
        col5.setWidth(110);
        col5.addListener(13, this.sortListener);
        TableColumn col6 = new TableColumn(table, 0);
        col6.setText("AuthPass");
        col6.setWidth(70);
        TableColumn col7 = new TableColumn(table, 0);
        col7.setText("PrivType");
        col7.setData((Object)Column.PRIVTYPE);
        col7.setWidth(80);
        col7.addListener(13, this.sortListener);
        TableColumn col8 = new TableColumn(table, 0);
        col8.setText("PrivPass");
        col8.setWidth(70);
        TableColumn col9 = new TableColumn(table, 0);
        col9.setText("Comments");
        col9.setData((Object)Column.COMMENTS);
        col9.setWidth(100);
        col9.addListener(13, this.sortListener);
        TableColumnLayout tableLayout = new TableColumnLayout();
        tableComp.setLayout((Layout)tableLayout);
        tableLayout.setColumnData((Widget)col1, (ColumnLayoutData)new ColumnWeightData(0, col1.getWidth()));
        tableLayout.setColumnData((Widget)col2, (ColumnLayoutData)new ColumnWeightData(0, col2.getWidth()));
        tableLayout.setColumnData((Widget)col3, (ColumnLayoutData)new ColumnWeightData(0, col3.getWidth()));
        tableLayout.setColumnData((Widget)col4, (ColumnLayoutData)new ColumnWeightData(0, col4.getWidth()));
        tableLayout.setColumnData((Widget)col5, (ColumnLayoutData)new ColumnWeightData(0, col5.getWidth()));
        tableLayout.setColumnData((Widget)col6, (ColumnLayoutData)new ColumnWeightData(0, col6.getWidth()));
        tableLayout.setColumnData((Widget)col7, (ColumnLayoutData)new ColumnWeightData(0, col7.getWidth()));
        tableLayout.setColumnData((Widget)col8, (ColumnLayoutData)new ColumnWeightData(0, col6.getWidth()));
        tableLayout.setColumnData((Widget)col9, (ColumnLayoutData)new ColumnWeightData(100, col6.getWidth()));
        this.m_tableViewer = new TableViewer(table);
        this.m_tableProvider = new ContentAndLabelProvider();
        this.m_tableViewer.setLabelProvider((IBaseLabelProvider)this.m_tableProvider);
        this.m_tableViewer.setContentProvider((IContentProvider)this.m_tableProvider);
        this.m_tableViewer.setInput((Object)this.m_snmpUsers);
        this.m_tableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                SnmpV3Tab.this.edit();
            }
        });
        this.m_tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                SnmpV3Tab.this.checkButtonStatus();
            }
        });
        this.m_tableViewer.setSorter((ViewerSorter)new Sorter());
        FancyToolTipSupport.enableFor((ColumnViewer)this.m_tableViewer, 2);
        table.setToolTipText("");
        if (!this.m_isReadOnly) {
            this.createContentMenu(this.m_tableViewer);
        }
        this.m_tableViewer.getTable().setSortColumn(col1);
        this.m_tableViewer.getTable().setSortDirection(1024);
        this.m_tableViewer.refresh(true);
    }

    public void createContentMenu(TableViewer tableViewer) {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(false);
        Menu menu = menuMgr.createContextMenu(tableViewer.getControl());
        tableViewer.getControl().setMenu(menu);
        IWorkbenchPartSite site = ConfigurationView.getInstance().getSite();
        site.registerContextMenu(menuMgr, (ISelectionProvider)tableViewer);
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                try {
                    StructuredSelection sel = (StructuredSelection)SnmpV3Tab.this.m_tableViewer.getSelection();
                    Action reload = new Action(){

                        public void run() {
                            SnmpV3Tab.this.loadFromServer();
                        }
                    };
                    reload.setText("Reload");
                    reload.setImageDescriptor(BMUI.IMAGE_DESCR_REFRESH);
                    reload.setId("Reload");
                    manager.add((IAction)reload);
                    manager.add((IContributionItem)new Separator());
                    Action add = new Action(){

                        public void run() {
                            SnmpV3Tab.this.add();
                        }
                    };
                    add.setText("Add");
                    add.setId("Add");
                    add.setImageDescriptor(SnmpV3Tab.this.m_sharedImages.getImageDescriptor("IMG_OBJ_ADD"));
                    manager.add((IAction)add);
                    Action edit = new Action(){

                        public void run() {
                            SnmpV3Tab.this.edit();
                        }
                    };
                    edit.setText("Edit");
                    edit.setId("Edit");
                    edit.setEnabled(sel.size() == 1);
                    manager.add((IAction)edit);
                    Action del = new Action(){

                        public void run() {
                            SnmpV3Tab.this.delete();
                        }
                    };
                    del.setText("Delete");
                    del.setId("Delete");
                    del.setImageDescriptor(SnmpV3Tab.this.m_sharedImages.getImageDescriptor("IMG_TOOL_DELETE"));
                    del.setEnabled(!sel.isEmpty());
                    manager.add((IAction)del);
                    Action dup = new Action(){

                        public void run() {
                            SnmpV3Tab.this.duplicate();
                        }
                    };
                    dup.setText("Duplicate");
                    dup.setId("Duplicate");
                    dup.setImageDescriptor(SnmpV3Tab.this.m_sharedImages.getImageDescriptor("IMG_TOOL_COPY"));
                    dup.setEnabled(sel.size() == 1);
                    manager.add((IAction)dup);
                    manager.add((IContributionItem)new Separator());
                    Action imp = new Action(){

                        public void run() {
                            try {
                                SnmpV3Tab.this.importFile();
                            }
                            catch (Throwable throwable) {}
                        }
                    };
                    imp.setText("Import ...");
                    imp.setId("Import");
                    imp.setImageDescriptor(BMUI.IMAGE_DESCR_IMPORT);
                    manager.add((IAction)imp);
                }
                catch (RuntimeException runtimeException) {}
            }
        });
    }

    public void checkButtonStatus() {
        int selCount = this.m_tableViewer.getTable().getSelectionCount();
        if (selCount == 1) {
            this.m_gui.enableField(this.m_edit_btn, true);
            this.m_gui.enableField(this.m_dup_btn, true);
            this.m_gui.enableField(this.m_del_btn, true);
        } else if (selCount > 1) {
            this.m_gui.enableField(this.m_edit_btn, false);
            this.m_gui.enableField(this.m_dup_btn, false);
            this.m_gui.enableField(this.m_del_btn, true);
        } else {
            this.m_gui.enableField(this.m_edit_btn, false);
            this.m_gui.enableField(this.m_dup_btn, false);
            this.m_gui.enableField(this.m_del_btn, false);
        }
    }

    public void importFile() {
        FileDialog dialog = new FileDialog(this.getControl().getShell(), 4096);
        dialog.setFilterExtensions(null);
        dialog.setText("Open File");
        String path = dialog.open();
        if (path != null) {
            File file = new File(path);
            SnmpV3ImportUserDialog sd = new SnmpV3ImportUserDialog(this.getControl().getShell(), file);
            if (sd.open() == 0) {
                boolean isChanged = false;
                int pos1 = this.getColumnPosition(sd, "ENGINE_ID");
                int pos2 = this.getColumnPosition(sd, "USER");
                int pos3 = this.getColumnPosition(sd, "AUTH_TYPE");
                int pos4 = this.getColumnPosition(sd, "AUTH_PASS");
                int pos5 = this.getColumnPosition(sd, "PRIV_TYPE");
                int pos6 = this.getColumnPosition(sd, "PRIV_PASS");
                int pos7 = this.getColumnPosition(sd, "COMMENT");
                for (String[] arr : sd.m_data) {
                    try {
                        JsonObject jo = new JsonObject();
                        jo.addProperty("agentID", ANY_AGENT_STAR);
                        jo.addProperty(ENGINE_ID, arr[pos1]);
                        jo.addProperty(USER, arr[pos2]);
                        boolean isSupportedAuthType = false;
                        if (pos3 >= 0) {
                            String auType = arr[pos3].toUpperCase().trim();
                            if (auTypes_accepted.contains(auType)) {
                                jo.addProperty(AUTH_TYPE, auType);
                                isSupportedAuthType = true;
                            } else {
                                jo.addProperty(AUTH_TYPE, "");
                            }
                        } else {
                            jo.addProperty(AUTH_TYPE, "");
                        }
                        if (isSupportedAuthType && pos4 >= 0) {
                            jo.addProperty(AUTH_EN_PASS, Cryptor.encrypt(arr[pos4]));
                        } else {
                            jo.addProperty(AUTH_PASS, "");
                        }
                        boolean isSupportedPrivType = false;
                        if (pos5 >= 0) {
                            String prType = arr[pos5].toUpperCase().trim();
                            if (prTypes_accepted.contains(prType)) {
                                jo.addProperty(PRIV_TYPE, prType);
                                isSupportedPrivType = true;
                            } else {
                                jo.addProperty(PRIV_TYPE, "");
                            }
                        } else {
                            jo.addProperty(PRIV_TYPE, "");
                        }
                        if (isSupportedPrivType && pos6 >= 0) {
                            jo.addProperty(PRIV_EN_PASS, Cryptor.encrypt(arr[pos6]));
                        } else {
                            jo.addProperty(PRIV_PASS, "");
                        }
                        if (pos7 >= 0) {
                            jo.addProperty(COMMENT, arr[pos7]);
                        } else {
                            jo.addProperty(COMMENT, "");
                        }
                        if (this.m_snmpUsers.contains(jo)) continue;
                        this.m_snmpUsers.add(jo);
                        isChanged = true;
                    }
                    catch (Throwable e) {
                        RTLogger.print(3, "Error import snmpV3 user from input: " + Arrays.asList(arr), e);
                    }
                }
                this.refreshTable();
                this.setDirty(isChanged);
                this.checkButtonStatus();
            }
        }
    }

    private void refreshTable() {
        this.m_tableViewer.refresh();
    }

    private int getColumnPosition(SnmpV3ImportUserDialog sd, String ccName) {
        int pos = -1;
        String eidNstr = sd.m_mapping.get(ccName);
        if (eidNstr != null) {
            eidNstr = eidNstr.replace("Field ", "");
            pos = Integer.parseInt(eidNstr) - 1;
        }
        return pos;
    }

    private void loadFromServer() {
        final SnmpV3Tab tab = this;
        ScGetSNMPV3Users scGet = new ScGetSNMPV3Users(Repository.getInstance());
        scGet.addCmdPostProcess(new ICmdPostProcess(){

            public void postProcess(ServerClient sc0) {
                ScGetSNMPV3Users sc = (ScGetSNMPV3Users)sc0;
                if (!sc.isFileExists()) {
                    tab.m_snmpUsers = new JsonArray();
                } else {
                    String data = sc.getResultObject();
                    try {
                        JsonParser parser = new JsonParser();
                        tab.m_snmpUsers = parser.parse(data).getAsJsonArray();
                    }
                    catch (JsonSyntaxException jsonSyntaxException) {
                        tab.m_snmpUsers = null;
                    }
                }
                UIJob uijob = new UIJob("rfr snmpv3"){

                    @Override
                    public IStatus runInUIThread(IProgressMonitor monitor) {
                        try {
                            SnmpV3Tab.this.createMainArea();
                            SnmpV3Tab.this.refreshTable();
                            SnmpV3Tab.this.setDirty(false);
                        }
                        catch (Exception e) {
                            RTLogger.print(3, "", e);
                        }
                        return null;
                    }
                };
                UIJobManager.getInstance().schedule(uijob);
            }
        });
        JobManager.getInstance().schedule(scGet);
    }

    private void undo() {
        this.setDirty(false);
        this.loadFromServer();
    }

    private void save() {
        GsonBuilder builder = new GsonBuilder().setPrettyPrinting();
        builder.disableHtmlEscaping();
        String jsonPrettyPrinted = builder.create().toJson(this.m_snmpUsers);
        ScSetSNMPV3Users sc = new ScSetSNMPV3Users(Repository.getInstance(), jsonPrettyPrinted);
        sc.addCmdPostProcess(new ICmdPostProcess(){

            public void postProcess(ServerClient sc) {
                SnmpV3Tab.this.loadFromServer();
            }
        });
        sc.start();
    }

    public void add() {
        this.openEditDialog(null, this.m_parent.getShell());
        this.refreshTable();
        this.setDirty(true);
        this.checkButtonStatus();
    }

    public void edit() {
        JsonObject jo;
        StructuredSelection ss = (StructuredSelection)this.m_tableViewer.getSelection();
        if (!ss.isEmpty() && (jo = (JsonObject)ss.getFirstElement()) != null) {
            this.openEditDialog(jo, this.m_parent.getShell());
        }
    }

    public void delete() {
        boolean deleted = false;
        StructuredSelection ss = (StructuredSelection)this.m_tableViewer.getSelection();
        for (JsonObject jobj : ss) {
            if (!this.m_snmpUsers.remove(jobj)) continue;
            deleted = true;
        }
        if (deleted) {
            this.refreshTable();
            this.setDirty(true);
            this.checkButtonStatus();
        }
    }

    public void duplicate() {
        StructuredSelection ss = (StructuredSelection)this.m_tableViewer.getSelection();
        JsonObject jobj = (JsonObject)ss.getFirstElement();
        JsonObject cloned = jobj.deepCopy();
        this.m_snmpUsers.add(cloned);
        this.refreshTable();
        this.setDirty(true);
        this.checkButtonStatus();
    }

    private void setDirty(boolean isDirty) {
        this.m_isDirty = isDirty;
        this.m_gui.enableField(this.m_save_btn, isDirty && this.isValidAll());
        this.m_gui.enableField(this.m_undo_btn, isDirty);
        if (!this.m_isDirty && this.getText().startsWith(ANY_AGENT_STAR)) {
            this.setText(VIEW_TITLE);
        } else if (this.m_isDirty && !this.getText().startsWith(ANY_AGENT_STAR)) {
            this.setText("* SNMP v3 Users");
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        String name = "";
        Object obj = e.getSource();
        if (obj instanceof Button) {
            Button b = (Button)obj;
            name = (String)b.getData();
            if (name.equalsIgnoreCase(UNDO)) {
                this.undo();
            } else if (name.equalsIgnoreCase(SAVE)) {
                this.save();
            } else if (name.equalsIgnoreCase(RELOAD)) {
                this.loadFromServer();
            } else if (name.equalsIgnoreCase(IMPORT)) {
                try {
                    this.importFile();
                }
                catch (Throwable throwable) {}
            } else if (name.equalsIgnoreCase(ADD)) {
                this.add();
            } else if (name.equalsIgnoreCase(EDIT)) {
                this.edit();
            } else if (name.equalsIgnoreCase(DELETE)) {
                this.delete();
            } else if (name.equalsIgnoreCase(DUPLICATE)) {
                this.duplicate();
            }
        }
    }

    public void mouseDoubleClick(MouseEvent e) {
    }

    public void mouseDown(MouseEvent e) {
    }

    public void mouseUp(MouseEvent e) {
        Object o = e.getSource();
        if (o instanceof Label) {
            Label l = (Label)o;
            String name = (String)l.getData();
            if (REMOVE_FILTER.equals(name)) {
                this.activateSearchIcon(false);
                this.clearSearchText();
            }
            this.applyFilter();
        }
    }

    private void applyFilter() {
        this.setFilter();
        if (this.m_searchText.getText().trim().length() > 0) {
            this.setFilter();
        } else {
            this.removeFilter();
        }
    }

    private void setFilter() {
        String searchText_trimmed = this.m_searchText.getText().trim();
        this.activateSearchIcon(searchText_trimmed.length() > 0);
        if (this.m_searchText.getText().length() > searchText_trimmed.length()) {
            this.m_searchText.setText(searchText_trimmed);
        }
        SnmpV3TableFilter treeFilter = new SnmpV3TableFilter(searchText_trimmed);
        this.m_tableViewer.setFilters(new ViewerFilter[]{treeFilter});
        this.refreshTable();
    }

    private void removeFilter() {
        this.activateSearchIcon(false);
        this.clearSearchText();
        this.m_tableViewer.setFilters(new ViewerFilter[0]);
        this.refreshTable();
    }

    public void clearSearchText() {
        if (this.m_searchText.getText().length() > 0) {
            this.m_searchText.setText("");
        }
    }

    public void setSearchText(String text) {
        if (text != null && text.length() > 0) {
            this.m_searchText.setText(text);
        }
    }

    public void activateSearchIcon(boolean activate) {
        this.m_searchIcon.setEnabled(activate);
    }

    private void openEditDialog(JsonObject jo, Shell shell) {
        JsonObject oobj;
        EditDialog ed = new EditDialog(shell, jo);
        ed.setBlockOnOpen(true);
        int res = ed.open();
        if (res != 1 && res == 0 && ed.isDirty() && (oobj = ed.getJsonObject()) != null) {
            if (ed.isNewElement()) {
                this.m_snmpUsers.add(oobj);
                this.refreshTable();
                this.setDirty(true);
                this.checkButtonStatus();
            } else if (!this.replaceElement(this.m_snmpUsers, jo, oobj)) {
                new ShowMessageBox("Error", "Error update snmp user record", 1);
            } else {
                this.refreshTable();
                this.setDirty(true);
                this.checkButtonStatus();
            }
        }
    }

    public boolean isValid(JsonObject element) {
        boolean isvalid;
        boolean bl = isvalid = element.get("agentID") != null && element.get("agentID").getAsString().length() > 0 && element.get(ENGINE_ID) != null && element.get(ENGINE_ID).getAsString().length() > 0 && element.get(USER) != null && element.get(USER).getAsString().length() > 0 && element.get(AUTH_TYPE) != null && auTypes_accepted.contains(element.get(AUTH_TYPE).getAsString()) && element.get(PRIV_TYPE) != null && prTypes_accepted.contains(element.get(PRIV_TYPE).getAsString()) && (!element.get(AUTH_TYPE).getAsString().equals("") || element.get(PRIV_TYPE).getAsString().equals(""));
        if (isvalid) {
            if (!element.get(AUTH_TYPE).getAsString().equals("") && Cryptor.decrypt(SnmpV3Tab.getEnPass(element, AUTH_PASS, AUTH_EN_PASS).getAsString()).length() < 8) {
                isvalid = false;
            }
            if (!element.get(PRIV_TYPE).getAsString().equals("") && Cryptor.decrypt(SnmpV3Tab.getEnPass(element, PRIV_PASS, PRIV_EN_PASS).getAsString()).length() < 8) {
                isvalid = false;
            }
        }
        return isvalid;
    }

    public boolean isValidAll() {
        for (JsonObject element : this.m_snmpUsers) {
            if (this.isValid(element)) continue;
            return false;
        }
        return true;
    }

    public void dispose() {
        if (this.m_isDirty) {
            try {
                ShowSimpleDialog dialog = new ShowSimpleDialog(this.getControl().getShell(), "Save SNMP v3 Users", "SNMP v3 Users has been modified.            \n\nSave changes?", "Save", "No");
                int res = dialog.open();
                if (res == 0) {
                    this.save();
                }
            }
            catch (Throwable throwable) {}
        }
        super.dispose();
    }

    private static JsonElement getEnPass(JsonObject element, String pName, String pEnName) {
        JsonElement authPass = element.get(pName);
        if (authPass == null) {
            authPass = element.get(pEnName);
            if (authPass == null) {
                element.addProperty(pEnName, "");
                authPass = element.get(pEnName);
            }
        } else {
            String encryptedPass = Cryptor.encrypt(authPass.getAsString());
            element.remove(pName);
            element.remove(pEnName);
            element.addProperty(pEnName, encryptedPass);
            authPass = element.get(pEnName);
        }
        return authPass;
    }

    public boolean replaceElement(JsonArray elements, JsonElement oldObj, JsonElement newObj) {
        if (oldObj == null || newObj == null || elements.size() == 0) {
            return false;
        }
        int i = 0;
        while (i < elements.size()) {
            if (elements.get(i).equals(oldObj)) {
                elements.set(i, newObj);
                return true;
            }
            ++i;
        }
        return false;
    }

    public Object[] getElements(JsonArray array) {
        Object[] arr = new Object[array.size()];
        int i = 0;
        while (i < array.size()) {
            arr[i] = array.get(i);
            ++i;
        }
        return arr;
    }

    public static enum Column {
        AGENTNAME,
        AGENTID,
        ENGINEID,
        USER,
        AUTHTYPE,
        PRIVTYPE,
        COMMENTS;

    }

    public class ContentAndLabelProvider
    extends StyledCellLabelProvider
    implements IStructuredContentProvider {
        public Object[] getElements(Object inputElement) {
            return SnmpV3Tab.this.m_snmpUsers == null ? null : SnmpV3Tab.this.getElements(SnmpV3Tab.this.m_snmpUsers);
        }

        public void inputChanged(Viewer arg0, Object arg1, Object arg2) {
        }

        public void update(ViewerCell cell) {
            int colIndex = cell.getColumnIndex();
            JsonObject element = (JsonObject)cell.getElement();
            String agentID = element.get("agentID").getAsString();
            switch (colIndex) {
                case 0: {
                    if (SnmpV3Tab.ANY_AGENT_STAR.equals(agentID)) {
                        cell.setText(SnmpV3Tab.ANY_AGENT);
                    } else {
                        AgentCard ac = Repository.getInstance().getAgentCard(agentID);
                        if (ac != null) {
                            cell.setText(ac.getLabel());
                        } else {
                            cell.setText("???");
                        }
                    }
                    if (SnmpV3Tab.this.isValid(element)) break;
                    cell.setBackground(BMUI.color_light_red);
                    break;
                }
                case 1: {
                    cell.setText(agentID);
                    break;
                }
                case 2: {
                    cell.setText(element.get(SnmpV3Tab.ENGINE_ID).getAsString());
                    break;
                }
                case 3: {
                    cell.setText(element.get(SnmpV3Tab.USER).getAsString());
                    break;
                }
                case 4: {
                    cell.setText(element.get(SnmpV3Tab.AUTH_TYPE).getAsString());
                    break;
                }
                case 5: {
                    JsonElement authPass = SnmpV3Tab.getEnPass(element, SnmpV3Tab.AUTH_PASS, SnmpV3Tab.AUTH_EN_PASS);
                    if (authPass != null && authPass.getAsString() != null && authPass.getAsString().length() > 0) {
                        cell.setText("********");
                        break;
                    }
                    cell.setText("");
                    break;
                }
                case 6: {
                    if (element.get(SnmpV3Tab.PRIV_TYPE) == null) break;
                    cell.setText(element.get(SnmpV3Tab.PRIV_TYPE).getAsString());
                    break;
                }
                case 7: {
                    JsonElement privPass = SnmpV3Tab.getEnPass(element, SnmpV3Tab.PRIV_PASS, SnmpV3Tab.PRIV_EN_PASS);
                    if (privPass != null && privPass.getAsString() != null && privPass.getAsString().length() > 0) {
                        cell.setText("********");
                        break;
                    }
                    cell.setText("");
                    break;
                }
                case 8: {
                    if (element.get(SnmpV3Tab.COMMENT) == null) break;
                    cell.setText(element.get(SnmpV3Tab.COMMENT).getAsString());
                    break;
                }
            }
            super.update(cell);
        }
    }

    public class EditDialog
    extends StatusDialog
    implements SelectionListener,
    ModifyListener {
        public static final String F_SELECT_AGT = "F_SELECT_AGT";
        public static final String F_COMMENT = "F_COMMENT";
        public static final String F_PRIVPASS = "F_PRIVPASS";
        public static final String F_PRIVTYPE = "F_PRIVTYPE";
        public static final String F_AUTHPASS = "F_AUTHPASS";
        public static final String F_AUTHTYPE = "F_AUTHTYPE";
        public static final String F_USER = "F_USER";
        public static final String F_ENGINEID = "F_ENGINEID";
        public static final String F_AGENTLABEL = "F_AGENTLABEL";
        public static final String F_AGENTID = "F_AGENTID";
        Composite m_dialogComposite;
        JsonObject m_snmpUserElement;
        JsonObject m_snmpUserElementResult;
        Text m_agentID_txt;
        Text m_agentName_txt;
        Text m_engineID_txt;
        Text m_user_txt;
        CCombo m_authType_cc;
        Text m_authPass_txt;
        CCombo m_privType_cc;
        Text m_privPass_txt;
        Text m_comments_txt;
        Button m_selectAgent_btn;
        boolean m_isNewElement;

        public EditDialog(Shell parent, JsonObject snmpUserElement) {
            super(parent);
            this.m_dialogComposite = null;
            this.m_snmpUserElement = null;
            this.m_snmpUserElementResult = null;
            this.m_agentID_txt = null;
            this.m_agentName_txt = null;
            this.m_engineID_txt = null;
            this.m_user_txt = null;
            this.m_authType_cc = null;
            this.m_authPass_txt = null;
            this.m_privType_cc = null;
            this.m_privPass_txt = null;
            this.m_comments_txt = null;
            this.m_selectAgent_btn = null;
            this.m_isNewElement = false;
            this.setTitle(snmpUserElement == null ? "Add SNMP User" : "Edit SNMP User");
            this.setShellStyle(this.getShellStyle() ^ 0x10000);
            this.m_snmpUserElement = snmpUserElement;
            if (this.m_snmpUserElement == null) {
                this.m_snmpUserElement = new JsonObject();
                this.m_isNewElement = true;
            }
        }

        protected Control createDialogArea(Composite parent) {
            String agentName;
            GUIDisplayElements gui = new GUIDisplayElements();
            gui.centerShell(parent.getShell(), Display.getCurrent());
            this.m_dialogComposite = new Composite(parent, 0);
            GridLayout gl = new GridLayout(3, false);
            gl.marginWidth = 13;
            gl.marginTop = 13;
            gl.marginHeight = 0;
            this.m_dialogComposite.setLayout((Layout)gl);
            GridData gd = new GridData(4, 4, true, true);
            gd.widthHint = 500;
            this.m_dialogComposite.setLayoutData((Object)gd);
            String agentID = this.m_snmpUserElement.get("agentID") == null ? "" : this.m_snmpUserElement.get("agentID").getAsString();
            AgentCard ac = Repository.getInstance().getAgentCard(agentID);
            String string = agentName = ac == null ? "" : ac.getLabel();
            if (SnmpV3Tab.ANY_AGENT_STAR.equals(agentName)) {
                agentName = SnmpV3Tab.ANY_AGENT;
            }
            this.m_agentName_txt = gui.addInputFieldSingle(this.m_dialogComposite, F_AGENTLABEL, "Agent:", agentName, 1, 1, 0, 0, 100, null);
            this.m_agentName_txt.setEditable(false);
            this.m_selectAgent_btn = gui.addButton(this.m_dialogComposite, F_SELECT_AGT, " Select ", true, this);
            this.m_agentID_txt = gui.addInputFieldSingle(this.m_dialogComposite, F_AGENTID, "Agent ID:", agentID, 2, 1, 0, 0, 100, this);
            this.m_engineID_txt = gui.addInputFieldSingle(this.m_dialogComposite, F_ENGINEID, "Engine ID:", this.m_snmpUserElement.get(SnmpV3Tab.ENGINE_ID) == null ? "" : this.m_snmpUserElement.get(SnmpV3Tab.ENGINE_ID).getAsString(), 2, 1, 0, 0, 100, this);
            this.m_user_txt = gui.addInputFieldSingle(this.m_dialogComposite, F_USER, "User:", this.m_snmpUserElement.get(SnmpV3Tab.USER) == null ? "" : this.m_snmpUserElement.get(SnmpV3Tab.USER).getAsString(), 2, 1, 0, 0, 100, this);
            Composite authPriv_comp = new Composite(this.m_dialogComposite, 0);
            gl = new GridLayout(4, false);
            gl.marginWidth = 0;
            authPriv_comp.setLayout((Layout)gl);
            authPriv_comp.setLayoutData((Object)new GridData(4, 4, true, false, 4, 1));
            JsonElement authType = this.m_snmpUserElement.get(SnmpV3Tab.AUTH_TYPE);
            this.m_authType_cc = gui.addDropDown(authPriv_comp, F_AUTHTYPE, "Auth Type: ", comboAuth, authType == null || authType.getAsString().length() == 0 ? SnmpV3Tab.NONE : authType.getAsString(), "", 1, 1, 0, 0, this);
            this.m_authPass_txt = gui.addPasswordField(authPriv_comp, F_AUTHPASS, "Auth Pass: ", Cryptor.decrypt(SnmpV3Tab.getEnPass(this.m_snmpUserElement, SnmpV3Tab.AUTH_PASS, SnmpV3Tab.AUTH_EN_PASS).getAsString()), 1, 1, 15, 0, 100, this);
            JsonElement privType = this.m_snmpUserElement.get(SnmpV3Tab.PRIV_TYPE);
            this.m_privType_cc = gui.addDropDown(authPriv_comp, F_PRIVTYPE, "Priv Type: ", comboPriv, privType == null || privType.getAsString().length() == 0 ? SnmpV3Tab.NONE : privType.getAsString(), "", 1, 1, 0, 0, this);
            this.m_privPass_txt = gui.addPasswordField(authPriv_comp, F_PRIVPASS, "Priv Pass: ", Cryptor.decrypt(SnmpV3Tab.getEnPass(this.m_snmpUserElement, SnmpV3Tab.PRIV_PASS, SnmpV3Tab.PRIV_EN_PASS).getAsString()), 1, 1, 15, 0, 100, this);
            this.m_comments_txt = gui.addInputFieldSingle(this.m_dialogComposite, F_COMMENT, "Comment: ", this.m_snmpUserElement.get(SnmpV3Tab.COMMENT) == null ? "" : this.m_snmpUserElement.get(SnmpV3Tab.COMMENT).getAsString(), 2, 1, 0, 0, 100, this);
            this.validateFields();
            if (this.m_isNewElement) {
                this.m_authType_cc.select(SnmpV3Tab.this.authType_NONE);
                this.m_privType_cc.select(SnmpV3Tab.this.privType_NONE);
            }
            if (this.m_authType_cc.getText().equals(SnmpV3Tab.NONE)) {
                SnmpV3Tab.this.m_gui.enableField(this.m_authPass_txt, false);
                SnmpV3Tab.this.m_gui.enableField(this.m_privType_cc, false);
                SnmpV3Tab.this.m_gui.enableField(this.m_privPass_txt, false);
            } else if (this.m_privType_cc.getText().equals(SnmpV3Tab.NONE)) {
                SnmpV3Tab.this.m_gui.enableField(this.m_privPass_txt, false);
            }
            return this.m_dialogComposite;
        }

        protected void updateButtonsEnableState(IStatus status) {
            super.updateButtonsEnableState(status);
            this.getButton(0).setEnabled(false);
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.checkButtonStatus();
        }

        public void widgetSelected(SelectionEvent e) {
            List<AgentCard> list;
            AgentTreeDialog atd;
            int resAdt;
            Button but;
            String name = "";
            Object o = e.getSource();
            if (o instanceof CCombo) {
                CCombo combo = (CCombo)o;
                name = (String)combo.getData();
                if (F_AUTHTYPE.equals(name)) {
                    if (combo.getItem(combo.getSelectionIndex()).equals(SnmpV3Tab.NONE)) {
                        this.m_privType_cc.select(SnmpV3Tab.this.privType_NONE);
                        SnmpV3Tab.this.m_gui.enableField(this.m_privPass_txt, false);
                        SnmpV3Tab.this.m_gui.enableField(this.m_privType_cc, false);
                        SnmpV3Tab.this.m_gui.enableField(this.m_authPass_txt, false);
                    } else {
                        SnmpV3Tab.this.m_gui.enableField(this.m_authPass_txt, true);
                        SnmpV3Tab.this.m_gui.enableField(this.m_privType_cc, true);
                        this.m_privType_cc.select(SnmpV3Tab.this.privType_NONE);
                    }
                } else if (F_PRIVTYPE.equals(name)) {
                    if (combo.getItem(combo.getSelectionIndex()).equals(SnmpV3Tab.NONE)) {
                        SnmpV3Tab.this.m_gui.enableField(this.m_privPass_txt, false);
                    } else {
                        SnmpV3Tab.this.m_gui.enableField(this.m_privPass_txt, true);
                    }
                }
            } else if (o instanceof Button && F_SELECT_AGT.equals((but = (Button)e.widget).getData()) && (resAdt = (atd = new AgentTreeDialog(this.getShell(), "Select Agent")).open()) == 0 && (list = atd.getSelectedAgentCards(false)) != null && list.size() > 0) {
                AgentCard ac = list.get(0);
                this.m_agentName_txt.setText(ac.getLabel());
                this.m_agentID_txt.setText(ac.getAgentID());
            }
            this.checkButtonStatus();
        }

        public void modifyText(ModifyEvent e) {
            String fieldName = "";
            Object obj = e.getSource();
            if (obj instanceof Text) {
                Text field = (Text)e.getSource();
                fieldName = (String)field.getData();
                String value = field.getText().trim();
                if (!fieldName.equals(F_AGENTLABEL)) {
                    if (fieldName.equals(F_AGENTID)) {
                        if (SnmpV3Tab.ANY_AGENT_STAR.equals(value)) {
                            this.m_agentName_txt.setText(SnmpV3Tab.ANY_AGENT);
                            this.m_agentName_txt.setBackground(BMUI.defaultBackground);
                            this.m_agentID_txt.setBackground(BMUI.defaultBackground);
                        } else {
                            AgentCard ac = Repository.getInstance().getAgentCard(value);
                            if (ac != null) {
                                this.m_agentName_txt.setText(ac.getLabel());
                                this.m_agentName_txt.setBackground(BMUI.defaultBackground);
                                this.m_agentID_txt.setBackground(BMUI.defaultBackground);
                            } else {
                                this.m_agentName_txt.setText("");
                                this.m_agentName_txt.setBackground(BMUI.color_light_red);
                                this.m_agentID_txt.setBackground(BMUI.color_light_red);
                            }
                        }
                    } else if (!(fieldName.equals(F_ENGINEID) || fieldName.equals(F_USER) || fieldName.equals(F_AUTHPASS))) {
                        fieldName.equals(F_PRIVPASS);
                    }
                }
            }
            this.checkButtonStatus();
        }

        public boolean isNewElement() {
            return this.m_isNewElement;
        }

        public boolean isDirty() {
            return this.isNewElement() || !this.m_snmpUserElement.equals(this.getJsonObject());
        }

        public void checkButtonStatus() {
            this.getButton(0).setEnabled(this.isDirty() && this.validateFields());
        }

        public boolean validateFields() {
            boolean isValid = true;
            String agentName = this.m_agentName_txt.getText().trim();
            if (agentName.equals("")) {
                if (this.m_agentID_txt.getText().equals(SnmpV3Tab.ANY_AGENT_STAR)) {
                    this.m_agentName_txt.setText(SnmpV3Tab.ANY_AGENT);
                    this.m_agentName_txt.setBackground(BMUI.defaultBackground);
                    this.m_agentID_txt.setBackground(BMUI.defaultBackground);
                } else {
                    this.m_agentName_txt.setBackground(BMUI.color_light_red);
                    this.m_agentID_txt.setBackground(BMUI.color_light_red);
                    isValid = false;
                }
            } else {
                this.m_agentName_txt.setBackground(BMUI.defaultBackground);
                this.m_agentID_txt.setBackground(BMUI.defaultBackground);
            }
            String engineID = this.m_engineID_txt.getText().trim();
            if (engineID.equals("")) {
                this.m_engineID_txt.setBackground(BMUI.color_light_red);
                isValid = false;
            } else {
                this.m_engineID_txt.setBackground(BMUI.defaultBackground);
            }
            String user = this.m_user_txt.getText().trim();
            if (user.equals("")) {
                this.m_user_txt.setBackground(BMUI.color_light_red);
                isValid = false;
            } else {
                this.m_user_txt.setBackground(BMUI.defaultBackground);
            }
            if (this.m_authType_cc.getText().equals(SnmpV3Tab.NONE)) {
                this.m_authPass_txt.setBackground(BMUI.defaultBackground);
            } else if (this.m_authPass_txt.getText().length() < 8) {
                isValid = false;
                this.m_authPass_txt.setBackground(BMUI.color_light_red);
                this.m_authPass_txt.setToolTipText("Password required (min 8 chars)");
            } else {
                this.m_authPass_txt.setBackground(BMUI.defaultBackground);
                this.m_authPass_txt.setToolTipText("");
            }
            if (this.m_privType_cc.getText().equals(SnmpV3Tab.NONE)) {
                this.m_privPass_txt.setBackground(BMUI.defaultBackground);
            } else if (this.m_privPass_txt.getText().length() < 8) {
                isValid = false;
                this.m_privPass_txt.setBackground(BMUI.color_light_red);
                this.m_privPass_txt.setToolTipText("Password required (min 8 chars)");
            } else {
                this.m_privPass_txt.setBackground(BMUI.defaultBackground);
                this.m_privPass_txt.setToolTipText("");
            }
            return isValid;
        }

        public boolean isValid() {
            boolean isValid = true;
            if (!this.m_authType_cc.getText().equals(SnmpV3Tab.NONE) && this.m_authPass_txt.getText().length() < 8) {
                isValid = false;
                this.m_authPass_txt.setBackground(BMUI.color_light_red);
                this.m_authPass_txt.setToolTipText("Password required (min 8 chars)");
            }
            if (!this.m_privType_cc.getText().equals(SnmpV3Tab.NONE) && this.m_privPass_txt.getText().length() < 8) {
                isValid = false;
                this.m_privPass_txt.setBackground(BMUI.color_light_red);
                this.m_privPass_txt.setToolTipText("Password required (min 8 chars)");
            }
            if (this.m_authType_cc.getText().equals(SnmpV3Tab.NONE) && !this.m_privType_cc.getText().equals(SnmpV3Tab.NONE)) {
                isValid = false;
                this.m_privType_cc.setBackground(BMUI.color_light_red);
                this.m_privType_cc.setToolTipText("noAuth +Priv is not allowed combination");
            }
            if (this.m_authType_cc.getText().equals(SnmpV3Tab.NONE)) {
                this.m_authPass_txt.setBackground(null);
                this.m_authPass_txt.setToolTipText(null);
            }
            if (this.m_privType_cc.getText().equals(SnmpV3Tab.NONE)) {
                this.m_privPass_txt.setBackground(null);
                this.m_privPass_txt.setToolTipText(null);
            }
            if (isValid) {
                this.m_authPass_txt.setBackground(null);
                this.m_authPass_txt.setToolTipText(null);
                this.m_privPass_txt.setBackground(null);
                this.m_privPass_txt.setToolTipText(null);
                this.m_privType_cc.setBackground(null);
                this.m_privType_cc.setToolTipText(null);
            }
            return isValid;
        }

        public JsonObject getJsonObject() {
            return this.m_snmpUserElementResult;
        }

        private JsonObject _getJsonObject() {
            JsonObject obj = new JsonObject();
            obj.addProperty("agentID", this.m_agentID_txt.getText());
            obj.addProperty(SnmpV3Tab.ENGINE_ID, this.m_engineID_txt.getText());
            obj.addProperty(SnmpV3Tab.USER, this.m_user_txt.getText());
            String authType = this.m_authType_cc.getItem(this.m_authType_cc.getSelectionIndex());
            obj.addProperty(SnmpV3Tab.AUTH_TYPE, authType.equals(SnmpV3Tab.NONE) ? "" : authType);
            obj.addProperty(SnmpV3Tab.AUTH_EN_PASS, authType.equals(SnmpV3Tab.NONE) ? "" : Cryptor.encrypt(this.m_authPass_txt.getText()));
            String privType = this.m_privType_cc.getItem(this.m_privType_cc.getSelectionIndex());
            obj.addProperty(SnmpV3Tab.PRIV_TYPE, privType.equals(SnmpV3Tab.NONE) ? "" : privType);
            obj.addProperty(SnmpV3Tab.PRIV_EN_PASS, privType.equals(SnmpV3Tab.NONE) ? "" : Cryptor.encrypt(this.m_privPass_txt.getText()));
            obj.addProperty(SnmpV3Tab.COMMENT, this.m_comments_txt.getText());
            return obj;
        }

        protected void okPressed() {
            this.m_snmpUserElementResult = this._getJsonObject();
            super.okPressed();
        }
    }

    public class SnmpV3TableFilter
    extends ViewerFilter {
        private String m_text = null;

        public SnmpV3TableFilter(String text) {
            this.m_text = text.toLowerCase();
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            JsonObject el = (JsonObject)element;
            JsonElement agidJE = el.get("agentID");
            if (agidJE != null) {
                AgentCard ac;
                String agentID = agidJE.getAsString();
                if (agentID.toLowerCase().contains(this.m_text)) {
                    return true;
                }
                if (agentID.equals(SnmpV3Tab.ANY_AGENT_STAR) ? SnmpV3Tab.ANY_AGENT.toLowerCase().contains(this.m_text) : (ac = Repository.getInstance().getAgentCard(agentID)) != null && ac.getLabel().toLowerCase().contains(this.m_text)) {
                    return true;
                }
            }
            String[] stringArray = new String[]{SnmpV3Tab.ENGINE_ID, SnmpV3Tab.USER, SnmpV3Tab.AUTH_TYPE, SnmpV3Tab.PRIV_TYPE, SnmpV3Tab.COMMENT};
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String pName = stringArray[n2];
                try {
                    JsonElement elN = el.get(pName);
                    if (elN != null && elN.getAsString().toLowerCase().contains(this.m_text)) {
                        return true;
                    }
                }
                catch (Throwable throwable) {}
                ++n2;
            }
            return false;
        }
    }

    public class Sorter
    extends ViewerSorter
    implements Comparator<Object> {
        private Column m_currentColumn = Column.AGENTNAME;
        private int m_direction = 128;

        public int compare(Viewer viewer, Object e1, Object e2) {
            TableViewer tv = (TableViewer)viewer;
            TableColumn tc = tv.getTable().getSortColumn();
            this.m_currentColumn = (Column)((Object)tc.getData());
            this.m_direction = tv.getTable().getSortDirection();
            return this.compare(e1, e2);
        }

        @Override
        public int compare(Object o1, Object o2) {
            if (this.m_currentColumn == null) {
                return 0;
            }
            JsonObject j1 = (JsonObject)o1;
            JsonObject j2 = (JsonObject)o2;
            int res = 0;
            try {
                switch (this.m_currentColumn) {
                    case AGENTNAME: {
                        AgentCard ac1 = null;
                        try {
                            ac1 = Repository.getInstance().getAgentCard(j1.get("agentID").getAsString());
                        }
                        catch (Throwable throwable) {}
                        AgentCard ac2 = null;
                        try {
                            ac2 = Repository.getInstance().getAgentCard(j2.get("agentID").getAsString());
                        }
                        catch (Throwable throwable) {}
                        if (ac1 != null || ac2 != null) {
                            if (ac1 != null && ac2 != null) {
                                res = ac1.getLabel().compareTo(ac2.getLabel());
                                if (res != 0) {
                                    break;
                                }
                            } else {
                                int n = res = ac1 == null ? 1 : -1;
                            }
                        }
                        if (res != 0) break;
                    }
                    case AGENTID: {
                        res = this.getCompareString(j1, "agentID").compareTo(this.getCompareString(j2, "agentID"));
                        if (res == 0 && (res = this.getCompareString(j1, SnmpV3Tab.ENGINE_ID).compareTo(this.getCompareString(j2, SnmpV3Tab.ENGINE_ID))) == 0 && (res = this.getCompareString(j1, SnmpV3Tab.USER).compareTo(this.getCompareString(j2, SnmpV3Tab.USER))) == 0 && (res = this.getCompareString(j1, SnmpV3Tab.AUTH_TYPE).compareTo(this.getCompareString(j2, SnmpV3Tab.AUTH_TYPE))) == 0) {
                            res = this.getCompareString(j1, SnmpV3Tab.PRIV_TYPE).compareTo(this.getCompareString(j2, SnmpV3Tab.PRIV_TYPE));
                        }
                        break;
                    }
                    case ENGINEID: {
                        res = this.getCompareString(j1, SnmpV3Tab.ENGINE_ID).compareTo(this.getCompareString(j2, SnmpV3Tab.ENGINE_ID));
                        if (res == 0 && (res = this.getCompareString(j1, "agentID").compareTo(this.getCompareString(j2, "agentID"))) == 0 && (res = this.getCompareString(j1, SnmpV3Tab.USER).compareTo(this.getCompareString(j2, SnmpV3Tab.USER))) == 0 && (res = this.getCompareString(j1, SnmpV3Tab.AUTH_TYPE).compareTo(this.getCompareString(j2, SnmpV3Tab.AUTH_TYPE))) == 0) {
                            res = this.getCompareString(j1, SnmpV3Tab.PRIV_TYPE).compareTo(this.getCompareString(j2, SnmpV3Tab.PRIV_TYPE));
                        }
                        break;
                    }
                    case USER: {
                        res = this.getCompareString(j1, SnmpV3Tab.USER).compareTo(this.getCompareString(j2, SnmpV3Tab.USER));
                        if (res == 0 && (res = this.getCompareString(j1, "agentID").compareTo(this.getCompareString(j2, "agentID"))) == 0 && (res = this.getCompareString(j1, SnmpV3Tab.ENGINE_ID).compareTo(this.getCompareString(j2, SnmpV3Tab.ENGINE_ID))) == 0 && (res = this.getCompareString(j1, SnmpV3Tab.AUTH_TYPE).compareTo(this.getCompareString(j2, SnmpV3Tab.AUTH_TYPE))) == 0) {
                            res = this.getCompareString(j1, SnmpV3Tab.PRIV_TYPE).compareTo(this.getCompareString(j2, SnmpV3Tab.PRIV_TYPE));
                        }
                        break;
                    }
                    case AUTHTYPE: {
                        res = this.getCompareString(j1, SnmpV3Tab.AUTH_TYPE).compareTo(this.getCompareString(j2, SnmpV3Tab.AUTH_TYPE));
                        if (res == 0 && (res = this.getCompareString(j1, "agentID").compareTo(this.getCompareString(j2, "agentID"))) == 0 && (res = this.getCompareString(j1, SnmpV3Tab.ENGINE_ID).compareTo(this.getCompareString(j2, SnmpV3Tab.ENGINE_ID))) == 0 && (res = this.getCompareString(j1, SnmpV3Tab.USER).compareTo(this.getCompareString(j2, SnmpV3Tab.USER))) == 0) {
                            res = this.getCompareString(j1, SnmpV3Tab.PRIV_TYPE).compareTo(this.getCompareString(j2, SnmpV3Tab.PRIV_TYPE));
                        }
                        break;
                    }
                    case PRIVTYPE: {
                        res = this.getCompareString(j1, SnmpV3Tab.PRIV_TYPE).compareTo(this.getCompareString(j2, SnmpV3Tab.PRIV_TYPE));
                        if (res == 0 && (res = this.getCompareString(j1, "agentID").compareTo(this.getCompareString(j2, "agentID"))) == 0 && (res = this.getCompareString(j1, SnmpV3Tab.ENGINE_ID).compareTo(this.getCompareString(j2, SnmpV3Tab.ENGINE_ID))) == 0 && (res = this.getCompareString(j1, SnmpV3Tab.USER).compareTo(this.getCompareString(j2, SnmpV3Tab.USER))) == 0) {
                            res = this.getCompareString(j1, SnmpV3Tab.AUTH_TYPE).compareTo(this.getCompareString(j2, SnmpV3Tab.AUTH_TYPE));
                        }
                        break;
                    }
                    case COMMENTS: {
                        res = this.getCompareString(j1, SnmpV3Tab.COMMENT).compareTo(this.getCompareString(j2, SnmpV3Tab.COMMENT));
                        if (res == 0 && (res = this.getCompareString(j1, "agentID").compareTo(this.getCompareString(j2, "agentID"))) == 0 && (res = this.getCompareString(j1, SnmpV3Tab.ENGINE_ID).compareTo(this.getCompareString(j2, SnmpV3Tab.ENGINE_ID))) == 0 && (res = this.getCompareString(j1, SnmpV3Tab.USER).compareTo(this.getCompareString(j2, SnmpV3Tab.USER))) == 0 && (res = this.getCompareString(j1, SnmpV3Tab.AUTH_TYPE).compareTo(this.getCompareString(j2, SnmpV3Tab.AUTH_TYPE))) == 0) {
                            res = this.getCompareString(j1, SnmpV3Tab.PRIV_TYPE).compareTo(this.getCompareString(j2, SnmpV3Tab.PRIV_TYPE));
                        }
                        break;
                    }
                }
            }
            catch (Throwable throwable) {}
            return this.m_direction == 1024 ? res : -1 * res;
        }

        public void sort(Viewer viewer, Object[] elements) {
            TableViewer tv = (TableViewer)viewer;
            TableColumn tc = tv.getTable().getSortColumn();
            if (tc != null) {
                this.m_currentColumn = (Column)((Object)tc.getData());
                this.m_direction = tv.getTable().getSortDirection();
                Arrays.sort(elements, this);
            }
        }

        private String getCompareString(JsonObject obj, String pName) {
            JsonElement je = obj.get(pName);
            return je == null ? "" : je.getAsString();
        }
    }
}

