/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.views.dashboard2d;

import com.blixx.boom.engine.BMUI;
import com.blixx.boom.gui.utils.GUIDisplayElements;
import com.blixx.boom.gui.views.DashBoardGraph2D;
import com.blixx.boom.gui.views.DashBoardView2;
import com.blixx.boom.gui.views.MessagesView;
import com.blixx.boom.gui.views.dashboard2d.SevCube2D;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseListener;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.ToolbarLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Color;

public class Application2D
extends Figure
implements MouseListener {
    private Application2D m_instance = this;
    public DashBoardView2 m_dashBoardView = null;
    public static Color m_bgColor_grey = GUIDisplayElements.m_labelBkgrndColor;
    public static Color m_bgColor_white = BMUI.color_white;
    private String m_applName = null;
    private int m_maxSevInt = 1;
    private List<Integer> m_sev = null;
    private int m_width = 80;
    private int m_maxSevHeight = 20;
    private int m_sevHeight = 16;
    public static String APP = "APP";

    public Application2D(DashBoardView2 dashboardView, String applName, List<Integer> sev) {
        this.m_dashBoardView = dashboardView;
        this.m_applName = applName;
        this.m_sev = sev;
        try {
            this.m_width = this.m_dashBoardView.getDashboardGraph().getUpperLeftCorner().getWidth();
        }
        catch (Exception exception) {}
        this.m_maxSevHeight = DashBoardGraph2D.getSevCubeSize().height + 4;
        ToolbarLayout layout = new ToolbarLayout(false);
        layout.setSpacing(0);
        this.setLayoutManager((LayoutManager)layout);
        this.setBackgroundColor(m_bgColor_grey);
        this.setBorder((Border)new LineBorder(BMUI.color_darkGrey2, 1));
        this.setOpaque(true);
        this.m_instance.addMouseListener(this);
        int i = 1;
        while (i < 6) {
            Integer count = this.m_sev.get(i);
            if (count == null) {
                count = 0;
            }
            if (count != 0) {
                this.m_maxSevInt = i;
            }
            ++i;
        }
        RectangleFigure topRec = new RectangleFigure();
        topRec.setBorder((Border)new LineBorder(m_bgColor_grey, 0));
        topRec.setBounds(new Rectangle(0, 0, this.m_width, this.m_maxSevHeight));
        this.add((IFigure)topRec);
        ApplMaxSeverities applMaxSev = new ApplMaxSeverities(this.m_applName, this.m_maxSevInt, this.m_width);
        topRec.add((IFigure)applMaxSev);
        RectangleFigure sevRec = new RectangleFigure();
        sevRec.setBounds(new Rectangle(0, 0, this.m_width, this.m_sevHeight));
        ApplSeverities severities = new ApplSeverities(this.m_dashBoardView, this.m_instance, this.m_width, this.m_sevHeight, this.m_applName, this.m_sev);
        sevRec.add((IFigure)severities, (Object)new Rectangle(0, 0, this.m_width, this.m_sevHeight));
        this.add((IFigure)sevRec);
    }

    public IFigure getToolTip() {
        StringBuffer tooltip = new StringBuffer();
        tooltip.append(this.m_applName).append("\nnormal : " + this.m_sev.get(1)).append("\nwarning: " + this.m_sev.get(2)).append("\nminor: " + this.m_sev.get(3)).append("\nmajor: " + this.m_sev.get(4)).append("\ncritical: " + this.m_sev.get(5));
        return new Label(tooltip.toString());
    }

    public int getMaxSev() {
        return this.m_maxSevInt;
    }

    public List<Integer> getSev() {
        return this.m_sev;
    }

    public String getApplName() {
        return this.m_applName;
    }

    public int getWidth() {
        return this.m_width;
    }

    public int getHeight() {
        return this.m_maxSevHeight + this.m_sevHeight;
    }

    public void mouseDoubleClicked(MouseEvent arg0) {
        Object o = arg0.getSource();
        if (o instanceof Application2D) {
            Application2D appl2D = (Application2D)((Object)o);
            String group = null;
            String appl = appl2D.getApplName();
            Integer sev = -1;
            StringBuffer sb = new StringBuffer();
            if (group != null) {
                sb.append("Group:" + group).append(" ");
            }
            if (appl != null) {
                sb.append("Application:" + appl).append(" ");
            }
            MessagesView.showMessagesForHosts(sb.toString(), appl2D.m_dashBoardView.getActiveHosts(), appl, group, null, sev, null, 0, 0);
        }
    }

    public void mousePressed(MouseEvent arg0) {
    }

    public void mouseReleased(MouseEvent arg0) {
    }

    private class ApplMaxSeverities
    extends Figure {
        public ApplMaxSeverities(String applName, int maxSev, int width) {
            ToolbarLayout layout = new ToolbarLayout(true);
            layout.setStretchMinorAxis(true);
            layout.setSpacing(2);
            this.setLayoutManager((LayoutManager)layout);
            this.setBounds(new Rectangle(2, 2, width, Application2D.this.m_maxSevHeight));
            RectangleFigure rec = new RectangleFigure();
            rec.setBounds(new Rectangle(new Point(0, 0), DashBoardGraph2D.getSevCubeSize()));
            rec.setBackgroundColor(this.getMaxSevColor(maxSev));
            rec.setBorder((Border)new LineBorder(BMUI.color_darkGrey2, 0));
            rec.setMaximumSize(new Dimension(DashBoardGraph2D.getSevCubeSize()));
            this.add((IFigure)rec);
            Label label = new Label(applName);
            this.add((IFigure)label);
        }

        private Color getMaxSevColor(int maxSev) {
            if (maxSev == 2) {
                maxSev = 1;
            }
            return BMUI.getColor(maxSev);
        }
    }

    private class ApplSeverities
    extends Figure {
        public ApplSeverities(DashBoardView2 dashboardView, Application2D appl2D, int width, int hight, String applName, List<Integer> sev) {
            ToolbarLayout layout = new ToolbarLayout(true);
            layout.setStretchMinorAxis(true);
            layout.setSpacing(0);
            this.setLayoutManager((LayoutManager)layout);
            this.setBorder((Border)new LineBorder(m_bgColor_grey, 0));
            int margin = 0;
            int sevWidth = width / 5 - 2;
            this.setBounds(new Rectangle(margin, margin, width, hight));
            if (sev == null) {
                sev = new ArrayList<Integer>();
                sev.add(0);
                sev.add(0);
                sev.add(0);
                sev.add(0);
                sev.add(0);
                sev.add(0);
            }
            SevCube2D normal = new SevCube2D(dashboardView, APP, sevWidth, applName, 1, sev.get(1));
            SevCube2D warning = new SevCube2D(dashboardView, APP, sevWidth, applName, 2, sev.get(2));
            SevCube2D minor = new SevCube2D(dashboardView, APP, sevWidth, applName, 3, sev.get(3));
            SevCube2D major = new SevCube2D(dashboardView, APP, sevWidth, applName, 4, sev.get(4));
            SevCube2D critical = new SevCube2D(dashboardView, APP, sevWidth, applName, 5, sev.get(5));
            this.add((IFigure)normal);
            this.add((IFigure)warning);
            this.add((IFigure)minor);
            this.add((IFigure)major);
            this.add((IFigure)critical);
        }
    }
}

