/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.views.dashboard2d;

import com.blixx.boom.engine.BMUI;
import com.blixx.boom.gui.utils.GUIDisplayElements;
import com.blixx.boom.gui.views.DashBoardView2;
import com.blixx.boom.gui.views.MessagesView;
import com.blixx.boom.gui.views.dashboard2d.Group2D;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseListener;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.ToolbarLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Color;

public class CrossCube2D
extends Figure
implements MouseListener {
    public DashBoardView2 m_dashboardView = null;
    private CrossCube2D m_instance = this;
    private String m_applName = null;
    private String m_grpName = null;
    private int m_maxSevCross = 0;
    private int m_cnt = 0;

    public CrossCube2D(DashBoardView2 dashboardView, boolean packed, String applName, String grpName, int maxSevCross, int width, int height) {
        this.m_dashboardView = dashboardView;
        this.m_applName = applName;
        this.m_grpName = grpName;
        this.m_maxSevCross = maxSevCross;
        ToolbarLayout layout = new ToolbarLayout();
        layout.setMinorAlignment(0);
        layout.setStretchMinorAxis(false);
        layout.setSpacing(2);
        this.setLayoutManager((LayoutManager)layout);
        this.m_instance.addMouseListener(this);
        RectangleFigure mainCube = new RectangleFigure();
        mainCube.setBounds(new Rectangle(0, 0, width, height));
        mainCube.setBackgroundColor(GUIDisplayElements.m_labelBkgrndColor);
        mainCube.setBorder((Border)new LineBorder(ColorConstants.white, 0));
        Dimension d = new Dimension(width, height);
        mainCube.setMinimumSize(d);
        mainCube.setMaximumSize(d);
        mainCube.setPreferredSize(d);
        if (maxSevCross == 0) {
            mainCube.setVisible(false);
        }
        this.add((IFigure)mainCube);
        if (maxSevCross > 0) {
            RectangleFigure crossCube = new RectangleFigure();
            crossCube.setBounds(new Rectangle((width - 16) / 2, (height - 16) / 2, 16, 16));
            crossCube.setBackgroundColor(this.getMaxSevColor(maxSevCross));
            crossCube.setBorder((Border)new LineBorder(BMUI.color_darkGrey2, 0));
            d = new Dimension(16, 16);
            crossCube.setMinimumSize(d);
            crossCube.setMaximumSize(d);
            crossCube.setPreferredSize(d);
            mainCube.add((IFigure)crossCube);
        }
    }

    public IFigure getToolTip() {
        StringBuffer tooltip = new StringBuffer();
        tooltip.append("Group: " + this.m_grpName).append("\nApplication: " + this.m_applName);
        return new Label(tooltip.toString());
    }

    private Color getMaxSevColor(int maxSevCross) {
        if (maxSevCross == 2) {
            maxSevCross = 1;
        }
        return BMUI.getColor(maxSevCross);
    }

    public String getApplName() {
        return this.m_applName;
    }

    public String getGrpName() {
        return this.m_grpName;
    }

    public int getMaxSev() {
        return this.m_maxSevCross;
    }

    public int getCNT() {
        return this.m_cnt;
    }

    public void mouseDoubleClicked(MouseEvent arg0) {
        Object o = arg0.getSource();
        if (o instanceof CrossCube2D) {
            CrossCube2D crossCube = (CrossCube2D)((Object)o);
            String group = crossCube.getGrpName();
            String appl = crossCube.getApplName();
            Integer sev = crossCube.getMaxSev();
            if (sev == null) {
                sev = -1;
            }
            StringBuffer sb = new StringBuffer();
            if (group != null) {
                sb.append("Group:" + group).append(" ");
            }
            if (appl != null) {
                sb.append("Application:" + appl).append(" ");
            }
            MessagesView.showMessagesForHosts(sb.toString(), crossCube.m_dashboardView.getActiveHosts(), appl, group, null, sev, null, 0, 0);
        }
    }

    public void mousePressed(MouseEvent arg0) {
    }

    public void mouseReleased(MouseEvent arg0) {
    }

    public Dimension getPreferredSize(int wHint, int hHint) {
        Dimension d = null;
        try {
            Group2D g2d = this.m_dashboardView.getDashboardGraph().getGroup2D(this.m_grpName);
            d = new Dimension(g2d.getBounds().width, super.getPreferredSize((int)wHint, (int)hHint).height);
        }
        catch (Throwable throwable) {
            d = super.getPreferredSize(wHint, hHint);
        }
        return d;
    }

    protected void layout() {
        super.layout();
    }
}

