/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.views.dashboard2d;

import com.blixx.boom.engine.BMUI;
import com.blixx.boom.gui.utils.GUIDisplayElements;
import com.blixx.boom.gui.views.DashBoardGraph2D;
import com.blixx.boom.gui.views.DashBoardView2;
import com.blixx.boom.gui.views.MessagesView;
import com.blixx.boom.gui.views.dashboard2d.SevCube2D;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseListener;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.ToolbarLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Color;

public class Group2D
extends Figure
implements MouseListener {
    public static Color m_bgColor_grey = GUIDisplayElements.m_labelBkgrndColor;
    public static Color m_bgColor_white = BMUI.color_white;
    private Group2D m_instance = this;
    public DashBoardView2 m_dashBoardView = null;
    private String m_grpName = null;
    private List<Integer> m_sev = null;
    private int m_width = 24;
    private int m_height = 112;
    private SevCube2D m_normal = null;
    private SevCube2D m_warning = null;
    private SevCube2D m_minor = null;
    private SevCube2D m_major = null;
    private SevCube2D m_critical = null;
    public static String GRP = "GRP";

    public Group2D(DashBoardView2 dashBoardView, boolean packed, String name, List<Integer> sev) {
        this.m_instance.addMouseListener(this);
        this.m_dashBoardView = dashBoardView;
        this.m_grpName = name;
        this.m_sev = sev;
        if (this.m_sev == null) {
            this.m_sev = new ArrayList<Integer>();
            this.m_sev.add(0);
            this.m_sev.add(0);
            this.m_sev.add(0);
            this.m_sev.add(0);
            this.m_sev.add(0);
            this.m_sev.add(0);
        }
        this.m_height = DashBoardGraph2D.getSevCubeSize().height + 6 + (DashBoardGraph2D.getFontHeight() + 6) * 6;
        if (packed) {
            this.createPackedGroup();
        } else {
            this.m_width = 100;
            this.createUnpackedPackedGroup();
        }
    }

    private void createPackedGroup() {
        this.setBackgroundColor(m_bgColor_grey);
        this.setBorder((Border)new LineBorder(BMUI.color_darkGrey2, 1));
        this.setOpaque(true);
        this.setSize(new Dimension(this.m_width, this.m_height));
        RectangleFigure mainRec = new RectangleFigure();
        mainRec.setBackgroundColor(m_bgColor_grey);
        mainRec.setBorder((Border)new LineBorder(m_bgColor_grey, 0));
        ToolbarLayout layout = new ToolbarLayout();
        layout.setSpacing(1);
        layout.setMinorAlignment(0);
        mainRec.setLayoutManager((LayoutManager)layout);
        mainRec.setBounds(new Rectangle(0, 2, this.m_width, this.m_height));
        this.add((IFigure)mainRec);
        RectangleFigure maxSevCube = new RectangleFigure();
        maxSevCube.setBackgroundColor(this.getMaxSevColor());
        maxSevCube.setBorder((Border)new LineBorder(BMUI.color_darkGrey2, 0));
        maxSevCube.setSize(DashBoardGraph2D.getSevCubeSize());
        maxSevCube.setMaximumSize(DashBoardGraph2D.getSevCubeSize());
        mainRec.add((IFigure)maxSevCube);
        Label grpName = new Label(this.m_grpName);
        mainRec.add((IFigure)grpName);
        RectangleFigure severities = new RectangleFigure();
        ToolbarLayout layout1 = new ToolbarLayout();
        layout1.setVertical(true);
        severities.setLayoutManager((LayoutManager)layout1);
        severities.setBorder((Border)new LineBorder(m_bgColor_grey, 0));
        severities.setOpaque(true);
        Dimension d = new Dimension(this.m_width, 5 * DashBoardGraph2D.getFontHeight());
        severities.setBounds(new Rectangle(new Point(0, 0), d));
        severities.setSize(d);
        mainRec.add((IFigure)severities);
        this.m_normal = new SevCube2D(this.m_dashBoardView, GRP, this.m_width, this.m_grpName, 1, this.m_sev.get(1));
        this.m_warning = new SevCube2D(this.m_dashBoardView, GRP, this.m_width, this.m_grpName, 2, this.m_sev.get(2));
        this.m_minor = new SevCube2D(this.m_dashBoardView, GRP, this.m_width, this.m_grpName, 3, this.m_sev.get(3));
        this.m_major = new SevCube2D(this.m_dashBoardView, GRP, this.m_width, this.m_grpName, 4, this.m_sev.get(4));
        this.m_critical = new SevCube2D(this.m_dashBoardView, GRP, this.m_width, this.m_grpName, 5, this.m_sev.get(5));
        severities.add((IFigure)this.m_normal);
        severities.add((IFigure)this.m_warning);
        severities.add((IFigure)this.m_minor);
        severities.add((IFigure)this.m_major);
        severities.add((IFigure)this.m_critical);
    }

    private void createUnpackedPackedGroup() {
        ToolbarLayout layout = new ToolbarLayout();
        layout.setMinorAlignment(0);
        layout.setSpacing(1);
        this.setLayoutManager((LayoutManager)layout);
        this.setBorder((Border)new LineBorder(BMUI.color_darkGrey2, 0));
        this.setBackgroundColor(m_bgColor_grey);
        this.setOpaque(true);
        this.setSize(new Dimension(this.m_width, this.m_height));
        RectangleFigure dummy = new RectangleFigure();
        dummy.setBackgroundColor(m_bgColor_grey);
        dummy.setBorder((Border)new LineBorder(m_bgColor_grey, 0));
        dummy.setSize(new Dimension(1, 2));
        this.add((IFigure)dummy);
        RectangleFigure maxSevCube = new RectangleFigure();
        maxSevCube.setBackgroundColor(this.getMaxSevColor());
        maxSevCube.setBorder((Border)new LineBorder(BMUI.color_darkGrey2, 0));
        maxSevCube.setSize(DashBoardGraph2D.getSevCubeSize());
        maxSevCube.setMaximumSize(DashBoardGraph2D.getSevCubeSize());
        this.add((IFigure)maxSevCube);
        Label grpName = new Label(this.m_grpName);
        this.add((IFigure)grpName);
        RectangleFigure severities = new RectangleFigure();
        ToolbarLayout layout1 = new ToolbarLayout();
        layout1.setVertical(true);
        severities.setLayoutManager((LayoutManager)layout1);
        severities.setBackgroundColor(m_bgColor_grey);
        severities.setBorder((Border)new LineBorder(m_bgColor_grey, 0));
        severities.setOpaque(true);
        Dimension d = new Dimension(this.m_width, 5 * DashBoardGraph2D.getFontHeight());
        severities.setBounds(new Rectangle(new Point(0, 0), d));
        severities.setSize(d);
        this.add((IFigure)severities);
        this.m_normal = new SevCube2D(this.m_dashBoardView, GRP, this.m_width, this.m_grpName, 1, this.m_sev.get(1));
        this.m_warning = new SevCube2D(this.m_dashBoardView, GRP, this.m_width, this.m_grpName, 2, this.m_sev.get(2));
        this.m_minor = new SevCube2D(this.m_dashBoardView, GRP, this.m_width, this.m_grpName, 3, this.m_sev.get(3));
        this.m_major = new SevCube2D(this.m_dashBoardView, GRP, this.m_width, this.m_grpName, 4, this.m_sev.get(4));
        this.m_critical = new SevCube2D(this.m_dashBoardView, GRP, this.m_width, this.m_grpName, 5, this.m_sev.get(5));
        severities.add((IFigure)this.m_normal);
        severities.add((IFigure)this.m_warning);
        severities.add((IFigure)this.m_minor);
        severities.add((IFigure)this.m_major);
        severities.add((IFigure)this.m_critical);
    }

    private Color getMaxSevColor() {
        int maxSev = 1;
        int i = 1;
        while (i < 6) {
            Integer count = this.m_sev.get(i);
            if (count == null) {
                count = 0;
            }
            if (count != 0) {
                maxSev = i;
            }
            ++i;
        }
        if (maxSev == 2) {
            maxSev = 1;
        }
        return BMUI.getColor(maxSev);
    }

    public IFigure getToolTip() {
        StringBuffer tooltip = new StringBuffer();
        tooltip.append(this.m_grpName).append("\nnormal : " + this.m_sev.get(1)).append("\nwarning: " + this.m_sev.get(2)).append("\nminor: " + this.m_sev.get(3)).append("\nmajor: " + this.m_sev.get(4)).append("\ncritical: " + this.m_sev.get(5));
        return new Label(tooltip.toString());
    }

    public String getName() {
        return this.m_grpName;
    }

    public List<Integer> getSeverities() {
        return this.m_sev;
    }

    public void mouseDoubleClicked(MouseEvent arg0) {
        Object o = arg0.getSource();
        Group2D group = null;
        if (o instanceof Group2D) {
            group = (Group2D)((Object)o);
            String grpName = group.m_instance.getName();
            String applName = null;
            Integer sev = -1;
            StringBuffer sb = new StringBuffer();
            if (group != null) {
                sb.append("Group:" + (Object)((Object)group)).append(" ");
            }
            if (applName != null) {
                sb.append("Application:" + applName).append(" ");
            }
            MessagesView.showMessagesForHosts(sb.toString(), this.m_dashBoardView.getActiveHosts(), applName, grpName, null, sev, null, 0, 0);
        }
    }

    public void mousePressed(MouseEvent arg0) {
    }

    public void mouseReleased(MouseEvent arg0) {
    }
}

