/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.views.dashboard2d;

import com.blixx.boom.engine.BMUI;
import com.blixx.boom.gui.views.DashBoardGraph2D;
import com.blixx.boom.gui.views.DashBoardView2;
import com.blixx.boom.gui.views.MessagesView;
import com.blixx.boom.gui.views.dashboard2d.Application2D;
import com.blixx.boom.gui.views.dashboard2d.Group2D;
import com.blixx.shared.Severity;
import org.eclipse.draw2d.AbstractBorder;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseListener;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.ToolbarLayout;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Color;

public class SevCube2D
extends Figure
implements MouseListener {
    private SevCube2D m_instance = this;
    private DashBoardView2 m_dashBoardView = null;
    private String m_grpName = null;
    private String m_applName = null;
    private int m_sev = 1;
    private int m_count = 0;
    private int m_width = 0;
    private int m_height = 20;

    public SevCube2D(DashBoardView2 dashBoardView, String type, int width, String grpName, int sevInt, int count) {
        this.m_instance.addMouseListener(this);
        this.m_dashBoardView = dashBoardView;
        this.m_width = width;
        this.m_height = DashBoardGraph2D.getFontHeight() + 4;
        this.m_sev = sevInt;
        this.m_count = count;
        if (type.equals(Application2D.APP)) {
            this.createSevCubeAppl();
            this.m_applName = grpName;
        } else if (type.equals(Group2D.GRP)) {
            this.m_grpName = grpName;
            this.createSevCubeGrp();
        }
    }

    private void createSevCubeAppl() {
        ToolbarLayout layout = new ToolbarLayout();
        layout.setMinorAlignment(0);
        layout.setStretchMinorAxis(true);
        layout.setSpacing(0);
        this.setLayoutManager((LayoutManager)layout);
        this.setBorder((Border)new LineBorder(BMUI.color_darkGrey2, 0));
        String text = "";
        if (this.m_count > 0) {
            text = "" + this.m_count;
        }
        RectangleFigure rec = new RectangleFigure();
        rec.setBounds(new Rectangle(0, 0, this.m_width, this.m_height));
        rec.setBorder((Border)new LineBorder(BMUI.color_darkGrey, 0));
        this.add((IFigure)rec);
        Label label = new Label(text);
        label.setForegroundColor(this.getSevColor(this.m_sev));
        label.setBounds(new Rectangle(0, 0, this.m_width, this.m_height));
        rec.add((IFigure)label);
    }

    private void createSevCubeGrp() {
        ToolbarLayout layout = new ToolbarLayout();
        layout.setMinorAlignment(0);
        layout.setStretchMinorAxis(false);
        layout.setSpacing(2);
        this.setLayoutManager((LayoutManager)layout);
        this.setBorder((Border)new cubeBorderGrp());
        String text = "";
        if (this.m_count > 0) {
            text = "" + this.m_count;
        }
        Label label = new Label(text);
        label.setForegroundColor(this.getSevColor(this.m_sev));
        label.setBounds(new Rectangle(0, 0, this.m_width, this.m_height));
        this.add((IFigure)label);
    }

    private Color getSevColor(int sev) {
        return BMUI.getColor(sev);
    }

    public String getGrpName() {
        return this.m_grpName;
    }

    public String getApplName() {
        return this.m_applName;
    }

    public int getSev() {
        return this.m_sev;
    }

    public int getCount() {
        return this.m_count;
    }

    public void mouseDoubleClicked(MouseEvent arg0) {
        SevCube2D sevCube;
        int msgCount;
        Object o = arg0.getSource();
        if (o instanceof SevCube2D && (msgCount = (sevCube = (SevCube2D)((Object)o)).getCount()) > 0) {
            Integer sev = sevCube.getSev();
            if (sev == 0) {
                return;
            }
            String group = sevCube.getGrpName();
            String appl = sevCube.getApplName();
            StringBuffer sb = new StringBuffer();
            if (group != null) {
                sb.append("Group:" + group).append(" ");
            }
            if (appl != null) {
                sb.append("Application:" + appl).append(" ");
            }
            String severity = null;
            severity = sev == 2 ? String.valueOf(Severity.getSeverity(1)) + "|" + Severity.getSeverity(2) : Severity.getSeverity(sev);
            sb.append("(" + severity + ")").append(" ");
            MessagesView.showMessagesForHosts(sb.toString(), this.m_dashBoardView.getActiveHosts(), appl, group, null, sev, null, 0, 0);
        }
    }

    public void mousePressed(MouseEvent arg0) {
    }

    public void mouseReleased(MouseEvent arg0) {
    }

    private class cubeBorderGrp
    extends AbstractBorder {
        private cubeBorderGrp() {
        }

        public Insets getInsets(IFigure figure) {
            return new Insets(1, 0, 0, 0);
        }

        public void paint(IFigure figure, Graphics graphics, Insets insets) {
            graphics.setLineWidth(SevCube2D.this.m_sev == 1 ? 2 : 3);
            graphics.setForegroundColor(BMUI.color_darkGrey2);
            graphics.drawLine(cubeBorderGrp.getPaintRectangle((IFigure)figure, (Insets)insets).getTopLeft(), tempRect.getTopRight());
        }
    }
}

