/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.views.dashboard2d;

import com.blixx.boom.engine.BMUI;
import com.blixx.boom.engine.Repository;
import com.blixx.boom.engine.UIJob;
import com.blixx.boom.gui.views.DashBoardGraph2D;
import com.blixx.boom.gui.views.DashBoardView2;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.draw2d.ActionEvent;
import org.eclipse.draw2d.ActionListener;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.ToggleButton;
import org.eclipse.draw2d.ToolbarLayout;
import org.eclipse.draw2d.XYAnchor;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;

public class UpperLeftCorner
extends Figure {
    private DashBoardView2 m_dashboardView = null;
    private boolean m_packed = true;
    private int m_width = 140;
    private int m_hight = 110;
    private RectangleFigure m_mainRec = null;

    public UpperLeftCorner(DashBoardView2 dashboardView, boolean packed) {
        this.m_dashboardView = dashboardView;
        this.m_packed = packed;
        ToolbarLayout layout = new ToolbarLayout();
        layout.setSpacing(1);
        this.setLayoutManager((LayoutManager)layout);
        this.setBackgroundColor(DashBoardGraph2D.m_bgColor_grey);
        this.setBorder((Border)new LineBorder(BMUI.color_darkGrey, 1));
        this.setOpaque(true);
        this.m_hight = DashBoardGraph2D.getSevCubeSize().height + 6 + (DashBoardGraph2D.getFontHeight() + 6) * 6 + 5;
        if (this.m_packed) {
            this.m_width = 80;
        }
        this.m_mainRec = new RectangleFigure();
        this.m_mainRec.setBounds(new Rectangle(-5, 0, this.m_width, this.m_hight));
        this.m_mainRec.setBorder((Border)new LineBorder(BMUI.color_darkGrey, 0));
        this.add((IFigure)this.m_mainRec);
        Label grp = new Label("Groups");
        grp.setBounds(new Rectangle(this.m_width / 2 - 15, 0, this.m_width - (this.m_width / 2 - 15), 30));
        this.m_mainRec.add((IFigure)grp);
        Label app = new Label("Applications");
        app.setBounds(new Rectangle(0, this.m_hight - 30, this.m_width, 30));
        this.m_mainRec.add((IFigure)app);
        PolylineConnection diagonal = new PolylineConnection();
        diagonal.setLineStyle(1);
        try {
            diagonal.setAntialias(1);
        }
        catch (Throwable throwable) {}
        diagonal.setSourceAnchor((ConnectionAnchor)new XYAnchor(new Point(5, 15)));
        diagonal.setTargetAnchor((ConnectionAnchor)new XYAnchor(new Point(this.m_width - 5, this.m_hight - 15)));
        diagonal.setForegroundColor(BMUI.color_black);
        this.add((IFigure)diagonal);
        ToggleButton btn = new ToggleButton(this.m_packed ? "Unpack" : "Pack");
        btn.setSelected(false);
        btn.setFont(BMUI.font_arial8_bold);
        btn.setBounds(new Rectangle(0, 0, -1, -1));
        btn.setToolTip(this.getBtnToolTip());
        btn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                UpperLeftCorner.this.m_dashboardView.setPack(!UpperLeftCorner.this.m_dashboardView.isPack());
                UIJob job = new UIJob("RefreshDabo"){

                    @Override
                    public IStatus runInUIThread(IProgressMonitor monitor) {
                        UpperLeftCorner.this.m_dashboardView.createContent();
                        ((UpperLeftCorner)(this).UpperLeftCorner.this).m_dashboardView.m_parent.layout();
                        return Status.OK_STATUS;
                    }
                };
                Repository.getUIJobManager().schedule(job);
            }
        });
        this.add((IFigure)btn);
    }

    public IFigure getToolTip() {
        return new Label("Pack/Unpack the Dashboard");
    }

    public IFigure getBtnToolTip() {
        if (this.m_packed) {
            return new Label("Click here to UNPACK the Dashboard");
        }
        return new Label("Click here to PACK the Dashboard");
    }

    public int getWidth() {
        return this.m_mainRec.getSize().width;
    }

    public int getHeight() {
        return this.m_mainRec.getSize().height;
    }
}

