/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.views.dnd;

import com.blixx.boom.engine.BMUI;
import com.blixx.boom.gui.Activator;
import com.blixx.boom.gui.views.dnd.DNDShare;
import com.blixx.log.RTLogger;
import com.blixx.shared.Condition;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbenchWindow;

public class DNDCopyMonConditionAction
extends Action {
    private String m_dndType = null;
    private List<Condition> m_elements = new ArrayList<Condition>();
    private Clipboard m_systemClipboard = null;

    public DNDCopyMonConditionAction(String dndType, Object viewer, Clipboard clipboard) {
        super("DNDCopyMonCondition");
        TableViewer tableViewer;
        IStructuredSelection ssel;
        this.setText("Copy");
        this.setId("dndcopymoncondition");
        this.m_dndType = dndType;
        this.m_systemClipboard = clipboard;
        IWorkbenchWindow window = Activator.getDefault().getWorkbench().getActiveWorkbenchWindow();
        ISharedImages sharedImages = window.getWorkbench().getSharedImages();
        this.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_COPY"));
        this.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_COPY_DISABLED"));
        if (this.m_dndType == null || this.m_dndType.length() == 0) {
            this.setEnabled(false);
        }
        if (this.m_dndType.equals(DNDShare.DND_COPY_MON_CONDITION_INTERN) && viewer instanceof TableViewer && (ssel = (IStructuredSelection)(tableViewer = (TableViewer)viewer).getSelection()) != null && !ssel.isEmpty()) {
            for (Object o : ssel) {
                List l;
                Object obj;
                if (!(o instanceof List) || !((obj = (l = (List)o).get(1)) instanceof Condition)) continue;
                Condition mc = (Condition)obj;
                this.m_elements.add(mc);
            }
        }
        if (this.m_elements == null || this.m_elements.size() == 0) {
            this.setEnabled(false);
        }
    }

    public void run() {
        if (this.m_dndType == null || this.m_elements.size() == 0) {
            return;
        }
        if (this.m_systemClipboard == null || this.m_systemClipboard.isDisposed()) {
            this.m_systemClipboard = new Clipboard(Display.getCurrent());
        }
        try {
            this.m_systemClipboard.clearContents();
            this.m_systemClipboard.setContents(new Object[]{String.valueOf(this.m_dndType) + ";" + BMUI.type_mon}, new Transfer[]{TextTransfer.getInstance()});
            RTLogger.print(5, String.valueOf(this.m_dndType) + ": MonitorConditions has been added to the system clipboard");
        }
        catch (Exception e) {
            RTLogger.print(5, String.valueOf(this.m_dndType) + " error: cannot add MonitorConditions to the system clipboard", e);
        }
        DNDShare.getInstance().clearDNDMonConditionObjects();
        DNDShare.getInstance().setDNDMonConditionObjects(this.m_elements);
    }
}

