/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.views.dnd;

import com.blixx.boom.engine.BMUI;
import com.blixx.boom.gui.Activator;
import com.blixx.boom.gui.dialogs.ShowMessageDialog;
import com.blixx.boom.gui.views.dnd.DNDShare;
import com.blixx.boom.snmp.MibTreeObject;
import com.blixx.log.RTLogger;
import com.blixx.shared.MsgCondition;
import com.blixx.shared.exceptions.PolicyException;
import com.blixx.shared.utils.GroupTreeObject;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbenchWindow;

public class DNDCopyMsgConditionAction
extends Action {
    private String m_dndType = null;
    private List<MsgCondition> m_elements = new LinkedList<MsgCondition>();
    private Clipboard m_systemClipboard = null;
    private boolean m_isRecursive = false;
    private StructuredViewer m_viewer = null;

    public DNDCopyMsgConditionAction(String dndType, StructuredViewer viewer, boolean isRecursive, Clipboard clipboard) {
        super("DNDCopyMsgCondition");
        this.setText("Copy");
        this.setId("dndcopymsgcondition");
        this.m_dndType = dndType;
        this.m_isRecursive = isRecursive;
        this.m_systemClipboard = clipboard;
        this.m_viewer = viewer;
        IWorkbenchWindow window = Activator.getDefault().getWorkbench().getActiveWorkbenchWindow();
        ISharedImages sharedImages = window.getWorkbench().getSharedImages();
        this.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_COPY"));
        this.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_COPY_DISABLED"));
        if (this.m_dndType == null || this.m_dndType.length() == 0) {
            this.setEnabled(false);
        } else if (this.m_dndType.equals(DNDShare.DND_COPY_MSG_CONDITION_INTERN)) {
            this.setText("Copy");
        } else if (this.m_dndType.equals(DNDShare.DND_COPY_MSG_CONDITION)) {
            if (this.m_isRecursive) {
                this.setText("Put sample Conditions to the Clipboard (recursive)");
            } else {
                this.setText("Put a sample Condition to the Clipboard");
            }
        }
        IStructuredSelection ssel = (IStructuredSelection)viewer.getSelection();
        if (ssel == null || ssel.isEmpty()) {
            this.setEnabled(false);
        }
    }

    public void collectDataFromViewer(StructuredViewer viewer, boolean isRecursive) {
        block10: {
            IStructuredSelection ssel;
            block11: {
                ssel = (IStructuredSelection)viewer.getSelection();
                if (ssel == null || ssel.isEmpty()) break block10;
                if (!this.m_dndType.equals(DNDShare.DND_COPY_MSG_CONDITION_INTERN)) break block11;
                if (!(viewer instanceof TableViewer)) break block10;
                for (Object o : ssel) {
                    List l;
                    Object obj;
                    if (!(o instanceof List) || !((obj = (l = (List)o).get(1)) instanceof MsgCondition)) continue;
                    MsgCondition mc = (MsgCondition)obj;
                    this.m_elements.add(mc);
                }
                break block10;
            }
            if (this.m_dndType.equals(DNDShare.DND_COPY_MSG_CONDITION) && viewer instanceof TreeViewer) {
                LinkedHashMap<MibTreeObject, String> all_elements = new LinkedHashMap<MibTreeObject, String>();
                for (Object o : ssel) {
                    if (o instanceof MibTreeObject) {
                        MibTreeObject sel_mto = (MibTreeObject)o;
                        String type = sel_mto.getType();
                        if (type.equals("NOTIFICATION-TYPE") || type.equals("TRAP-TYPE")) {
                            all_elements.put(sel_mto, null);
                        }
                        if (!this.m_isRecursive) continue;
                        Map<MibTreeObject, String> sub_elems = this.getSubElements(sel_mto, false, true, true);
                        ViewerFilter[] filters = viewer.getFilters();
                        if (filters != null) {
                            Iterator<Map.Entry<MibTreeObject, String>> itEl = sub_elems.entrySet().iterator();
                            while (itEl.hasNext()) {
                                boolean matched = true;
                                Map.Entry<MibTreeObject, String> en = itEl.next();
                                ViewerFilter[] viewerFilterArray = filters;
                                int n = filters.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    ViewerFilter f = viewerFilterArray[n2];
                                    if (!f.select((Viewer)viewer, null, (Object)en.getKey())) {
                                        matched = false;
                                        break;
                                    }
                                    ++n2;
                                }
                                if (!matched) continue;
                                all_elements.put(en.getKey(), en.getValue());
                            }
                            continue;
                        }
                        all_elements.putAll(sub_elems);
                        continue;
                    }
                    if (!(o instanceof GroupTreeObject)) continue;
                    GroupTreeObject cfr_ignored_0 = (GroupTreeObject)o;
                }
                for (Map.Entry entry : all_elements.entrySet()) {
                    MibTreeObject mto = (MibTreeObject)entry.getKey();
                    MsgCondition cond = this.getMsgCondition(mto);
                    if (cond == null) continue;
                    this.m_elements.add(cond);
                }
            }
        }
    }

    public void run() {
        this.collectDataFromViewer(this.m_viewer, this.m_isRecursive);
        if (this.m_elements.size() == 0) {
            return;
        }
        if (this.m_dndType.equals(DNDShare.DND_COPY_MSG_CONDITION)) {
            StringBuilder sb = new StringBuilder();
            for (MsgCondition mc : this.m_elements) {
                sb.append(mc.getDescription()).append('\n');
            }
            ShowMessageDialog md = new ShowMessageDialog(new Shell(Display.getCurrent().getActiveShell()), "  Put sample Conditions to the Clipboard (recursive)", String.valueOf(this.m_elements.size()) + " traps are found. Do you want to put them to the clipboard?", sb.toString(), "", true, "Yes");
            md.setBlockOnOpen(true);
            md.open();
            if (md.getReturnCode() != 0) {
                return;
            }
        }
        if (this.m_systemClipboard == null || this.m_systemClipboard.isDisposed()) {
            this.m_systemClipboard = new Clipboard(Display.getCurrent());
        }
        try {
            this.m_systemClipboard.clearContents();
            this.m_systemClipboard.setContents(new Object[]{String.valueOf(this.m_dndType) + ";" + BMUI.type_msg}, new Transfer[]{TextTransfer.getInstance()});
            RTLogger.print(5, String.valueOf(this.m_dndType) + ": FilterConditions has been added to the system clipboard");
        }
        catch (Exception e) {
            RTLogger.print(5, String.valueOf(this.m_dndType) + " error: cannot add FilterConditions to the system clipboard", e);
        }
        DNDShare.getInstance().clearDNDMsgConditionObjects();
        DNDShare.getInstance().setDNDMsgConditionObjects(this.m_elements);
    }

    private MsgCondition getMsgCondition(MibTreeObject mto) {
        if (mto == null) {
            return null;
        }
        MsgCondition mc = null;
        String mibType = mto.getType();
        Properties prop = new Properties();
        prop.setProperty("APPLICATION", "SNMPTrapd");
        prop.setProperty("MSGGRP", "SNMP");
        String oid = mto.getSNMP_OID();
        String trap = "Notif. ";
        if (mibType.equals("TRAP-TYPE")) {
            String parentOID = ((MibTreeObject)mto.getParent()).getSNMP_OID();
            if (oid.startsWith(".")) {
                oid = oid.replace(parentOID, "");
                oid = oid.substring(1);
            }
            String oidT = "$e[:|.][6.$S|$S|0.$S]";
            oidT = oidT.replace("$S", oid);
            oid = oidT = oidT.replace("$e", parentOID);
            trap = "Trap v1 ";
        }
        prop.setProperty("OBJECT", oid);
        prop.setProperty("MSGKEY", "<$AGENT_HOST>:<$HOST>:" + mto.getLabel2());
        prop.setProperty("ACKKEY", "");
        prop.setProperty("DEDUPL", "true");
        prop.setProperty("TEXT", "<*>");
        prop.setProperty("C_DESCRIPTION", String.valueOf(trap) + mto.getLabel2());
        prop.setProperty("HELPTEXT", String.valueOf(mto.getFullLabel()) + "\n" + mto.getDescription());
        prop.setProperty("HELPTEXT_ID", UUID.randomUUID().toString());
        StringBuffer text = new StringBuffer(mto.getLabel2());
        text.append("\n");
        text.append(this.getExpectedVariables(mto.getTrapVariables()));
        prop.setProperty("SET_TEXT", text.toString());
        prop.setProperty("SET_OBJECT", mto.getLabel2());
        prop.setProperty("ACTIONTYPE", "SEND");
        try {
            mc = MsgCondition.getInstance(prop, 0, 0);
        }
        catch (PolicyException e) {
            RTLogger.print(5, String.valueOf(this.m_dndType) + " error creating FilterCondition", e);
        }
        return mc;
    }

    private StringBuffer getExpectedVariables(Map<String, String> m) {
        StringBuffer sb = new StringBuffer();
        for (String oid : m.keySet()) {
            String name = m.get(oid);
            sb.append(name).append(" : <$").append(oid).append(">\n");
        }
        sb.append("\n");
        return sb;
    }

    private Map<MibTreeObject, String> getSubElements(MibTreeObject mto, boolean getPrimitiv, boolean getTrap, boolean getNotification) {
        LinkedHashMap<MibTreeObject, String> elements = new LinkedHashMap<MibTreeObject, String>();
        List<GroupTreeObject> sub_elements = mto.getAllElements();
        int i = 0;
        while (i < sub_elements.size()) {
            GroupTreeObject o = sub_elements.get(i);
            if (o instanceof MibTreeObject) {
                MibTreeObject elem = (MibTreeObject)o;
                String type = elem.getType();
                if (type.equals("NOTIFICATION-TYPE") || type.equals("TRAP-TYPE")) {
                    elements.put(elem, null);
                }
            } else {
                boolean cfr_ignored_0 = o instanceof GroupTreeObject;
            }
            ++i;
        }
        return elements;
    }

    public boolean isRecursive() {
        return this.m_isRecursive;
    }
}

