/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.views.dnd;

import com.blixx.shared.pg.PGItem;
import com.blixx.shared.utils.GroupTreeObjectLast;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;

public class DNDCopyPGItem
extends Action {
    private StructuredViewer m_viewer = null;
    private List<String> m_selection = new LinkedList<String>();

    public DNDCopyPGItem(StructuredViewer vi, boolean hasOwnerRights) {
        this.setText("Copy");
        this.setId("dndcopytreeobjectaction");
        ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
        this.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_COPY"));
        this.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_COPY_DISABLED"));
        this.m_viewer = vi;
        if (!hasOwnerRights || this.m_viewer == null || this.m_viewer.getSelection().isEmpty()) {
            this.setEnabled(false);
        }
        this.m_selection = this.getSelection();
        if (this.m_selection.size() == 0) {
            this.setEnabled(false);
        }
    }

    public void run() {
        if (!this.isEnabled()) {
            return;
        }
        Clipboard clipboard = new Clipboard(Display.getCurrent());
        clipboard.clearContents();
        StringBuilder sb = new StringBuilder();
        Iterator<String> its = this.m_selection.iterator();
        while (its.hasNext()) {
            sb.append(its.next());
            if (!its.hasNext()) continue;
            sb.append('\n');
        }
        clipboard.setContents(new Object[]{sb.toString()}, new Transfer[]{TextTransfer.getInstance()});
    }

    private List<String> getSelection() {
        LinkedList<String> selection = new LinkedList<String>();
        StructuredSelection sel = (StructuredSelection)this.m_viewer.getSelection();
        for (Object o : sel) {
            if (!(o instanceof GroupTreeObjectLast)) continue;
            GroupTreeObjectLast gtoL = (GroupTreeObjectLast)o;
            try {
                PGItem item = (PGItem)gtoL.getTreeObject().getObject();
                String strI = item.toString();
                if (selection.contains(strI)) continue;
                selection.add(strI);
            }
            catch (Throwable throwable) {}
        }
        return selection;
    }
}

