/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.views.dnd;

import com.blixx.boom.engine.Repository;
import com.blixx.boom.gui.Activator;
import com.blixx.boom.gui.views.dnd.DNDShare;
import com.blixx.boom.gui.views.dnd.DNDTreeIconManager;
import com.blixx.log.RTLogger;
import com.blixx.shared.utils.GroupTreeObject;
import com.blixx.shared.utils.GroupTreeObjectLast;
import com.blixx.shared.utils.GroupTreeObjectUnsubmitted;
import java.util.ArrayList;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbenchWindow;

public class DNDCutCopyActionTreeAction
extends Action {
    private TreeViewer m_tv = null;
    private String m_dndType = null;
    private ArrayList<GroupTreeObject> m_actionList = new ArrayList();
    private DNDTreeIconManager m_treeIconManager = null;
    private Clipboard m_clipboard = null;

    public DNDCutCopyActionTreeAction(TreeViewer tv, String dndType, Clipboard clipboard) {
        super("DNDCutCopyAction");
        if (Repository.getInstance().getRights(1007) < 3 || tv == null || dndType == null || clipboard == null) {
            this.setEnabled(false);
            return;
        }
        this.m_tv = tv;
        this.m_dndType = dndType;
        this.m_clipboard = clipboard;
        this.m_treeIconManager = new DNDTreeIconManager();
        IWorkbenchWindow window = Activator.getDefault().getWorkbench().getActiveWorkbenchWindow();
        ISharedImages sharedImages = window.getWorkbench().getSharedImages();
        if (this.m_dndType.equals(DNDShare.DND_COPY_ACTION)) {
            this.setText("Copy");
            this.setId("dndcopyaction");
            this.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_COPY"));
            this.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_COPY_DISABLED"));
        } else if (this.m_dndType.equals(DNDShare.DND_CUT_ACTION)) {
            this.setText("Cut");
            this.setId("dndcutaction");
            this.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_CUT"));
            this.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_CUT_DISABLED"));
        } else {
            this.setEnabled(false);
            return;
        }
        IStructuredSelection ssel = (IStructuredSelection)this.m_tv.getSelection();
        if (ssel != null && !ssel.isEmpty()) {
            this.m_actionList.ensureCapacity(ssel.size());
            for (Object o : ssel) {
                GroupTreeObjectLast gtol;
                if (!(o instanceof GroupTreeObjectLast) || (gtol = (GroupTreeObjectLast)o) instanceof GroupTreeObjectUnsubmitted || Repository.getInstance().getRights(gtol.getParent().getName()) != 3) continue;
                this.m_actionList.add(gtol);
            }
        }
        if (this.m_actionList.size() == 0) {
            this.setEnabled(false);
        }
    }

    public void run() {
        if (!this.isEnabled()) {
            return;
        }
        try {
            this.m_clipboard.clearContents();
            this.m_clipboard.setContents(new Object[]{this.m_dndType}, new Transfer[]{TextTransfer.getInstance()});
            RTLogger.print(5, String.valueOf(this.m_dndType) + ": actions has been added to the system clipboard");
        }
        catch (Exception e) {
            RTLogger.print(5, String.valueOf(this.m_dndType) + " error: cannot add actions to the system clipboard", e);
        }
        this.m_treeIconManager.restoreActionTreeIcons(this.m_tv, this.m_dndType);
        DNDShare.getInstance().clearDNDActionTreeObjects();
        DNDShare.getInstance().setDNDActionTreeObjects(this.m_actionList);
        if (this.m_dndType.equals(DNDShare.DND_CUT_ACTION)) {
            int i = 0;
            while (i < this.m_actionList.size()) {
                GroupTreeObjectLast gtol = (GroupTreeObjectLast)this.m_actionList.get(i);
                com.blixx.shared.Action action = (com.blixx.shared.Action)gtol.getTreeObject().getObject();
                if (action.m_serverAction) {
                    gtol.setIcon("IMAGE_ACTION_SERVER_CUT");
                } else {
                    gtol.setIcon("IMAGE_ACTION_CUT");
                }
                ++i;
            }
            if (this.m_actionList.size() > 0) {
                this.m_tv.refresh();
            }
        }
    }
}

