/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.views.dnd;

import com.blixx.boom.engine.BMUI;
import com.blixx.boom.engine.Repository;
import com.blixx.boom.gui.Activator;
import com.blixx.boom.gui.policies.PolicyManager;
import com.blixx.boom.gui.views.dnd.DNDShare;
import com.blixx.boom.gui.views.dnd.DNDTreeIconManager;
import com.blixx.log.RTLogger;
import com.blixx.shared.utils.GroupTreeObject;
import com.blixx.shared.utils.GroupTreeObjectLast;
import java.util.ArrayList;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbenchWindow;

public class DNDCutCopyAsnLinksAction
extends Action {
    private TreeViewer m_tv = null;
    private String m_dndType = null;
    private ArrayList m_list = new ArrayList();
    private DNDTreeIconManager m_treeIconManager = null;
    private Clipboard m_clipboard = null;

    public DNDCutCopyAsnLinksAction(TreeViewer tv, String dndType, Clipboard clipboard) {
        super("DNDCutCopyAction");
        this.m_tv = tv;
        this.m_dndType = dndType;
        this.m_clipboard = clipboard;
        this.m_treeIconManager = new DNDTreeIconManager();
        IWorkbenchWindow window = Activator.getDefault().getWorkbench().getActiveWorkbenchWindow();
        ISharedImages sharedImages = window.getWorkbench().getSharedImages();
        if (this.m_dndType.equals(DNDShare.DND_COPY) || this.m_dndType.equals(DNDShare.DND_COPY_ASN_LINKS) || this.m_dndType.equals(DNDShare.DND_COPY_ASN_FOLDER)) {
            this.setText("Copy");
            this.setId("dndcopyaction");
            this.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_COPY"));
            this.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_COPY_DISABLED"));
        } else if (this.m_dndType.equals(DNDShare.DND_CUT) || this.m_dndType.equals(DNDShare.DND_CUT_ASN_LINKS) || this.m_dndType.equals(DNDShare.DND_CUT_ASN_FOLDER)) {
            this.setText("Cut");
            this.setId("dndcutaction");
            this.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_CUT"));
            this.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_CUT_DISABLED"));
        } else {
            this.setEnabled(false);
            return;
        }
        if (Repository.getInstance().getRights(1008) < 3) {
            this.setEnabled(false);
            return;
        }
        if (this.m_dndType.equals(DNDShare.DND_COPY) || this.m_dndType.equals(DNDShare.DND_CUT)) {
            this.m_dndType = this.getCorrectDNDType(this.m_tv, this.m_dndType);
        }
        if (this.m_dndType != null) {
            IStructuredSelection ssel = (IStructuredSelection)this.m_tv.getSelection();
            if (this.m_dndType.equals(DNDShare.DND_COPY_ASN_FOLDER) || this.m_dndType.equals(DNDShare.DND_CUT_ASN_FOLDER)) {
                if (ssel.size() > 0) {
                    for (GroupTreeObject o : ssel) {
                        if (this.m_dndType.equals(DNDShare.DND_CUT_ASN_FOLDER)) {
                            GroupTreeObject pga = o.findFirstParent(BMUI.type_assignment_pol);
                            if (!PolicyManager.getInstance().isPermittedPGAModify(pga)) {
                                this.setEnabled(false);
                                return;
                            }
                        }
                        if (o instanceof GroupTreeObjectLast) continue;
                        this.m_list.add(o);
                    }
                }
            } else if ((this.m_dndType.equals(DNDShare.DND_COPY_ASN_LINKS) || this.m_dndType.equals(DNDShare.DND_CUT_ASN_LINKS)) && ssel.size() > 0) {
                for (GroupTreeObject o : ssel) {
                    if (this.m_dndType.equals(DNDShare.DND_CUT_ASN_LINKS)) {
                        GroupTreeObject pga = o.findFirstParent(BMUI.type_assignment_pol);
                        if (!PolicyManager.getInstance().isPermittedPGAModify(pga)) {
                            this.setEnabled(false);
                            return;
                        }
                    }
                    if (!(o instanceof GroupTreeObjectLast)) continue;
                    this.m_list.add((GroupTreeObjectLast)o);
                }
            }
        }
        if (this.m_list.size() == 0) {
            this.setEnabled(false);
            return;
        }
    }

    public void run() {
        if (this.m_tv == null || this.m_dndType == null || this.m_list.size() == 0) {
            return;
        }
        this.m_treeIconManager.restoreAssignmentTreeIcons(this.m_tv, this.m_dndType);
        this.m_clipboard.clearContents();
        DNDShare.getInstance().clearDNDAsnTreeObjects();
        try {
            this.m_clipboard.setContents(new Object[]{this.m_dndType}, new Transfer[]{TextTransfer.getInstance()});
            RTLogger.print(5, String.valueOf(this.m_dndType) + ": objects has been added to the system clipboard");
        }
        catch (Exception e) {
            RTLogger.print(5, String.valueOf(this.m_dndType) + " error: cannot add objects to the system clipboard", e);
        }
        DNDShare.getInstance().setDNDAsnTreeObjects(this.m_list);
        if (this.m_dndType.equals(DNDShare.DND_CUT_ASN_LINKS)) {
            int i = 0;
            while (i < this.m_list.size()) {
                GroupTreeObjectLast gtol = (GroupTreeObjectLast)this.m_list.get(i);
                String type = gtol.getTreeObject().getType();
                if (type.equals(BMUI.type_mon)) {
                    gtol.setIcon("IMAGE_MON_LNK_CUT");
                } else if (type.equals(BMUI.type_msg)) {
                    gtol.setIcon("IMAGE_MSG_LNK_CUT");
                } else if (type.equals(BMUI.type_assignment_bin)) {
                    gtol.setIcon("IMAGE_PKG_LNK_CUT");
                }
                ++i;
            }
            this.m_tv.refresh();
        } else if (this.m_dndType.equals(DNDShare.DND_CUT_ASN_FOLDER)) {
            int i = 0;
            while (i < this.m_list.size()) {
                GroupTreeObject gto = (GroupTreeObject)this.m_list.get(i);
                gto.setType("IMAGE_FOLDER_CUT");
                ++i;
            }
            this.m_tv.refresh();
        }
    }

    public String getCorrectDNDType(TreeViewer tv, String type) {
        GroupTreeObject gto;
        String dndType = null;
        IStructuredSelection ssel = (IStructuredSelection)tv.getSelection();
        Object o = ssel.getFirstElement();
        if (o instanceof GroupTreeObjectLast) {
            if (type.equals(DNDShare.DND_CUT)) {
                dndType = DNDShare.DND_CUT_ASN_LINKS;
            } else if (type.equals(DNDShare.DND_COPY)) {
                dndType = DNDShare.DND_COPY_ASN_LINKS;
            }
        } else if (o instanceof GroupTreeObject && (gto = (GroupTreeObject)o).getTreeObject().getType().equals(BMUI.type_folder)) {
            if (type.equals(DNDShare.DND_CUT)) {
                dndType = DNDShare.DND_CUT_ASN_FOLDER;
            } else if (type.equals(DNDShare.DND_COPY)) {
                dndType = DNDShare.DND_COPY_ASN_FOLDER;
            }
        }
        return dndType;
    }
}

