/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.views.dnd;

import com.blixx.boom.engine.BMUI;
import com.blixx.boom.engine.Repository;
import com.blixx.boom.gui.Activator;
import com.blixx.boom.gui.views.dnd.DNDShare;
import com.blixx.boom.gui.views.dnd.DNDTreeIconManager;
import com.blixx.log.RTLogger;
import com.blixx.shared.utils.GroupTreeObject;
import com.blixx.shared.utils.GroupTreeObjectLast;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbenchWindow;

public class DNDCutCopyBinaryAction
extends Action {
    private TreeViewer m_tv = null;
    private String m_dndType = null;
    private List<GroupTreeObject> m_list = new ArrayList<GroupTreeObject>();
    private DNDTreeIconManager m_treeIconManager = null;
    private Clipboard m_clipboard = null;

    public DNDCutCopyBinaryAction(TreeViewer tv, String dndType, Clipboard clipboard) {
        super("DNDCutCopyAction");
        this.m_tv = tv;
        this.m_dndType = dndType;
        this.m_clipboard = clipboard;
        this.m_treeIconManager = new DNDTreeIconManager();
        IWorkbenchWindow window = Activator.getDefault().getWorkbench().getActiveWorkbenchWindow();
        ISharedImages sharedImages = window.getWorkbench().getSharedImages();
        if (this.m_dndType.equals(DNDShare.DND_COPY) || this.m_dndType.equals(DNDShare.DND_COPY_BINARY)) {
            this.setText("Copy");
            this.setId("dndcopyaction");
            this.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_COPY"));
            this.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_COPY_DISABLED"));
        } else if (this.m_dndType.equals(DNDShare.DND_CUT) || this.m_dndType.equals(DNDShare.DND_CUT_BINARY_FILE)) {
            this.setText("Cut");
            this.setId("dndcutaction");
            this.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_CUT"));
            this.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_CUT_DISABLED"));
        } else {
            this.setEnabled(false);
            return;
        }
        if (Repository.getInstance().getRights(1006) < 3) {
            this.setEnabled(false);
            return;
        }
        if (this.m_dndType.equals(DNDShare.DND_COPY) || this.m_dndType.equals(DNDShare.DND_CUT)) {
            this.m_dndType = this.getCorrectDNDType(this.m_tv, this.m_dndType);
        }
        if (this.m_dndType != null) {
            IStructuredSelection ssel = (IStructuredSelection)this.m_tv.getSelection();
            if (this.m_dndType.equals(DNDShare.DND_COPY_BINARY)) {
                if (ssel.size() > 0) {
                    for (Object o : ssel) {
                        GroupTreeObject gto;
                        if (!(o instanceof GroupTreeObject) || o instanceof GroupTreeObjectLast || !(gto = (GroupTreeObject)o).getType().equals(BMUI.type_assignment_bin)) continue;
                        this.m_list.add(gto);
                    }
                }
            } else if (this.m_dndType.equals(DNDShare.DND_CUT_BINARY_FILE) && ssel.size() > 0) {
                for (Object o : ssel) {
                    GroupTreeObjectLast gtol;
                    if (!(o instanceof GroupTreeObjectLast) || !(gtol = (GroupTreeObjectLast)o).getType().equals(BMUI.type_file)) continue;
                    this.m_list.add(gtol);
                }
            }
        }
        if (this.m_list.size() == 0) {
            this.setEnabled(false);
            return;
        }
    }

    public void run() {
        if (this.m_list.size() == 0) {
            return;
        }
        this.m_clipboard.clearContents();
        this.m_treeIconManager.restoreBinaryTreeIcons(this.m_tv, this.m_dndType);
        DNDShare.getInstance().clearDNDBinaryObjects();
        try {
            this.m_clipboard.setContents(new Object[]{this.m_dndType}, new Transfer[]{TextTransfer.getInstance()});
            RTLogger.print(5, String.valueOf(this.m_dndType) + ": binaries has been added to the system clipboard");
            DNDShare.getInstance().setDNDBinaryObjects(this.m_list);
            if (this.m_dndType.equals(DNDShare.DND_CUT_BINARY_FILE)) {
                int i = 0;
                while (i < this.m_list.size()) {
                    GroupTreeObjectLast gtol = (GroupTreeObjectLast)this.m_list.get(i);
                    gtol.setIcon("IMAGE_FILE_CUT");
                    ++i;
                }
                this.m_tv.refresh();
            }
        }
        catch (Exception e) {
            RTLogger.print(5, String.valueOf(this.m_dndType) + " error: cannot add binaries to the system clipboard", e);
        }
    }

    public String getCorrectDNDType(TreeViewer tv, String type) {
        GroupTreeObject gto;
        String dndType = null;
        IStructuredSelection ssel = (IStructuredSelection)tv.getSelection();
        Object o = ssel.getFirstElement();
        if (o instanceof GroupTreeObjectLast) {
            if (type.equals(DNDShare.DND_CUT)) {
                dndType = DNDShare.DND_CUT_BINARY_FILE;
            }
        } else if (o instanceof GroupTreeObject && (gto = (GroupTreeObject)o).getTreeObject().getType().equals(BMUI.type_assignment_bin) && type.equals(DNDShare.DND_COPY)) {
            dndType = DNDShare.DND_COPY_BINARY;
        }
        return dndType;
    }
}

