/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.views.dnd;

import com.blixx.boom.engine.BMUI;
import com.blixx.boom.engine.Repository;
import com.blixx.boom.gui.Activator;
import com.blixx.boom.gui.dialogs.ShowMessageBox;
import com.blixx.boom.gui.policies.PolicyManager;
import com.blixx.boom.gui.views.dnd.DNDShare;
import com.blixx.boom.gui.views.dnd.DNDTreeIconManager;
import com.blixx.log.RTLogger;
import com.blixx.shared.utils.GroupTreeObject;
import com.blixx.shared.utils.GroupTreeObjectLast;
import com.blixx.shared.utils.GroupTreeObjectUnsubmitted;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbenchWindow;

public class DNDCutCopyPolicyAction
extends Action {
    private TreeViewer m_tv = null;
    private String m_dndType = null;
    private List<GroupTreeObject> m_pList = new ArrayList<GroupTreeObject>();
    private DNDTreeIconManager m_treeIconManager = null;
    private Clipboard m_clipboard = null;

    public DNDCutCopyPolicyAction(TreeViewer tv, String dndType, Clipboard clipboard) {
        super("DNDCutCopyAction");
        this.m_tv = tv;
        this.m_dndType = dndType;
        this.m_clipboard = clipboard;
        this.m_treeIconManager = new DNDTreeIconManager();
        IWorkbenchWindow window = Activator.getDefault().getWorkbench().getActiveWorkbenchWindow();
        ISharedImages sharedImages = window.getWorkbench().getSharedImages();
        if (this.m_dndType.equals(DNDShare.DND_COPY) || this.m_dndType.equals(DNDShare.DND_COPY_POLICY) || this.m_dndType.equals(DNDShare.DND_COPY_POLICY_FOLDER)) {
            this.setText("Copy");
            this.setId("dndcopyaction");
            this.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_COPY"));
            this.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_COPY_DISABLED"));
        } else if (this.m_dndType.equals(DNDShare.DND_CUT) || this.m_dndType.equals(DNDShare.DND_CUT_POLICY_FOLDER) || this.m_dndType.equals(DNDShare.DND_CUT_POLICY)) {
            this.setText("Cut");
            this.setId("dndcutaction");
            this.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_CUT"));
            this.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_CUT_DISABLED"));
        } else {
            this.setEnabled(false);
            return;
        }
        if (Repository.getInstance().getRights(1001) < 3) {
            this.setEnabled(false);
            return;
        }
        if (this.m_dndType.equals(DNDShare.DND_COPY) || this.m_dndType.equals(DNDShare.DND_CUT)) {
            this.m_dndType = this.getCorrectDNDType(this.m_tv, this.m_dndType);
        }
        if (this.m_dndType != null) {
            IStructuredSelection ssel = (IStructuredSelection)this.m_tv.getSelection();
            if (this.m_dndType.equals(DNDShare.DND_COPY_POLICY_FOLDER) || this.m_dndType.equals(DNDShare.DND_CUT_POLICY_FOLDER)) {
                if (ssel.size() > 0) {
                    for (Object o : ssel) {
                        if (!(o instanceof GroupTreeObject) || o instanceof GroupTreeObjectLast) continue;
                        GroupTreeObject gto = (GroupTreeObject)o;
                        if (this.m_dndType.equals(DNDShare.DND_CUT_POLICY_FOLDER) && !PolicyManager.getInstance().isPermittedPolicyModifyRecursive(gto)) {
                            this.setEnabled(false);
                            return;
                        }
                        boolean permittedPolicyRead = PolicyManager.getInstance().isPermittedPolicyRead(gto);
                        if (!permittedPolicyRead) continue;
                        this.m_pList.add(gto);
                    }
                }
            } else if ((this.m_dndType.equals(DNDShare.DND_COPY_POLICY) || this.m_dndType.equals(DNDShare.DND_CUT_POLICY)) && ssel.size() > 0) {
                for (Object o : ssel) {
                    boolean permittedPolicyRead;
                    GroupTreeObjectLast gtol;
                    if (!(o instanceof GroupTreeObjectLast) || (gtol = (GroupTreeObjectLast)o) instanceof GroupTreeObjectUnsubmitted || !(permittedPolicyRead = PolicyManager.getInstance().isPermittedPolicyRead(gtol))) continue;
                    this.m_pList.add(gtol);
                }
            }
        }
        if (this.m_pList.size() == 0) {
            this.setEnabled(false);
        }
    }

    public void run() {
        GroupTreeObject gto;
        int i;
        this.m_treeIconManager.restorePolicyTreeIcons(this.m_tv, this.m_dndType);
        this.m_clipboard.clearContents();
        DNDShare.getInstance().clearDNDPolicyTreeObjects();
        try {
            this.m_clipboard.setContents(new Object[]{this.m_dndType}, new Transfer[]{TextTransfer.getInstance()});
            if (RTLogger.getCurrentLevel() >= 5) {
                RTLogger.print(5, String.valueOf(this.m_dndType) + ": " + this.m_pList.size() + " objects has been added to the system clipboard");
            }
            i = 0;
            while (i < this.m_pList.size()) {
                gto = this.m_pList.get(i);
                if (gto instanceof GroupTreeObjectLast) {
                    RTLogger.print(6, String.valueOf(this.m_dndType) + ": '" + gto.getPath() + "'");
                } else {
                    RTLogger.print(6, String.valueOf(this.m_dndType) + ": '" + gto.getPath() + "' (" + gto.getAllElements().size() + " subelements)");
                }
                ++i;
            }
        }
        catch (Throwable e) {
            RTLogger.print(5, String.valueOf(this.m_dndType) + " error: cannot add selected objects to the system clipboard", e);
            new ShowMessageBox("Error", "Cannot add elements to the system clipboard!", 1);
            return;
        }
        DNDShare.getInstance().setDNDPolicyTreeObjects(this.m_pList);
        if (this.m_dndType.equals(DNDShare.DND_CUT_POLICY)) {
            i = 0;
            while (i < this.m_pList.size()) {
                GroupTreeObjectLast gtol = (GroupTreeObjectLast)this.m_pList.get(i);
                String type = gtol.getTreeObject().getType();
                if (type.equals(BMUI.type_mon)) {
                    gtol.setIcon("IMAGE_MON_CUT");
                } else if (type.equals(BMUI.type_msg)) {
                    gtol.setIcon("IMAGE_MSG_CUT");
                }
                ++i;
            }
            this.m_tv.refresh();
        } else if (this.m_dndType.equals(DNDShare.DND_CUT_POLICY_FOLDER)) {
            i = 0;
            while (i < this.m_pList.size()) {
                gto = this.m_pList.get(i);
                gto.setType("IMAGE_FOLDER_CUT");
                ++i;
            }
            this.m_tv.refresh();
        }
    }

    public String getCorrectDNDType(TreeViewer tv, String type) {
        String dndType = null;
        IStructuredSelection ssel = (IStructuredSelection)tv.getSelection();
        Object o = ssel.getFirstElement();
        if (o instanceof GroupTreeObjectLast) {
            if (type.equals(DNDShare.DND_CUT)) {
                dndType = DNDShare.DND_CUT_POLICY;
            } else if (type.equals(DNDShare.DND_COPY)) {
                dndType = DNDShare.DND_COPY_POLICY;
            }
        } else if (o instanceof GroupTreeObject) {
            GroupTreeObject gto = (GroupTreeObject)o;
            if (gto.getTreeObject().getType().equals(BMUI.type_toplevel)) {
                return null;
            }
            if (type.equals(DNDShare.DND_CUT)) {
                dndType = DNDShare.DND_CUT_POLICY_FOLDER;
            } else if (type.equals(DNDShare.DND_COPY)) {
                dndType = DNDShare.DND_COPY_POLICY_FOLDER;
            }
        }
        return dndType;
    }
}

