/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.views.dnd;

import com.blixx.boom.engine.EventFilter;
import com.blixx.boom.gui.settings.UISettings;
import com.blixx.boom.gui.views.MessageBrowserTab;
import com.blixx.boom.gui.views.MessagesView;
import com.blixx.boom.gui.views.MessagesViewFolder;
import com.blixx.boom.gui.views.actions.ViewFilterAction;
import com.blixx.boom.gui.views.sim.SimTab;
import com.blixx.boom.gui.views.sim.ViewActiveMessagesAction;
import java.util.HashMap;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class DNDMessageTabItems {
    public static CTabItem m_draggingItem;
    public CTabFolder m_folder = null;
    public Display m_display = null;
    public int m_cTabIndex = -1;

    public DNDMessageTabItems(CTabFolder folder, Display display) {
        this.m_folder = folder;
        this.m_display = display;
    }

    public void addDNDSupport() {
        Transfer[] types = new Transfer[]{TextTransfer.getInstance()};
        int operations = 2;
        DragSource source = new DragSource((Control)this.m_folder, operations);
        source.setTransfer(types);
        source.addDragListener(new DragSourceListener(){
            CTabItem cTabItem;

            public void dragStart(DragSourceEvent event) {
                event.doit = DNDMessageTabItems.this.m_folder.getItemCount() != 0;
                m_draggingItem = this.cTabItem = DNDMessageTabItems.this.m_folder.getSelection();
                event.doit = m_draggingItem != null ? UISettings.getInstance().IB_canMoveTab() : false;
            }

            public void dragSetData(DragSourceEvent event) {
                event.data = m_draggingItem.getText();
            }

            public void dragFinished(DragSourceEvent event) {
                if (event.detail == 2) {
                    this.cTabItem.dispose();
                }
            }
        });
        DropTarget target = new DropTarget((Control)this.m_folder, operations);
        target.setTransfer(types);
        target.addDropListener((DropTargetListener)new DropTargetAdapter(){

            public void drop(DropTargetEvent event) {
                CTabItem tab;
                if (event.data == null) {
                    event.detail = 0;
                    return;
                }
                if (!UISettings.getInstance().IB_canMoveTab() || m_draggingItem == null) {
                    return;
                }
                MessagesViewFolder sourceFolder = null;
                if (m_draggingItem instanceof MessageBrowserTab) {
                    tab = (MessageBrowserTab)m_draggingItem;
                    sourceFolder = (MessagesViewFolder)tab.getParent();
                } else if (m_draggingItem instanceof SimTab) {
                    tab = (SimTab)m_draggingItem;
                    sourceFolder = (MessagesViewFolder)tab.getParent();
                }
                DropTarget dt = (DropTarget)event.getSource();
                MessagesViewFolder targetFolder = (MessagesViewFolder)dt.getControl();
                MessagesView targetView = targetFolder.getView();
                if (((Object)((Object)sourceFolder)).equals((Object)targetFolder)) {
                    event.detail = 0;
                    return;
                }
                if (m_draggingItem instanceof SimTab) {
                    SimTab simTab_old = (SimTab)m_draggingItem;
                    SimTab simTab_new = new SimTab(DNDMessageTabItems.this.m_folder, 64, simTab_old.getText());
                    if (simTab_old.getData() != null && simTab_old.getData().equals(MessagesView.RENAMED)) {
                        simTab_new.setData(MessagesView.RENAMED);
                    }
                    TableViewer tv_indications_old = simTab_old.getTableViewerMessageBrowser();
                    TableViewer tv_indications_new = simTab_new.getTableViewerMessageBrowser();
                    tv_indications_new.getTable().setColumnOrder(tv_indications_old.getTable().getColumnOrder());
                    this.setColumWidth(tv_indications_old.getTable(), tv_indications_new.getTable());
                    ViewerFilter[] fvList1 = tv_indications_old.getFilters();
                    int index = 0;
                    while (index < fvList1.length) {
                        ViewerFilter f = fvList1[index];
                        EventFilter ef = (EventFilter)f;
                        ef.m_tv = tv_indications_new;
                        ViewFilterAction.addFilter(simTab_new, tv_indications_new, ef);
                        ++index;
                    }
                    ViewerSorter sorter1 = tv_indications_old.getSorter();
                    ViewFilterAction.addSorter(tv_indications_new, sorter1);
                    TableViewer tv_filteredGrps_old = simTab_old.getTableViewerGroupFiltered();
                    TableViewer tv_filteredGrps_new = simTab_new.getTableViewerGroupFiltered();
                    tv_filteredGrps_new.getTable().setColumnOrder(tv_filteredGrps_old.getTable().getColumnOrder());
                    this.setColumWidth(tv_filteredGrps_old.getTable(), tv_filteredGrps_new.getTable());
                    ViewerFilter[] fvList2 = tv_filteredGrps_old.getFilters();
                    int index2 = 0;
                    while (index2 < fvList2.length) {
                        ViewerFilter f = fvList2[index2];
                        EventFilter ef = (EventFilter)f;
                        ef.m_tv = tv_filteredGrps_new;
                        ViewFilterAction.addFilter(simTab_new, tv_filteredGrps_new, ef);
                        ++index2;
                    }
                    ViewerSorter sorter2 = tv_filteredGrps_old.getSorter();
                    ViewFilterAction.addSorter(tv_filteredGrps_new, sorter2);
                    TableViewer tv_uniqueMessages_old = simTab_old.getTableViewerUniqueMessages();
                    TableViewer tv_uniqueMessages_new = simTab_new.getTableViewerUniqueMessages();
                    tv_uniqueMessages_new.getTable().setColumnOrder(tv_uniqueMessages_old.getTable().getColumnOrder());
                    this.setColumWidth(tv_uniqueMessages_old.getTable(), tv_uniqueMessages_new.getTable());
                    ViewerFilter[] fvList3 = tv_uniqueMessages_old.getFilters();
                    int index3 = 0;
                    while (index3 < fvList3.length) {
                        ViewerFilter f = fvList3[index3];
                        EventFilter ef = (EventFilter)f;
                        ef.m_tv = tv_uniqueMessages_new;
                        ViewFilterAction.addFilter(simTab_new, tv_uniqueMessages_new, ef);
                        ++index3;
                    }
                    ViewerSorter sorter3 = tv_uniqueMessages_old.getSorter();
                    ViewFilterAction.addSorter(tv_uniqueMessages_new, sorter3);
                    DNDMessageTabItems.this.m_folder.setSelection((CTabItem)simTab_new);
                    DNDMessageTabItems.this.m_folder.setFocus();
                    boolean showActive = simTab_old.m_showActive;
                    if (!showActive) {
                        ViewActiveMessagesAction switchAction = new ViewActiveMessagesAction(simTab_new, tv_indications_new, true);
                        switchAction.run();
                    }
                } else if (m_draggingItem instanceof MessageBrowserTab) {
                    MessageBrowserTab tab2 = (MessageBrowserTab)m_draggingItem;
                    MessageBrowserTab mtb = null;
                    int type = tab2.getEventProvider().getType();
                    if (1 == type) {
                        return;
                    }
                    if (type == 0) {
                        mtb = new MessageBrowserTab(targetView.getSite(), DNDMessageTabItems.this.m_folder, tab2.getStyle(), DNDMessageTabItems.this.m_folder.getItemCount(), tab2.getText(), tab2.getEventProvider().isShowActive(), tab2.getType(), tab2.m_predefinedOrUserTab);
                    }
                    if (tab2.getData() != null && tab2.getData().equals(MessagesView.RENAMED)) {
                        mtb.setData(MessagesView.RENAMED);
                    }
                    Table table_old = tab2.getTableViewer().getTable();
                    Table table_new = mtb.getTableViewer().getTable();
                    table_new.setColumnOrder(table_old.getColumnOrder());
                    this.setColumWidth(table_old, table_new);
                    ViewerFilter[] fvList = tab2.tableViewer.getFilters();
                    int index = 0;
                    while (index < fvList.length) {
                        ViewerFilter f = fvList[index];
                        EventFilter ef = (EventFilter)f;
                        ef.m_tv = mtb.tableViewer;
                        ViewFilterAction.addFilter((Object)mtb, mtb.tableViewer, ef);
                        ++index;
                    }
                    ViewerSorter sorter = tab2.tableViewer.getSorter();
                    ViewFilterAction.addSorter(mtb.tableViewer, sorter);
                    DNDMessageTabItems.this.m_folder.setSelection((CTabItem)mtb);
                    DNDMessageTabItems.this.m_folder.setFocus();
                    UISettings.getInstance().storeAndReload();
                }
            }

            public void setColumWidth(Table tbl_old, Table tbl_new) {
                TableColumn col;
                HashMap<String, Integer> oldSettings = new HashMap<String, Integer>();
                int i = 0;
                while (i < tbl_old.getColumnCount()) {
                    col = tbl_old.getColumn(i);
                    oldSettings.put(col.getText(), col.getWidth());
                    ++i;
                }
                i = 0;
                while (i < tbl_new.getColumnCount()) {
                    col = tbl_new.getColumn(i);
                    if (oldSettings.containsKey(col.getText())) {
                        col.setWidth(((Integer)oldSettings.get(col.getText())).intValue());
                    }
                    ++i;
                }
            }
        });
    }
}

