/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.views.dnd;

import com.blixx.boom.engine.BMUI;
import com.blixx.boom.gui.Activator;
import com.blixx.boom.gui.policies.PolicyManager;
import com.blixx.boom.gui.views.AbstractPolicyTab;
import com.blixx.boom.gui.views.MonitorCondListProvider;
import com.blixx.boom.gui.views.dnd.DNDShare;
import com.blixx.log.RTLogger;
import com.blixx.shared.Condition;
import com.blixx.shared.Policy;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.ui.ISharedImages;

public class DNDPasteMonConditionsAction
extends Action {
    private AbstractPolicyTab<Policy> m_tab = null;
    private String m_policyType = null;
    private MonitorCondListProvider m_conditionList = null;
    private String m_DNDType = null;
    private List<Condition> m_DND_monCondList = new ArrayList<Condition>();
    private Clipboard m_clipboard = null;

    public DNDPasteMonConditionsAction(AbstractPolicyTab<Policy> tab, MonitorCondListProvider conditionList, boolean isReadOnly, Clipboard clipboard) {
        super("DNDPasteMonCondition");
        String[] split;
        String clipboard_data;
        this.setText("Paste");
        this.setId("dndpastemoncondition");
        ISharedImages sharedImages = Activator.getDefault().getWorkbench().getActiveWorkbenchWindow().getWorkbench().getSharedImages();
        this.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_PASTE"));
        this.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_PASTE_DISABLED"));
        this.m_tab = tab;
        this.m_conditionList = conditionList;
        this.m_clipboard = clipboard;
        if (isReadOnly || this.m_conditionList == null || this.m_clipboard == null) {
            this.setEnabled(false);
            return;
        }
        this.m_DND_monCondList = DNDShare.getInstance().getDNDMonConditionObjects();
        if (this.m_DND_monCondList == null || this.m_DND_monCondList.size() == 0) {
            this.setEnabled(false);
        }
        if ((clipboard_data = (String)this.m_clipboard.getContents((Transfer)TextTransfer.getInstance())) != null && (split = clipboard_data.split(";")) != null) {
            int size = split.length;
            switch (size) {
                case 2: {
                    this.m_DNDType = split[0];
                    this.m_policyType = split[1];
                    break;
                }
                default: {
                    this.setEnabled(false);
                    return;
                }
            }
        }
        if (this.m_DNDType == null || this.m_policyType == null || !this.m_policyType.equals(BMUI.type_mon) || !this.m_DNDType.equals(DNDShare.DND_COPY_MON_CONDITION_INTERN)) {
            this.setEnabled(false);
            return;
        }
        PolicyManager pm = PolicyManager.getInstance();
        if (pm == null) {
            this.setEnabled(false);
            return;
        }
    }

    public void run() {
        if (this.m_DNDType == null || this.m_DND_monCondList == null || this.m_DND_monCondList.size() == 0 || this.m_conditionList == null) {
            return;
        }
        boolean setDirty = false;
        int i = 0;
        while (i < this.m_DND_monCondList.size()) {
            Condition monCond = this.m_DND_monCondList.get(i);
            Condition clone = monCond.clone();
            this.m_conditionList.addCondition(clone);
            setDirty = true;
            RTLogger.print(5, "DNDPaste mon condition " + clone.getDescription());
            ++i;
        }
        if (setDirty) {
            this.m_tab.setDirty(true);
            this.m_conditionList.checkButtonStatus();
        }
    }
}

