/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.views.dnd;

import com.blixx.boom.engine.BMUI;
import com.blixx.boom.gui.Activator;
import com.blixx.boom.gui.policies.PolicyManager;
import com.blixx.boom.gui.views.AbstractPolicyTab;
import com.blixx.boom.gui.views.FilterCondList;
import com.blixx.boom.gui.views.dnd.DNDShare;
import com.blixx.log.RTLogger;
import com.blixx.shared.MsgCondition;
import com.blixx.shared.MsgPolicy;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.ui.ISharedImages;

public class DNDPasteMsgConditionsAction
extends Action {
    private AbstractPolicyTab<MsgPolicy> m_tab = null;
    private String m_policyType = null;
    private FilterCondList m_conditionList = null;
    private String m_DNDType = null;
    private List<MsgCondition> m_DND_msgCondList = new ArrayList<MsgCondition>();
    private Clipboard m_systemClipboard = null;

    public DNDPasteMsgConditionsAction(AbstractPolicyTab<MsgPolicy> tab, FilterCondList conditionList, boolean isReadOnly, Clipboard clipboard) {
        super("DNDPasteMsgCondition");
        String[] split;
        String clipboard_data;
        this.setText("Paste");
        this.setId("dndpastemsgcondition");
        ISharedImages sharedImages = Activator.getDefault().getWorkbench().getActiveWorkbenchWindow().getWorkbench().getSharedImages();
        this.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_PASTE"));
        this.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_PASTE_DISABLED"));
        this.m_tab = tab;
        this.m_conditionList = conditionList;
        this.m_systemClipboard = clipboard;
        if (isReadOnly || this.m_conditionList == null || this.m_systemClipboard == null) {
            this.setEnabled(false);
            return;
        }
        this.m_DND_msgCondList = DNDShare.getInstance().getDNDMsgConditionObjects();
        if (this.m_DND_msgCondList == null || this.m_DND_msgCondList.size() == 0) {
            this.setEnabled(false);
        }
        if ((clipboard_data = (String)this.m_systemClipboard.getContents((Transfer)TextTransfer.getInstance())) != null && (split = clipboard_data.split(";")) != null) {
            int size = split.length;
            switch (size) {
                case 2: {
                    this.m_DNDType = split[0];
                    this.m_policyType = split[1];
                    break;
                }
                default: {
                    this.setEnabled(false);
                    return;
                }
            }
        }
        if (this.m_DNDType == null || this.m_policyType == null || !this.m_policyType.equals(BMUI.type_msg) || !this.m_DNDType.equals(DNDShare.DND_COPY_MSG_CONDITION_INTERN) && !this.m_DNDType.equals(DNDShare.DND_COPY_MSG_CONDITION)) {
            this.setEnabled(false);
            return;
        }
        PolicyManager pm = PolicyManager.getInstance();
        if (pm == null) {
            this.setEnabled(false);
            return;
        }
    }

    public void run() {
        if (this.m_DNDType == null || this.m_DND_msgCondList == null || this.m_DND_msgCondList.size() == 0 || this.m_conditionList == null) {
            return;
        }
        boolean setDirty = false;
        int i = 0;
        while (i < this.m_DND_msgCondList.size()) {
            MsgCondition msgCond = this.m_DND_msgCondList.get(i);
            if (this.m_DNDType.equals(DNDShare.DND_COPY_MSG_CONDITION_INTERN)) {
                MsgCondition clone = msgCond.clone();
                this.m_conditionList.addConditionWithoutRefresh(clone);
                setDirty = true;
                RTLogger.print(5, "DNDPaste msg condition " + clone.getDescription());
            } else if (this.m_DNDType.equals(DNDShare.DND_COPY_MSG_CONDITION)) {
                this.m_conditionList.addConditionWithoutRefresh(msgCond);
                RTLogger.print(5, String.valueOf(this.m_DNDType) + ": " + msgCond.getDescription());
                setDirty = true;
            }
            ++i;
        }
        this.m_conditionList.refresh();
        if (setDirty) {
            this.m_tab.setDirty(true);
            this.m_conditionList.checkButtonStatus();
        }
    }
}

