/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.views.dnd;

import com.blixx.boom.engine.BMUI;
import com.blixx.boom.gui.utils.ICanSetTreeDirty;
import com.blixx.boom.gui.utils.STreeViewer;
import com.blixx.shared.pg.PGItem;
import com.blixx.shared.utils.GroupTreeObject;
import com.blixx.shared.utils.GroupTreeObjectLast;
import com.blixx.shared.utils.GroupTreeObjectUnsubmitted;
import com.blixx.shared.utils.TreeObject;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;

public class DNDPastePGItem
extends Action {
    private STreeViewer m_viewer = null;
    private ICanSetTreeDirty m_notify;
    private List<PGItem> list = new LinkedList<PGItem>();

    public DNDPastePGItem(STreeViewer vi, ICanSetTreeDirty notify, boolean hasOwnerRights) {
        this.setText("Paste");
        this.setId("dndpastetreeobjectaction");
        ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
        this.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_PASTE"));
        this.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_PASTE_DISABLED"));
        this.m_viewer = vi;
        this.m_notify = notify;
        if (!hasOwnerRights || this.m_viewer == null || this.m_viewer.getSelection().isEmpty()) {
            this.setEnabled(false);
            return;
        }
        Clipboard clipboard = new Clipboard(Display.getCurrent());
        if (!clipboard.isDisposed()) {
            try {
                String[] arr;
                String values = (String)clipboard.getContents((Transfer)TextTransfer.getInstance());
                String[] stringArray = arr = values.split("\r?\n");
                int n = arr.length;
                int n2 = 0;
                while (n2 < n) {
                    String s = stringArray[n2];
                    PGItem item = PGItem.parse(s);
                    this.list.add(item);
                    ++n2;
                }
            }
            catch (Throwable throwable) {}
            if (this.list.size() == 0) {
                this.setEnabled(false);
            }
        }
    }

    public void run() {
        block15: {
            if (!this.isEnabled()) {
                return;
            }
            try {
                try {
                    StructuredSelection ss = (StructuredSelection)this.m_viewer.getSelection();
                    GroupTreeObject sel = (GroupTreeObject)ss.getFirstElement();
                    if (sel instanceof GroupTreeObjectLast) {
                        sel = sel.getParent();
                    }
                    for (PGItem item : this.list) {
                        GroupTreeObjectUnsubmitted itemGTOL = new GroupTreeObjectUnsubmitted(new TreeObject(item.toString(), BMUI.type_file, item), null, "IMAGE_FILE_CUT");
                        if (sel.getChild(itemGTOL.getName(), itemGTOL.getType()) != null) continue;
                        sel.addElement(itemGTOL);
                        if (this.m_notify != null) {
                            this.m_notify.setTreeDirty();
                        }
                        this.m_viewer.setExpandedState(sel, true);
                    }
                }
                catch (Throwable throwable) {
                    try {
                        this.m_viewer.refresh();
                    }
                    catch (Throwable throwable2) {}
                    break block15;
                }
            }
            catch (Throwable throwable) {
                try {
                    this.m_viewer.refresh();
                }
                catch (Throwable throwable3) {}
                throw throwable;
            }
            try {
                this.m_viewer.refresh();
            }
            catch (Throwable throwable) {}
        }
    }
}

