/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.views.dnd;

import com.blixx.boom.engine.Repository;
import com.blixx.boom.engine.ServerClient;
import com.blixx.boom.gui.Activator;
import com.blixx.boom.gui.dialogs.ShowMessageBox;
import com.blixx.boom.gui.views.ActionView;
import com.blixx.boom.gui.views.dnd.DNDShare;
import com.blixx.boom.gui.views.dnd.DNDTreeIconManager;
import com.blixx.log.RTLogger;
import com.blixx.shared.utils.GroupTreeObject;
import com.blixx.shared.utils.GroupTreeObjectLast;
import com.blixx.shared.utils.GroupTreeObjectUnsubmitted;
import com.blixx.shared.utils.TreeObject;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.ui.ISharedImages;

public class DNDPasteToActionTreeAction
extends Action {
    private TreeViewer m_tv = null;
    private String m_DNDType = null;
    private GroupTreeObject m_target_gto = null;
    private List<GroupTreeObject> m_list = new ArrayList<GroupTreeObject>();
    private Clipboard m_clipboard = null;

    public DNDPasteToActionTreeAction(TreeViewer tv, Clipboard clipboard) {
        super("DNDPasteAction");
        IStructuredSelection ssel;
        this.setText("Paste");
        this.setId("dndpasteaction");
        ISharedImages sharedImages = Activator.getDefault().getWorkbench().getActiveWorkbenchWindow().getWorkbench().getSharedImages();
        this.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_PASTE"));
        this.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_PASTE_DISABLED"));
        if (Repository.getInstance().getRights(1007) < 3 || tv == null || clipboard == null) {
            this.setEnabled(false);
            return;
        }
        this.m_tv = tv;
        this.m_clipboard = clipboard;
        this.m_DNDType = (String)this.m_clipboard.getContents((Transfer)TextTransfer.getInstance());
        if (this.m_DNDType != null && (this.m_DNDType.equals(DNDShare.DND_COPY_ACTION) || this.m_DNDType.equals(DNDShare.DND_CUT_ACTION)) && (ssel = (IStructuredSelection)tv.getSelection()).size() == 1) {
            Object o = ssel.getFirstElement();
            if (o instanceof GroupTreeObject && !(o instanceof GroupTreeObjectLast)) {
                GroupTreeObject gto = (GroupTreeObject)o;
                if (Repository.getInstance().getRights(gto.getName()) == 3) {
                    this.m_target_gto = gto;
                }
            } else if (o instanceof GroupTreeObjectLast) {
                GroupTreeObjectLast gtol = (GroupTreeObjectLast)o;
                if (Repository.getInstance().getRights(gtol.getParent().getName()) == 3) {
                    this.m_target_gto = gtol.getParent();
                }
            }
        }
        this.m_list = DNDShare.getInstance().getDNDActionTreeObjects();
        if (this.m_target_gto == null || this.m_list == null || this.m_list.size() == 0) {
            this.setEnabled(false);
        }
    }

    public void run() {
        GroupTreeObjectLast gtol;
        int i;
        if (!this.isEnabled() || this.m_DNDType == null || this.m_target_gto == null || this.m_list == null || this.m_list.size() == 0) {
            return;
        }
        StringBuffer sb = new StringBuffer();
        if (this.m_DNDType.equals(DNDShare.DND_COPY_ACTION)) {
            i = 0;
            while (i < this.m_list.size()) {
                gtol = (GroupTreeObjectLast)this.m_list.get(i);
                try {
                    com.blixx.shared.Action action = (com.blixx.shared.Action)gtol.getTreeObject().getObject();
                    com.blixx.shared.Action actionCopy = action.clone();
                    GroupTreeObjectUnsubmitted gtolU = new GroupTreeObjectUnsubmitted(new TreeObject(actionCopy.m_label, gtol.getTreeObject().getType(), actionCopy), null, gtol.getIcon());
                    if (this.m_target_gto.findElement(gtolU.getName(), gtolU.getTreeObject().getType()) != null) {
                        sb.append("  " + gtolU.getName()).append("\n");
                    } else {
                        this.m_target_gto.addElement(gtolU);
                        ActionView.displayAction(actionCopy, this.m_target_gto.getName(), gtol.getParent(), gtolU, true);
                    }
                }
                catch (RuntimeException e) {
                    RTLogger.print(5, "", e);
                }
                ++i;
            }
        } else if (this.m_DNDType.equals(DNDShare.DND_CUT_ACTION)) {
            i = 0;
            while (i < this.m_list.size()) {
                gtol = (GroupTreeObjectLast)this.m_list.get(i);
                if (this.m_target_gto.findElement(gtol.getName(), gtol.getTreeObject().getType()) != null) {
                    sb.append("  " + gtol.getName()).append("\n");
                } else {
                    try {
                        com.blixx.shared.Action action = (com.blixx.shared.Action)gtol.getTreeObject().getObject();
                        ServerClient sc = ServerClient.moveAction(action.m_ID, this.m_target_gto.getName());
                        sc.runInUIThread(null);
                        if (sc.isSuccess()) {
                            ActionView.reOpenActionTab(action, this.m_target_gto.getName());
                        } else {
                            RTLogger.print(5, String.valueOf(this.m_DNDType) + ": error moving action");
                        }
                    }
                    catch (Exception e) {
                        RTLogger.print(5, "", e);
                    }
                }
                ++i;
            }
        }
        if (sb.length() > 0) {
            StringBuffer sb2 = new StringBuffer();
            sb2.append("The following Actions already exist in the Action Group '" + this.m_target_gto.getName() + "':\n").append(sb.toString());
            if (this.m_DNDType.equals(DNDShare.DND_CUT_ACTION)) {
                new ShowMessageBox("Cannot move Action!", sb2.toString(), 1);
                DNDTreeIconManager tim = new DNDTreeIconManager();
                tim.restoreActionTreeIcons(this.m_tv, this.m_DNDType);
            } else if (this.m_DNDType.equals(DNDShare.DND_COPY_ACTION)) {
                new ShowMessageBox("Cannot copy Action!", sb2.toString(), 1);
            }
        }
        this.m_tv.setExpandedState((Object)this.m_target_gto, true);
        this.m_tv.refresh();
    }
}

