/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.views.dnd;

import com.blixx.boom.engine.BMUI;
import com.blixx.boom.engine.Repository;
import com.blixx.boom.engine.ServerClientBatch;
import com.blixx.boom.gui.Activator;
import com.blixx.boom.gui.dialogs.ProgressDialog;
import com.blixx.boom.gui.policies.PolicyManager;
import com.blixx.boom.gui.views.PolicyListView;
import com.blixx.boom.gui.views.actions.UpdateServer;
import com.blixx.boom.gui.views.dnd.DNDShare;
import com.blixx.boom.gui.views.dnd.DNDTreeIconManager;
import com.blixx.log.RTLogger;
import com.blixx.shared.BM;
import com.blixx.shared.sc.CMDS;
import com.blixx.shared.utils.GroupTreeObject;
import com.blixx.shared.utils.GroupTreeObjectLast;
import com.blixx.shared.utils.TreeObject;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.ui.ISharedImages;

public class DNDPasteToAsnTreeAction
extends Action {
    private TreeViewer m_tv = null;
    private String m_dndType = null;
    private GroupTreeObject m_target_gto = null;
    private List<GroupTreeObject> m_list = new ArrayList<GroupTreeObject>();
    private DNDTreeIconManager m_treeIconManager = null;
    private Clipboard m_clipboard = null;

    public DNDPasteToAsnTreeAction(TreeViewer tv, Clipboard clipboard) {
        super("DNDPasteAction");
        IStructuredSelection ssel;
        this.setText("Paste");
        this.setId("dndpasteaction");
        ISharedImages sharedImages = Activator.getDefault().getWorkbench().getActiveWorkbenchWindow().getWorkbench().getSharedImages();
        this.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_PASTE"));
        this.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_PASTE_DISABLED"));
        this.m_tv = tv;
        this.m_clipboard = clipboard;
        this.m_treeIconManager = new DNDTreeIconManager();
        if (Repository.getInstance().getRights(1001) < 3) {
            this.setEnabled(false);
            return;
        }
        this.m_dndType = (String)this.m_clipboard.getContents((Transfer)TextTransfer.getInstance());
        if (this.m_dndType != null && (this.m_dndType.equals(DNDShare.DND_COPY_ASN_LINKS) || this.m_dndType.equals(DNDShare.DND_CUT_ASN_LINKS) || this.m_dndType.equals(DNDShare.DND_COPY_ASN_FOLDER) || this.m_dndType.equals(DNDShare.DND_CUT_ASN_FOLDER) || this.m_dndType.equals(DNDShare.DND_COPY_POLICY) || this.m_dndType.equals(DNDShare.DND_COPY_POLICY_FOLDER) || this.m_dndType.equals(DNDShare.DND_COPY_BINARY)) && (ssel = (IStructuredSelection)tv.getSelection()).size() == 1) {
            Object o = ssel.getFirstElement();
            if (o instanceof GroupTreeObject && !(o instanceof GroupTreeObjectLast)) {
                GroupTreeObject gto = (GroupTreeObject)o;
                if (!gto.getTreeObject().getType().equals(BMUI.type_toplevel)) {
                    this.m_target_gto = gto;
                }
            } else if (o instanceof GroupTreeObjectLast) {
                this.m_target_gto = ((GroupTreeObjectLast)o).getParent();
            }
        }
        if (this.m_dndType == null || this.m_target_gto == null) {
            this.setEnabled(false);
            return;
        }
        GroupTreeObject pga = this.m_target_gto.findFirstParent(BMUI.type_assignment_pol);
        if (!PolicyManager.getInstance().isPermittedPGAModify(pga)) {
            this.setEnabled(false);
            return;
        }
        this.m_list = this.m_dndType.equals(DNDShare.DND_COPY_POLICY) || this.m_dndType.equals(DNDShare.DND_COPY_POLICY_FOLDER) ? DNDShare.getInstance().getDNDPolicyTreeObjects() : (this.m_dndType.equals(DNDShare.DND_COPY_BINARY) ? DNDShare.getInstance().getDNDBinaryObjects() : DNDShare.getInstance().getDNDAsnTreeObjects());
        if (this.m_list == null || this.m_list.size() == 0) {
            this.setEnabled(false);
        }
    }

    public void run() {
        ProgressDialog pd;
        ServerClientBatch scBatch;
        block51: {
            block52: {
                if (this.m_dndType == null || this.m_target_gto == null || this.m_list == null || this.m_list.size() == 0) {
                    return;
                }
                boolean isSuccess = false;
                scBatch = new ServerClientBatch("BATCH");
                pd = null;
                try {
                    UpdateServer usrv = new UpdateServer();
                    scBatch.openSocket();
                    this.m_tv.setExpandedState((Object)this.m_target_gto, true);
                    if (this.m_dndType.equals(DNDShare.DND_COPY_ASN_FOLDER)) {
                        GroupTreeObject gto = null;
                        int i = 0;
                        while (i < this.m_list.size()) {
                            gto = this.m_list.get(i);
                            isSuccess = usrv.syncAsnWithServer(scBatch, gto.getPath(), this.m_target_gto.getPath(), CMDS.ACTION_COPY, gto.getType());
                            if (isSuccess) {
                                RTLogger.print(5, String.valueOf(this.m_dndType) + ": copied asn folder from " + gto.getPath() + " to " + this.m_target_gto.getPath());
                            } else {
                                RTLogger.print(5, String.valueOf(this.m_dndType) + ": error copying folder from " + gto.getPath() + " to " + this.m_target_gto.getPath());
                            }
                            ++i;
                        }
                        break block51;
                    }
                    if (this.m_dndType.equals(DNDShare.DND_CUT_ASN_FOLDER)) {
                        GroupTreeObject gto = null;
                        int i = 0;
                        while (i < this.m_list.size()) {
                            gto = this.m_list.get(i);
                            if (gto == null || gto.getParentPath().equals(this.m_target_gto.getPath()) || this.m_target_gto.getPath().startsWith(gto.getPath())) {
                                this.m_treeIconManager.restoreAssignmentTreeIcons(gto, this.m_dndType);
                            } else {
                                isSuccess = usrv.syncAsnWithServer(scBatch, gto.getPath(), this.m_target_gto.getPath(), CMDS.ACTION_MOVE, gto.getType());
                                if (isSuccess) {
                                    this.m_treeIconManager.restoreAssignmentTreeIcons(gto, this.m_dndType);
                                    RTLogger.print(5, String.valueOf(this.m_dndType) + ": moved asn folder from " + gto.getPath() + " to " + this.m_target_gto.getPath());
                                } else {
                                    RTLogger.print(5, String.valueOf(this.m_dndType) + ": error moving folder from " + gto.getPath() + " to " + this.m_target_gto.getPath());
                                }
                            }
                            ++i;
                        }
                        DNDShare.getInstance().clearDNDAsnTreeObjects();
                        break block51;
                    }
                    if (this.m_dndType.equals(DNDShare.DND_COPY_ASN_LINKS)) {
                        GroupTreeObjectLast gtol = null;
                        int i = 0;
                        while (i < this.m_list.size()) {
                            gtol = (GroupTreeObjectLast)this.m_list.get(i);
                            isSuccess = usrv.syncAsnWithServer(scBatch, gtol.getLinkedPath(), this.m_target_gto.getPath(), CMDS.ACTION_ADDLINK, gtol.getType());
                            if (isSuccess) {
                                RTLogger.print(5, String.valueOf(this.m_dndType) + ": link copied from " + gtol.getPath() + " to " + this.m_target_gto.getPath());
                            } else {
                                RTLogger.print(5, String.valueOf(this.m_dndType) + ": error copying link from " + gtol.getPath() + " to " + this.m_target_gto.getPath());
                            }
                            ++i;
                        }
                        break block51;
                    }
                    if (this.m_dndType.equals(DNDShare.DND_CUT_ASN_LINKS)) {
                        GroupTreeObjectLast gtol = null;
                        int i = 0;
                        while (i < this.m_list.size()) {
                            gtol = (GroupTreeObjectLast)this.m_list.get(i);
                            if (!this.m_target_gto.getPath().equals(gtol.getPath()) && !this.m_target_gto.getPath().startsWith(String.valueOf(gtol.getPath()) + BM.GTO_PATH_SEPARATOR)) {
                                isSuccess = usrv.syncAsnWithServer(scBatch, gtol.getPath(), this.m_target_gto.getPath(), CMDS.ACTION_MOVE, gtol.getType());
                                if (isSuccess) {
                                    this.m_treeIconManager.restoreAssignmentTreeIcons(gtol, this.m_dndType);
                                    RTLogger.print(5, String.valueOf(this.m_dndType) + ": link moved from " + gtol.getPath() + " to " + this.m_target_gto.getPath());
                                } else {
                                    RTLogger.print(5, String.valueOf(this.m_dndType) + ": error moving link from " + gtol.getPath() + " to " + this.m_target_gto.getPath());
                                }
                            }
                            ++i;
                        }
                        DNDShare.getInstance().clearDNDAsnTreeObjects();
                        break block51;
                    }
                    if (this.m_dndType.equals(PolicyListView.DND_COPY_POLICY)) {
                        pd = this.startProgressDialog("  Add Links");
                        int progressNumber = 0;
                        GroupTreeObjectLast gtol = null;
                        int i = 0;
                        while (i < this.m_list.size()) {
                            gtol = (GroupTreeObjectLast)this.m_list.get(i);
                            pd.setProgress("Add Policy Link  '" + gtol.getName() + "'", ++progressNumber);
                            GroupTreeObject existing = this.m_target_gto.getChild(gtol.getName(), gtol.getType());
                            if (existing == null) {
                                isSuccess = usrv.syncAsnWithServer(scBatch, gtol.getPath(), this.m_target_gto.getPath(), CMDS.ACTION_ADDLINK, gtol.getType());
                                if (isSuccess) {
                                    RTLogger.print(5, String.valueOf(this.m_dndType) + ": policy link added from " + gtol.getPath() + " to asn tree " + this.m_target_gto.getPath());
                                } else {
                                    RTLogger.print(5, String.valueOf(this.m_dndType) + ": error adding policy link from " + gtol.getName() + " to asn tree " + this.m_target_gto.getPath());
                                }
                            }
                            ++i;
                        }
                        pd.close();
                        break block51;
                    }
                    if (this.m_dndType.equals(PolicyListView.DND_COPY_POLICY_FOLDER)) {
                        pd = this.startProgressDialog("  Add Links");
                        int progressNumber = 0;
                        GroupTreeObject gto = null;
                        String sourcePath = null;
                        int i = 0;
                        while (i < this.m_list.size()) {
                            gto = this.m_list.get(i);
                            sourcePath = gto.getPath();
                            pd.setProgress("Add Folder  '" + gto.getName() + "'", ++progressNumber);
                            isSuccess = usrv.syncAsnWithServer(scBatch, sourcePath, this.m_target_gto.getPath(), CMDS.ACTION_ADDLINK, gto.getType());
                            if (isSuccess) {
                                RTLogger.print(5, String.valueOf(this.m_dndType) + ": policy folder added from " + gto.getPath() + " to asn tree " + this.m_target_gto.getPath());
                            } else {
                                RTLogger.print(5, String.valueOf(this.m_dndType) + ": error adding policy folder from " + gto.getPath() + " to asn tree " + this.m_target_gto.getPath());
                            }
                            ++i;
                        }
                        pd.close();
                        break block51;
                    }
                    if (!this.m_dndType.equals(DNDShare.DND_COPY_BINARY)) break block52;
                    pd = this.startProgressDialog("  Add Links");
                    int progressNumber = 0;
                    GroupTreeObject gto = null;
                    String sourcePath = null;
                    int i = 0;
                    while (i < this.m_list.size()) {
                        gto = this.m_list.get(i);
                        pd.setProgress("Add Binary Link  '" + gto.getName() + "'", ++progressNumber);
                        GroupTreeObject existing = this.m_target_gto.getChild(gto.getName(), gto.getType());
                        if (existing != null) {
                            RTLogger.print(5, "DNDPasteToAsnTreeAction - link does already exist: " + existing.getPath() + " / " + existing.getType());
                        } else {
                            sourcePath = gto.getPath();
                            isSuccess = usrv.syncAsnWithServer(scBatch, sourcePath, this.m_target_gto.getPath(), CMDS.ACTION_ADDLINK, gto.getType());
                            if (isSuccess) {
                                RTLogger.print(5, String.valueOf(this.m_dndType) + ": binary added from " + gto.getPath() + " to asn tree " + this.m_target_gto.getPath());
                            } else {
                                RTLogger.print(5, String.valueOf(this.m_dndType) + ": error adding binary from " + gto.getPath() + " to asn tree " + this.m_target_gto.getPath());
                            }
                        }
                        ++i;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        scBatch.close();
                    }
                    catch (Throwable throwable2) {}
                    try {
                        if (pd != null) {
                            pd.close();
                        }
                    }
                    catch (Throwable throwable3) {}
                    throw throwable;
                }
            }
            try {
                scBatch.close();
            }
            catch (Throwable throwable) {}
            try {
                if (pd != null) {
                    pd.close();
                }
            }
            catch (Throwable throwable) {}
            return;
        }
        try {
            scBatch.close();
        }
        catch (Throwable throwable) {}
        try {
            if (pd != null) {
                pd.close();
            }
        }
        catch (Throwable throwable) {}
        this.m_tv.refresh();
    }

    public ProgressDialog startProgressDialog(String title) {
        ProgressDialog pd = new ProgressDialog(title, "", 0, this.m_list.size());
        pd.setBlockOnOpen(false);
        pd.open();
        return pd;
    }

    public GroupTreeObject proccessObject(GroupTreeObject newFolder, Object obj) {
        GroupTreeObject gtoNew = null;
        if (obj instanceof GroupTreeObject && !(obj instanceof GroupTreeObjectLast)) {
            GroupTreeObject gto = (GroupTreeObject)obj;
            gtoNew = new GroupTreeObject(new TreeObject(gto.getName(), gto.getTreeObject().getType(), null));
            List<GroupTreeObject> list = gto.getElements();
            for (GroupTreeObject o : list) {
                if (o instanceof GroupTreeObject && !(o instanceof GroupTreeObjectLast)) {
                    GroupTreeObject folder = this.proccessObject(gtoNew, o);
                    gtoNew.addElement(folder);
                    continue;
                }
                if (!(o instanceof GroupTreeObjectLast)) continue;
                GroupTreeObjectLast gtol = (GroupTreeObjectLast)o;
                String iconType = null;
                if (gtol.getTreeObject().getType().equals(BMUI.type_mon)) {
                    iconType = "IMAGE_MON_LNK";
                } else if (gtol.getTreeObject().getType().equals(BMUI.type_msg)) {
                    iconType = "IMAGE_MSG_LNK";
                }
                gtoNew.addElement(new GroupTreeObjectLast(gtol.getTreeObject(), gtol.getLinkedPath(), iconType));
            }
        } else if (obj instanceof GroupTreeObjectLast) {
            GroupTreeObjectLast gtol = (GroupTreeObjectLast)obj;
            newFolder.addElement(new GroupTreeObjectLast(gtol.getTreeObject(), gtol.getLinkedPath(), null));
            return newFolder;
        }
        return gtoNew;
    }
}

