/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.views.dnd;

import com.blixx.boom.editors.OpenFileAction;
import com.blixx.boom.engine.BMUI;
import com.blixx.boom.engine.Repository;
import com.blixx.boom.engine.ServerClient;
import com.blixx.boom.gui.Activator;
import com.blixx.boom.gui.dialogs.SaveDialog2;
import com.blixx.boom.gui.views.BinariesListView;
import com.blixx.boom.gui.views.dnd.DNDShare;
import com.blixx.boom.gui.views.dnd.DNDTreeIconManager;
import com.blixx.log.RTLogger;
import com.blixx.shared.utils.GroupTreeObject;
import com.blixx.shared.utils.GroupTreeObjectLast;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class DNDPasteToBinaryTreeAction
extends Action {
    private IWorkbenchWindow m_window = null;
    private TreeViewer m_tv = null;
    private String m_dndType = null;
    private GroupTreeObject m_target_gto = null;
    private List<GroupTreeObject> m_dndFileList = new ArrayList<GroupTreeObject>();
    private DNDTreeIconManager m_treeIconManager = null;
    private Clipboard m_clipboard = null;

    public DNDPasteToBinaryTreeAction(IWorkbenchWindow window, TreeViewer tv, Clipboard clipboard) {
        super("DNDPasteAction");
        IStructuredSelection ssel;
        this.setText("Paste");
        this.setId("dndpasteaction");
        ISharedImages sharedImages = Activator.getDefault().getWorkbench().getActiveWorkbenchWindow().getWorkbench().getSharedImages();
        this.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_PASTE"));
        this.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_PASTE_DISABLED"));
        this.m_window = window;
        this.m_tv = tv;
        this.m_clipboard = clipboard;
        this.m_treeIconManager = new DNDTreeIconManager();
        if (Repository.getInstance().getRights(1006) <= 1) {
            this.setEnabled(false);
            return;
        }
        this.m_dndType = (String)this.m_clipboard.getContents((Transfer)TextTransfer.getInstance());
        if (this.m_dndType != null && this.m_dndType.equals(DNDShare.DND_CUT_BINARY_FILE) && (ssel = (IStructuredSelection)tv.getSelection()).size() == 1) {
            Object obj = ssel.getFirstElement();
            if (obj instanceof GroupTreeObject && !(obj instanceof GroupTreeObjectLast)) {
                GroupTreeObject gto = (GroupTreeObject)obj;
                if (!gto.getTreeObject().getType().equals(BMUI.type_toplevel)) {
                    this.m_target_gto = gto;
                }
            } else if (obj instanceof GroupTreeObjectLast) {
                this.m_target_gto = ((GroupTreeObjectLast)obj).getParent();
            }
        }
        if (this.m_target_gto == null) {
            this.setEnabled(false);
            return;
        }
        this.m_dndFileList = DNDShare.getInstance().getDNDBinaryObjects();
        if (this.m_dndFileList == null || this.m_dndFileList.size() == 0) {
            this.setEnabled(false);
        }
    }

    public void run() {
        if (this.m_dndType.equals(DNDShare.DND_CUT_BINARY_FILE)) {
            OpenFileAction openFile;
            GroupTreeObject movedGTOL;
            boolean moved;
            boolean wasOpen;
            String sourcePath;
            HashMap<String, String> elementsOK = new HashMap<String, String>();
            HashMap<String, String> elemsExist = new HashMap<String, String>();
            int i = 0;
            while (i < this.m_dndFileList.size()) {
                String targetPath;
                GroupTreeObjectLast gtol = (GroupTreeObjectLast)this.m_dndFileList.get(i);
                String fileName = gtol.getName();
                sourcePath = gtol.getPath();
                if (!sourcePath.equals(targetPath = String.valueOf(this.m_target_gto.getPath()) + "/" + fileName)) {
                    if (this.m_target_gto.getFirstChild(fileName) != null) {
                        elemsExist.put(targetPath, sourcePath);
                    } else {
                        elementsOK.put(targetPath, sourcePath);
                    }
                }
                ++i;
            }
            List<Object> overwrite = new ArrayList();
            if (elemsExist.size() > 0) {
                String msg = "The following files do already exist. Do you want to overwrite?";
                Image image = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FILE");
                ArrayList<String> list = new ArrayList<String>(elemsExist.keySet());
                SaveDialog2 dialog = new SaveDialog2("Overwrite Files", msg, image, list);
                dialog.setBlockOnOpen(true);
                dialog.setBtnText("OK", "Cancel Paste");
                dialog.open();
                int returnCode = dialog.getReturnCode();
                if (returnCode == 0) {
                    overwrite = dialog.getSelectedElements();
                } else {
                    int i2 = 0;
                    while (i2 < this.m_dndFileList.size()) {
                        GroupTreeObjectLast gtol = (GroupTreeObjectLast)this.m_dndFileList.get(i2);
                        this.m_treeIconManager.restoreBinaryTreeIcons(gtol, this.m_dndType);
                        ++i2;
                    }
                    return;
                }
            }
            for (String targetPath : overwrite) {
                sourcePath = (String)elemsExist.get(targetPath);
                GroupTreeObject sourceGTOL = Repository.getInstance().getBinaryTree().searchPath(sourcePath, BMUI.type_file);
                GroupTreeObject targetGTOL = Repository.getInstance().getBinaryTree().searchPath(targetPath, BMUI.type_file);
                wasOpen = this.closeFileIfOpen(sourceGTOL);
                this.closeFileIfOpen(targetGTOL);
                this.deleteFile(targetPath);
                moved = this.moveFile(sourcePath, targetPath);
                if (!moved) {
                    this.m_treeIconManager.restoreBinaryTreeIcons(sourceGTOL, this.m_dndType);
                    continue;
                }
                if (!moved || !wasOpen) continue;
                movedGTOL = Repository.getInstance().getBinaryTree().searchPath(targetPath, BMUI.type_file);
                openFile = new OpenFileAction(this.m_window, (GroupTreeObjectLast)movedGTOL);
                openFile.run();
            }
            for (String targetPath : elementsOK.keySet()) {
                String sourcePath2 = (String)elementsOK.get(targetPath);
                GroupTreeObject sourceGTOL = Repository.getInstance().getBinaryTree().searchPath(sourcePath2, BMUI.type_file);
                wasOpen = this.closeFileIfOpen(sourceGTOL);
                moved = this.moveFile(sourcePath2, targetPath);
                if (!moved) {
                    this.m_treeIconManager.restoreBinaryTreeIcons(sourceGTOL, this.m_dndType);
                    continue;
                }
                if (!moved || !wasOpen) continue;
                movedGTOL = Repository.getInstance().getBinaryTree().searchPath(targetPath, BMUI.type_file);
                openFile = new OpenFileAction(this.m_window, (GroupTreeObjectLast)movedGTOL);
                openFile.run();
            }
            DNDShare.getInstance().clearDNDBinaryObjects();
            BinariesListView.getInstance().refreshTree(true);
            this.m_tv.setExpandedState((Object)this.m_target_gto, true);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean closeFileIfOpen(GroupTreeObject gtol) {
        if (gtol == null) {
            return false;
        }
        String treePath = gtol.getPath();
        treePath = treePath.replace("/root/Packages", "");
        String[] name_type_dir = new String[]{treePath, gtol.getTreeObject().getType(), Repository.getUserTmpDirectory()};
        ServerClient sc = ServerClient.getFile(name_type_dir);
        sc.runInUIThread(null);
        if (!sc.isSuccess()) return false;
        try {
            File file = (File)sc.getResultObject();
            String filePath = file.getCanonicalPath();
            filePath = filePath.replace("\\", "/");
            IWorkbenchPage page = this.m_window.getActivePage();
            IEditorReference[] editorRef = page.getEditorReferences();
            int i = 0;
            while (true) {
                if (i >= editorRef.length) {
                    return false;
                }
                IEditorReference ref = editorRef[i];
                IEditorPart editor = ref.getEditor(false);
                IEditorInput input = editor.getEditorInput();
                if (input.getName().equals(filePath)) {
                    IEditorPart editor2Close = page.findEditor(input);
                    if (editor2Close == null) return true;
                    page.closeEditor(editor2Close, false);
                    return true;
                }
                ++i;
            }
        }
        catch (IOException e) {
            RTLogger.print(5, "DNDPasteToBinaryAction: error closing file in editor: ", e);
        }
        return false;
    }

    private boolean moveFile(String sourcePath, String targetPath) {
        boolean moved = true;
        sourcePath = sourcePath.replace("/root/Packages", "srv/packages");
        targetPath = targetPath.replace("/root/Packages", "srv/packages");
        ServerClient sc = ServerClient.renameFile(sourcePath, targetPath);
        sc.runInUIThread(null);
        if (sc.isSuccess()) {
            RTLogger.print(5, "File moved from " + sourcePath + " to " + targetPath);
        } else {
            moved = false;
            RTLogger.print(5, "Error moving file from " + sourcePath + " to " + targetPath);
        }
        return moved;
    }

    private void deleteFile(String path) {
        path = path.replace("/root/Packages", "srv/packages");
        ServerClient sc = ServerClient.deleteFile(path);
        sc.runInUIThread(null);
    }
}

