/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.views.dnd;

import com.blixx.boom.engine.BMUI;
import com.blixx.boom.engine.Repository;
import com.blixx.boom.engine.ServerClientBatch;
import com.blixx.boom.gui.Activator;
import com.blixx.boom.gui.dialogs.ProgressDialog;
import com.blixx.boom.gui.policies.PolicyManager;
import com.blixx.boom.gui.views.AssignmentListView;
import com.blixx.boom.gui.views.PolicyView;
import com.blixx.boom.gui.views.actions.UpdateServer;
import com.blixx.boom.gui.views.dnd.DNDShare;
import com.blixx.boom.gui.views.dnd.DNDTreeIconManager;
import com.blixx.log.RTLogger;
import com.blixx.shared.MsgPolicy;
import com.blixx.shared.Policy;
import com.blixx.shared.sc.CMDS;
import com.blixx.shared.utils.GroupTreeObject;
import com.blixx.shared.utils.GroupTreeObjectLast;
import com.blixx.shared.utils.GroupTreeObjectUnsubmitted;
import com.blixx.shared.utils.TreeObject;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.ISharedImages;

public class DNDPasteToPolicyTreeAction
extends Action {
    private TreeViewer m_tv = null;
    private String m_dndType = null;
    private GroupTreeObject m_target_gto = null;
    private List<GroupTreeObject> m_list = new ArrayList<GroupTreeObject>();
    private DNDTreeIconManager m_treeIconManager = null;
    private PolicyManager m_polManager = null;
    private Clipboard m_clipboard = null;

    public DNDPasteToPolicyTreeAction(TreeViewer tv, Clipboard clipboard) {
        super("DNDPasteAction");
        this.setText("Paste");
        this.setId("dndpasteaction");
        ISharedImages sharedImages = Activator.getDefault().getWorkbench().getActiveWorkbenchWindow().getWorkbench().getSharedImages();
        this.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_PASTE"));
        this.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_PASTE_DISABLED"));
        this.m_tv = tv;
        this.m_clipboard = clipboard;
        this.m_treeIconManager = new DNDTreeIconManager();
        this.m_polManager = PolicyManager.getInstance();
        if (Repository.getInstance().getRights(1001) < 3) {
            this.setEnabled(false);
            return;
        }
        this.m_dndType = (String)this.m_clipboard.getContents((Transfer)TextTransfer.getInstance());
        if (this.m_dndType != null) {
            IStructuredSelection ssel;
            if ((this.m_dndType.equals(DNDShare.DND_COPY_POLICY) || this.m_dndType.equals(DNDShare.DND_CUT_POLICY) || this.m_dndType.equals(DNDShare.DND_CUT_POLICY_FOLDER) || this.m_dndType.equals(DNDShare.DND_COPY_POLICY_FOLDER)) && (ssel = (IStructuredSelection)tv.getSelection()).size() == 1) {
                Object obj = ssel.getFirstElement();
                if (obj instanceof GroupTreeObject && !(obj instanceof GroupTreeObjectLast)) {
                    this.m_target_gto = (GroupTreeObject)obj;
                } else if (obj instanceof GroupTreeObjectLast) {
                    this.m_target_gto = ((GroupTreeObjectLast)obj).getParent();
                }
            }
            this.m_list = DNDShare.getInstance().getDNDPolicyTreeObjects();
            if (this.m_target_gto == null || this.m_list == null || this.m_list.size() == 0) {
                this.setEnabled(false);
                return;
            }
        }
        if (this.m_list.size() == 0) {
            this.setEnabled(false);
        }
    }

    public void run() {
        if (this.m_dndType.equals(DNDShare.DND_COPY_POLICY)) {
            int i = 0;
            while (i < this.m_list.size()) {
                GroupTreeObjectLast gtoLast = (GroupTreeObjectLast)this.m_list.get(i);
                GroupTreeObjectUnsubmitted gtoU = this.duplicatePolicy(gtoLast, this.m_target_gto.getPath());
                if (gtoU != null) {
                    RTLogger.print(5, "successfully duplicated: policy " + gtoU.getName());
                } else {
                    RTLogger.print(5, "Error duplicating policy " + gtoLast.getName());
                }
                ++i;
            }
            this.refreshTree(this.m_tv);
            this.m_tv.setExpandedState((Object)this.m_target_gto, true);
        } else if (this.m_dndType.equals(DNDShare.DND_CUT_POLICY)) {
            if (this.checkPathConflicts()) {
                boolean isSuccess = false;
                boolean hasRefreshed = false;
                ServerClientBatch scBatch = new ServerClientBatch("BATCH");
                scBatch.openSocket();
                UpdateServer usrv = new UpdateServer();
                this.m_clipboard.clearContents();
                try {
                    int i = 0;
                    while (i < this.m_list.size()) {
                        GroupTreeObjectLast gtol = (GroupTreeObjectLast)this.m_list.get(i);
                        if (gtol == null || gtol.getParentPath().equals(this.m_target_gto.getPath())) {
                            this.m_treeIconManager.restorePolicyTreeIcons(gtol, this.m_dndType);
                        } else {
                            isSuccess = usrv.syncWithServer(scBatch, gtol.getPath(), this.m_target_gto.getPath(), CMDS.ACTION_MOVE, gtol.getType());
                            if (isSuccess) {
                                GroupTreeObject parentOld = gtol.getParent();
                                this.m_treeIconManager.restorePolicyTreeIcons(gtol, this.m_dndType);
                                this.m_target_gto.addElement(gtol);
                                parentOld.removeElement(gtol);
                                hasRefreshed = true;
                                RTLogger.print(5, "DNDCUT&Paste " + gtol.getTreeObject().getType() + " policy " + gtol.getName() + " to policy tree");
                            } else {
                                RTLogger.print(5, "DNDCUT&Paste: Error pasting " + gtol.getTreeObject().getType() + " policy " + gtol.getName() + " to the policy tree");
                                MessageDialog.openError((Shell)this.m_tv.getControl().getShell(), (String)"Error", (String)usrv.m_resultString);
                            }
                        }
                        ++i;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        scBatch.close();
                    }
                    catch (Throwable throwable2) {}
                    throw throwable;
                }
                try {
                    scBatch.close();
                }
                catch (Throwable throwable) {}
                DNDShare.getInstance().clearDNDPolicyTreeObjects();
                if (hasRefreshed) {
                    this.refreshTree(AssignmentListView.getInstance().getTreeViewer());
                    this.refreshTree(this.m_tv);
                    this.m_tv.setExpandedState((Object)this.m_target_gto, true);
                }
            }
        } else if (this.m_dndType.equals(DNDShare.DND_COPY_POLICY_FOLDER)) {
            if (this.checkPathConflicts()) {
                ServerClientBatch scBatch = new ServerClientBatch("BATCH");
                scBatch.openSocket();
                UpdateServer usrv = new UpdateServer();
                try {
                    int i = 0;
                    while (i < this.m_list.size()) {
                        GroupTreeObject topFolderGTO = this.m_list.get(i);
                        String topSourcePath = topFolderGTO.getParentPath();
                        String topTargePath = this.m_target_gto.getPath();
                        int total = topFolderGTO.getAllElements().size() + 1;
                        ProgressDialog pd = new ProgressDialog("  Copy/Paste", "", 0, total);
                        pd.setBlockOnOpen(false);
                        pd.open();
                        int pdNumber = 0;
                        try {
                            this.duplicateFolder(topFolderGTO, this.m_target_gto, usrv, scBatch, topSourcePath, topTargePath, pd, pdNumber);
                        }
                        catch (Throwable throwable) {
                            try {
                                pd.close();
                            }
                            catch (Throwable throwable3) {}
                            throw throwable;
                        }
                        try {
                            pd.close();
                        }
                        catch (Throwable throwable) {}
                        ++i;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        scBatch.close();
                    }
                    catch (Throwable throwable4) {}
                    throw throwable;
                }
                try {
                    scBatch.close();
                }
                catch (Throwable throwable) {}
                this.refreshTree(this.m_tv);
                this.m_tv.setExpandedState((Object)this.m_target_gto, true);
            }
        } else if (this.m_dndType.equals(DNDShare.DND_CUT_POLICY_FOLDER) && this.checkPathConflicts()) {
            boolean isSuccess = false;
            boolean hasRefreshed = false;
            ServerClientBatch scBatch = new ServerClientBatch("BATCH");
            scBatch.openSocket();
            UpdateServer usrv = new UpdateServer();
            this.m_clipboard.clearContents();
            ProgressDialog pd = new ProgressDialog("  Move Folder", "", 0, this.m_list.size());
            pd.setBlockOnOpen(false);
            pd.open();
            int processingNumber = 0;
            try {
                int i = 0;
                while (i < this.m_list.size()) {
                    GroupTreeObject gto = this.m_list.get(i);
                    if (gto == null || gto.getParentPath().equals(this.m_target_gto.getPath()) || this.m_target_gto.getPath().startsWith(gto.getPath())) {
                        this.m_treeIconManager.restorePolicyTreeIcons(gto, this.m_dndType);
                        this.m_tv.refresh();
                    } else {
                        pd.setProgress("   Move Element " + gto.getName(), ++processingNumber);
                        isSuccess = usrv.syncWithServer(scBatch, gto.getPath(), this.m_target_gto.getPath(), CMDS.ACTION_MOVE, gto.getType());
                        if (isSuccess) {
                            GroupTreeObject parentOld = gto.getParent();
                            this.m_treeIconManager.restorePolicyTreeIcons(gto, this.m_dndType);
                            this.m_target_gto.addElement(gto);
                            parentOld.removeElement(gto);
                            RTLogger.print(5, String.valueOf(this.m_dndType) + ": move folder " + gto.getName() + " inside the policy tree");
                            hasRefreshed = true;
                            this.m_tv.setExpandedState((Object)gto, true);
                        } else {
                            RTLogger.print(5, String.valueOf(this.m_dndType) + ": error moving folder " + gto.getName() + " inside the policy tree");
                            MessageDialog.openError((Shell)this.m_tv.getControl().getShell(), (String)"Error", (String)usrv.m_resultString);
                        }
                    }
                    ++i;
                }
            }
            catch (Throwable throwable) {
                try {
                    pd.close();
                }
                catch (Throwable throwable5) {}
                try {
                    scBatch.close();
                }
                catch (Throwable throwable6) {}
                throw throwable;
            }
            try {
                pd.close();
            }
            catch (Throwable throwable) {}
            try {
                scBatch.close();
            }
            catch (Throwable throwable) {}
            DNDShare.getInstance().clearDNDPolicyTreeObjects();
            if (hasRefreshed) {
                this.refreshTree(AssignmentListView.getInstance().getTreeViewer());
                this.refreshTree(this.m_tv);
                this.m_tv.setExpandedState((Object)this.m_target_gto, true);
            }
        }
    }

    public boolean checkPathConflicts() {
        boolean okay;
        block8: {
            block10: {
                block9: {
                    okay = true;
                    if (!this.m_dndType.equals(DNDShare.DND_CUT_POLICY)) break block9;
                    int i = 0;
                    while (i < this.m_list.size()) {
                        GroupTreeObjectLast gtoLast = (GroupTreeObjectLast)this.m_list.get(i);
                        if (this.m_target_gto.equals(gtoLast.getParent())) {
                            this.m_list.remove(gtoLast);
                        }
                        ++i;
                    }
                    break block8;
                }
                if (!this.m_dndType.equals(DNDShare.DND_CUT_POLICY_FOLDER)) break block10;
                int i = 0;
                while (i < this.m_list.size()) {
                    GroupTreeObject sourceGTO = this.m_list.get(i);
                    if (this.m_target_gto.getFirstChild(sourceGTO.getName()) != null) {
                        MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"  Cut Folder", (String)"Path Conflict! Folder does already exist!");
                        okay = false;
                        break block8;
                    }
                    if (this.m_target_gto.getPath().startsWith(sourceGTO.getPath())) {
                        MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"  Cut Folder", (String)"Path Conflict! Cannot move Folder to a Subfolder!");
                        okay = false;
                        break block8;
                    }
                    ++i;
                }
                break block8;
            }
            if (!this.m_dndType.equals(DNDShare.DND_COPY_POLICY_FOLDER)) break block8;
            int i = 0;
            while (i < this.m_list.size()) {
                GroupTreeObject sourceGTO = this.m_list.get(i);
                if (this.m_target_gto.getFirstChild(sourceGTO.getName()) != null) {
                    MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"  Copy Folder", (String)"Path Conflict! Folder does already exist!");
                    okay = false;
                    break;
                }
                if (this.m_target_gto.getPath().startsWith(sourceGTO.getPath())) {
                    MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"  Copy Folder", (String)"Path Conflict! Cannot copy Folder to a Subfolder!");
                    okay = false;
                    break;
                }
                ++i;
            }
        }
        return okay;
    }

    public int duplicateFolder(GroupTreeObject folderGTO, GroupTreeObject targetGTO, UpdateServer usrv, ServerClientBatch scBatch, String topSourcePath, String topTargetPath, ProgressDialog pd, int pdNumber) {
        if (folderGTO == null || folderGTO instanceof GroupTreeObjectLast || targetGTO == null) {
            return pdNumber;
        }
        pd.setProgress("   Create Folder " + folderGTO.getName(), ++pdNumber);
        GroupTreeObject newGTO = this.createFolder(folderGTO.getName(), targetGTO, usrv, scBatch);
        if (newGTO != null) {
            List<GroupTreeObject> list = folderGTO.getElements();
            for (GroupTreeObject subGTO : list) {
                if (subGTO instanceof GroupTreeObjectLast) {
                    GroupTreeObjectLast gtol = (GroupTreeObjectLast)subGTO;
                    String newParentPath = gtol.getParentPath().replace(topSourcePath, topTargetPath);
                    pd.setProgress("   Duplicate Policy " + gtol.getName(), ++pdNumber);
                    this.duplicatePolicy(gtol, newParentPath);
                    continue;
                }
                pdNumber = this.duplicateFolder(subGTO, newGTO, usrv, scBatch, topSourcePath, topTargetPath, pd, pdNumber);
            }
        }
        return pdNumber;
    }

    private GroupTreeObject createFolder(String name, GroupTreeObject target, UpdateServer usrv, ServerClientBatch scBatch) {
        boolean isSuccess = usrv.syncWithServer(scBatch, target.getPath(), name, CMDS.ACTION_ADD, target.getType());
        if (isSuccess) {
            target.addElement(new GroupTreeObject(new TreeObject(name, BMUI.type_folder, null)));
        } else {
            RTLogger.print(5, String.valueOf(this.m_dndType) + ": error copying folder " + name + " inside the policy tree");
            MessageDialog.openError((Shell)this.m_tv.getControl().getShell(), (String)"Error", (String)("Cannot copy Folder " + name));
        }
        return target.getFirstChild(name);
    }

    private GroupTreeObjectUnsubmitted duplicatePolicy(GroupTreeObjectLast gtol, String newParentPath) {
        boolean isReadPermitted = PolicyManager.getInstance().isPermittedPolicyRead(gtol);
        if (!isReadPermitted) {
            RTLogger.print(5, "Not enough rights to duplicate Policy " + gtol.getName());
            return null;
        }
        RTLogger.print(5, "Duplicate Policy " + gtol.getName());
        String type = gtol.getTreeObject().getType();
        GroupTreeObjectUnsubmitted m_gtolU = null;
        if (type.equals(BMUI.type_mon)) {
            File fileP = Repository.getInstance().fetchFile(gtol.getName(), type);
            Policy p = this.m_polManager.getMonitorPolicy(fileP);
            Policy pCopy = Policy.getCopy(p);
            m_gtolU = new GroupTreeObjectUnsubmitted(new TreeObject(pCopy.getName(), BMUI.type_mon, pCopy), null, "IMAGE_MON");
            GroupTreeObject newParent = this.m_polManager.getPolicyTree().searchPath(newParentPath, BMUI.type_folder);
            if (newParent != null) {
                newParent.addElement(m_gtolU);
                PolicyView.showNewPolicyTab(pCopy, this.m_tv, m_gtolU, true);
                this.m_polManager.addUnsubmitted(m_gtolU, newParentPath);
            }
        } else if (type.equals(BMUI.type_msg)) {
            File fileP = Repository.getInstance().fetchFile(gtol.getName(), type);
            MsgPolicy mp = this.m_polManager.getMessagePolicy(fileP);
            MsgPolicy mpCopy = MsgPolicy.getCopy(mp);
            m_gtolU = new GroupTreeObjectUnsubmitted(new TreeObject(mpCopy.getName(), BMUI.type_msg, mpCopy), null, "IMAGE_MSG");
            GroupTreeObject newParent = this.m_polManager.getPolicyTree().searchPath(newParentPath, BMUI.type_folder);
            if (newParent != null) {
                newParent.addElement(m_gtolU);
                PolicyView.showNewPolicyTab(mpCopy, this.m_tv, m_gtolU, true);
                this.m_polManager.addUnsubmitted(m_gtolU, newParentPath);
            }
        }
        return m_gtolU;
    }

    private void refreshTree(TreeViewer tv) {
        Object[] expanded = tv.getExpandedElements();
        tv.refresh();
        int index = 0;
        while (index < expanded.length) {
            tv.setExpandedState(expanded[index], true);
            ++index;
        }
    }
}

